const express = require('express');
const {check, validationResult} = require('express-validator');
const app = express();

app.use(express.static('public'));
app.use(express.urlencoded({ extended: false }));

app.get('/', (request, response) => {
    response.redirect('/ice-cream.html');
});

app.post('/process', [
    /*
        Write code to validate
            * username (should be between 8 and 25 chars)
            * email (should be valid email)
            * phone (should use format: ###-###-####)
            * flavor (should not equal '0')
            * container (should exist)
            * terms (should exist)
        
        CHALLENGE:
        Write a custom validator for requests. If its length
            is 0 or between 10 and 200, it is valid; otherwise,
            it is invalid.
    */
], (request, response) => {
    const errors = validationResult(request);

    if (errors.isEmpty()) {
        // code to process form goes here
        response.redirect('/success.html');
    } else {
        let msg = 'You have the following errors:<ol>';
        for (error of errors.array()) {
            msg += "<li>" + error.msg + "</li>";
        }
        msg += "</ol>";
        const html_process = `<!DOCTYPE html>
        <html lang="en">
        <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width,initial-scale=1">
        <link rel="stylesheet" href="normalize.css">
        <link rel="stylesheet" href="styles.css">
        <title>Oops!</title>
        </head>
        <body>
        <main>
            <h1>Form Errors</h1>
            ${msg}
            <a href="javascript:history.back()">Try again.</a>
        </main>
        </body>
        </html>`;
        response.status(200);
        response.send(html_process);
    }
    console.log(request.body);
    console.log(errors.array());
});

app.listen(8080);