const express = require('express');
const {check, validationResult} = require('express-validator');
const app = express();

app.use(express.static('public'));
app.use(express.urlencoded({ extended: false }));

app.get('/', (request, response) => {
    response.redirect('/quiz.html');
});

app.post('/process', [
    check('answer').equals('42')
], (request, response) => {
    const errors = validationResult(request);
    console.log(errors.array());
    let msg;
    if (errors.isEmpty()) {
        msg = "<span class='valid'>Right on! " +
            "Did you bring your towel?</span>";
    } else {
        msg = "<span class='invalid'>That is not right, " +
            "but don't panic. You'd far rather be happy " +
            "than right any day.</span>";
    }
    response.status(200);
    response.send(msg);
});

app.listen(8080);