const express = require('express');
const {check, validationResult} = require('express-validator');
const app = express();


app.use(express.static('public'));
app.use(express.urlencoded({ extended: false }));

app.get('/', (request, response) => {
    response.redirect('/simple-form.html');
});

app.post('/process', 
    check('fname','First name is required.').isLength({ min: 1 }),
    check('lname','Last name is required.').isLength({ min: 1 })
, (request, response) => {
    const errors = validationResult(request);
    if (errors.isEmpty()) {
        // code to process form goes here
        response.redirect('/success.html');
    } else {
        let errorList = '';
        for (error of errors.array()) {
            errorList += "<li>" + error.msg + "</li>";
        }
        const html_process = `<!DOCTYPE html>
        <html lang="en">
        <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width,initial-scale=1">
        <link rel="stylesheet" href="normalize.css">
        <link rel="stylesheet" href="styles.css">
        <title>Oops!!</title>
        </head>
        <body>
        <main>
            <h1>Form Errors</h1>
            <p>You have the following errors:</p>
            <ol>
                ${errorList}
            </ol>
            <a href='javascript:history.back()'>Try again.</a>
        </main>
        </body>
        </html>`;
        response.status(200);
        response.send(html_process);
    }

    console.log(request.body);
    console.log(errors.array());
});

app.listen(8080);