CREATE TABLE users (
  id serial PRIMARY KEY,
  first_name text NOT NULL,
  last_name text NOT NULL,
  date_joined date NOT NULL
);

CREATE TABLE lists (
  id serial PRIMARY KEY,
  title text NOT NULL,
  user_id integer NOT NULL REFERENCES users (id),
  created timestamptz NOT NULL
);

INSERT INTO users
(
    first_name,
    last_name,
    date_joined
)
VALUES
(
    'Jared',
    'Dunn',
    now()
);

INSERT INTO lists 
(
    title,
    user_id,
    created
)
VALUES
(
    'Groceries', 
    (SELECT id FROM users WHERE first_name='Jared' AND last_name='Dunn'), 
    now()
);