drop user C##student CASCADE;
create user C##student identified by student
default tablespace users temporary tablespace 
temp account unlock;

grant connect, resource to C##student;
alter user C##student quota unlimited on users;

connect C##student/student

BEGIN
  EXECUTE IMMEDIATE 'DROP TABLE OrderDetails';
EXCEPTION
  WHEN others THEN
    NULL;
END;
/

BEGIN
  EXECUTE IMMEDIATE 'DROP TABLE Products';
EXCEPTION
  WHEN others THEN
    NULL;
END;
/

BEGIN
  EXECUTE IMMEDIATE 'DROP TABLE Suppliers';
EXCEPTION
  WHEN others THEN
    NULL;
END;
/

BEGIN
  EXECUTE IMMEDIATE 'DROP TABLE Orders';
EXCEPTION
  WHEN others THEN
    NULL;
END;
/

BEGIN
  EXECUTE IMMEDIATE 'DROP TABLE Shippers';
EXCEPTION
  WHEN others THEN
    NULL;
END;
/

BEGIN
  EXECUTE IMMEDIATE 'DROP TABLE Employees';
EXCEPTION
  WHEN others THEN
    NULL;
END;
/

BEGIN
  EXECUTE IMMEDIATE 'DROP TABLE Categories';
EXCEPTION
  WHEN others THEN
    NULL;
END;
/

BEGIN
  EXECUTE IMMEDIATE 'DROP TABLE Customers';
EXCEPTION
  WHEN others THEN
    NULL;
END;
/

BEGIN
  EXECUTE IMMEDIATE 'DROP TABLE Region';
EXCEPTION
  WHEN others THEN
    NULL;
END;

/

CREATE TABLE Region
(
    RegionID  NUMBER GENERATED AS IDENTITY,
    RegionDescription VARCHAR2(50) not null,
    CONSTRAINT Region_pk PRIMARY KEY (RegionID)
)
/
CREATE TABLE Customers (
  CUSTOMERID                       VARCHAR2(5),
  COMPANYNAME                      VARCHAR2(40) NOT NULL,
  CONTACTNAME                      VARCHAR2(30),
  CONTACTTITLE                     VARCHAR2(30),
  ADDRESS                          VARCHAR2(60),
  CITY                             VARCHAR2(15),
  Region                           VARCHAR2(15),
  POSTALCODE                       VARCHAR2(10),
  COUNTRY                          VARCHAR2(15),
  PHONE                            VARCHAR2(24),
  FAX                              VARCHAR2(24),
  CONSTRAINT PK_Customers PRIMARY KEY (CUSTOMERID)
)
/
CREATE TABLE Categories (
  CATEGORYID                       NUMBER GENERATED AS IDENTITY,
  CATEGORYNAME                     VARCHAR2(15) NOT NULL,
  DESCRIPTION                      VARCHAR2(255),
  CONSTRAINT PK_Categories PRIMARY KEY (CATEGORYID)
)
/

CREATE TABLE Employees (
  EMPLOYEEID                       NUMBER GENERATED AS IDENTITY,
  LASTNAME                         VARCHAR2(20) NOT NULL,
  FIRSTNAME                        VARCHAR2(10) NOT NULL,
  TITLE                            VARCHAR2(30),
  TITLEOFCOURTESY                  VARCHAR2(25),
  BIRTHDATE                        DATE,
  HIREDATE                         DATE,
  ADDRESS                          VARCHAR2(60),
  CITY                             VARCHAR2(15),
  Region                           VARCHAR2(15),
  POSTALCODE                       VARCHAR2(10),
  COUNTRY                          VARCHAR2(15),
  HOMEPHONE                        VARCHAR2(24),
  EXTENSION                        VARCHAR2(4),
  PHOTO                            VARCHAR2(255),
  NOTES                            VARCHAR2(1000),
  REPORTSTO                        NUMBER(11),
  CONSTRAINT PK_Employee PRIMARY KEY (EMPLOYEEID),
  CONSTRAINT EMPLOYEEBOSSES FOREIGN KEY (REPORTSTO) REFERENCES Employees (EMPLOYEEID)
)
/
CREATE TABLE Shippers (
  SHIPPERID                        NUMBER GENERATED AS IDENTITY,
  COMPANYNAME                      VARCHAR2(40) NOT NULL,
  PHONE                            VARCHAR2(24),
  CONSTRAINT PK_Shippers PRIMARY KEY (SHIPPERID)
)
/
CREATE TABLE Orders (
  ORDERID                          NUMBER GENERATED AS IDENTITY,
  CUSTOMERID                       VARCHAR2(5),
  EMPLOYEEID                       NUMBER(11),
  ORDERDATE                        DATE,
  REQUIREDDATE                     DATE,
  SHIPPEDDATE                      DATE,
  SHIPVIA                          NUMBER(11),
  FREIGHT                          NUMBER(15,4) DEFAULT 0,
  SHIPNAME                         VARCHAR2(40),
  SHIPADDRESS                      VARCHAR2(60),
  SHIPCITY                         VARCHAR2(15),
  SHIPRegion                       VARCHAR2(15),
  SHIPPOSTALCODE                   VARCHAR2(10),
  SHIPCOUNTRY                      VARCHAR2(15),
  CONSTRAINT PK_Orders PRIMARY KEY (ORDERID),
  CONSTRAINT CustomersOrders FOREIGN KEY (CUSTOMERID) REFERENCES Customers (CUSTOMERID),
  CONSTRAINT EmployeesOrders FOREIGN KEY (EMPLOYEEID) REFERENCES Employees (EMPLOYEEID),
  CONSTRAINT ShippersOrders FOREIGN KEY (SHIPVIA) REFERENCES Shippers (SHIPPERID)
)
/
CREATE TABLE Suppliers (
  SUPPLIERID                       NUMBER GENERATED AS IDENTITY,
  COMPANYNAME                      VARCHAR2(40) NOT NULL,
  CONTACTNAME                      VARCHAR2(30),
  CONTACTTITLE                     VARCHAR2(30),
  ADDRESS                          VARCHAR2(60),
  CITY                             VARCHAR2(15),
  Region                           VARCHAR2(15),
  POSTALCODE                       VARCHAR2(10),
  COUNTRY                          VARCHAR2(15),
  PHONE                            VARCHAR2(24),
  FAX                              VARCHAR2(24),
  HOMEPAGE                         VARCHAR(100),
  CONSTRAINT PK_Suppliers PRIMARY KEY (SUPPLIERID)
)
/
CREATE TABLE Products (
  PRODUCTID                        NUMBER GENERATED AS IDENTITY,
  PRODUCTNAME                      VARCHAR2(40) NOT NULL,
  SUPPLIERID                       NUMBER(11),
  CATEGORYID                       NUMBER(11),
  QUANTITYPERUNIT                  VARCHAR2(20),
  UNITPRICE                        NUMBER(15,4) DEFAULT 0,
  UNITSINSTOCK                     NUMBER(5) DEFAULT 0,
  UNITSONORDER                     NUMBER(5) DEFAULT 0,
  REORDERLEVEL                     NUMBER(5) DEFAULT 0,
  DISCONTINUED                     NUMBER(1) DEFAULT 0,
  CONSTRAINT PK_Products PRIMARY KEY (PRODUCTID),
  CONSTRAINT CategoriesProducts FOREIGN KEY (CATEGORYID) REFERENCES Categories (CATEGORYID),
  CONSTRAINT SuppliersProducts FOREIGN KEY (SUPPLIERID) REFERENCES Suppliers (SUPPLIERID)
)
/
CREATE TABLE OrderDetails (
  ORDERID                          NUMBER(11) NOT NULL,
  PRODUCTID                        NUMBER(11) NOT NULL,
  UNITPRICE                        NUMBER(15,4) DEFAULT 0 NOT NULL,
  QUANTITY                         NUMBER(5) DEFAULT 1 NOT NULL,
  DISCOUNT                         FLOAT DEFAULT 0 NOT NULL,
  CONSTRAINT PK_OrderDetails PRIMARY KEY (ORDERID, PRODUCTID),
  CONSTRAINT OrdersOrderDetails FOREIGN KEY (ORDERID)  REFERENCES Orders (ORDERID),
  CONSTRAINT ProductsOrderDetails FOREIGN KEY (PRODUCTID) REFERENCES Products (PRODUCTID)
)
/
/* Insert into table */

INSERT INTO Suppliers (COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX,HOMEPAGE) VALUES ('Exotic Liquids','Charlotte Cooper','Purchasing Manager','49 Gilbert St.','London',NULL,'EC1 4SD','UK','(171) 555-2222',NULL,NULL);
INSERT INTO Suppliers (COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX,HOMEPAGE) VALUES ('New Orleans Cajun Delights','Shelley Burke','Order Administrator','P.O. Box 78934','New Orleans','LA','70117','USA','(100) 555-4822',NULL,NULL);
INSERT INTO Suppliers (COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX,HOMEPAGE) VALUES ('Grandma Kelly''s Homestead','Regina Murphy','Sales Representative','707 Oxford Rd.','Ann Arbor','MI','48104','USA','(313) 555-5735','(313) 555-3349',NULL);
INSERT INTO Suppliers (COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX,HOMEPAGE) VALUES ('Tokyo Traders','Yoshi Nagase','Marketing Manager','9-8 Sekimai'||CHR(13)||CHR(10)||'Musashino-shi','Tokyo',NULL,'100','Japan','(03) 3555-5011',NULL,NULL);
INSERT INTO Suppliers (COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX,HOMEPAGE) VALUES ('Cooperativa de Quesos ''Las Cabras''','Antonio del Valle Saavedra ','Export Administrator','Calle del Rosal 4','Oviedo','Asturias','33007','Spain','(98) 598 76 54',NULL,NULL);
INSERT INTO Suppliers (COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX,HOMEPAGE) VALUES ('Mayumi''s','Mayumi Ohno','Marketing Representative','92 Setsuko'||CHR(13)||CHR(10)||'Chuo-ku','Osaka',NULL,'545','Japan','(06) 431-7877',NULL,'<a href="http://www.microsoft.com/accessdev/sampleapps/mayumi.htm">Mayumi''s</a>');
INSERT INTO Suppliers (COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX,HOMEPAGE) VALUES ('Pavlova, Ltd.','Ian Devling','Marketing Manager','74 Rose St.'||CHR(13)||CHR(10)||'Moonie Ponds','Melbourne','Victoria','3058','Australia','(03) 444-2343','(03) 444-6588',NULL);
INSERT INTO Suppliers (COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX,HOMEPAGE) VALUES ('Specialty Biscuits, Ltd.','Peter Wilson','Sales Representative','29 King''s Way','Manchester',NULL,'M14 GSD','UK','(161) 555-4448',NULL,NULL);
INSERT INTO Suppliers (COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX,HOMEPAGE) VALUES ('PB Knäckebröd AB','Lars Peterson','Sales Agent','Kaloadagatan 13','Göteborg',NULL,'S-345 67','Sweden ','031-987 65 43','031-987 65 91',NULL);
INSERT INTO Suppliers (COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX,HOMEPAGE) VALUES ('Refrescos Americanas LTDA','Carlos Diaz','Marketing Manager','Av. das Americanas 12.890','Sao Paulo',NULL,'5442','Brazil','(11) 555 4640',NULL,NULL);
INSERT INTO Suppliers (COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX,HOMEPAGE) VALUES ('Heli Süßwaren GmbH '||Chr(38)||' Co. KG','Petra Winkler','Sales Manager','Tiergartenstraße 5','Berlin',NULL,'10785','Germany','(010) 9984510',NULL,NULL);
INSERT INTO Suppliers (COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX,HOMEPAGE) VALUES ('Plutzer Lebensmittelgroßmärkte AG','Martin Bein','International Marketing Mgr.','Bogenallee 51','Frankfurt',NULL,'60439','Germany','(069) 992755',NULL,'<a href="http://www.microsoft.com/accessdev/sampleapps/plutzer.htm">Plutzer</a>');
INSERT INTO Suppliers (COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX,HOMEPAGE) VALUES ('Nord-Ost-Fisch Handelsgesellschaft mbH','Sven Petersen','Coordinator Foreign Markets','Frahmredder 112a','Cuxhaven',NULL,'27478','Germany','(04721) 8713','(04721) 8714',NULL);
INSERT INTO Suppliers (COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX,HOMEPAGE) VALUES ('Formaggi Fortini s.r.l.','Elio Rossi','Sales Representative','Viale Dante, 75','Ravenna',NULL,'48100','Italy','(0544) 60323','(0544) 60603',NULL);
INSERT INTO Suppliers (COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX,HOMEPAGE) VALUES ('Norske Meierier','Beate Vileid','Marketing Manager','Hatlevegen 5','Sandvika',NULL,'1320','Norway','(0)2-953010',NULL,NULL);
INSERT INTO Suppliers (COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX,HOMEPAGE) VALUES ('Bigfoot Breweries','Cheryl Saylor','Regional Account Rep.','3400 - 8th Avenue'||CHR(13)||CHR(10)||'Suite 210','Bend','OR','97101','USA','(503) 555-9931',NULL,NULL);
INSERT INTO Suppliers (COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX,HOMEPAGE) VALUES ('Svensk Sjöföda AB','Michael Björn','Sales Representative','Brovallavägen 231','Stockholm',NULL,'S-123 45','Sweden','08-123 45 67',NULL,NULL);
INSERT INTO Suppliers (COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX,HOMEPAGE) VALUES ('Aux joyeux ecclésiastiques','Guylène Nodier','Sales Manager','203, Rue des Francs-Bourgeois','Paris',NULL,'75004','France','(1) 03.83.00.68','(1) 03.83.00.62',NULL);
INSERT INTO Suppliers (COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX,HOMEPAGE) VALUES ('New England Seafood Cannery','Robb Merchant','Wholesale Account Agent','Order Processing Dept.'||CHR(13)||CHR(10)||'2100 Paul Revere Blvd.','Boston','MA','02134','USA','(617) 555-3267','(617) 555-3389',NULL);
INSERT INTO Suppliers (COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX,HOMEPAGE) VALUES ('Leka Trading','Chandra Leka','Owner','471 Serangoon Loop, Suite #402','Singapore',NULL,'0512','Singapore','555-8787',NULL,NULL);
INSERT INTO Suppliers (COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX,HOMEPAGE) VALUES ('Lyngbysild','Niels Petersen','Sales Manager','Lyngbysild'||CHR(13)||CHR(10)||'Fiskebakken 10','Lyngby',NULL,'2800','Denmark','43844108','43844115',NULL);
INSERT INTO Suppliers (COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX,HOMEPAGE) VALUES ('Zaanse Snoepfabriek','Dirk Luchte','Accounting Manager','Verkoop'||CHR(13)||CHR(10)||'Rijnweg 22','Zaandam',NULL,'9999 ZZ','Netherlands','(12345) 1212','(12345) 1210',NULL);
INSERT INTO Suppliers (COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX,HOMEPAGE) VALUES ('Karkki Oy','Anne Heikkonen','Product Manager','Valtakatu 12','Lappeenranta',NULL,'53120','Finland','(953) 10956',NULL,NULL);
INSERT INTO Suppliers (COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX,HOMEPAGE) VALUES ('G''day, Mate','Wendy Mackenzie','Sales Representative','170 Prince Edward Parade'||CHR(13)||CHR(10)||'Hunter''s Hill','Sydney','NSW','2042','Australia','(02) 555-5914','(02) 555-4873','<a href="http://www.microsoft.com/accessdev/sampleapps/gdaymate.htm">G''day Mate</a>');
INSERT INTO Suppliers (COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX,HOMEPAGE) VALUES ('Ma Maison','Jean-Guy Lauzon','Marketing Manager','2960 Rue St. Laurent','Montréal','Québec','H1J 1C3','Canada','(514) 555-9022',NULL,NULL);
INSERT INTO Suppliers (COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX,HOMEPAGE) VALUES ('Pasta Buttini s.r.l.','Giovanni Giudici','Order Administrator','Via dei Gelsomini, 153','Salerno',NULL,'84100','Italy','(089) 6547665','(089) 6547667',NULL);
INSERT INTO Suppliers (COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX,HOMEPAGE) VALUES ('Escargots Nouveaux','Marie Delamare','Sales Manager','22, rue H. Voiron','Montceau',NULL,'71300','France','85.57.00.07',NULL,NULL);
INSERT INTO Suppliers (COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX,HOMEPAGE) VALUES ('Gai pâturage','Eliane Noz','Sales Representative','Bat. B'||CHR(13)||CHR(10)||'3, rue des Alpes','Annecy',NULL,'74000','France','38.76.98.06','38.76.98.58',NULL);
INSERT INTO Suppliers (COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX,HOMEPAGE) VALUES ('Forêts d''érables','Chantal Goulet','Accounting Manager','148 rue Chasseur','Ste-Hyacinthe','Québec','J2S 7S8','Canada','(514) 555-2955','(514) 555-2921',NULL);

/* Commit changes */
COMMIT;


/* Insert into table */

INSERT INTO Categories (CATEGORYNAME,DESCRIPTION) VALUES ('Beverages','Soft drinks, coffees, teas, beers, and ales');
INSERT INTO Categories (CATEGORYNAME,DESCRIPTION) VALUES ('Condiments','Sweet and savory sauces, relishes, spreads, and seasonings');
INSERT INTO Categories (CATEGORYNAME,DESCRIPTION) VALUES ('Confections','Desserts, candies, and sweet breads');
INSERT INTO Categories (CATEGORYNAME,DESCRIPTION) VALUES ('Dairy Products','Cheeses');
INSERT INTO Categories (CATEGORYNAME,DESCRIPTION) VALUES ('Grains/Cereals','Breads, crackers, pasta, and cereal');
INSERT INTO Categories (CATEGORYNAME,DESCRIPTION) VALUES ('Meat/Poultry','Prepared meats');
INSERT INTO Categories (CATEGORYNAME,DESCRIPTION) VALUES ('Produce','Dried fruit and bean curd');
INSERT INTO Categories (CATEGORYNAME,DESCRIPTION) VALUES ('Seafood','Seaweed and fish');

/* Commit changes */
COMMIT;


/* Insert into table */

INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Chai',1,1,'10 boxes x 20 bags',18,39,0,10,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Chang',1,1,'24 - 12 oz bottles',19,17,40,25,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Aniseed Syrup',1,2,'12 - 550 ml bottles',10,13,70,25,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Chef Anton''s Cajun Seasoning',2,2,'48 - 6 oz jars',22,53,0,0,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Chef Anton''s Gumbo Mix',2,2,'36 boxes',21.35,0,0,0,1);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Grandma''s Boysenberry Spread',3,2,'12 - 8 oz jars',25,120,0,25,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Uncle Bob''s Organic Dried Pears',3,7,'12 - 1 lb pkgs.',30,15,0,10,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Northwoods Cranberry Sauce',3,2,'12 - 12 oz jars',40,6,0,0,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Mishi Kobe Niku',4,6,'18 - 500 g pkgs.',97,29,0,0,1);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Ikura',4,8,'12 - 200 ml jars',31,31,0,0,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Queso Cabrales',5,4,'1 kg pkg.',21,22,30,30,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Queso Manchego La Pastora',5,4,'10 - 500 g pkgs.',38,86,0,0,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Konbu',6,8,'2 kg box',6,24,0,5,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Tofu',6,7,'40 - 100 g pkgs.',23.25,35,0,0,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Genen Shouyu',6,2,'24 - 250 ml bottles',15.5,39,0,5,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Pavlova',7,3,'32 - 500 g boxes',17.45,29,0,10,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Alice Mutton',7,6,'20 - 1 kg tins',39,0,0,0,1);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Carnarvon Tigers',7,8,'16 kg pkg.',62.5,42,0,0,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Teatime Chocolate Biscuits',8,3,'10 boxes x 12 pieces',9.2,25,0,5,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Sir Rodney''s Marmalade',8,3,'30 gift boxes',81,40,0,0,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Sir Rodney''s Scones',8,3,'24 pkgs. x 4 pieces',10,3,40,5,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Gustaf''s Knäckebröd',9,5,'24 - 500 g pkgs.',21,104,0,25,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Tunnbröd',9,5,'12 - 250 g pkgs.',9,61,0,25,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Guaraná Fantástica',10,1,'12 - 355 ml cans',4.5,20,0,0,1);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('NuNuCa Nuß-Nougat-Creme',11,3,'20 - 450 g glasses',14,76,0,30,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Gumbär Gummibärchen',11,3,'100 - 250 g bags',31.23,15,0,0,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Schoggi Schokolade',11,3,'100 - 100 g pieces',43.9,49,0,30,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Rössle Sauerkraut',12,7,'25 - 825 g cans',45.6,26,0,0,1);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Thüringer Rostbratwurst',12,6,'50 bags x 30 sausgs.',123.79,0,0,0,1);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Nord-Ost Matjeshering',13,8,'10 - 200 g glasses',25.89,10,0,15,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Gorgonzola Telino',14,4,'12 - 100 g pkgs',12.5,0,70,20,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Mascarpone Fabioli',14,4,'24 - 200 g pkgs.',32,9,40,25,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Geitost',15,4,'500 g',2.5,112,0,20,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Sasquatch Ale',16,1,'24 - 12 oz bottles',14,111,0,15,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Steeleye Stout',16,1,'24 - 12 oz bottles',18,20,0,15,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Inlagd Sill',17,8,'24 - 250 g  jars',19,112,0,20,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Gravad lax',17,8,'12 - 500 g pkgs.',26,11,50,25,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Côte de Blaye',18,1,'12 - 75 cl bottles',263.5,17,0,15,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Chartreuse verte',18,1,'750 cc per bottle',18,69,0,5,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Boston Crab Meat',19,8,'24 - 4 oz tins',18.4,123,0,30,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Jack''s New England Clam Chowder',19,8,'12 - 12 oz cans',9.65,85,0,10,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Singaporean Hokkien Fried Mee',20,5,'32 - 1 kg pkgs.',14,26,0,0,1);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Ipoh Coffee',20,1,'16 - 500 g tins',46,17,10,25,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Gula Malacca',20,2,'20 - 2 kg bags',19.45,27,0,15,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Rogede sild',21,8,'1k pkg.',9.5,5,70,15,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Spegesild',21,8,'4 - 450 g glasses',12,95,0,0,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Zaanse koeken',22,3,'10 - 4 oz boxes',9.5,36,0,0,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Chocolade',22,3,'10 pkgs.',12.75,15,70,25,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Maxilaku',23,3,'24 - 50 g pkgs.',20,10,60,15,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Valkoinen suklaa',23,3,'12 - 100 g bars',16.25,65,0,30,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Manjimup Dried Apples',24,7,'50 - 300 g pkgs.',53,20,0,10,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Filo Mix',24,5,'16 - 2 kg boxes',7,38,0,25,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Perth Pasties',24,6,'48 pieces',32.8,0,0,0,1);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Tourtière',25,6,'16 pies',7.45,21,0,10,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Pâté chinois',25,6,'24 boxes x 2 pies',24,115,0,20,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Gnocchi di nonna Alice',26,5,'24 - 250 g pkgs.',38,21,10,30,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Ravioli Angelo',26,5,'24 - 250 g pkgs.',19.5,36,0,20,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Escargots de Bourgogne',27,8,'24 pieces',13.25,62,0,20,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Raclette Courdavault',28,4,'5 kg pkg.',55,79,0,0,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Camembert Pierrot',28,4,'15 - 300 g rounds',34,19,0,0,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Sirop d''érable',29,2,'24 - 500 ml bottles',28.5,113,0,25,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Tarte au sucre',29,3,'48 pies',49.3,17,0,0,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Vegie-spread',7,2,'15 - 625 g jars',43.9,24,0,5,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Wimmers gute Semmelknödel',12,5,'20 bags x 4 pieces',33.25,22,80,30,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Louisiana Fiery Hot Pepper Sauce',2,2,'32 - 8 oz bottles',21.05,76,0,0,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Louisiana Hot Spiced Okra',2,2,'24 - 8 oz jars',17,4,100,20,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Laughing Lumberjack Lager',16,1,'24 - 12 oz bottles',14,52,0,10,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Scottish Longbreads',8,3,'10 boxes x 8 pieces',12.5,6,10,15,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Gudbrandsdalsost',15,4,'10 kg pkg.',36,26,0,15,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Outback Lager',7,1,'24 - 355 ml bottles',15,15,10,30,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Flotemysost',15,4,'10 - 500 g pkgs.',21.5,26,0,0,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Mozzarella di Giovanni',14,4,'24 - 200 g pkgs.',34.8,14,0,0,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Röd Kaviar',17,8,'24 - 150 g jars',15,101,0,5,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Longlife Tofu',4,7,'5 kg pkg.',10,4,20,5,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Rhönbräu Klosterbier',12,1,'24 - 0.5 l bottles',7.75,125,0,25,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Lakkalikööri',23,1,'500 ml ',18,57,0,20,0);
INSERT INTO Products (PRODUCTNAME,SUPPLIERID,CATEGORYID,QUANTITYPERUNIT,UNITPRICE,UNITSINSTOCK,UNITSONORDER,REORDERLEVEL,DISCONTINUED) VALUES ('Original Frankfurter grüne Soße',12,2,'12 boxes',13,32,0,15,0);

/* Commit changes */
COMMIT;



/* Insert into table */

INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('ALFKI','Alfreds Futterkiste','Maria Anders','Sales Representative','Obere Str. 57','Berlin',NULL,'12209','Germany','030-0074321','030-0076545');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('ANATR','Ana Trujillo Emparedados y helados','Ana Trujillo','Owner','Avda. de la Constitución 2222','México D.F.',NULL,'05021','Mexico','(5) 555-4729','(5) 555-3745');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('ANTON','Antonio Moreno Taquería','Antonio Moreno','Owner','Mataderos  2312','México D.F.',NULL,'05023','Mexico','(5) 555-3932',NULL);
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('AROUT','Around the Horn','Thomas Hardy','Sales Representative','120 Hanover Sq.','London',NULL,'WA1 1DP','UK','(171) 555-7788','(171) 555-6750');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('BERGS','Berglunds snabbköp','Christina Berglund','Order Administrator','Berguvsvägen  8','Luleå',NULL,'S-958 22','Sweden','0921-12 34 65','0921-12 34 67');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('BLAUS','Blauer See Delikatessen','Hanna Moos','Sales Representative','Forsterstr. 57','Mannheim',NULL,'68306','Germany','0621-08460','0621-08924');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('BLONP','Blondel père et fils','Frédérique Citeaux','Marketing Manager','24, place Kléber','Strasbourg',NULL,'67000','France','88.60.15.31','88.60.15.32');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('BOLID','Bólido Comidas preparadas','Martín Sommer','Owner','C/ Araquil, 67','Madrid',NULL,'28023','Spain','(91) 555 22 82','(91) 555 91 99');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('BONAP','Bon app''','Laurence Lebihan','Owner','12, rue des Bouchers','Marseille',NULL,'13008','France','91.24.45.40','91.24.45.41');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('BOTTM','Bottom-Dollar Markets','Elizabeth Lincoln','Accounting Manager','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada','(604) 555-4729','(604) 555-3745');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('BSBEV','B''s Beverages','Victoria Ashworth','Sales Representative','Fauntleroy Circus','London',NULL,'EC2 5NT','UK','(171) 555-1212',NULL);
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('CACTU','Cactus Comidas para llevar','Patricio Simpson','Sales Agent','Cerrito 333','Buenos Aires',NULL,'1010','Argentina','(1) 135-5555','(1) 135-4892');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('CENTC','Centro comercial Moctezuma','Francisco Chang','Marketing Manager','Sierras de Granada 9993','México D.F.',NULL,'05022','Mexico','(5) 555-3392','(5) 555-7293');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('CHOPS','Chop-suey Chinese','Yang Wang','Owner','Hauptstr. 29','Bern',NULL,'3012','Switzerland','0452-076545',NULL);
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('COMMI','Comércio Mineiro','Pedro Afonso','Sales Associate','Av. dos Lusíadas, 23','Sao Paulo','SP','05432-043','Brazil','(11) 555-7647',NULL);
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('CONSH','Consolidated Holdings','Elizabeth Brown','Sales Representative','Berkeley Gardens'||CHR(13)||CHR(10)||'12  Brewery ','London',NULL,'WX1 6LT','UK','(171) 555-2282','(171) 555-9199');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('DRACD','Drachenblut Delikatessen','Sven Ottlieb','Order Administrator','Walserweg 21','Aachen',NULL,'52066','Germany','0241-039123','0241-059428');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('DUMON','Du monde entier','Janine Labrune','Owner','67, rue des Cinquante Otages','Nantes',NULL,'44000','France','40.67.88.88','40.67.89.89');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('EASTC','Eastern Connection','Ann Devon','Sales Agent','35 King George','London',NULL,'WX3 6FW','UK','(171) 555-0297','(171) 555-3373');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('ERNSH','Ernst Handel','Roland Mendel','Sales Manager','Kirchgasse 6','Graz',NULL,'8010','Austria','7675-3425','7675-3426');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('FAMIA','Familia Arquibaldo','Aria Cruz','Marketing Assistant','Rua Orós, 92','Sao Paulo','SP','05442-030','Brazil','(11) 555-9857',NULL);
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('FISSA','FISSA Fabrica Inter. Salchichas S.A.','Diego Roel','Accounting Manager','C/ Moralzarzal, 86','Madrid',NULL,'28034','Spain','(91) 555 94 44','(91) 555 55 93');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('FOLIG','Folies gourmandes','Martine Rancé','Assistant Sales Agent','184, chaussée de Tournai','Lille',NULL,'59000','France','20.16.10.16','20.16.10.17');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('FOLKO','Folk och fä HB','Maria Larsson','Owner','Åkergatan 24','Bräcke',NULL,'S-844 67','Sweden','0695-34 67 21',NULL);
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('FRANK','Frankenversand','Peter Franken','Marketing Manager','Berliner Platz 43','München',NULL,'80805','Germany','089-0877310','089-0877451');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('FRANR','France restauration','Carine Schmitt','Marketing Manager','54, rue Royale','Nantes',NULL,'44000','France','40.32.21.21','40.32.21.20');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('FRANS','Franchi S.p.A.','Paolo Accorti','Sales Representative','Via Monte Bianco 34','Torino',NULL,'10100','Italy','011-4988260','011-4988261');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('FURIB','Furia Bacalhau e Frutos do Mar','Lino Rodriguez ','Sales Manager','Jardim das rosas n. 32','Lisboa',NULL,'1675','Portugal','(1) 354-2534','(1) 354-2535');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('GALED','Galería del gastrónomo','Eduardo Saavedra','Marketing Manager','Rambla de Cataluña, 23','Barcelona',NULL,'08022','Spain','(93) 203 4560','(93) 203 4561');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('GODOS','Godos Cocina Típica','José Pedro Freyre','Sales Manager','C/ Romero, 33','Sevilla',NULL,'41101','Spain','(95) 555 82 82',NULL);
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('GOURL','Gourmet Lanchonetes','André Fonseca','Sales Associate','Av. Brasil, 442','Campinas','SP','04876-786','Brazil','(11) 555-9482',NULL);
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('GREAL','Great Lakes Food Market','Howard Snyder','Marketing Manager','2732 Baker Blvd.','Eugene','OR','97403','USA','(503) 555-7555',NULL);
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('GROSR','GROSELLA-Restaurante','Manuel Pereira','Owner','5ª Ave. Los Palos Grandes','Caracas','DF','1081','Venezuela','(2) 283-2951','(2) 283-3397');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('HANAR','Hanari Carnes','Mario Pontes','Accounting Manager','Rua do Paço, 67','Rio de Janeiro','RJ','05454-876','Brazil','(21) 555-0091','(21) 555-8765');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('HILAA','HILARION-Abastos','Carlos Hernández','Sales Representative','Carrera 22 con Ave. Carlos Soublette #8-35','San Cristóbal','Táchira','5022','Venezuela','(5) 555-1340','(5) 555-1948');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('HUNGC','Hungry Coyote Import Store','Yoshi Latimer','Sales Representative','City Center Plaza'||CHR(13)||CHR(10)||'516 Main St.','Elgin','OR','97827','USA','(503) 555-6874','(503) 555-2376');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('HUNGO','Hungry Owl All-Night Grocers','Patricia McKenna','Sales Associate','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland','2967 542','2967 3333');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('ISLAT','Island Trading','Helen Bennett','Marketing Manager','Garden House'||CHR(13)||CHR(10)||'Crowther Way','Cowes','Isle of Wight','PO31 7PJ','UK','(198) 555-8888',NULL);
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('KOENE','Königlich Essen','Philip Cramer','Sales Associate','Maubelstr. 90','Brandenburg',NULL,'14776','Germany','0555-09876',NULL);
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('LACOR','La corne d''abondance','Daniel Tonini','Sales Representative','67, avenue de l''Europe','Versailles',NULL,'78000','France','30.59.84.10','30.59.85.11');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('LAMAI','La maison d''Asie','Annette Roulet','Sales Manager','1 rue Alsace-Lorraine','Toulouse',NULL,'31000','France','61.77.61.10','61.77.61.11');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('LAUGB','Laughing Bacchus Wine Cellars','Yoshi Tannamuri','Marketing Assistant','1900 Oak St.','Vancouver','BC','V3F 2K1','Canada','(604) 555-3392','(604) 555-7293');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('LAZYK','Lazy K Kountry Store','John Steel','Marketing Manager','12 Orchestra Terrace','Walla Walla','WA','99362','USA','(509) 555-7969','(509) 555-6221');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('LEHMS','Lehmanns Marktstand','Renate Messner','Sales Representative','Magazinweg 7','Frankfurt a.M. ',NULL,'60528','Germany','069-0245984','069-0245874');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('LETSS','Let''s Stop N Shop','Jaime Yorres','Owner','87 Polk St.'||CHR(13)||CHR(10)||'Suite 5','San Francisco','CA','94117','USA','(415) 555-5938',NULL);
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('LILAS','LILA-Supermercado','Carlos González','Accounting Manager','Carrera 52 con Ave. Bolívar #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela','(9) 331-6954','(9) 331-7256');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('LINOD','LINO-Delicateses','Felipe Izquierdo','Owner','Ave. 5 de Mayo Porlamar','I. de Margarita','Nueva Esparta','4980','Venezuela','(8) 34-56-12','(8) 34-93-93');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('LONEP','Lonesome Pine Restaurant','Fran Wilson','Sales Manager','89 Chiaroscuro Rd.','Portland','OR','97219','USA','(503) 555-9573','(503) 555-9646');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('MAGAA','Magazzini Alimentari Riuniti','Giovanni Rovelli','Marketing Manager','Via Ludovico il Moro 22','Bergamo',NULL,'24100','Italy','035-640230','035-640231');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('MAISD','Maison Dewey','Catherine Dewey','Sales Agent','Rue Joseph-Bens 532','Bruxelles',NULL,'B-1180','Belgium','(02) 201 24 67','(02) 201 24 68');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('MEREP','Mère Paillarde','Jean Fresnière','Marketing Assistant','43 rue St. Laurent','Montréal','Québec','H1J 1C3','Canada','(514) 555-8054','(514) 555-8055');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('MORGK','Morgenstern Gesundkost','Alexander Feuer','Marketing Assistant','Heerstr. 22','Leipzig',NULL,'04179','Germany','0342-023176',NULL);
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('NORTS','North/South','Simon Crowther','Sales Associate','South House'||CHR(13)||CHR(10)||'300 Queensbridge','London',NULL,'SW7 1RZ','UK','(171) 555-7733','(171) 555-2530');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('OCEAN','Océano Atlántico Ltda.','Yvonne Moncada','Sales Agent','Ing. Gustavo Moncada 8585'||CHR(13)||CHR(10)||'Piso 20-A','Buenos Aires',NULL,'1010','Argentina','(1) 135-5333','(1) 135-5535');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('OLDWO','Old World Delicatessen','Rene Phillips','Sales Representative','2743 Bering St.','Anchorage','AK','99508','USA','(907) 555-7584','(907) 555-2880');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('OTTIK','Ottilies Käseladen','Henriette Pfalzheim','Owner','Mehrheimerstr. 369','Köln',NULL,'50739','Germany','0221-0644327','0221-0765721');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('PARIS','Paris spécialités','Marie Bertrand','Owner','265, boulevard Charonne','Paris',NULL,'75012','France','(1) 42.34.22.66','(1) 42.34.22.77');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('PERIC','Pericles Comidas clásicas','Guillermo Fernández','Sales Representative','Calle Dr. Jorge Cash 321','México D.F.',NULL,'05033','Mexico','(5) 552-3745','(5) 545-3745');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('PICCO','Piccolo und mehr','Georg Pipps','Sales Manager','Geislweg 14','Salzburg',NULL,'5020','Austria','6562-9722','6562-9723');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('PRINI','Princesa Isabel Vinhos','Isabel de Castro','Sales Representative','Estrada da saúde n. 58','Lisboa',NULL,'1756','Portugal','(1) 356-5634',NULL);
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('QUEDE','Que Delícia','Bernardo Batista','Accounting Manager','Rua da Panificadora, 12','Rio de Janeiro','RJ','02389-673','Brazil','(21) 555-4252','(21) 555-4545');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('QUEEN','Queen Cozinha','Lúcia Carvalho','Marketing Assistant','Alameda dos Canàrios, 891','Sao Paulo','SP','05487-020','Brazil','(11) 555-1189',NULL);
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('QUICK','QUICK-Stop','Horst Kloss','Accounting Manager','Taucherstraße 10','Cunewalde',NULL,'01307','Germany','0372-035188',NULL);
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('RANCH','Rancho grande','Sergio Gutiérrez','Sales Representative','Av. del Libertador 900','Buenos Aires',NULL,'1010','Argentina','(1) 123-5555','(1) 123-5556');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('RATTC','Rattlesnake Canyon Grocery','Paula Wilson','Assistant Sales Representative','2817 Milton Dr.','Albuquerque','NM','87110','USA','(505) 555-5939','(505) 555-3620');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('REGGC','Reggiani Caseifici','Maurizio Moroni','Sales Associate','Strada Provinciale 124','Reggio Emilia',NULL,'42100','Italy','0522-556721','0522-556722');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('RICAR','Ricardo Adocicados','Janete Limeira','Assistant Sales Agent','Av. Copacabana, 267','Rio de Janeiro','RJ','02389-890','Brazil','(21) 555-3412',NULL);
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('RICSU','Richter Supermarkt','Michael Holz','Sales Manager','Grenzacherweg 237','Genève',NULL,'1203','Switzerland','0897-034214',NULL);
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('ROMEY','Romero y tomillo','Alejandra Camino','Accounting Manager','Gran Vía, 1','Madrid',NULL,'28001','Spain','(91) 745 6200','(91) 745 6210');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('SANTG','Santé Gourmet','Jonas Bergulfsen','Owner','Erling Skakkes gate 78','Stavern',NULL,'4110','Norway','07-98 92 35','07-98 92 47');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('SAVEA','Save-a-lot Markets','Jose Pavarotti','Sales Representative','187 Suffolk Ln.','Boise','ID','83720','USA','(208) 555-8097',NULL);
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('SEVES','Seven Seas Imports','Hari Kumar','Sales Manager','90 Wadhurst Rd.','London',NULL,'OX15 4NB','UK','(171) 555-1717','(171) 555-5646');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('SIMOB','Simons bistro','Jytte Petersen','Owner','Vinbæltet 34','Kobenhavn',NULL,'1734','Denmark','31 12 34 56','31 13 35 57');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('SPECD','spécialités du monde','Dominique Perrier','Marketing Manager','25, rue Lauriston','Paris',NULL,'75016','France','(1) 47.55.60.10','(1) 47.55.60.20');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('SPLIR','Split Rail Beer '||Chr(38)||' Ale','Art Braunschweiger','Sales Manager','P.O. Box 555','Lander','WY','82520','USA','(307) 555-4680','(307) 555-6525');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('SUPRD','Suprêmes délices','Pascale Cartrain','Accounting Manager','Boulevard Tirou, 255','Charleroi',NULL,'B-6000','Belgium','(071) 23 67 22 20','(071) 23 67 22 21');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('THEBI','The Big Cheese','Liz Nixon','Marketing Manager','89 Jefferson Way'||CHR(13)||CHR(10)||'Suite 2','Portland','OR','97201','USA','(503) 555-3612',NULL);
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('THECR','The Cracker Box','Liu Wong','Marketing Assistant','55 Grizzly Peak Rd.','Butte','MT','59801','USA','(406) 555-5834','(406) 555-8083');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('TOMSP','Toms Spezialitäten','Karin Josephs','Marketing Manager','Luisenstr. 48','Münster',NULL,'44087','Germany','0251-031259','0251-035695');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('TORTU','Tortuga Restaurante','Miguel Angel Paolino','Owner','Avda. Azteca 123','México D.F.',NULL,'05033','Mexico','(5) 555-2933',NULL);
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('TRADH','Tradiçao Hipermercados','Anabela Domingues','Sales Representative','Av. Inês de Castro, 414','Sao Paulo','SP','05634-030','Brazil','(11) 555-2167','(11) 555-2168');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('TRAIH','Trail''s Head Gourmet Provisioners','Helvetius Nagy','Sales Associate','722 DaVinci Blvd.','Kirkland','WA','98034','USA','(206) 555-8257','(206) 555-2174');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('VAFFE','Vaffeljernet','Palle Ibsen','Sales Manager','Smagsloget 45','Århus',NULL,'8200','Denmark','86 21 32 43','86 22 33 44');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('VICTE','Victuailles en stock','Mary Saveley','Sales Agent','2, rue du Commerce','Lyon',NULL,'69004','France','78.32.54.86','78.32.54.87');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('VINET','Vins et alcools Chevalier','Paul Henriot','Accounting Manager','59 rue de l''Abbaye','Reims',NULL,'51100','France','26.47.15.10','26.47.15.11');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('WANDK','Die Wandernde Kuh','Rita Müller','Sales Representative','Adenauerallee 900','Stuttgart',NULL,'70563','Germany','0711-020361','0711-035428');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('WARTH','Wartian Herkku','Pirkko Koskitalo','Accounting Manager','Torikatu 38','Oulu',NULL,'90110','Finland','981-443655','981-443655');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('WELLI','Wellington Importadora','Paula Parente','Sales Manager','Rua do Mercado, 12','Resende','SP','08737-363','Brazil','(14) 555-8122',NULL);
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('WHITC','White Clover Markets','Karl Jablonski','Owner','305 - 14th Ave. S.'||CHR(13)||CHR(10)||'Suite 3B','Seattle','WA','98128','USA','(206) 555-4112','(206) 555-4115');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('WILMK','Wilman Kala','Matti Karttunen','Owner/Marketing Assistant','Keskuskatu 45','Helsinki',NULL,'21240','Finland','90-224 8858','90-224 8858');
INSERT INTO Customers (CUSTOMERID, COMPANYNAME,CONTACTNAME,CONTACTTITLE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,PHONE,FAX) VALUES ('WOLZA','Wolski  Zajazd','Zbyszek Piestrzeniewicz','Owner','ul. Filtrowa 68','Warszawa',NULL,'01-012','Poland','(26) 642-7012','(26) 642-7012');

/* Commit changes */
COMMIT;


/* Insert into table */

INSERT INTO Shippers (COMPANYNAME,PHONE) VALUES ('Speedy Express','(503) 555-9831');
INSERT INTO Shippers (COMPANYNAME,PHONE) VALUES ('United Package','(503) 555-3199');
INSERT INTO Shippers (COMPANYNAME,PHONE) VALUES ('Federal Shipping','(503) 555-9931');

/* Commit changes */
COMMIT;


/* Insert into table */
INSERT INTO Employees (LASTNAME,FIRSTNAME,TITLE,TITLEOFCOURTESY,BIRTHDATE,HIREDATE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,HOMEPHONE,EXTENSION,PHOTO,NOTES,REPORTSTO) VALUES ('Fuller','Andrew','Vice President, Sales','Dr.',TO_DATE('19-Feb-1952'),TO_DATE('2448849;00000','J;SSSSS'),'908 W. Capital Way','Tacoma','WA','98401','USA','(206) 555-9482','3457','EmpID2.bmp','Andrew received his BTS commercial and a Ph.D. in international marketing from the University of Dallas.  He is fluent in French and Italian and reads German.  He joined the company as a sales representative, was promoted to sales manager and was then named vice president of sales.  Andrew is a member of the Sales Management Roundtable, the Seattle Chamber of Commerce, and the Pacific Rim Importers Association.',NULL);
INSERT INTO Employees (LASTNAME,FIRSTNAME,TITLE,TITLEOFCOURTESY,BIRTHDATE,HIREDATE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,HOMEPHONE,EXTENSION,PHOTO,NOTES,REPORTSTO) VALUES ('Davolio','Nancy','Sales Representative','Ms.',TO_DATE('8-Dec-1948'),TO_DATE('2448744;00000','J;SSSSS'),'507 - 20th Ave. E.'||CHR(13)||CHR(10)||'Apt. 2A','Seattle','WA','98122','USA','(206) 555-9857','5467','EmpID1.bmp','Education includes a BA in psychology from Colorado State University.  She also completed "The Art of the Cold Call."  Nancy is a member of Toastmasters International.',2);
INSERT INTO Employees (LASTNAME,FIRSTNAME,TITLE,TITLEOFCOURTESY,BIRTHDATE,HIREDATE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,HOMEPHONE,EXTENSION,PHOTO,NOTES,REPORTSTO) VALUES ('Leverling','Janet','Sales Representative','Ms.',TO_DATE('30-Aug-1963'),TO_DATE('2448714;00000','J;SSSSS'),'722 Moss Bay Blvd.','Kirkland','WA','98033','USA','(206) 555-3412','3355','EmpID3.bmp','Janet has a BS degree in chemistry from Boston College).  She has also completed a certificate program in food retailing management.  Janet was hired as a sales associate and was promoted to sales representative.',2);
INSERT INTO Employees (LASTNAME,FIRSTNAME,TITLE,TITLEOFCOURTESY,BIRTHDATE,HIREDATE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,HOMEPHONE,EXTENSION,PHOTO,NOTES,REPORTSTO) VALUES ('Peacock','Margaret','Sales Representative','Mrs.',TO_DATE('19-Sep-1937'),TO_DATE('2449111;00000','J;SSSSS'),'4110 Old Redmond Rd.','Redmond','WA','98052','USA','(206) 555-8122','5176','EmpID4.bmp','Margaret holds a BA in English literature from Concordia College and an MA from the American Institute of Culinary Arts. She was temporarily assigned to the London office before returning to her permanent post in Seattle.',2);
INSERT INTO Employees (LASTNAME,FIRSTNAME,TITLE,TITLEOFCOURTESY,BIRTHDATE,HIREDATE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,HOMEPHONE,EXTENSION,PHOTO,NOTES,REPORTSTO) VALUES ('Buchanan','Steven','Sales Manager','Mr.',TO_DATE('04-Mar-1955'),TO_DATE('2449278;00000','J;SSSSS'),'14 Garrett Hill','London',NULL,'SW1 8JR','UK','(71) 555-4848','3453','EmpID5.bmp','Steven Buchanan graduated from St. Andrews University, Scotland, with a BSC degree.  Upon joining the company as a sales representative, he spent 6 months in an orientation program at the Seattle office and then returned to his permanent post in London, where he was promoted to sales manager.  Mr. Buchanan has completed the courses "Successful Telemarketing" and "International Sales Management."  He is fluent in French.',2);
INSERT INTO Employees (LASTNAME,FIRSTNAME,TITLE,TITLEOFCOURTESY,BIRTHDATE,HIREDATE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,HOMEPHONE,EXTENSION,PHOTO,NOTES,REPORTSTO) VALUES ('Suyama','Michael','Sales Representative','Mr.',TO_DATE('02-Jul-1963'),TO_DATE('2449278;00000','J;SSSSS'),'Coventry House'||CHR(13)||CHR(10)||'Miner Rd.','London',NULL,'EC2 7JR','UK','(71) 555-7773','428','EmpID6.bmp','Michael is a graduate of Sussex University (MA, economics) and the University of California at Los Angeles (MBA, marketing).  He has also taken the courses "Multi-Cultural Selling" and "Time Management for the Sales Professional."  He is fluent in Japanese and can read and write French, Portuguese, and Spanish.',5);
INSERT INTO Employees (LASTNAME,FIRSTNAME,TITLE,TITLEOFCOURTESY,BIRTHDATE,HIREDATE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,HOMEPHONE,EXTENSION,PHOTO,NOTES,REPORTSTO) VALUES ('King','Robert','Sales Representative','Mr.',TO_DATE('29-May-1960'),TO_DATE('2449355;00000','J;SSSSS'),'Edgeham Hollow'||CHR(13)||CHR(10)||'Winchester Way','London',NULL,'RG1 9SP','UK','(71) 555-5598','465','EmpID7.bmp','Robert King served in the Peace Corps and traveled extensively before completing his degree in English at the University of Michigan and then joining the company.  After completing a course entitled "Selling in Europe," he was transferred to the London office.',5);
INSERT INTO Employees (LASTNAME,FIRSTNAME,TITLE,TITLEOFCOURTESY,BIRTHDATE,HIREDATE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,HOMEPHONE,EXTENSION,PHOTO,NOTES,REPORTSTO) VALUES ('Callahan','Laura','Inside Sales Coordinator','Ms.',TO_DATE('09-Jan-1958'),TO_DATE('2449417;00000','J;SSSSS'),'4726 - 11th Ave. N.E.','Seattle','WA','98105','USA','(206) 555-1189','2344','EmpID8.bmp','Laura received a BA in psychology from the University of Washington.  She has also completed a course in business French.  She reads and writes French.',2);
INSERT INTO Employees (LASTNAME,FIRSTNAME,TITLE,TITLEOFCOURTESY,BIRTHDATE,HIREDATE,ADDRESS,CITY,Region,POSTALCODE,COUNTRY,HOMEPHONE,EXTENSION,PHOTO,NOTES,REPORTSTO) VALUES ('Dodsworth','Anne','Sales Representative','Ms.',TO_DATE('27-Jan-1966'),TO_DATE('2449672;00000','J;SSSSS'),'7 Houndstooth Rd.','London',NULL,'WG2 7LT','UK','(71) 555-4444','452','EmpID9.bmp','Anne has a BA degree in English from St. Lawrence College.  She is fluent in French and German.',5);

/* Commit changes */
COMMIT;


/* Insert into table */

INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WILMK',5,TO_DATE('2450269;00000','J;SSSSS'),TO_DATE('2450297;00000','J;SSSSS'),TO_DATE('2450281;00000','J;SSSSS'),3,32.38,'Vins et alcools Chevalier','59 rue de l''Abbaye','Reims',NULL,'51100','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('TRADH',6,TO_DATE('2450270;00000','J;SSSSS'),TO_DATE('2450312;00000','J;SSSSS'),TO_DATE('2450275;00000','J;SSSSS'),1,11.61,'Toms Spezialitäten','Luisenstr. 48','Münster',NULL,'44087','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HANAR',4,TO_DATE('2450273;00000','J;SSSSS'),TO_DATE('2450301;00000','J;SSSSS'),TO_DATE('2450277;00000','J;SSSSS'),2,65.83,'Hanari Carnes','Rua do Paço, 67','Rio de Janeiro','RJ','05454-876','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('VICTE',3,TO_DATE('2450273;00000','J;SSSSS'),TO_DATE('2450301;00000','J;SSSSS'),TO_DATE('2450280;00000','J;SSSSS'),1,41.34,'Victuailles en stock','2, rue du Commerce','Lyon',NULL,'69004','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SUPRD',4,TO_DATE('2450274;00000','J;SSSSS'),TO_DATE('2450302;00000','J;SSSSS'),TO_DATE('2450276;00000','J;SSSSS'),2,51.3,'Suprêmes délices','Boulevard Tirou, 255','Charleroi',NULL,'B-6000','Belgium');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HANAR',3,TO_DATE('2450275;00000','J;SSSSS'),TO_DATE('2450289;00000','J;SSSSS'),TO_DATE('2450281;00000','J;SSSSS'),2,58.17,'Hanari Carnes','Rua do Paço, 67','Rio de Janeiro','RJ','05454-876','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('CHOPS',5,TO_DATE('2450276;00000','J;SSSSS'),TO_DATE('2450304;00000','J;SSSSS'),TO_DATE('2450288;00000','J;SSSSS'),2,22.98,'Chop-suey Chinese','Hauptstr. 31','Bern',NULL,'3012','Switzerland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RICSU',9,TO_DATE('2450277;00000','J;SSSSS'),TO_DATE('2450305;00000','J;SSSSS'),TO_DATE('2450280;00000','J;SSSSS'),3,148.33,'Richter Supermarkt','Starenweg 5','Genève',NULL,'1204','Switzerland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WELLI',3,TO_DATE('2450280;00000','J;SSSSS'),TO_DATE('2450308;00000','J;SSSSS'),TO_DATE('2450282;00000','J;SSSSS'),2,13.97,'Wellington Importadora','Rua do Mercado, 12','Resende','SP','08737-363','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HILAA',4,TO_DATE('2450281;00000','J;SSSSS'),TO_DATE('2450309;00000','J;SSSSS'),TO_DATE('2450287;00000','J;SSSSS'),3,81.91,'HILARION-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Cristóbal','Táchira','5022','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ERNSH',1,TO_DATE('2450282;00000','J;SSSSS'),TO_DATE('2450310;00000','J;SSSSS'),TO_DATE('2450288;00000','J;SSSSS'),1,140.51,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('CENTC',4,TO_DATE('2450283;00000','J;SSSSS'),TO_DATE('2450311;00000','J;SSSSS'),TO_DATE('2450290;00000','J;SSSSS'),3,3.25,'Centro comercial Moctezuma','Sierras de Granada 9993','México D.F.',NULL,'05022','Mexico');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('OLDWO',4,TO_DATE('2450284;00000','J;SSSSS'),TO_DATE('2450312;00000','J;SSSSS'),TO_DATE('2450294;00000','J;SSSSS'),1,55.09,'Ottilies Käseladen','Mehrheimerstr. 369','Köln',NULL,'50739','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUEDE',4,TO_DATE('2450284;00000','J;SSSSS'),TO_DATE('2450312;00000','J;SSSSS'),TO_DATE('2450295;00000','J;SSSSS'),2,3.05,'Que Delícia','Rua da Panificadora, 12','Rio de Janeiro','RJ','02389-673','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RATTC',8,TO_DATE('2450287;00000','J;SSSSS'),TO_DATE('2450315;00000','J;SSSSS'),TO_DATE('2450290;00000','J;SSSSS'),3,48.29,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ERNSH',9,TO_DATE('2450288;00000','J;SSSSS'),TO_DATE('2450316;00000','J;SSSSS'),TO_DATE('2450296;00000','J;SSSSS'),3,146.06,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FOLKO',6,TO_DATE('2450289;00000','J;SSSSS'),TO_DATE('2450317;00000','J;SSSSS'),TO_DATE('2450319;00000','J;SSSSS'),3,3.67,'Folk och fä HB','Åkergatan 24','Bräcke',NULL,'S-844 67','Sweden');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BLONP',2,TO_DATE('2450290;00000','J;SSSSS'),TO_DATE('2450318;00000','J;SSSSS'),TO_DATE('2450308;00000','J;SSSSS'),1,55.28,'Blondel père et fils','24, place Kléber','Strasbourg',NULL,'67000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WARTH',3,TO_DATE('2450291;00000','J;SSSSS'),TO_DATE('2450333;00000','J;SSSSS'),TO_DATE('2450296;00000','J;SSSSS'),3,25.73,'Wartian Herkku','Torikatu 38','Oulu',NULL,'90110','Finland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FRANK',4,TO_DATE('2450294;00000','J;SSSSS'),TO_DATE('2450322;00000','J;SSSSS'),TO_DATE('2450302;00000','J;SSSSS'),1,208.58,'Frankenversand','Berliner Platz 43','München',NULL,'80805','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('GROSR',8,TO_DATE('2450295;00000','J;SSSSS'),TO_DATE('2450323;00000','J;SSSSS'),TO_DATE('2450298;00000','J;SSSSS'),3,66.29,'GROSELLA-Restaurante','5ª Ave. Los Palos Grandes','Caracas','DF','1081','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WHITC',5,TO_DATE('2450296;00000','J;SSSSS'),TO_DATE('2450310;00000','J;SSSSS'),TO_DATE('2450305;00000','J;SSSSS'),1,4.56,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WARTH',1,TO_DATE('2450297;00000','J;SSSSS'),TO_DATE('2450325;00000','J;SSSSS'),TO_DATE('2450298;00000','J;SSSSS'),1,136.54,'Wartian Herkku','Torikatu 38','Oulu',NULL,'90110','Finland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SPLIR',6,TO_DATE('2450297;00000','J;SSSSS'),TO_DATE('2450325;00000','J;SSSSS'),TO_DATE('2450326;00000','J;SSSSS'),2,4.54,'Split Rail Beer '||Chr(38)||' Ale','P.O. Box 555','Lander','WY','82520','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RATTC',6,TO_DATE('2450298;00000','J;SSSSS'),TO_DATE('2450326;00000','J;SSSSS'),TO_DATE('2450302;00000','J;SSSSS'),2,98.03,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUICK',3,TO_DATE('2450301;00000','J;SSSSS'),TO_DATE('2450329;00000','J;SSSSS'),TO_DATE('2450308;00000','J;SSSSS'),3,76.07,'QUICK-Stop','Taucherstraße 10','Cunewalde',NULL,'01307','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('VINET',6,TO_DATE('2450302;00000','J;SSSSS'),TO_DATE('2450330;00000','J;SSSSS'),TO_DATE('2450312;00000','J;SSSSS'),1,6.01,'Vins et alcools Chevalier','59 rue de l''Abbaye','Reims',NULL,'51100','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('MAGAA',1,TO_DATE('2450303;00000','J;SSSSS'),TO_DATE('2450331;00000','J;SSSSS'),TO_DATE('2450305;00000','J;SSSSS'),1,26.93,'Magazzini Alimentari Riuniti','Via Ludovico il Moro 22','Bergamo',NULL,'24100','Italy');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('TORTU',8,TO_DATE('2450304;00000','J;SSSSS'),TO_DATE('2450318;00000','J;SSSSS'),TO_DATE('2450310;00000','J;SSSSS'),3,13.84,'Tortuga Restaurante','Avda. Azteca 123','México D.F.',NULL,'05033','Mexico');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('MORGK',2,TO_DATE('2450305;00000','J;SSSSS'),TO_DATE('2450333;00000','J;SSSSS'),TO_DATE('2450309;00000','J;SSSSS'),3,125.77,'Morgenstern Gesundkost','Heerstr. 22','Leipzig',NULL,'04179','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BERGS',8,TO_DATE('2450308;00000','J;SSSSS'),TO_DATE('2450336;00000','J;SSSSS'),TO_DATE('2450312;00000','J;SSSSS'),2,92.69,'Berglunds snabbköp','Berguvsvägen  8','Luleå',NULL,'S-958 22','Sweden');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LEHMS',8,TO_DATE('2450309;00000','J;SSSSS'),TO_DATE('2450337;00000','J;SSSSS'),TO_DATE('2450312;00000','J;SSSSS'),2,25.83,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M. ',NULL,'60528','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BERGS',2,TO_DATE('2450310;00000','J;SSSSS'),TO_DATE('2450338;00000','J;SSSSS'),TO_DATE('2450339;00000','J;SSSSS'),1,8.98,'Berglunds snabbköp','Berguvsvägen  8','Luleå',NULL,'S-958 22','Sweden');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ROMEY',4,TO_DATE('2450310;00000','J;SSSSS'),TO_DATE('2450324;00000','J;SSSSS'),TO_DATE('2450317;00000','J;SSSSS'),1,2.94,'Romero y tomillo','Gran Vía, 1','Madrid',NULL,'28001','Spain');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ROMEY',4,TO_DATE('2450311;00000','J;SSSSS'),TO_DATE('2450339;00000','J;SSSSS'),TO_DATE('2450317;00000','J;SSSSS'),1,12.69,'Romero y tomillo','Gran Vía, 1','Madrid',NULL,'28001','Spain');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LILAS',3,TO_DATE('2450312;00000','J;SSSSS'),TO_DATE('2450340;00000','J;SSSSS'),TO_DATE('2450319;00000','J;SSSSS'),3,84.81,'LILA-Supermercado','Carrera 52 con Ave. Bolívar #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LEHMS',4,TO_DATE('2450315;00000','J;SSSSS'),TO_DATE('2450343;00000','J;SSSSS'),TO_DATE('2450323;00000','J;SSSSS'),1,76.56,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M. ',NULL,'60528','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUICK',1,TO_DATE('2450316;00000','J;SSSSS'),TO_DATE('2450344;00000','J;SSSSS'),TO_DATE('2450322;00000','J;SSSSS'),2,76.83,'QUICK-Stop','Taucherstraße 10','Cunewalde',NULL,'01307','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUICK',8,TO_DATE('2450317;00000','J;SSSSS'),TO_DATE('2450345;00000','J;SSSSS'),TO_DATE('2450326;00000','J;SSSSS'),3,229.24,'QUICK-Stop','Taucherstraße 10','Cunewalde',NULL,'01307','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RICAR',8,TO_DATE('2450318;00000','J;SSSSS'),TO_DATE('2450346;00000','J;SSSSS'),TO_DATE('2450324;00000','J;SSSSS'),3,12.76,'Ricardo Adocicados','Av. Copacabana, 267','Rio de Janeiro','RJ','02389-890','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('REGGC',4,TO_DATE('2450319;00000','J;SSSSS'),TO_DATE('2450347;00000','J;SSSSS'),TO_DATE('2450330;00000','J;SSSSS'),1,7.45,'Reggiani Caseifici','Strada Provinciale 124','Reggio Emilia',NULL,'42100','Italy');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BSBEV',7,TO_DATE('2450322;00000','J;SSSSS'),TO_DATE('2450350;00000','J;SSSSS'),TO_DATE('2450324;00000','J;SSSSS'),3,22.77,'B''s Beverages','Fauntleroy Circus','London',NULL,'EC2 5NT','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('COMMI',8,TO_DATE('2450323;00000','J;SSSSS'),TO_DATE('2450351;00000','J;SSSSS'),TO_DATE('2450330;00000','J;SSSSS'),1,79.7,'Comércio Mineiro','Av. dos Lusíadas, 23','Sao Paulo','SP','05432-043','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUEDE',6,TO_DATE('2450323;00000','J;SSSSS'),TO_DATE('2450351;00000','J;SSSSS'),TO_DATE('2450331;00000','J;SSSSS'),2,6.4,'Que Delícia','Rua da Panificadora, 12','Rio de Janeiro','RJ','02389-673','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('TRADH',1,TO_DATE('2450324;00000','J;SSSSS'),TO_DATE('2450352;00000','J;SSSSS'),TO_DATE('2450329;00000','J;SSSSS'),2,1.35,'Tradiçao Hipermercados','Av. Inês de Castro, 414','Sao Paulo','SP','05634-030','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('TORTU',1,TO_DATE('2450325;00000','J;SSSSS'),TO_DATE('2450353;00000','J;SSSSS'),TO_DATE('2450338;00000','J;SSSSS'),3,21.18,'Tortuga Restaurante','Avda. Azteca 123','México D.F.',NULL,'05033','Mexico');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RATTC',4,TO_DATE('2450326;00000','J;SSSSS'),TO_DATE('2450354;00000','J;SSSSS'),TO_DATE('2450332;00000','J;SSSSS'),2,147.26,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('VINET',2,TO_DATE('2450329;00000','J;SSSSS'),TO_DATE('2450357;00000','J;SSSSS'),TO_DATE('2450337;00000','J;SSSSS'),2,1.15,'Vins et alcools Chevalier','59 rue de l''Abbaye','Reims',NULL,'51100','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LILAS',6,TO_DATE('2450330;00000','J;SSSSS'),TO_DATE('2450358;00000','J;SSSSS'),TO_DATE('2450338;00000','J;SSSSS'),1,.12,'LILA-Supermercado','Carrera 52 con Ave. Bolívar #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BLONP',5,TO_DATE('2450331;00000','J;SSSSS'),TO_DATE('2450373;00000','J;SSSSS'),TO_DATE('2450337;00000','J;SSSSS'),2,5.74,'Blondel père et fils','24, place Kléber','Strasbourg',NULL,'67000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HUNGO',6,TO_DATE('2450332;00000','J;SSSSS'),TO_DATE('2450360;00000','J;SSSSS'),TO_DATE('2450338;00000','J;SSSSS'),2,168.22,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RICAR',4,TO_DATE('2450333;00000','J;SSSSS'),TO_DATE('2450361;00000','J;SSSSS'),TO_DATE('2450340;00000','J;SSSSS'),2,29.76,'Ricardo Adocicados','Av. Copacabana, 267','Rio de Janeiro','RJ','02389-890','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('MAGAA',2,TO_DATE('2450336;00000','J;SSSSS'),TO_DATE('2450364;00000','J;SSSSS'),TO_DATE('2450345;00000','J;SSSSS'),2,17.68,'Magazzini Alimentari Riuniti','Via Ludovico il Moro 22','Bergamo',NULL,'24100','Italy');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WANDK',8,TO_DATE('2450336;00000','J;SSSSS'),TO_DATE('2450364;00000','J;SSSSS'),TO_DATE('2450344;00000','J;SSSSS'),2,45.08,'Die Wandernde Kuh','Adenauerallee 900','Stuttgart',NULL,'70563','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SUPRD',4,TO_DATE('2450337;00000','J;SSSSS'),TO_DATE('2450365;00000','J;SSSSS'),TO_DATE('2450366;00000','J;SSSSS'),2,6.27,'Suprêmes délices','Boulevard Tirou, 255','Charleroi',NULL,'B-6000','Belgium');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('GODOS',7,TO_DATE('2450338;00000','J;SSSSS'),TO_DATE('2450366;00000','J;SSSSS'),TO_DATE('2450345;00000','J;SSSSS'),2,107.83,'Godos Cocina Típica','C/ Romero, 33','Sevilla',NULL,'41101','Spain');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('TORTU',1,TO_DATE('2450339;00000','J;SSSSS'),TO_DATE('2450367;00000','J;SSSSS'),TO_DATE('2450344;00000','J;SSSSS'),2,63.79,'Tortuga Restaurante','Avda. Azteca 123','México D.F.',NULL,'05033','Mexico');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('OLDWO',8,TO_DATE('2450340;00000','J;SSSSS'),TO_DATE('2450368;00000','J;SSSSS'),TO_DATE('2450366;00000','J;SSSSS'),3,257.62,'Old World Delicatessen','2743 Bering St.','Anchorage','AK','99508','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ROMEY',1,TO_DATE('2450343;00000','J;SSSSS'),TO_DATE('2450371;00000','J;SSSSS'),TO_DATE('2450350;00000','J;SSSSS'),3,7.56,'Romero y tomillo','Gran Vía, 1','Madrid',NULL,'28001','Spain');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LONEP',2,TO_DATE('2450344;00000','J;SSSSS'),TO_DATE('2450372;00000','J;SSSSS'),TO_DATE('2450352;00000','J;SSSSS'),2,.56,'Lonesome Pine Restaurant','89 Chiaroscuro Rd.','Portland','OR','97219','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ANATR',7,TO_DATE('2450345;00000','J;SSSSS'),TO_DATE('2450373;00000','J;SSSSS'),TO_DATE('2450351;00000','J;SSSSS'),3,1.61,'Ana Trujillo Emparedados y helados','Avda. de la Constitución 2222','México D.F.',NULL,'05021','Mexico');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HUNGO',3,TO_DATE('2450346;00000','J;SSSSS'),TO_DATE('2450374;00000','J;SSSSS'),TO_DATE('2450380;00000','J;SSSSS'),1,47.3,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('THEBI',8,TO_DATE('2450347;00000','J;SSSSS'),TO_DATE('2450375;00000','J;SSSSS'),TO_DATE('2450354;00000','J;SSSSS'),2,17.52,'The Big Cheese','89 Jefferson Way'||CHR(13)||CHR(10)||'Suite 2','Portland','OR','97201','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('DUMON',1,TO_DATE('2450347;00000','J;SSSSS'),TO_DATE('2450361;00000','J;SSSSS'),TO_DATE('2450353;00000','J;SSSSS'),3,24.69,'Du monde entier','67, rue des Cinquante Otages','Nantes',NULL,'44000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WANDK',2,TO_DATE('2450350;00000','J;SSSSS'),TO_DATE('2450378;00000','J;SSSSS'),TO_DATE('2450360;00000','J;SSSSS'),2,40.26,'Die Wandernde Kuh','Adenauerallee 900','Stuttgart',NULL,'70563','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUICK',2,TO_DATE('2450351;00000','J;SSSSS'),TO_DATE('2450379;00000','J;SSSSS'),TO_DATE('2450361;00000','J;SSSSS'),2,1.96,'QUICK-Stop','Taucherstraße 10','Cunewalde',NULL,'01307','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RATTC',1,TO_DATE('2450352;00000','J;SSSSS'),TO_DATE('2450380;00000','J;SSSSS'),TO_DATE('2450361;00000','J;SSSSS'),2,74.16,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ISLAT',4,TO_DATE('2450353;00000','J;SSSSS'),TO_DATE('2450381;00000','J;SSSSS'),TO_DATE('2450360;00000','J;SSSSS'),2,41.76,'Island Trading','Garden House'||CHR(13)||CHR(10)||'Crowther Way','Cowes','Isle of Wight','PO31 7PJ','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RATTC',1,TO_DATE('2450354;00000','J;SSSSS'),TO_DATE('2450382;00000','J;SSSSS'),TO_DATE('2450365;00000','J;SSSSS'),3,150.15,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LONEP',6,TO_DATE('2450357;00000','J;SSSSS'),TO_DATE('2450385;00000','J;SSSSS'),TO_DATE('2450367;00000','J;SSSSS'),1,12.69,'Lonesome Pine Restaurant','89 Chiaroscuro Rd.','Portland','OR','97219','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ISLAT',8,TO_DATE('2450358;00000','J;SSSSS'),TO_DATE('2450386;00000','J;SSSSS'),TO_DATE('2450361;00000','J;SSSSS'),2,4.73,'Island Trading','Garden House'||CHR(13)||CHR(10)||'Crowther Way','Cowes','Isle of Wight','PO31 7PJ','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('TORTU',7,TO_DATE('2450359;00000','J;SSSSS'),TO_DATE('2450387;00000','J;SSSSS'),TO_DATE('2450368;00000','J;SSSSS'),3,64.5,'Tortuga Restaurante','Avda. Azteca 123','México D.F.',NULL,'05033','Mexico');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WARTH',5,TO_DATE('2450360;00000','J;SSSSS'),TO_DATE('2450374;00000','J;SSSSS'),TO_DATE('2450375;00000','J;SSSSS'),3,34.57,'Wartian Herkku','Torikatu 38','Oulu',NULL,'90110','Finland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ISLAT',3,TO_DATE('2450360;00000','J;SSSSS'),TO_DATE('2450388;00000','J;SSSSS'),TO_DATE('2450368;00000','J;SSSSS'),2,3.43,'Island Trading','Garden House'||CHR(13)||CHR(10)||'Crowther Way','Cowes','Isle of Wight','PO31 7PJ','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('PERIC',7,TO_DATE('2450361;00000','J;SSSSS'),TO_DATE('2450389;00000','J;SSSSS'),TO_DATE('2450380;00000','J;SSSSS'),3,.4,'Pericles Comidas clásicas','Calle Dr. Jorge Cash 321','México D.F.',NULL,'05033','Mexico');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('KOENE',4,TO_DATE('2450364;00000','J;SSSSS'),TO_DATE('2450392;00000','J;SSSSS'),TO_DATE('2450371;00000','J;SSSSS'),1,4.88,'Königlich Essen','Maubelstr. 90','Brandenburg',NULL,'14776','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SAVEA',9,TO_DATE('2450365;00000','J;SSSSS'),TO_DATE('2450393;00000','J;SSSSS'),TO_DATE('2450367;00000','J;SSSSS'),1,214.27,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('KOENE',1,TO_DATE('2450366;00000','J;SSSSS'),TO_DATE('2450380;00000','J;SSSSS'),TO_DATE('2450371;00000','J;SSSSS'),3,64.86,'Königlich Essen','Maubelstr. 90','Brandenburg',NULL,'14776','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BOLID',4,TO_DATE('2450367;00000','J;SSSSS'),TO_DATE('2450395;00000','J;SSSSS'),TO_DATE('2450371;00000','J;SSSSS'),2,77.92,'Bólido Comidas preparadas','C/ Araquil, 67','Madrid',NULL,'28023','Spain');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FOLKO',2,TO_DATE('2450368;00000','J;SSSSS'),TO_DATE('2450396;00000','J;SSSSS'),TO_DATE('2450371;00000','J;SSSSS'),1,63.36,'Folk och fä HB','Åkergatan 24','Bräcke',NULL,'S-844 67','Sweden');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FURIB',4,TO_DATE('2450371;00000','J;SSSSS'),TO_DATE('2450399;00000','J;SSSSS'),TO_DATE('2450374;00000','J;SSSSS'),3,87.03,'Furia Bacalhau e Frutos do Mar','Jardim das rosas n. 32','Lisboa',NULL,'1675','Portugal');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SPLIR',4,TO_DATE('2450372;00000','J;SSSSS'),TO_DATE('2450414;00000','J;SSSSS'),TO_DATE('2450380;00000','J;SSSSS'),2,191.67,'Split Rail Beer '||Chr(38)||' Ale','P.O. Box 555','Lander','WY','82520','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LILAS',3,TO_DATE('2450373;00000','J;SSSSS'),TO_DATE('2450401;00000','J;SSSSS'),TO_DATE('2450385;00000','J;SSSSS'),1,12.75,'LILA-Supermercado','Carrera 52 con Ave. Bolívar #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BONAP',9,TO_DATE('2450373;00000','J;SSSSS'),TO_DATE('2450415;00000','J;SSSSS'),TO_DATE('2450378;00000','J;SSSSS'),1,10.19,'Bon app''','12, rue des Bouchers','Marseille',NULL,'13008','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('MEREP',3,TO_DATE('2450374;00000','J;SSSSS'),TO_DATE('2450416;00000','J;SSSSS'),TO_DATE('2450378;00000','J;SSSSS'),2,52.84,'Mère Paillarde','43 rue St. Laurent','Montréal','Québec','H1J 1C3','Canada');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WARTH',5,TO_DATE('2450375;00000','J;SSSSS'),TO_DATE('2450403;00000','J;SSSSS'),TO_DATE('2450382;00000','J;SSSSS'),3,.59,'Wartian Herkku','Torikatu 38','Oulu',NULL,'90110','Finland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('VICTE',8,TO_DATE('2450378;00000','J;SSSSS'),TO_DATE('2450406;00000','J;SSSSS'),TO_DATE('2450385;00000','J;SSSSS'),2,8.56,'Victuailles en stock','2, rue du Commerce','Lyon',NULL,'69004','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HUNGO',7,TO_DATE('2450379;00000','J;SSSSS'),TO_DATE('2450407;00000','J;SSSSS'),TO_DATE('2450381;00000','J;SSSSS'),2,42.11,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('PRINI',7,TO_DATE('2450380;00000','J;SSSSS'),TO_DATE('2450408;00000','J;SSSSS'),TO_DATE('2450382;00000','J;SSSSS'),2,15.51,'Princesa Isabel Vinhos','Estrada da saúde n. 58','Lisboa',NULL,'1756','Portugal');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FRANK',4,TO_DATE('2450381;00000','J;SSSSS'),TO_DATE('2450409;00000','J;SSSSS'),TO_DATE('2450386;00000','J;SSSSS'),3,108.26,'Frankenversand','Berliner Platz 43','München',NULL,'80805','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('OLDWO',4,TO_DATE('2450382;00000','J;SSSSS'),TO_DATE('2450410;00000','J;SSSSS'),TO_DATE('2450386;00000','J;SSSSS'),3,84.21,'Old World Delicatessen','2743 Bering St.','Anchorage','AK','99508','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('MEREP',2,TO_DATE('2450385;00000','J;SSSSS'),TO_DATE('2450413;00000','J;SSSSS'),TO_DATE('2450392;00000','J;SSSSS'),2,15.66,'Mère Paillarde','43 rue St. Laurent','Montréal','Québec','H1J 1C3','Canada');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BONAP',1,TO_DATE('2450386;00000','J;SSSSS'),TO_DATE('2450414;00000','J;SSSSS'),TO_DATE('2450396;00000','J;SSSSS'),3,166.31,'Bon app''','12, rue des Bouchers','Marseille',NULL,'13008','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SIMOB',7,TO_DATE('2450386;00000','J;SSSSS'),TO_DATE('2450414;00000','J;SSSSS'),TO_DATE('2450393;00000','J;SSSSS'),3,26.78,'Simons bistro','Vinbæltet 34','Kobenhavn',NULL,'1734','Denmark');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FRANK',4,TO_DATE('2450387;00000','J;SSSSS'),TO_DATE('2450401;00000','J;SSSSS'),TO_DATE('2450392;00000','J;SSSSS'),2,54.83,'Frankenversand','Berliner Platz 43','München',NULL,'80805','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LEHMS',4,TO_DATE('2450388;00000','J;SSSSS'),TO_DATE('2450416;00000','J;SSSSS'),TO_DATE('2450394;00000','J;SSSSS'),1,110.37,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M. ',NULL,'60528','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WHITC',4,TO_DATE('2450389;00000','J;SSSSS'),TO_DATE('2450417;00000','J;SSSSS'),TO_DATE('2450393;00000','J;SSSSS'),2,23.29,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUICK',2,TO_DATE('2450392;00000','J;SSSSS'),TO_DATE('2450420;00000','J;SSSSS'),TO_DATE('2450399;00000','J;SSSSS'),2,249.06,'QUICK-Stop','Taucherstraße 10','Cunewalde',NULL,'01307','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RATTC',3,TO_DATE('2450393;00000','J;SSSSS'),TO_DATE('2450435;00000','J;SSSSS'),TO_DATE('2450396;00000','J;SSSSS'),3,142.08,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FAMIA',4,TO_DATE('2450394;00000','J;SSSSS'),TO_DATE('2450422;00000','J;SSSSS'),TO_DATE('2450396;00000','J;SSSSS'),3,3.1,'Familia Arquibaldo','Rua Orós, 92','Sao Paulo','SP','05442-030','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WANDK',4,TO_DATE('2450395;00000','J;SSSSS'),TO_DATE('2450423;00000','J;SSSSS'),TO_DATE('2450403;00000','J;SSSSS'),2,.78,'Die Wandernde Kuh','Adenauerallee 900','Stuttgart',NULL,'70563','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SPLIR',7,TO_DATE('2450396;00000','J;SSSSS'),TO_DATE('2450424;00000','J;SSSSS'),TO_DATE('2450403;00000','J;SSSSS'),1,8.63,'Split Rail Beer '||Chr(38)||' Ale','P.O. Box 555','Lander','WY','82520','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LAMAI',6,TO_DATE('2450399;00000','J;SSSSS'),TO_DATE('2450427;00000','J;SSSSS'),TO_DATE('2450421;00000','J;SSSSS'),2,64.19,'La maison d''Asie','1 rue Alsace-Lorraine','Toulouse',NULL,'31000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ERNSH',1,TO_DATE('2450399;00000','J;SSSSS'),TO_DATE('2450427;00000','J;SSSSS'),TO_DATE('2450408;00000','J;SSSSS'),1,162.33,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FURIB',3,TO_DATE('2450400;00000','J;SSSSS'),TO_DATE('2450414;00000','J;SSSSS'),TO_DATE('2450406;00000','J;SSSSS'),3,1.3,'Furia Bacalhau e Frutos do Mar','Jardim das rosas n. 32','Lisboa',NULL,'1675','Portugal');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('PICCO',7,TO_DATE('2450401;00000','J;SSSSS'),TO_DATE('2450429;00000','J;SSSSS'),TO_DATE('2450413;00000','J;SSSSS'),3,360.63,'Piccolo und mehr','Geislweg 14','Salzburg',NULL,'5020','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('PERIC',8,TO_DATE('2450402;00000','J;SSSSS'),TO_DATE('2450430;00000','J;SSSSS'),TO_DATE('2450408;00000','J;SSSSS'),3,53.8,'Pericles Comidas clásicas','Calle Dr. Jorge Cash 321','México D.F.',NULL,'05033','Mexico');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('AROUT',6,TO_DATE('2450403;00000','J;SSSSS'),TO_DATE('2450431;00000','J;SSSSS'),TO_DATE('2450408;00000','J;SSSSS'),1,41.95,'Around the Horn','Brook Farm'||CHR(13)||CHR(10)||'Stratford St. Mary','Colchester','Essex','CO7 6JX','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WANDK',6,TO_DATE('2450406;00000','J;SSSSS'),TO_DATE('2450434;00000','J;SSSSS'),TO_DATE('2450415;00000','J;SSSSS'),2,36.71,'Die Wandernde Kuh','Adenauerallee 900','Stuttgart',NULL,'70563','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LILAS',1,TO_DATE('2450407;00000','J;SSSSS'),TO_DATE('2450435;00000','J;SSSSS'),TO_DATE('2450420;00000','J;SSSSS'),3,34.88,'LILA-Supermercado','Carrera 52 con Ave. Bolívar #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LAMAI',5,TO_DATE('2450408;00000','J;SSSSS'),TO_DATE('2450436;00000','J;SSSSS'),TO_DATE('2450415;00000','J;SSSSS'),1,19.64,'La maison d''Asie','1 rue Alsace-Lorraine','Toulouse',NULL,'31000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SEVES',5,TO_DATE('2450409;00000','J;SSSSS'),TO_DATE('2450437;00000','J;SSSSS'),TO_DATE('2450414;00000','J;SSSSS'),3,288.43,'Seven Seas Imports','90 Wadhurst Rd.','London',NULL,'OX15 4NB','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BLONP',4,TO_DATE('2450410;00000','J;SSSSS'),TO_DATE('2450438;00000','J;SSSSS'),TO_DATE('2450420;00000','J;SSSSS'),3,131.7,'Blondel père et fils','24, place Kléber','Strasbourg',NULL,'67000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUICK',1,TO_DATE('2450410;00000','J;SSSSS'),TO_DATE('2450438;00000','J;SSSSS'),TO_DATE('2450421;00000','J;SSSSS'),2,183.17,'QUICK-Stop','Taucherstraße 10','Cunewalde',NULL,'01307','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BONAP',3,TO_DATE('2450413;00000','J;SSSSS'),TO_DATE('2450441;00000','J;SSSSS'),TO_DATE('2450416;00000','J;SSSSS'),1,96.04,'Bon app''','12, rue des Bouchers','Marseille',NULL,'13008','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('DRACD',4,TO_DATE('2450414;00000','J;SSSSS'),TO_DATE('2450442;00000','J;SSSSS'),TO_DATE('2450422;00000','J;SSSSS'),3,30.54,'Drachenblut Delikatessen','Walserweg 21','Aachen',NULL,'52066','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('EASTC',1,TO_DATE('2450414;00000','J;SSSSS'),TO_DATE('2450456;00000','J;SSSSS'),TO_DATE('2450422;00000','J;SSSSS'),1,71.97,'Eastern Connection','35 King George','London',NULL,'WX3 6FW','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ANTON',3,TO_DATE('2450415;00000','J;SSSSS'),TO_DATE('2450443;00000','J;SSSSS'),TO_DATE('2450420;00000','J;SSSSS'),2,22,'Antonio Moreno Taquería','Mataderos  2312','México D.F.',NULL,'05023','Mexico');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('GALED',8,TO_DATE('2450416;00000','J;SSSSS'),TO_DATE('2450458;00000','J;SSSSS'),TO_DATE('2450448;00000','J;SSSSS'),2,10.14,'Galería del gastronómo','Rambla de Cataluña, 23','Barcelona',NULL,'8022','Spain');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('VAFFE',7,TO_DATE('2450416;00000','J;SSSSS'),TO_DATE('2450444;00000','J;SSSSS'),TO_DATE('2450420;00000','J;SSSSS'),3,13.55,'Vaffeljernet','Smagsloget 45','Århus',NULL,'8200','Denmark');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ERNSH',2,TO_DATE('2450417;00000','J;SSSSS'),TO_DATE('2450445;00000','J;SSSSS'),TO_DATE('2450420;00000','J;SSSSS'),2,101.95,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SPLIR',8,TO_DATE('2450420;00000','J;SSSSS'),TO_DATE('2450448;00000','J;SSSSS'),TO_DATE('2450427;00000','J;SSSSS'),2,195.68,'Split Rail Beer '||Chr(38)||' Ale','P.O. Box 555','Lander','WY','82520','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('CHOPS',6,TO_DATE('2450421;00000','J;SSSSS'),TO_DATE('2450449;00000','J;SSSSS'),TO_DATE('2450445;00000','J;SSSSS'),2,1.17,'Chop-suey Chinese','Hauptstr. 31','Bern',NULL,'3012','Switzerland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LAMAI',1,TO_DATE('2450421;00000','J;SSSSS'),TO_DATE('2450449;00000','J;SSSSS'),TO_DATE('2450442;00000','J;SSSSS'),1,.45,'La maison d''Asie','1 rue Alsace-Lorraine','Toulouse',NULL,'31000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUEEN',5,TO_DATE('2450422;00000','J;SSSSS'),TO_DATE('2450450;00000','J;SSSSS'),TO_DATE('2450427;00000','J;SSSSS'),2,890.78,'Queen Cozinha','Alameda dos Canàrios, 891','Sao Paulo','SP','05487-020','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HUNGO',4,TO_DATE('2450423;00000','J;SSSSS'),TO_DATE('2450451;00000','J;SSSSS'),TO_DATE('2450429;00000','J;SSSSS'),3,124.12,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WOLZA',1,TO_DATE('2450423;00000','J;SSSSS'),TO_DATE('2450451;00000','J;SSSSS'),TO_DATE('2450427;00000','J;SSSSS'),3,3.94,'Wolski Zajazd','ul. Filtrowa 68','Warszawa',NULL,'01-012','Poland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HUNGC',3,TO_DATE('2450424;00000','J;SSSSS'),TO_DATE('2450452;00000','J;SSSSS'),TO_DATE('2450427;00000','J;SSSSS'),2,20.12,'Hungry Coyote Import Store','City Center Plaza'||CHR(13)||CHR(10)||'516 Main St.','Elgin','OR','97827','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('MEREP',1,TO_DATE('2450427;00000','J;SSSSS'),TO_DATE('2450455;00000','J;SSSSS'),TO_DATE('2450431;00000','J;SSSSS'),2,20.39,'Mère Paillarde','43 rue St. Laurent','Montréal','Québec','H1J 1C3','Canada');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SEVES',1,TO_DATE('2450427;00000','J;SSSSS'),TO_DATE('2450455;00000','J;SSSSS'),TO_DATE('2450431;00000','J;SSSSS'),3,22.21,'Seven Seas Imports','90 Wadhurst Rd.','London',NULL,'OX15 4NB','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FOLKO',5,TO_DATE('2450428;00000','J;SSSSS'),TO_DATE('2450456;00000','J;SSSSS'),TO_DATE('2450437;00000','J;SSSSS'),3,5.44,'Folk och fä HB','Åkergatan 24','Bräcke',NULL,'S-844 67','Sweden');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUEDE',2,TO_DATE('2450429;00000','J;SSSSS'),TO_DATE('2450457;00000','J;SSSSS'),TO_DATE('2450431;00000','J;SSSSS'),1,45.03,'Que Delícia','Rua da Panificadora, 12','Rio de Janeiro','RJ','02389-673','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HUNGO',8,TO_DATE('2450430;00000','J;SSSSS'),TO_DATE('2450458;00000','J;SSSSS'),TO_DATE('2450465;00000','J;SSSSS'),3,35.03,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LILAS',3,TO_DATE('2450430;00000','J;SSSSS'),TO_DATE('2450458;00000','J;SSSSS'),TO_DATE('2450431;00000','J;SSSSS'),3,7.99,'LILA-Supermercado','Carrera 52 con Ave. Bolívar #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ERNSH',4,TO_DATE('2450431;00000','J;SSSSS'),TO_DATE('2450459;00000','J;SSSSS'),TO_DATE('2450434;00000','J;SSSSS'),1,94.77,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('AROUT',8,TO_DATE('2450434;00000','J;SSSSS'),TO_DATE('2450462;00000','J;SSSSS'),TO_DATE('2450436;00000','J;SSSSS'),3,34.24,'Around the Horn','Brook Farm'||CHR(13)||CHR(10)||'Stratford St. Mary','Colchester','Essex','CO7 6JX','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BERGS',3,TO_DATE('2450434;00000','J;SSSSS'),TO_DATE('2450462;00000','J;SSSSS'),TO_DATE('2450438;00000','J;SSSSS'),3,168.64,'Berglunds snabbköp','Berguvsvägen  8','Luleå',NULL,'S-958 22','Sweden');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SPLIR',1,TO_DATE('2450435;00000','J;SSSSS'),TO_DATE('2450463;00000','J;SSSSS'),TO_DATE('2450441;00000','J;SSSSS'),2,30.96,'Split Rail Beer '||Chr(38)||' Ale','P.O. Box 555','Lander','WY','82520','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FAMIA',9,TO_DATE('2450436;00000','J;SSSSS'),TO_DATE('2450450;00000','J;SSSSS'),TO_DATE('2450443;00000','J;SSSSS'),3,13.99,'Familia Arquibaldo','Rua Orós, 92','Sao Paulo','SP','05442-030','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SANTG',1,TO_DATE('2450436;00000','J;SSSSS'),TO_DATE('2450464;00000','J;SSSSS'),TO_DATE('2450438;00000','J;SSSSS'),2,93.63,'Santé Gourmet','Erling Skakkes gate 78','Stavern',NULL,'4110','Norway');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SEVES',2,TO_DATE('2450437;00000','J;SSSSS'),TO_DATE('2450465;00000','J;SSSSS'),TO_DATE('2450438;00000','J;SSSSS'),1,34.86,'Seven Seas Imports','90 Wadhurst Rd.','London',NULL,'OX15 4NB','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BOTTM',4,TO_DATE('2450438;00000','J;SSSSS'),TO_DATE('2450466;00000','J;SSSSS'),TO_DATE('2450442;00000','J;SSSSS'),2,47.42,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ERNSH',6,TO_DATE('2450441;00000','J;SSSSS'),TO_DATE('2450469;00000','J;SSSSS'),TO_DATE('2450444;00000','J;SSSSS'),1,126.38,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('DRACD',3,TO_DATE('2450441;00000','J;SSSSS'),TO_DATE('2450469;00000','J;SSSSS'),TO_DATE('2450449;00000','J;SSSSS'),3,5.45,'Drachenblut Delikatessen','Walserweg 21','Aachen',NULL,'52066','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('PICCO',2,TO_DATE('2450442;00000','J;SSSSS'),TO_DATE('2450470;00000','J;SSSSS'),TO_DATE('2450450;00000','J;SSSSS'),3,122.46,'Piccolo und mehr','Geislweg 14','Salzburg',NULL,'5020','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SAVEA',1,TO_DATE('2450443;00000','J;SSSSS'),TO_DATE('2450471;00000','J;SSSSS'),TO_DATE('2450452;00000','J;SSSSS'),3,126.56,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HUNGC',1,TO_DATE('2450443;00000','J;SSSSS'),TO_DATE('2450471;00000','J;SSSSS'),TO_DATE('2450452;00000','J;SSSSS'),3,30.34,'Hungry Coyote Import Store','City Center Plaza'||CHR(13)||CHR(10)||'516 Main St.','Elgin','OR','97827','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HILAA',6,TO_DATE('2450444;00000','J;SSSSS'),TO_DATE('2450472;00000','J;SSSSS'),TO_DATE('2450452;00000','J;SSSSS'),1,184.41,'HILARION-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Cristóbal','Táchira','5022','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FRANK',1,TO_DATE('2450445;00000','J;SSSSS'),TO_DATE('2450459;00000','J;SSSSS'),TO_DATE('2450455;00000','J;SSSSS'),3,135.35,'Frankenversand','Berliner Platz 43','München',NULL,'80805','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('PRINI',5,TO_DATE('2450445;00000','J;SSSSS'),TO_DATE('2450473;00000','J;SSSSS'),TO_DATE('2450451;00000','J;SSSSS'),1,60.26,'Princesa Isabel Vinhos','Estrada da saúde n. 58','Lisboa',NULL,'1756','Portugal');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SAVEA',2,TO_DATE('2450448;00000','J;SSSSS'),TO_DATE('2450476;00000','J;SSSSS'),TO_DATE('2450458;00000','J;SSSSS'),3,89.16,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('VAFFE',8,TO_DATE('2450449;00000','J;SSSSS'),TO_DATE('2450463;00000','J;SSSSS'),TO_DATE('2450457;00000','J;SSSSS'),3,27.36,'Vaffeljernet','Smagsloget 45','Århus',NULL,'8200','Denmark');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('EASTC',1,TO_DATE('2450450;00000','J;SSSSS'),TO_DATE('2450478;00000','J;SSSSS'),TO_DATE('2450465;00000','J;SSSSS'),3,83.93,'Eastern Connection','35 King George','London',NULL,'WX3 6FW','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RATTC',1,TO_DATE('2450450;00000','J;SSSSS'),TO_DATE('2450478;00000','J;SSSSS'),TO_DATE('2450459;00000','J;SSSSS'),1,12.51,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ERNSH',8,TO_DATE('2450451;00000','J;SSSSS'),TO_DATE('2450493;00000','J;SSSSS'),TO_DATE('2450459;00000','J;SSSSS'),2,67.88,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ERNSH',4,TO_DATE('2450452;00000','J;SSSSS'),TO_DATE('2450480;00000','J;SSSSS'),TO_DATE('2450458;00000','J;SSSSS'),3,73.79,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('MAGAA',2,TO_DATE('2450452;00000','J;SSSSS'),TO_DATE('2450480;00000','J;SSSSS'),TO_DATE('2450457;00000','J;SSSSS'),1,155.97,'Magazzini Alimentari Riuniti','Via Ludovico il Moro 22','Bergamo',NULL,'24100','Italy');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LINOD',1,TO_DATE('2450455;00000','J;SSSSS'),TO_DATE('2450483;00000','J;SSSSS'),TO_DATE('2450471;00000','J;SSSSS'),1,34.82,'LINO-Delicateses','Ave. 5 de Mayo Porlamar','I. de Margarita','Nueva Esparta','4980','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUEEN',7,TO_DATE('2450456;00000','J;SSSSS'),TO_DATE('2450498;00000','J;SSSSS'),TO_DATE('2450462;00000','J;SSSSS'),1,108.04,'Queen Cozinha','Alameda dos Canàrios, 891','Sao Paulo','SP','05487-020','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('OTTIK',2,TO_DATE('2450456;00000','J;SSSSS'),TO_DATE('2450484;00000','J;SSSSS'),TO_DATE('2450479;00000','J;SSSSS'),2,91.48,'Ottilies Käseladen','Mehrheimerstr. 369','Köln',NULL,'50739','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FOLIG',8,TO_DATE('2450457;00000','J;SSSSS'),TO_DATE('2450485;00000','J;SSSSS'),TO_DATE('2450463;00000','J;SSSSS'),1,11.26,'Folies gourmandes','184, chaussée de Tournai','Lille',NULL,'59000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('OCEAN',3,TO_DATE('2450458;00000','J;SSSSS'),TO_DATE('2450486;00000','J;SSSSS'),TO_DATE('2450463;00000','J;SSSSS'),1,29.83,'Océano Atlántico Ltda.','Ing. Gustavo Moncada 8585'||CHR(13)||CHR(10)||'Piso 20-A','Buenos Aires',NULL,'1010','Argentina');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BOTTM',3,TO_DATE('2450459;00000','J;SSSSS'),TO_DATE('2450487;00000','J;SSSSS'),TO_DATE('2450464;00000','J;SSSSS'),3,2.4,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BOTTM',9,TO_DATE('2450459;00000','J;SSSSS'),TO_DATE('2450487;00000','J;SSSSS'),TO_DATE('2450470;00000','J;SSSSS'),3,23.65,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WARTH',8,TO_DATE('2450462;00000','J;SSSSS'),TO_DATE('2450490;00000','J;SSSSS'),TO_DATE('2450464;00000','J;SSSSS'),2,3.77,'Wartian Herkku','Torikatu 38','Oulu',NULL,'90110','Finland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LAMAI',3,TO_DATE('2450463;00000','J;SSSSS'),TO_DATE('2450491;00000','J;SSSSS'),TO_DATE('2450465;00000','J;SSSSS'),2,95.66,'La maison d''Asie','1 rue Alsace-Lorraine','Toulouse',NULL,'31000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FAMIA',2,TO_DATE('2450463;00000','J;SSSSS'),TO_DATE('2450491;00000','J;SSSSS'),TO_DATE('2450466;00000','J;SSSSS'),3,21.48,'Familia Arquibaldo','Rua Orós, 92','Sao Paulo','SP','05442-030','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HUNGC',3,TO_DATE('2450464;00000','J;SSSSS'),TO_DATE('2450492;00000','J;SSSSS'),TO_DATE('2450473;00000','J;SSSSS'),1,.2,'Hungry Coyote Import Store','City Center Plaza'||CHR(13)||CHR(10)||'516 Main St.','Elgin','OR','97827','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WARTH',8,TO_DATE('2450465;00000','J;SSSSS'),TO_DATE('2450493;00000','J;SSSSS'),TO_DATE('2450476;00000','J;SSSSS'),3,22.72,'Wartian Herkku','Torikatu 38','Oulu',NULL,'90110','Finland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SIMOB',4,TO_DATE('2450465;00000','J;SSSSS'),TO_DATE('2450493;00000','J;SSSSS'),TO_DATE('2450477;00000','J;SSSSS'),3,70.29,'Simons bistro','Vinbæltet 34','Kobenhavn',NULL,'1734','Denmark');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUICK',4,TO_DATE('2450466;00000','J;SSSSS'),TO_DATE('2450494;00000','J;SSSSS'),TO_DATE('2450473;00000','J;SSSSS'),1,17.55,'QUICK-Stop','Taucherstraße 10','Cunewalde',NULL,'01307','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RICSU',4,TO_DATE('2450469;00000','J;SSSSS'),TO_DATE('2450497;00000','J;SSSSS'),TO_DATE('2450479;00000','J;SSSSS'),2,137.35,'Richter Supermarkt','Starenweg 5','Genève',NULL,'1204','Switzerland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WELLI',3,TO_DATE('2450470;00000','J;SSSSS'),TO_DATE('2450498;00000','J;SSSSS'),TO_DATE('2450476;00000','J;SSSSS'),1,44.12,'Wellington Importadora','Rua do Mercado, 12','Resende','SP','08737-363','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUEDE',8,TO_DATE('2450470;00000','J;SSSSS'),TO_DATE('2450512;00000','J;SSSSS'),TO_DATE('2450476;00000','J;SSSSS'),1,99.23,'Que Delícia','Rua da Panificadora, 12','Rio de Janeiro','RJ','02389-673','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FRANS',2,TO_DATE('2450471;00000','J;SSSSS'),TO_DATE('2450499;00000','J;SSSSS'),TO_DATE('2450480;00000','J;SSSSS'),1,3.02,'Franchi S.p.A.','Via Monte Bianco 34','Torino',NULL,'10100','Italy');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('GOURL',6,TO_DATE('2450472;00000','J;SSSSS'),TO_DATE('2450486;00000','J;SSSSS'),TO_DATE('2450504;00000','J;SSSSS'),3,24.5,'Gourmet Lanchonetes','Av. Brasil, 442','Campinas','SP','04876-786','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('MEREP',7,TO_DATE('2450472;00000','J;SSSSS'),TO_DATE('2450500;00000','J;SSSSS'),TO_DATE('2450476;00000','J;SSSSS'),2,370.61,'Mère Paillarde','43 rue St. Laurent','Montréal','Québec','H1J 1C3','Canada');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LAMAI',6,TO_DATE('2450473;00000','J;SSSSS'),TO_DATE('2450501;00000','J;SSSSS'),TO_DATE('2450494;00000','J;SSSSS'),2,7.93,'La maison d''Asie','1 rue Alsace-Lorraine','Toulouse',NULL,'31000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('GALED',4,TO_DATE('2450476;00000','J;SSSSS'),TO_DATE('2450504;00000','J;SSSSS'),TO_DATE('2450486;00000','J;SSSSS'),1,18.69,'Galería del gastronómo','Rambla de Cataluña, 23','Barcelona',NULL,'8022','Spain');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('PICCO',4,TO_DATE('2450476;00000','J;SSSSS'),TO_DATE('2450504;00000','J;SSSSS'),TO_DATE('2450511;00000','J;SSSSS'),2,31.29,'Piccolo und mehr','Geislweg 14','Salzburg',NULL,'5020','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('REGGC',7,TO_DATE('2450477;00000','J;SSSSS'),TO_DATE('2450505;00000','J;SSSSS'),TO_DATE('2450484;00000','J;SSSSS'),1,11.09,'Reggiani Caseifici','Strada Provinciale 124','Reggio Emilia',NULL,'42100','Italy');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HUNGO',3,TO_DATE('2450478;00000','J;SSSSS'),TO_DATE('2450520;00000','J;SSSSS'),TO_DATE('2450487;00000','J;SSSSS'),2,56.63,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ERNSH',4,TO_DATE('2450479;00000','J;SSSSS'),TO_DATE('2450493;00000','J;SSSSS'),TO_DATE('2450483;00000','J;SSSSS'),1,458.78,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BOTTM',4,TO_DATE('2450479;00000','J;SSSSS'),TO_DATE('2450493;00000','J;SSSSS'),TO_DATE('2450487;00000','J;SSSSS'),2,44.17,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SPLIR',3,TO_DATE('2450480;00000','J;SSSSS'),TO_DATE('2450494;00000','J;SSSSS'),TO_DATE('2450487;00000','J;SSSSS'),2,4.34,'Split Rail Beer '||Chr(38)||' Ale','P.O. Box 555','Lander','WY','82520','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('PRINI',3,TO_DATE('2450483;00000','J;SSSSS'),TO_DATE('2450511;00000','J;SSSSS'),TO_DATE('2450512;00000','J;SSSSS'),3,73.83,'Princesa Isabel Vinhos','Estrada da saúde n. 58','Lisboa',NULL,'1756','Portugal');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FOLKO',3,TO_DATE('2450483;00000','J;SSSSS'),TO_DATE('2450511;00000','J;SSSSS'),TO_DATE('2450493;00000','J;SSSSS'),2,17.92,'Folk och fä HB','Åkergatan 24','Bräcke',NULL,'S-844 67','Sweden');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('CONSH',8,TO_DATE('2450484;00000','J;SSSSS'),TO_DATE('2450526;00000','J;SSSSS'),TO_DATE('2450487;00000','J;SSSSS'),2,9.21,'Consolidated Holdings','Berkeley Gardens'||CHR(13)||CHR(10)||'12  Brewery ','London',NULL,'WX1 6LT','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BLONP',3,TO_DATE('2450485;00000','J;SSSSS'),TO_DATE('2450513;00000','J;SSSSS'),TO_DATE('2450491;00000','J;SSSSS'),2,156.66,'Blondel père et fils','24, place Kléber','Strasbourg',NULL,'67000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WARTH',8,TO_DATE('2450485;00000','J;SSSSS'),TO_DATE('2450513;00000','J;SSSSS'),TO_DATE('2450492;00000','J;SSSSS'),1,19.97,'Wartian Herkku','Torikatu 38','Oulu',NULL,'90110','Finland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('TOMSP',3,TO_DATE('2450486;00000','J;SSSSS'),TO_DATE('2450514;00000','J;SSSSS'),TO_DATE('2450494;00000','J;SSSSS'),2,8.24,'Toms Spezialitäten','Luisenstr. 48','Münster',NULL,'44087','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('MEREP',6,TO_DATE('2450487;00000','J;SSSSS'),TO_DATE('2450515;00000','J;SSSSS'),TO_DATE('2450490;00000','J;SSSSS'),3,4.07,'Mère Paillarde','43 rue St. Laurent','Montréal','Québec','H1J 1C3','Canada');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SAVEA',4,TO_DATE('2450490;00000','J;SSSSS'),TO_DATE('2450518;00000','J;SSSSS'),TO_DATE('2450508;00000','J;SSSSS'),2,86.53,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('OLDWO',3,TO_DATE('2450490;00000','J;SSSSS'),TO_DATE('2450532;00000','J;SSSSS'),TO_DATE('2450522;00000','J;SSSSS'),2,73.02,'Old World Delicatessen','2743 Bering St.','Anchorage','AK','99508','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ERNSH',3,TO_DATE('2450491;00000','J;SSSSS'),TO_DATE('2450519;00000','J;SSSSS'),TO_DATE('2450498;00000','J;SSSSS'),2,47.94,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('REGGC',8,TO_DATE('2450492;00000','J;SSSSS'),TO_DATE('2450520;00000','J;SSSSS'),TO_DATE('2450494;00000','J;SSSSS'),1,13.95,'Reggiani Caseifici','Strada Provinciale 124','Reggio Emilia',NULL,'42100','Italy');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BERGS',3,TO_DATE('2450492;00000','J;SSSSS'),TO_DATE('2450520;00000','J;SSSSS'),TO_DATE('2450501;00000','J;SSSSS'),3,3.5,'Berglunds snabbköp','Berguvsvägen  8','Luleå',NULL,'S-958 22','Sweden');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BERGS',3,TO_DATE('2450493;00000','J;SSSSS'),TO_DATE('2450521;00000','J;SSSSS'),TO_DATE('2450500;00000','J;SSSSS'),1,9.3,'Berglunds snabbköp','Berguvsvägen  8','Luleå',NULL,'S-958 22','Sweden');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('TOMSP',6,TO_DATE('2450494;00000','J;SSSSS'),TO_DATE('2450522;00000','J;SSSSS'),TO_DATE('2450499;00000','J;SSSSS'),1,14.68,'Toms Spezialitäten','Luisenstr. 48','Münster',NULL,'44087','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RICAR',4,TO_DATE('2450494;00000','J;SSSSS'),TO_DATE('2450522;00000','J;SSSSS'),TO_DATE('2450515;00000','J;SSSSS'),2,68.66,'Ricardo Adocicados','Av. Copacabana, 267','Rio de Janeiro','RJ','02389-890','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RANCH',4,TO_DATE('2450497;00000','J;SSSSS'),TO_DATE('2450525;00000','J;SSSSS'),TO_DATE('2450504;00000','J;SSSSS'),2,38.82,'Rancho grande','Av. del Libertador 900','Buenos Aires',NULL,'1010','Argentina');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BLONP',3,TO_DATE('2450498;00000','J;SSSSS'),TO_DATE('2450526;00000','J;SSSSS'),TO_DATE('2450507;00000','J;SSSSS'),2,53.3,'Blondel père et fils','24, place Kléber','Strasbourg',NULL,'67000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('VICTE',8,TO_DATE('2450499;00000','J;SSSSS'),TO_DATE('2450527;00000','J;SSSSS'),TO_DATE('2450519;00000','J;SSSSS'),2,7.23,'Victuailles en stock','2, rue du Commerce','Lyon',NULL,'69004','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUICK',4,TO_DATE('2450499;00000','J;SSSSS'),TO_DATE('2450513;00000','J;SSSSS'),TO_DATE('2450520;00000','J;SSSSS'),3,189.09,'QUICK-Stop','Taucherstraße 10','Cunewalde',NULL,'01307','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SAVEA',8,TO_DATE('2450500;00000','J;SSSSS'),TO_DATE('2450528;00000','J;SSSSS'),TO_DATE('2450506;00000','J;SSSSS'),1,140.26,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('AROUT',1,TO_DATE('2450501;00000','J;SSSSS'),TO_DATE('2450529;00000','J;SSSSS'),TO_DATE('2450506;00000','J;SSSSS'),2,25.36,'Around the Horn','Brook Farm'||CHR(13)||CHR(10)||'Stratford St. Mary','Colchester','Essex','CO7 6JX','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LAMAI',4,TO_DATE('2450501;00000','J;SSSSS'),TO_DATE('2450529;00000','J;SSSSS'),TO_DATE('2450505;00000','J;SSSSS'),3,2.74,'La maison d''Asie','1 rue Alsace-Lorraine','Toulouse',NULL,'31000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WARTH',8,TO_DATE('2450504;00000','J;SSSSS'),TO_DATE('2450546;00000','J;SSSSS'),TO_DATE('2450511;00000','J;SSSSS'),2,180.45,'Wartian Herkku','Torikatu 38','Oulu',NULL,'90110','Finland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('KOENE',8,TO_DATE('2450505;00000','J;SSSSS'),TO_DATE('2450547;00000','J;SSSSS'),TO_DATE('2450508;00000','J;SSSSS'),2,8.12,'Königlich Essen','Maubelstr. 90','Brandenburg',NULL,'14776','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('KOENE',2,TO_DATE('2450505;00000','J;SSSSS'),TO_DATE('2450533;00000','J;SSSSS'),TO_DATE('2450511;00000','J;SSSSS'),1,11.57,'Königlich Essen','Maubelstr. 90','Brandenburg',NULL,'14776','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SUPRD',7,TO_DATE('2450506;00000','J;SSSSS'),TO_DATE('2450534;00000','J;SSSSS'),TO_DATE('2450512;00000','J;SSSSS'),3,147.06,'Suprêmes délices','Boulevard Tirou, 255','Charleroi',NULL,'B-6000','Belgium');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('VICTE',4,TO_DATE('2450507;00000','J;SSSSS'),TO_DATE('2450535;00000','J;SSSSS'),TO_DATE('2450508;00000','J;SSSSS'),2,25.09,'Victuailles en stock','2, rue du Commerce','Lyon',NULL,'69004','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FOLKO',8,TO_DATE('2450508;00000','J;SSSSS'),TO_DATE('2450536;00000','J;SSSSS'),TO_DATE('2450511;00000','J;SSSSS'),1,16.27,'Folk och fä HB','Åkergatan 24','Bräcke',NULL,'S-844 67','Sweden');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LILAS',1,TO_DATE('2450508;00000','J;SSSSS'),TO_DATE('2450536;00000','J;SSSSS'),TO_DATE('2450513;00000','J;SSSSS'),3,148.61,'LILA-Supermercado','Carrera 52 con Ave. Bolívar #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('CONSH',2,TO_DATE('2450511;00000','J;SSSSS'),TO_DATE('2450539;00000','J;SSSSS'),TO_DATE('2450526;00000','J;SSSSS'),1,6.17,'Consolidated Holdings','Berkeley Gardens'||CHR(13)||CHR(10)||'12  Brewery ','London',NULL,'WX1 6LT','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SUPRD',5,TO_DATE('2450512;00000','J;SSSSS'),TO_DATE('2450540;00000','J;SSSSS'),TO_DATE('2450514;00000','J;SSSSS'),3,14.78,'Suprêmes délices','Boulevard Tirou, 255','Charleroi',NULL,'B-6000','Belgium');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FURIB',4,TO_DATE('2450512;00000','J;SSSSS'),TO_DATE('2450540;00000','J;SSSSS'),TO_DATE('2450522;00000','J;SSSSS'),2,89,'Furia Bacalhau e Frutos do Mar','Jardim das rosas n. 32','Lisboa',NULL,'1675','Portugal');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('VAFFE',1,TO_DATE('2450513;00000','J;SSSSS'),TO_DATE('2450541;00000','J;SSSSS'),TO_DATE('2450522;00000','J;SSSSS'),3,145.04,'Vaffeljernet','Smagsloget 45','Århus',NULL,'8200','Denmark');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('COMMI',4,TO_DATE('2450514;00000','J;SSSSS'),TO_DATE('2450542;00000','J;SSSSS'),TO_DATE('2450521;00000','J;SSSSS'),1,11.93,'Comércio Mineiro','Av. dos Lusíadas, 23','Sao Paulo','SP','05432-043','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('MAGAA',8,TO_DATE('2450514;00000','J;SSSSS'),TO_DATE('2450542;00000','J;SSSSS'),TO_DATE('2450519;00000','J;SSSSS'),2,4.93,'Magazzini Alimentari Riuniti','Via Ludovico il Moro 22','Bergamo',NULL,'24100','Italy');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('KOENE',3,TO_DATE('2450515;00000','J;SSSSS'),TO_DATE('2450543;00000','J;SSSSS'),TO_DATE('2450520;00000','J;SSSSS'),3,44.12,'Königlich Essen','Maubelstr. 90','Brandenburg',NULL,'14776','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WHITC',1,TO_DATE('2450518;00000','J;SSSSS'),TO_DATE('2450546;00000','J;SSSSS'),TO_DATE('2450522;00000','J;SSSSS'),1,60.18,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BONAP',4,TO_DATE('2450519;00000','J;SSSSS'),TO_DATE('2450547;00000','J;SSSSS'),TO_DATE('2450522;00000','J;SSSSS'),2,64.56,'Bon app''','12, rue des Bouchers','Marseille',NULL,'13008','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BSBEV',2,TO_DATE('2450519;00000','J;SSSSS'),TO_DATE('2450547;00000','J;SSSSS'),TO_DATE('2450526;00000','J;SSSSS'),3,45.59,'B''s Beverages','Fauntleroy Circus','London',NULL,'EC2 5NT','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SEVES',8,TO_DATE('2450520;00000','J;SSSSS'),TO_DATE('2450548;00000','J;SSSSS'),TO_DATE('2450527;00000','J;SSSSS'),1,4.2,'Seven Seas Imports','90 Wadhurst Rd.','London',NULL,'OX15 4NB','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ISLAT',1,TO_DATE('2450521;00000','J;SSSSS'),TO_DATE('2450535;00000','J;SSSSS'),TO_DATE('2450529;00000','J;SSSSS'),3,16.37,'Island Trading','Garden House'||CHR(13)||CHR(10)||'Crowther Way','Cowes','Isle of Wight','PO31 7PJ','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('PERIC',5,TO_DATE('2450521;00000','J;SSSSS'),TO_DATE('2450549;00000','J;SSSSS'),TO_DATE('2450529;00000','J;SSSSS'),2,83.49,'Pericles Comidas clásicas','Calle Dr. Jorge Cash 321','México D.F.',NULL,'05033','Mexico');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SUPRD',9,TO_DATE('2450522;00000','J;SSSSS'),TO_DATE('2450550;00000','J;SSSSS'),TO_DATE('2450543;00000','J;SSSSS'),1,68.52,'Suprêmes délices','Boulevard Tirou, 255','Charleroi',NULL,'B-6000','Belgium');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HILAA',8,TO_DATE('2450525;00000','J;SSSSS'),TO_DATE('2450553;00000','J;SSSSS'),TO_DATE('2450532;00000','J;SSSSS'),3,4.41,'HILARION-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Cristóbal','Táchira','5022','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('PRINI',5,TO_DATE('2450525;00000','J;SSSSS'),TO_DATE('2450553;00000','J;SSSSS'),TO_DATE('2450533;00000','J;SSSSS'),2,13.02,'Princesa Isabel Vinhos','Estrada da saúde n. 58','Lisboa',NULL,'1756','Portugal');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('VICTE',2,TO_DATE('2450526;00000','J;SSSSS'),TO_DATE('2450540;00000','J;SSSSS'),TO_DATE('2450534;00000','J;SSSSS'),3,4.81,'Victuailles en stock','2, rue du Commerce','Lyon',NULL,'69004','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RATTC',3,TO_DATE('2450527;00000','J;SSSSS'),TO_DATE('2450555;00000','J;SSSSS'),TO_DATE('2450529;00000','J;SSSSS'),3,708.95,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FOLIG',6,TO_DATE('2450528;00000','J;SSSSS'),TO_DATE('2450556;00000','J;SSSSS'),TO_DATE('2450532;00000','J;SSSSS'),2,1.35,'Folies gourmandes','184, chaussée de Tournai','Lille',NULL,'59000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RICAR',8,TO_DATE('2450528;00000','J;SSSSS'),TO_DATE('2450556;00000','J;SSSSS'),TO_DATE('2450533;00000','J;SSSSS'),2,64.33,'Ricardo Adocicados','Av. Copacabana, 267','Rio de Janeiro','RJ','02389-890','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LAZYK',1,TO_DATE('2450529;00000','J;SSSSS'),TO_DATE('2450557;00000','J;SSSSS'),TO_DATE('2450549;00000','J;SSSSS'),3,7.48,'Lazy K Kountry Store','12 Orchestra Terrace','Walla Walla','WA','99362','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WHITC',7,TO_DATE('2450532;00000','J;SSSSS'),TO_DATE('2450560;00000','J;SSSSS'),TO_DATE('2450564;00000','J;SSSSS'),2,15.28,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BSBEV',3,TO_DATE('2450532;00000','J;SSSSS'),TO_DATE('2450560;00000','J;SSSSS'),TO_DATE('2450540;00000','J;SSSSS'),3,6.88,'B''s Beverages','Fauntleroy Circus','London',NULL,'EC2 5NT','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LINOD',4,TO_DATE('2450533;00000','J;SSSSS'),TO_DATE('2450547;00000','J;SSSSS'),TO_DATE('2450539;00000','J;SSSSS'),2,64.45,'LINO-Delicateses','Ave. 5 de Mayo Porlamar','I. de Margarita','Nueva Esparta','4980','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HILAA',1,TO_DATE('2450534;00000','J;SSSSS'),TO_DATE('2450562;00000','J;SSSSS'),TO_DATE('2450541;00000','J;SSSSS'),2,30.53,'HILARION-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Cristóbal','Táchira','5022','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUEEN',2,TO_DATE('2450534;00000','J;SSSSS'),TO_DATE('2450562;00000','J;SSSSS'),TO_DATE('2450536;00000','J;SSSSS'),2,71.07,'Queen Cozinha','Alameda dos Canàrios, 891','Sao Paulo','SP','05487-020','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FRANK',8,TO_DATE('2450535;00000','J;SSSSS'),TO_DATE('2450563;00000','J;SSSSS'),TO_DATE('2450541;00000','J;SSSSS'),2,4.93,'Frankenversand','Berliner Platz 43','München',NULL,'80805','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('PICCO',6,TO_DATE('2450536;00000','J;SSSSS'),TO_DATE('2450564;00000','J;SSSSS'),TO_DATE('2450548;00000','J;SSSSS'),2,5.29,'Piccolo und mehr','Geislweg 14','Salzburg',NULL,'5020','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HILAA',7,TO_DATE('2450539;00000','J;SSSSS'),TO_DATE('2450567;00000','J;SSSSS'),TO_DATE('2450542;00000','J;SSSSS'),2,210.19,'HILARION-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Cristóbal','Táchira','5022','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FURIB',8,TO_DATE('2450539;00000','J;SSSSS'),TO_DATE('2450567;00000','J;SSSSS'),TO_DATE('2450547;00000','J;SSSSS'),3,16.96,'Furia Bacalhau e Frutos do Mar','Jardim das rosas n. 32','Lisboa',NULL,'1675','Portugal');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BOTTM',3,TO_DATE('2450540;00000','J;SSSSS'),TO_DATE('2450568;00000','J;SSSSS'),TO_DATE('2450550;00000','J;SSSSS'),1,62.89,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LAMAI',4,TO_DATE('2450541;00000','J;SSSSS'),TO_DATE('2450569;00000','J;SSSSS'),TO_DATE('2450549;00000','J;SSSSS'),3,10.64,'La maison d''Asie','1 rue Alsace-Lorraine','Toulouse',NULL,'31000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('COMMI',4,TO_DATE('2450541;00000','J;SSSSS'),TO_DATE('2450569;00000','J;SSSSS'),TO_DATE('2450548;00000','J;SSSSS'),2,65.99,'Comércio Mineiro','Av. dos Lusíadas, 23','Sao Paulo','SP','05432-043','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LAUGB',3,TO_DATE('2450542;00000','J;SSSSS'),TO_DATE('2450570;00000','J;SSSSS'),TO_DATE('2450550;00000','J;SSSSS'),3,4.65,'Laughing Bacchus Wine Cellars','2319 Elm St.','Vancouver','BC','V3F 2K1','Canada');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('TRADH',7,TO_DATE('2450543;00000','J;SSSSS'),TO_DATE('2450571;00000','J;SSSSS'),TO_DATE('2450546;00000','J;SSSSS'),2,46.77,'Tradiçao Hipermercados','Av. Inês de Castro, 414','Sao Paulo','SP','05634-030','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LEHMS',7,TO_DATE('2450543;00000','J;SSSSS'),TO_DATE('2450571;00000','J;SSSSS'),TO_DATE('2450546;00000','J;SSSSS'),1,36.21,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M. ',NULL,'60528','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HILAA',8,TO_DATE('2450546;00000','J;SSSSS'),TO_DATE('2450574;00000','J;SSSSS'),TO_DATE('2450550;00000','J;SSSSS'),2,29.75,'HILARION-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Cristóbal','Táchira','5022','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LILAS',4,TO_DATE('2450547;00000','J;SSSSS'),TO_DATE('2450575;00000','J;SSSSS'),TO_DATE('2450555;00000','J;SSSSS'),2,102.02,'LILA-Supermercado','Carrera 52 con Ave. Bolívar #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LAMAI',6,TO_DATE('2450548;00000','J;SSSSS'),TO_DATE('2450576;00000','J;SSSSS'),TO_DATE('2450556;00000','J;SSSSS'),1,42.68,'La maison d''Asie','1 rue Alsace-Lorraine','Toulouse',NULL,'31000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BLAUS',9,TO_DATE('2450548;00000','J;SSSSS'),TO_DATE('2450576;00000','J;SSSSS'),TO_DATE('2450555;00000','J;SSSSS'),3,8.85,'Blauer See Delikatessen','Forsterstr. 57','Mannheim',NULL,'68306','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('PERIC',2,TO_DATE('2450549;00000','J;SSSSS'),TO_DATE('2450577;00000','J;SSSSS'),TO_DATE('2450568;00000','J;SSSSS'),1,69.32,'Pericles Comidas clásicas','Calle Dr. Jorge Cash 321','México D.F.',NULL,'05033','Mexico');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HUNGO',6,TO_DATE('2450550;00000','J;SSSSS'),TO_DATE('2450578;00000','J;SSSSS'),TO_DATE('2450555;00000','J;SSSSS'),2,16.74,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WHITC',4,TO_DATE('2450550;00000','J;SSSSS'),TO_DATE('2450578;00000','J;SSSSS'),TO_DATE('2450557;00000','J;SSSSS'),3,59.13,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('MEREP',3,TO_DATE('2450553;00000','J;SSSSS'),TO_DATE('2450581;00000','J;SSSSS'),TO_DATE('2450560;00000','J;SSSSS'),3,7.13,'Mère Paillarde','43 rue St. Laurent','Montréal','Québec','H1J 1C3','Canada');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('KOENE',9,TO_DATE('2450554;00000','J;SSSSS'),TO_DATE('2450582;00000','J;SSSSS'),TO_DATE('2450571;00000','J;SSSSS'),2,21.19,'Königlich Essen','Maubelstr. 90','Brandenburg',NULL,'14776','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ANTON',7,TO_DATE('2450554;00000','J;SSSSS'),TO_DATE('2450582;00000','J;SSSSS'),TO_DATE('2450561;00000','J;SSSSS'),1,47.45,'Antonio Moreno Taquería','Mataderos  2312','México D.F.',NULL,'05023','Mexico');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('OTTIK',1,TO_DATE('2450555;00000','J;SSSSS'),TO_DATE('2450583;00000','J;SSSSS'),TO_DATE('2450582;00000','J;SSSSS'),2,4.99,'Ottilies Käseladen','Mehrheimerstr. 369','Köln',NULL,'50739','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BLAUS',4,TO_DATE('2450556;00000','J;SSSSS'),TO_DATE('2450584;00000','J;SSSSS'),TO_DATE('2450568;00000','J;SSSSS'),1,.15,'Blauer See Delikatessen','Forsterstr. 57','Mannheim',NULL,'68306','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SAVEA',6,TO_DATE('2450557;00000','J;SSSSS'),TO_DATE('2450585;00000','J;SSSSS'),TO_DATE('2450567;00000','J;SSSSS'),3,367.63,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BONAP',4,TO_DATE('2450557;00000','J;SSSSS'),TO_DATE('2450585;00000','J;SSSSS'),TO_DATE('2450560;00000','J;SSSSS'),3,350.64,'Bon app''','12, rue des Bouchers','Marseille',NULL,'13008','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FAMIA',7,TO_DATE('2450560;00000','J;SSSSS'),TO_DATE('2450588;00000','J;SSSSS'),TO_DATE('2450563;00000','J;SSSSS'),2,3.53,'Familia Arquibaldo','Rua Orós, 92','Sao Paulo','SP','05442-030','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WANDK',7,TO_DATE('2450561;00000','J;SSSSS'),TO_DATE('2450603;00000','J;SSSSS'),TO_DATE('2450567;00000','J;SSSSS'),1,105.65,'Die Wandernde Kuh','Adenauerallee 900','Stuttgart',NULL,'70563','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ERNSH',3,TO_DATE('2450561;00000','J;SSSSS'),TO_DATE('2450589;00000','J;SSSSS'),TO_DATE('2450585;00000','J;SSSSS'),2,789.95,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUICK',2,TO_DATE('2450562;00000','J;SSSSS'),TO_DATE('2450576;00000','J;SSSSS'),TO_DATE('2450592;00000','J;SSSSS'),1,204.47,'QUICK-Stop','Taucherstraße 10','Cunewalde',NULL,'01307','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HUNGO',2,TO_DATE('2450563;00000','J;SSSSS'),TO_DATE('2450591;00000','J;SSSSS'),TO_DATE('2450570;00000','J;SSSSS'),3,62.78,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('NORTS',3,TO_DATE('2450563;00000','J;SSSSS'),TO_DATE('2450591;00000','J;SSSSS'),TO_DATE('2450568;00000','J;SSSSS'),3,32.07,'North/South','South House'||CHR(13)||CHR(10)||'300 Queensbridge','London',NULL,'SW7 1RZ','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('TORTU',4,TO_DATE('2450564;00000','J;SSSSS'),TO_DATE('2450578;00000','J;SSSSS'),TO_DATE('2450574;00000','J;SSSSS'),2,218.15,'Tortuga Restaurante','Avda. Azteca 123','México D.F.',NULL,'05033','Mexico');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('CHOPS',6,TO_DATE('2450567;00000','J;SSSSS'),TO_DATE('2450595;00000','J;SSSSS'),TO_DATE('2450570;00000','J;SSSSS'),3,91.76,'Chop-suey Chinese','Hauptstr. 31','Bern',NULL,'3012','Switzerland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SANTG',7,TO_DATE('2450568;00000','J;SSSSS'),TO_DATE('2450596;00000','J;SSSSS'),TO_DATE('2450570;00000','J;SSSSS'),1,13.37,'Santé Gourmet','Erling Skakkes gate 78','Stavern',NULL,'4110','Norway');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('CACTU',8,TO_DATE('2450568;00000','J;SSSSS'),TO_DATE('2450596;00000','J;SSSSS'),TO_DATE('2450571;00000','J;SSSSS'),2,17.22,'Cactus Comidas para llevar','Cerrito 333','Buenos Aires',NULL,'1010','Argentina');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LEHMS',4,TO_DATE('2450569;00000','J;SSSSS'),TO_DATE('2450597;00000','J;SSSSS'),TO_DATE('2450575;00000','J;SSSSS'),1,45.33,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M. ',NULL,'60528','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SEVES',7,TO_DATE('2450570;00000','J;SSSSS'),TO_DATE('2450598;00000','J;SSSSS'),TO_DATE('2450599;00000','J;SSSSS'),2,77.63,'Seven Seas Imports','90 Wadhurst Rd.','London',NULL,'OX15 4NB','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BERGS',1,TO_DATE('2450570;00000','J;SSSSS'),TO_DATE('2450598;00000','J;SSSSS'),TO_DATE('2450576;00000','J;SSSSS'),2,244.79,'Berglunds snabbköp','Berguvsvägen  8','Luleå',NULL,'S-958 22','Sweden');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BONAP',1,TO_DATE('2450571;00000','J;SSSSS'),TO_DATE('2450599;00000','J;SSSSS'),TO_DATE('2450592;00000','J;SSSSS'),2,11.06,'Bon app''','12, rue des Bouchers','Marseille',NULL,'13008','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WARTH',4,TO_DATE('2450574;00000','J;SSSSS'),TO_DATE('2450602;00000','J;SSSSS'),TO_DATE('2450584;00000','J;SSSSS'),2,58.59,'Wartian Herkku','Torikatu 38','Oulu',NULL,'90110','Finland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUICK',7,TO_DATE('2450574;00000','J;SSSSS'),TO_DATE('2450602;00000','J;SSSSS'),TO_DATE('2450576;00000','J;SSSSS'),1,41.9,'QUICK-Stop','Taucherstraße 10','Cunewalde',NULL,'01307','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('GREAL',6,TO_DATE('2450575;00000','J;SSSSS'),TO_DATE('2450589;00000','J;SSSSS'),TO_DATE('2450578;00000','J;SSSSS'),2,3.35,'Great Lakes Food Market','2732 Baker Blvd.','Eugene','OR','97403','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('MAISD',5,TO_DATE('2450576;00000','J;SSSSS'),TO_DATE('2450604;00000','J;SSSSS'),TO_DATE('2450578;00000','J;SSSSS'),2,66.69,'Maison Dewey','Rue Joseph-Bens 532','Bruxelles',NULL,'B-1180','Belgium');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('PICCO',3,TO_DATE('2450577;00000','J;SSSSS'),TO_DATE('2450605;00000','J;SSSSS'),TO_DATE('2450581;00000','J;SSSSS'),2,339.22,'Piccolo und mehr','Geislweg 14','Salzburg',NULL,'5020','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('OCEAN',7,TO_DATE('2450577;00000','J;SSSSS'),TO_DATE('2450605;00000','J;SSSSS'),TO_DATE('2450588;00000','J;SSSSS'),1,8.12,'Océano Atlántico Ltda.','Ing. Gustavo Moncada 8585'||CHR(13)||CHR(10)||'Piso 20-A','Buenos Aires',NULL,'1010','Argentina');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('EASTC',7,TO_DATE('2450578;00000','J;SSSSS'),TO_DATE('2450606;00000','J;SSSSS'),TO_DATE('2450581;00000','J;SSSSS'),3,74.46,'Eastern Connection','35 King George','London',NULL,'WX3 6FW','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FOLKO',8,TO_DATE('2450581;00000','J;SSSSS'),TO_DATE('2450609;00000','J;SSSSS'),TO_DATE('2450591;00000','J;SSSSS'),1,188.04,'Folk och fä HB','Åkergatan 24','Bräcke',NULL,'S-844 67','Sweden');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LEHMS',8,TO_DATE('2450581;00000','J;SSSSS'),TO_DATE('2450609;00000','J;SSSSS'),TO_DATE('2450583;00000','J;SSSSS'),2,27.94,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M. ',NULL,'60528','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ANTON',4,TO_DATE('2450582;00000','J;SSSSS'),TO_DATE('2450610;00000','J;SSSSS'),TO_DATE('2450590;00000','J;SSSSS'),1,15.64,'Antonio Moreno Taquería','Mataderos  2312','México D.F.',NULL,'05023','Mexico');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LEHMS',3,TO_DATE('2450583;00000','J;SSSSS'),TO_DATE('2450611;00000','J;SSSSS'),TO_DATE('2450606;00000','J;SSSSS'),2,58.88,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M. ',NULL,'60528','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RICSU',1,TO_DATE('2450583;00000','J;SSSSS'),TO_DATE('2450597;00000','J;SSSSS'),TO_DATE('2450588;00000','J;SSSSS'),1,78.85,'Richter Supermarkt','Starenweg 5','Genève',NULL,'1204','Switzerland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BSBEV',9,TO_DATE('2450584;00000','J;SSSSS'),TO_DATE('2450612;00000','J;SSSSS'),TO_DATE('2450585;00000','J;SSSSS'),3,4.87,'B''s Beverages','Fauntleroy Circus','London',NULL,'EC2 5NT','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BSBEV',6,TO_DATE('2450585;00000','J;SSSSS'),TO_DATE('2450613;00000','J;SSSSS'),TO_DATE('2450592;00000','J;SSSSS'),3,12.36,'B''s Beverages','Fauntleroy Circus','London',NULL,'EC2 5NT','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUICK',3,TO_DATE('2450588;00000','J;SSSSS'),TO_DATE('2450616;00000','J;SSSSS'),TO_DATE('2450613;00000','J;SSSSS'),3,1007.64,'QUICK-Stop','Taucherstraße 10','Cunewalde',NULL,'01307','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HANAR',2,TO_DATE('2450588;00000','J;SSSSS'),TO_DATE('2450616;00000','J;SSSSS'),TO_DATE('2450598;00000','J;SSSSS'),1,68.65,'Hanari Carnes','Rua do Paço, 67','Rio de Janeiro','RJ','05454-876','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('KOENE',1,TO_DATE('2450589;00000','J;SSSSS'),TO_DATE('2450617;00000','J;SSSSS'),TO_DATE('2450595;00000','J;SSSSS'),3,10.95,'Königlich Essen','Maubelstr. 90','Brandenburg',NULL,'14776','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LILAS',8,TO_DATE('2450590;00000','J;SSSSS'),TO_DATE('2450618;00000','J;SSSSS'),TO_DATE('2450592;00000','J;SSSSS'),2,48.17,'LILA-Supermercado','Carrera 52 con Ave. Bolívar #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LONEP',4,TO_DATE('2450590;00000','J;SSSSS'),TO_DATE('2450618;00000','J;SSSSS'),TO_DATE('2450599;00000','J;SSSSS'),1,24.91,'Lonesome Pine Restaurant','89 Chiaroscuro Rd.','Portland','OR','97219','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LAZYK',8,TO_DATE('2450591;00000','J;SSSSS'),TO_DATE('2450619;00000','J;SSSSS'),TO_DATE('2450626;00000','J;SSSSS'),2,11.92,'Lazy K Kountry Store','12 Orchestra Terrace','Walla Walla','WA','99362','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('VICTE',1,TO_DATE('2450592;00000','J;SSSSS'),TO_DATE('2450620;00000','J;SSSSS'),TO_DATE('2450596;00000','J;SSSSS'),3,194.72,'Victuailles en stock','2, rue du Commerce','Lyon',NULL,'69004','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SEVES',3,TO_DATE('2450592;00000','J;SSSSS'),TO_DATE('2450620;00000','J;SSSSS'),TO_DATE('2450602;00000','J;SSSSS'),2,178.43,'Seven Seas Imports','90 Wadhurst Rd.','London',NULL,'OX15 4NB','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('TOMSP',3,TO_DATE('2450595;00000','J;SSSSS'),TO_DATE('2450623;00000','J;SSSSS'),TO_DATE('2450602;00000','J;SSSSS'),2,1.43,'Toms Spezialitäten','Luisenstr. 48','Münster',NULL,'44087','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUICK',5,TO_DATE('2450596;00000','J;SSSSS'),TO_DATE('2450610;00000','J;SSSSS'),TO_DATE('2450599;00000','J;SSSSS'),1,171.24,'QUICK-Stop','Taucherstraße 10','Cunewalde',NULL,'01307','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('GODOS',7,TO_DATE('2450597;00000','J;SSSSS'),TO_DATE('2450625;00000','J;SSSSS'),TO_DATE('2450606;00000','J;SSSSS'),3,4.32,'Godos Cocina Típica','C/ Romero, 33','Sevilla',NULL,'41101','Spain');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FURIB',4,TO_DATE('2450597;00000','J;SSSSS'),TO_DATE('2450639;00000','J;SSSSS'),TO_DATE('2450606;00000','J;SSSSS'),3,72.95,'Furia Bacalhau e Frutos do Mar','Jardim das rosas n. 32','Lisboa',NULL,'1675','Portugal');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HILAA',2,TO_DATE('2450598;00000','J;SSSSS'),TO_DATE('2450626;00000','J;SSSSS'),TO_DATE('2450605;00000','J;SSSSS'),1,83.22,'HILARION-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Cristóbal','Táchira','5022','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WARTH',2,TO_DATE('2450599;00000','J;SSSSS'),TO_DATE('2450627;00000','J;SSSSS'),TO_DATE('2450603;00000','J;SSSSS'),2,149.49,'Wartian Herkku','Torikatu 38','Oulu',NULL,'90110','Finland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('OTTIK',4,TO_DATE('2450599;00000','J;SSSSS'),TO_DATE('2450627;00000','J;SSSSS'),TO_DATE('2450605;00000','J;SSSSS'),3,120.97,'Ottilies Käseladen','Mehrheimerstr. 369','Köln',NULL,'50739','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SAVEA',6,TO_DATE('2450602;00000','J;SSSSS'),TO_DATE('2450630;00000','J;SSSSS'),TO_DATE('2450604;00000','J;SSSSS'),3,252.49,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SIMOB',2,TO_DATE('2450603;00000','J;SSSSS'),TO_DATE('2450645;00000','J;SSSSS'),TO_DATE('2450613;00000','J;SSSSS'),1,9.8,'Simons bistro','Vinbæltet 34','Kobenhavn',NULL,'1734','Denmark');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LEHMS',9,TO_DATE('2450603;00000','J;SSSSS'),TO_DATE('2450617;00000','J;SSSSS'),TO_DATE('2450606;00000','J;SSSSS'),2,96.72,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M. ',NULL,'60528','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('AROUT',1,TO_DATE('2450604;00000','J;SSSSS'),TO_DATE('2450632;00000','J;SSSSS'),TO_DATE('2450610;00000','J;SSSSS'),2,72.97,'Around the Horn','Brook Farm'||CHR(13)||CHR(10)||'Stratford St. Mary','Colchester','Essex','CO7 6JX','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BLONP',6,TO_DATE('2450605;00000','J;SSSSS'),TO_DATE('2450633;00000','J;SSSSS'),TO_DATE('2450613;00000','J;SSSSS'),1,8.05,'Blondel père et fils','24, place Kléber','Strasbourg',NULL,'67000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FRANK',8,TO_DATE('2450606;00000','J;SSSSS'),TO_DATE('2450634;00000','J;SSSSS'),TO_DATE('2450609;00000','J;SSSSS'),1,36.65,'Frankenversand','Berliner Platz 43','München',NULL,'80805','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FOLKO',2,TO_DATE('2450606;00000','J;SSSSS'),TO_DATE('2450634;00000','J;SSSSS'),TO_DATE('2450609;00000','J;SSSSS'),2,242.21,'Folk och fä HB','Åkergatan 24','Bräcke',NULL,'S-844 67','Sweden');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('REGGC',1,TO_DATE('2450609;00000','J;SSSSS'),TO_DATE('2450637;00000','J;SSSSS'),TO_DATE('2450612;00000','J;SSSSS'),1,22.95,'Reggiani Caseifici','Strada Provinciale 124','Reggio Emilia',NULL,'42100','Italy');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RICAR',2,TO_DATE('2450610;00000','J;SSSSS'),TO_DATE('2450652;00000','J;SSSSS'),TO_DATE('2450624;00000','J;SSSSS'),2,60.43,'Ricardo Adocicados','Av. Copacabana, 267','Rio de Janeiro','RJ','02389-890','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RATTC',4,TO_DATE('2450610;00000','J;SSSSS'),TO_DATE('2450638;00000','J;SSSSS'),TO_DATE('2450616;00000','J;SSSSS'),3,13.75,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('MEREP',8,TO_DATE('2450611;00000','J;SSSSS'),TO_DATE('2450639;00000','J;SSSSS'),TO_DATE('2450618;00000','J;SSSSS'),2,7.15,'Mère Paillarde','43 rue St. Laurent','Montréal','Québec','H1J 1C3','Canada');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BLONP',9,TO_DATE('2450612;00000','J;SSSSS'),TO_DATE('2450640;00000','J;SSSSS'),TO_DATE('2450618;00000','J;SSSSS'),1,88.4,'Blondel père et fils','24, place Kléber','Strasbourg',NULL,'67000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HUNGO',1,TO_DATE('2450612;00000','J;SSSSS'),TO_DATE('2450640;00000','J;SSSSS'),TO_DATE('2450617;00000','J;SSSSS'),1,33.97,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('GALED',3,TO_DATE('2450613;00000','J;SSSSS'),TO_DATE('2450641;00000','J;SSSSS'),TO_DATE('2450639;00000','J;SSSSS'),3,6.54,'Galería del gastronómo','Rambla de Cataluña, 23','Barcelona',NULL,'8022','Spain');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RATTC',5,TO_DATE('2450616;00000','J;SSSSS'),TO_DATE('2450644;00000','J;SSSSS'),TO_DATE('2450641;00000','J;SSSSS'),1,58.98,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('MEREP',3,TO_DATE('2450617;00000','J;SSSSS'),TO_DATE('2450645;00000','J;SSSSS'),TO_DATE('2450619;00000','J;SSSSS'),3,188.99,'Mère Paillarde','43 rue St. Laurent','Montréal','Québec','H1J 1C3','Canada');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ERNSH',8,TO_DATE('2450617;00000','J;SSSSS'),TO_DATE('2450659;00000','J;SSSSS'),TO_DATE('2450634;00000','J;SSSSS'),3,26.06,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BERGS',3,TO_DATE('2450618;00000','J;SSSSS'),TO_DATE('2450646;00000','J;SSSSS'),TO_DATE('2450625;00000','J;SSSSS'),2,116.43,'Berglunds snabbköp','Berguvsvägen  8','Luleå',NULL,'S-958 22','Sweden');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ANTON',7,TO_DATE('2450619;00000','J;SSSSS'),TO_DATE('2450647;00000','J;SSSSS'),TO_DATE('2450620;00000','J;SSSSS'),3,84.84,'Antonio Moreno Taquería','Mataderos  2312','México D.F.',NULL,'05023','Mexico');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('TRAIH',4,TO_DATE('2450619;00000','J;SSSSS'),TO_DATE('2450647;00000','J;SSSSS'),TO_DATE('2450630;00000','J;SSSSS'),2,37.6,'Trail''s Head Gourmet Provisioners','722 DaVinci Blvd.','Kirkland','WA','98034','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('MORGK',5,TO_DATE('2450620;00000','J;SSSSS'),TO_DATE('2450634;00000','J;SSSSS'),TO_DATE('2450630;00000','J;SSSSS'),1,127.34,'Morgenstern Gesundkost','Heerstr. 22','Leipzig',NULL,'04179','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('TORTU',3,TO_DATE('2450623;00000','J;SSSSS'),TO_DATE('2450637;00000','J;SSSSS'),TO_DATE('2450630;00000','J;SSSSS'),3,18.56,'Tortuga Restaurante','Avda. Azteca 123','México D.F.',NULL,'05033','Mexico');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('TRAIH',9,TO_DATE('2450623;00000','J;SSSSS'),TO_DATE('2450665;00000','J;SSSSS'),TO_DATE('2450630;00000','J;SSSSS'),2,25.41,'Trail''s Head Gourmet Provisioners','722 DaVinci Blvd.','Kirkland','WA','98034','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BSBEV',4,TO_DATE('2450624;00000','J;SSSSS'),TO_DATE('2450652;00000','J;SSSSS'),TO_DATE('2450655;00000','J;SSSSS'),3,29.6,'B''s Beverages','Fauntleroy Circus','London',NULL,'EC2 5NT','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LETSS',1,TO_DATE('2450625;00000','J;SSSSS'),TO_DATE('2450653;00000','J;SSSSS'),TO_DATE('2450634;00000','J;SSSSS'),2,13.73,'Let''s Stop N Shop','87 Polk St.'||CHR(13)||CHR(10)||'Suite 5','San Francisco','CA','94117','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('OTTIK',4,TO_DATE('2450626;00000','J;SSSSS'),TO_DATE('2450654;00000','J;SSSSS'),TO_DATE('2450631;00000','J;SSSSS'),3,75.89,'Ottilies Käseladen','Mehrheimerstr. 369','Köln',NULL,'50739','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FAMIA',3,TO_DATE('2450626;00000','J;SSSSS'),TO_DATE('2450654;00000','J;SSSSS'),TO_DATE('2450632;00000','J;SSSSS'),1,3.01,'Familia Arquibaldo','Rua Orós, 92','Sao Paulo','SP','05442-030','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BLAUS',3,TO_DATE('2450627;00000','J;SSSSS'),TO_DATE('2450655;00000','J;SSSSS'),TO_DATE('2450644;00000','J;SSSSS'),2,27.71,'Blauer See Delikatessen','Forsterstr. 57','Mannheim',NULL,'68306','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WARTH',2,TO_DATE('2450630;00000','J;SSSSS'),TO_DATE('2450658;00000','J;SSSSS'),TO_DATE('2450634;00000','J;SSSSS'),2,7.28,'Wartian Herkku','Torikatu 38','Oulu',NULL,'90110','Finland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BLONP',4,TO_DATE('2450630;00000','J;SSSSS'),TO_DATE('2450658;00000','J;SSSSS'),TO_DATE('2450634;00000','J;SSSSS'),1,59.14,'Blondel père et fils','24, place Kléber','Strasbourg',NULL,'67000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WELLI',7,TO_DATE('2450631;00000','J;SSSSS'),TO_DATE('2450659;00000','J;SSSSS'),TO_DATE('2450640;00000','J;SSSSS'),1,13.41,'Wellington Importadora','Rua do Mercado, 12','Resende','SP','08737-363','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('REGGC',9,TO_DATE('2450632;00000','J;SSSSS'),TO_DATE('2450660;00000','J;SSSSS'),TO_DATE('2450639;00000','J;SSSSS'),1,.48,'Reggiani Caseifici','Strada Provinciale 124','Reggio Emilia',NULL,'42100','Italy');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUEDE',1,TO_DATE('2450632;00000','J;SSSSS'),TO_DATE('2450660;00000','J;SSSSS'),TO_DATE('2450639;00000','J;SSSSS'),1,62.52,'Que Delícia','Rua da Panificadora, 12','Rio de Janeiro','RJ','02389-673','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUICK',2,TO_DATE('2450633;00000','J;SSSSS'),TO_DATE('2450661;00000','J;SSSSS'),TO_DATE('2450640;00000','J;SSSSS'),3,194.67,'QUICK-Stop','Taucherstraße 10','Cunewalde',NULL,'01307','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('GREAL',8,TO_DATE('2450634;00000','J;SSSSS'),TO_DATE('2450662;00000','J;SSSSS'),TO_DATE('2450644;00000','J;SSSSS'),2,4.42,'Great Lakes Food Market','2732 Baker Blvd.','Eugene','OR','97403','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('MEREP',4,TO_DATE('2450637;00000','J;SSSSS'),TO_DATE('2450665;00000','J;SSSSS'),TO_DATE('2450644;00000','J;SSSSS'),3,44.77,'Mère Paillarde','43 rue St. Laurent','Montréal','Québec','H1J 1C3','Canada');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('VAFFE',1,TO_DATE('2450637;00000','J;SSSSS'),TO_DATE('2450651;00000','J;SSSSS'),TO_DATE('2450646;00000','J;SSSSS'),1,55.92,'Vaffeljernet','Smagsloget 45','Århus',NULL,'8200','Denmark');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LEHMS',3,TO_DATE('2450638;00000','J;SSSSS'),TO_DATE('2450666;00000','J;SSSSS'),TO_DATE('2450646;00000','J;SSSSS'),1,32.1,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M. ',NULL,'60528','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LEHMS',7,TO_DATE('2450639;00000','J;SSSSS'),TO_DATE('2450667;00000','J;SSSSS'),TO_DATE('2450674;00000','J;SSSSS'),2,174.2,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M. ',NULL,'60528','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('OLDWO',3,TO_DATE('2450639;00000','J;SSSSS'),TO_DATE('2450667;00000','J;SSSSS'),TO_DATE('2450646;00000','J;SSSSS'),2,5.24,'Old World Delicatessen','2743 Bering St.','Anchorage','AK','99508','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ERNSH',2,TO_DATE('2450640;00000','J;SSSSS'),TO_DATE('2450668;00000','J;SSSSS'),TO_DATE('2450644;00000','J;SSSSS'),1,96.78,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WHITC',8,TO_DATE('2450641;00000','J;SSSSS'),TO_DATE('2450669;00000','J;SSSSS'),TO_DATE('2450673;00000','J;SSSSS'),1,16.34,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('PICCO',7,TO_DATE('2450641;00000','J;SSSSS'),TO_DATE('2450669;00000','J;SSSSS'),TO_DATE('2450648;00000','J;SSSSS'),3,35.12,'Piccolo und mehr','Geislweg 14','Salzburg',NULL,'5020','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RATTC',1,TO_DATE('2450644;00000','J;SSSSS'),TO_DATE('2450672;00000','J;SSSSS'),TO_DATE('2450648;00000','J;SSSSS'),3,44.42,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BSBEV',6,TO_DATE('2450645;00000','J;SSSSS'),TO_DATE('2450687;00000','J;SSSSS'),TO_DATE('2450651;00000','J;SSSSS'),3,29.98,'B''s Beverages','Fauntleroy Circus','London',NULL,'EC2 5NT','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HUNGC',4,TO_DATE('2450646;00000','J;SSSSS'),TO_DATE('2450674;00000','J;SSSSS'),TO_DATE('2450651;00000','J;SSSSS'),1,45.13,'Hungry Coyote Import Store','City Center Plaza'||CHR(13)||CHR(10)||'516 Main St.','Elgin','OR','97827','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HILAA',7,TO_DATE('2450646;00000','J;SSSSS'),TO_DATE('2450688;00000','J;SSSSS'),TO_DATE('2450652;00000','J;SSSSS'),1,58.3,'HILARION-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Cristóbal','Táchira','5022','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('VAFFE',8,TO_DATE('2450647;00000','J;SSSSS'),TO_DATE('2450675;00000','J;SSSSS'),TO_DATE('2450652;00000','J;SSSSS'),2,2.92,'Vaffeljernet','Smagsloget 45','Århus',NULL,'8200','Denmark');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SAVEA',8,TO_DATE('2450648;00000','J;SSSSS'),TO_DATE('2450676;00000','J;SSSSS'),TO_DATE('2450669;00000','J;SSSSS'),2,48.77,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FURIB',1,TO_DATE('2450648;00000','J;SSSSS'),TO_DATE('2450676;00000','J;SSSSS'),TO_DATE('2450659;00000','J;SSSSS'),1,7.46,'Furia Bacalhau e Frutos do Mar','Jardim das rosas n. 32','Lisboa',NULL,'1675','Portugal');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('MEREP',1,TO_DATE('2450651;00000','J;SSSSS'),TO_DATE('2450679;00000','J;SSSSS'),TO_DATE('2450659;00000','J;SSSSS'),2,379.13,'Mère Paillarde','43 rue St. Laurent','Montréal','Québec','H1J 1C3','Canada');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('TRADH',4,TO_DATE('2450652;00000','J;SSSSS'),TO_DATE('2450680;00000','J;SSSSS'),TO_DATE('2450661;00000','J;SSSSS'),3,79.4,'Tradiçao Hipermercados','Av. Inês de Castro, 414','Sao Paulo','SP','05634-030','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SAVEA',5,TO_DATE('2450652;00000','J;SSSSS'),TO_DATE('2450680;00000','J;SSSSS'),TO_DATE('2450655;00000','J;SSSSS'),1,200.24,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('TOMSP',4,TO_DATE('2450653;00000','J;SSSSS'),TO_DATE('2450681;00000','J;SSSSS'),TO_DATE('2450662;00000','J;SSSSS'),2,27.79,'Toms Spezialitäten','Luisenstr. 48','Münster',NULL,'44087','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('DUMON',7,TO_DATE('2450654;00000','J;SSSSS'),TO_DATE('2450682;00000','J;SSSSS'),TO_DATE('2450660;00000','J;SSSSS'),2,1.85,'Du monde entier','67, rue des Cinquante Otages','Nantes',NULL,'44000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LAMAI',8,TO_DATE('2450655;00000','J;SSSSS'),TO_DATE('2450683;00000','J;SSSSS'),TO_DATE('2450667;00000','J;SSSSS'),1,26.78,'La maison d''Asie','1 rue Alsace-Lorraine','Toulouse',NULL,'31000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WOLZA',6,TO_DATE('2450655;00000','J;SSSSS'),TO_DATE('2450683;00000','J;SSSSS'),TO_DATE('2450662;00000','J;SSSSS'),2,80.65,'Wolski Zajazd','ul. Filtrowa 68','Warszawa',NULL,'01-012','Poland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SAVEA',1,TO_DATE('2450658;00000','J;SSSSS'),TO_DATE('2450686;00000','J;SSSSS'),TO_DATE('2450662;00000','J;SSSSS'),2,544.08,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HILAA',4,TO_DATE('2450659;00000','J;SSSSS'),TO_DATE('2450687;00000','J;SSSSS'),TO_DATE('2450662;00000','J;SSSSS'),2,8.11,'HILARION-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Cristóbal','Táchira','5022','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BLAUS',8,TO_DATE('2450659;00000','J;SSSSS'),TO_DATE('2450687;00000','J;SSSSS'),TO_DATE('2450662;00000','J;SSSSS'),3,1.93,'Blauer See Delikatessen','Forsterstr. 57','Mannheim',NULL,'68306','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WILMK',2,TO_DATE('2450660;00000','J;SSSSS'),TO_DATE('2450688;00000','J;SSSSS'),TO_DATE('2450667;00000','J;SSSSS'),3,.75,'Wilman Kala','Keskuskatu 45','Helsinki',NULL,'21240','Finland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('GREAL',1,TO_DATE('2450661;00000','J;SSSSS'),TO_DATE('2450689;00000','J;SSSSS'),TO_DATE('2450666;00000','J;SSSSS'),2,116.53,'Great Lakes Food Market','2732 Baker Blvd.','Eugene','OR','97403','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('GREAL',4,TO_DATE('2450661;00000','J;SSSSS'),TO_DATE('2450689;00000','J;SSSSS'),TO_DATE('2450665;00000','J;SSSSS'),2,18.53,'Great Lakes Food Market','2732 Baker Blvd.','Eugene','OR','97403','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('MEREP',1,TO_DATE('2450662;00000','J;SSSSS'),TO_DATE('2450704;00000','J;SSSSS'),TO_DATE('2450669;00000','J;SSSSS'),1,154.68,'Mère Paillarde','43 rue St. Laurent','Montréal','Québec','H1J 1C3','Canada');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('MEREP',3,TO_DATE('2450665;00000','J;SSSSS'),TO_DATE('2450693;00000','J;SSSSS'),TO_DATE('2450668;00000','J;SSSSS'),3,91.05,'Mère Paillarde','43 rue St. Laurent','Montréal','Québec','H1J 1C3','Canada');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LAUGB',2,TO_DATE('2450666;00000','J;SSSSS'),TO_DATE('2450694;00000','J;SSSSS'),TO_DATE('2450675;00000','J;SSSSS'),3,.94,'Laughing Bacchus Wine Cellars','2319 Elm St.','Vancouver','BC','V3F 2K1','Canada');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ISLAT',4,TO_DATE('2450666;00000','J;SSSSS'),TO_DATE('2450694;00000','J;SSSSS'),TO_DATE('2450672;00000','J;SSSSS'),2,23.73,'Island Trading','Garden House'||CHR(13)||CHR(10)||'Crowther Way','Cowes','Isle of Wight','PO31 7PJ','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RICAR',4,TO_DATE('2450667;00000','J;SSSSS'),TO_DATE('2450695;00000','J;SSSSS'),TO_DATE('2450672;00000','J;SSSSS'),3,50.97,'Ricardo Adocicados','Av. Copacabana, 267','Rio de Janeiro','RJ','02389-890','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FRANK',8,TO_DATE('2450668;00000','J;SSSSS'),TO_DATE('2450696;00000','J;SSSSS'),TO_DATE('2450673;00000','J;SSSSS'),2,97.18,'Frankenversand','Berliner Platz 43','München',NULL,'80805','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('THECR',4,TO_DATE('2450668;00000','J;SSSSS'),TO_DATE('2450696;00000','J;SSSSS'),TO_DATE('2450680;00000','J;SSSSS'),2,94.8,'The Cracker Box','55 Grizzly Peak Rd.','Butte','MT','59801','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ANATR',3,TO_DATE('2450669;00000','J;SSSSS'),TO_DATE('2450697;00000','J;SSSSS'),TO_DATE('2450675;00000','J;SSSSS'),1,43.9,'Ana Trujillo Emparedados y helados','Avda. de la Constitución 2222','México D.F.',NULL,'05021','Mexico');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BERGS',1,TO_DATE('2450672;00000','J;SSSSS'),TO_DATE('2450700;00000','J;SSSSS'),TO_DATE('2450681;00000','J;SSSSS'),2,138.69,'Berglunds snabbköp','Berguvsvägen  8','Luleå',NULL,'S-958 22','Sweden');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SAVEA',8,TO_DATE('2450672;00000','J;SSSSS'),TO_DATE('2450714;00000','J;SSSSS'),TO_DATE('2450682;00000','J;SSSSS'),3,107.46,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BLONP',4,TO_DATE('2450673;00000','J;SSSSS'),TO_DATE('2450701;00000','J;SSSSS'),TO_DATE('2450681;00000','J;SSSSS'),3,30.36,'Blondel père et fils','24, place Kléber','Strasbourg',NULL,'67000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('GODOS',4,TO_DATE('2450673;00000','J;SSSSS'),TO_DATE('2450701;00000','J;SSSSS'),TO_DATE('2450681;00000','J;SSSSS'),3,85.46,'Godos Cocina Típica','C/ Romero, 33','Sevilla',NULL,'41101','Spain');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('KOENE',1,TO_DATE('2450674;00000','J;SSSSS'),TO_DATE('2450702;00000','J;SSSSS'),TO_DATE('2450680;00000','J;SSSSS'),2,32.35,'Königlich Essen','Maubelstr. 90','Brandenburg',NULL,'14776','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LAMAI',8,TO_DATE('2450675;00000','J;SSSSS'),TO_DATE('2450703;00000','J;SSSSS'),TO_DATE('2450676;00000','J;SSSSS'),1,.87,'La maison d''Asie','1 rue Alsace-Lorraine','Toulouse',NULL,'31000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WANDK',8,TO_DATE('2450675;00000','J;SSSSS'),TO_DATE('2450703;00000','J;SSSSS'),TO_DATE('2450680;00000','J;SSSSS'),1,41.38,'Die Wandernde Kuh','Adenauerallee 900','Stuttgart',NULL,'70563','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ERNSH',7,TO_DATE('2450676;00000','J;SSSSS'),TO_DATE('2450704;00000','J;SSSSS'),TO_DATE('2450679;00000','J;SSSSS'),3,477.9,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FOLIG',4,TO_DATE('2450676;00000','J;SSSSS'),TO_DATE('2450704;00000','J;SSSSS'),TO_DATE('2450682;00000','J;SSSSS'),3,487.38,'Folies gourmandes','184, chaussée de Tournai','Lille',NULL,'59000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('MAGAA',8,TO_DATE('2450679;00000','J;SSSSS'),TO_DATE('2450707;00000','J;SSSSS'),TO_DATE('2450682;00000','J;SSSSS'),3,47.46,'Magazzini Alimentari Riuniti','Via Ludovico il Moro 22','Bergamo',NULL,'24100','Italy');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WARTH',4,TO_DATE('2450680;00000','J;SSSSS'),TO_DATE('2450708;00000','J;SSSSS'),TO_DATE('2450687;00000','J;SSSSS'),1,1.15,'Wartian Herkku','Torikatu 38','Oulu',NULL,'90110','Finland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUEEN',6,TO_DATE('2450680;00000','J;SSSSS'),TO_DATE('2450708;00000','J;SSSSS'),TO_DATE('2450687;00000','J;SSSSS'),1,201.29,'Queen Cozinha','Alameda dos Canàrios, 891','Sao Paulo','SP','05487-020','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LINOD',3,TO_DATE('2450681;00000','J;SSSSS'),TO_DATE('2450709;00000','J;SSSSS'),TO_DATE('2450693;00000','J;SSSSS'),1,158.44,'LINO-Delicateses','Ave. 5 de Mayo Porlamar','I. de Margarita','Nueva Esparta','4980','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SANTG',7,TO_DATE('2450681;00000','J;SSSSS'),TO_DATE('2450709;00000','J;SSSSS'),TO_DATE('2450688;00000','J;SSSSS'),3,38.64,'Santé Gourmet','Erling Skakkes gate 78','Stavern',NULL,'4110','Norway');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WANDK',4,TO_DATE('2450682;00000','J;SSSSS'),TO_DATE('2450710;00000','J;SSSSS'),TO_DATE('2450689;00000','J;SSSSS'),1,23.55,'Die Wandernde Kuh','Adenauerallee 900','Stuttgart',NULL,'70563','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HILAA',4,TO_DATE('2450683;00000','J;SSSSS'),TO_DATE('2450711;00000','J;SSSSS'),TO_DATE('2450687;00000','J;SSSSS'),2,179.61,'HILARION-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Cristóbal','Táchira','5022','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SIMOB',7,TO_DATE('2450683;00000','J;SSSSS'),TO_DATE('2450711;00000','J;SSSSS'),TO_DATE('2450697;00000','J;SSSSS'),3,41.89,'Simons bistro','Vinbæltet 34','Kobenhavn',NULL,'1734','Denmark');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ALFKI',6,TO_DATE('2450686;00000','J;SSSSS'),TO_DATE('2450714;00000','J;SSSSS'),TO_DATE('2450694;00000','J;SSSSS'),1,29.46,'Alfreds Futterkiste','Obere Str. 57','Berlin',NULL,'12209','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WELLI',3,TO_DATE('2450686;00000','J;SSSSS'),TO_DATE('2450714;00000','J;SSSSS'),TO_DATE('2450693;00000','J;SSSSS'),2,.14,'Wellington Importadora','Rua do Mercado, 12','Resende','SP','08737-363','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HANAR',4,TO_DATE('2450687;00000','J;SSSSS'),TO_DATE('2450715;00000','J;SSSSS'),TO_DATE('2450694;00000','J;SSSSS'),1,12.41,'Hanari Carnes','Rua do Paço, 67','Rio de Janeiro','RJ','05454-876','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HUNGO',9,TO_DATE('2450688;00000','J;SSSSS'),TO_DATE('2450730;00000','J;SSSSS'),TO_DATE('2450695;00000','J;SSSSS'),3,142.33,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUEDE',4,TO_DATE('2450688;00000','J;SSSSS'),TO_DATE('2450702;00000','J;SSSSS'),TO_DATE('2450695;00000','J;SSSSS'),2,45.54,'Que Delícia','Rua da Panificadora, 12','Rio de Janeiro','RJ','02389-673','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RICAR',5,TO_DATE('2450689;00000','J;SSSSS'),TO_DATE('2450731;00000','J;SSSSS'),TO_DATE('2450701;00000','J;SSSSS'),2,14.25,'Ricardo Adocicados','Av. Copacabana, 267','Rio de Janeiro','RJ','02389-890','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('MAISD',5,TO_DATE('2450689;00000','J;SSSSS'),TO_DATE('2450717;00000','J;SSSSS'),TO_DATE('2450690;00000','J;SSSSS'),3,6.2,'Maison Dewey','Rue Joseph-Bens 532','Bruxelles',NULL,'B-1180','Belgium');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FAMIA',5,TO_DATE('2450690;00000','J;SSSSS'),TO_DATE('2450718;00000','J;SSSSS'),TO_DATE('2450695;00000','J;SSSSS'),3,176.81,'Familia Arquibaldo','Rua Orós, 92','Sao Paulo','SP','05442-030','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WANDK',8,TO_DATE('2450693;00000','J;SSSSS'),TO_DATE('2450721;00000','J;SSSSS'),TO_DATE('2450703;00000','J;SSSSS'),2,20.6,'Die Wandernde Kuh','Adenauerallee 900','Stuttgart',NULL,'70563','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('GOURL',4,TO_DATE('2450693;00000','J;SSSSS'),TO_DATE('2450721;00000','J;SSSSS'),TO_DATE('2450700;00000','J;SSSSS'),2,7.14,'Gourmet Lanchonetes','Av. Brasil, 442','Campinas','SP','04876-786','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FRANK',1,TO_DATE('2450694;00000','J;SSSSS'),TO_DATE('2450722;00000','J;SSSSS'),TO_DATE('2450711;00000','J;SSSSS'),1,93.25,'Frankenversand','Berliner Platz 43','München',NULL,'80805','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BERGS',5,TO_DATE('2450694;00000','J;SSSSS'),TO_DATE('2450722;00000','J;SSSSS'),TO_DATE('2450703;00000','J;SSSSS'),1,55.26,'Berglunds snabbköp','Berguvsvägen  8','Luleå',NULL,'S-958 22','Sweden');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('REGGC',1,TO_DATE('2450695;00000','J;SSSSS'),TO_DATE('2450723;00000','J;SSSSS'),TO_DATE('2450703;00000','J;SSSSS'),2,4.41,'Reggiani Caseifici','Strada Provinciale 124','Reggio Emilia',NULL,'42100','Italy');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('GREAL',6,TO_DATE('2450696;00000','J;SSSSS'),TO_DATE('2450724;00000','J;SSSSS'),TO_DATE('2450702;00000','J;SSSSS'),1,57.15,'Great Lakes Food Market','2732 Baker Blvd.','Eugene','OR','97403','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SAVEA',2,TO_DATE('2450696;00000','J;SSSSS'),TO_DATE('2450724;00000','J;SSSSS'),TO_DATE('2450707;00000','J;SSSSS'),2,352.69,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUICK',4,TO_DATE('2450697;00000','J;SSSSS'),TO_DATE('2450725;00000','J;SSSSS'),TO_DATE('2450700;00000','J;SSSSS'),1,364.15,'QUICK-Stop','Taucherstraße 10','Cunewalde',NULL,'01307','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUEEN',7,TO_DATE('2450697;00000','J;SSSSS'),TO_DATE('2450725;00000','J;SSSSS'),TO_DATE('2450702;00000','J;SSSSS'),2,105.81,'Queen Cozinha','Alameda dos Canàrios, 891','Sao Paulo','SP','05487-020','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HUNGC',8,TO_DATE('2450700;00000','J;SSSSS'),TO_DATE('2450728;00000','J;SSSSS'),TO_DATE('2450737;00000','J;SSSSS'),1,111.29,'Hungry Coyote Import Store','City Center Plaza'||CHR(13)||CHR(10)||'516 Main St.','Elgin','OR','97827','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HUNGO',7,TO_DATE('2450701;00000','J;SSSSS'),TO_DATE('2450729;00000','J;SSSSS'),TO_DATE('2450707;00000','J;SSSSS'),3,17.55,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LONEP',3,TO_DATE('2450701;00000','J;SSSSS'),TO_DATE('2450729;00000','J;SSSSS'),TO_DATE('2450710;00000','J;SSSSS'),2,1.28,'Lonesome Pine Restaurant','89 Chiaroscuro Rd.','Portland','OR','97219','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BONAP',2,TO_DATE('2450702;00000','J;SSSSS'),TO_DATE('2450716;00000','J;SSSSS'),TO_DATE('2450725;00000','J;SSSSS'),2,113.15,'Bon app''','12, rue des Bouchers','Marseille',NULL,'13008','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FURIB',1,TO_DATE('2450702;00000','J;SSSSS'),TO_DATE('2450730;00000','J;SSSSS'),TO_DATE('2450711;00000','J;SSSSS'),3,1.27,'Furia Bacalhau e Frutos do Mar','Jardim das rosas n. 32','Lisboa',NULL,'1675','Portugal');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LONEP',1,TO_DATE('2450703;00000','J;SSSSS'),TO_DATE('2450731;00000','J;SSSSS'),TO_DATE('2450709;00000','J;SSSSS'),2,26.31,'Lonesome Pine Restaurant','89 Chiaroscuro Rd.','Portland','OR','97219','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RICSU',7,TO_DATE('2450704;00000','J;SSSSS'),TO_DATE('2450732;00000','J;SSSSS'),TO_DATE('2450714;00000','J;SSSSS'),2,232.42,'Richter Supermarkt','Starenweg 5','Genève',NULL,'1204','Switzerland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ERNSH',7,TO_DATE('2450704;00000','J;SSSSS'),TO_DATE('2450732;00000','J;SSSSS'),TO_DATE('2450711;00000','J;SSSSS'),1,78.09,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WANDK',1,TO_DATE('2450707;00000','J;SSSSS'),TO_DATE('2450735;00000','J;SSSSS'),TO_DATE('2450715;00000','J;SSSSS'),2,47.22,'Die Wandernde Kuh','Adenauerallee 900','Stuttgart',NULL,'70563','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SIMOB',2,TO_DATE('2450707;00000','J;SSSSS'),TO_DATE('2450735;00000','J;SSSSS'),TO_DATE('2450714;00000','J;SSSSS'),1,24.39,'Simons bistro','Vinbæltet 34','Kobenhavn',NULL,'1734','Denmark');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FRANK',4,TO_DATE('2450708;00000','J;SSSSS'),TO_DATE('2450736;00000','J;SSSSS'),TO_DATE('2450710;00000','J;SSSSS'),1,203.48,'Frankenversand','Berliner Platz 43','München',NULL,'80805','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FRANR',1,TO_DATE('2450709;00000','J;SSSSS'),TO_DATE('2450737;00000','J;SSSSS'),TO_DATE('2450716;00000','J;SSSSS'),1,30.34,'France restauration','54, rue Royale','Nantes',NULL,'44000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BERGS',9,TO_DATE('2450709;00000','J;SSSSS'),TO_DATE('2450723;00000','J;SSSSS'),TO_DATE('2450718;00000','J;SSSSS'),2,95.75,'Berglunds snabbköp','Berguvsvägen  8','Luleå',NULL,'S-958 22','Sweden');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WILMK',2,TO_DATE('2450710;00000','J;SSSSS'),TO_DATE('2450738;00000','J;SSSSS'),TO_DATE('2450711;00000','J;SSSSS'),1,22.76,'Wilman Kala','Keskuskatu 45','Helsinki',NULL,'21240','Finland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ISLAT',4,TO_DATE('2450710;00000','J;SSSSS'),TO_DATE('2450738;00000','J;SSSSS'),TO_DATE('2450722;00000','J;SSSSS'),2,.9,'Island Trading','Garden House'||CHR(13)||CHR(10)||'Crowther Way','Cowes','Isle of Wight','PO31 7PJ','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FRANK',5,TO_DATE('2450711;00000','J;SSSSS'),TO_DATE('2450739;00000','J;SSSSS'),TO_DATE('2450715;00000','J;SSSSS'),2,31.85,'Frankenversand','Berliner Platz 43','München',NULL,'80805','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('TORTU',2,TO_DATE('2450714;00000','J;SSSSS'),TO_DATE('2450742;00000','J;SSSSS'),TO_DATE('2450721;00000','J;SSSSS'),2,2.01,'Tortuga Restaurante','Avda. Azteca 123','México D.F.',NULL,'05033','Mexico');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ANTON',1,TO_DATE('2450714;00000','J;SSSSS'),TO_DATE('2450742;00000','J;SSSSS'),TO_DATE('2450718;00000','J;SSSSS'),3,4.03,'Antonio Moreno Taquería','Mataderos  2312','México D.F.',NULL,'05023','Mexico');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SAVEA',7,TO_DATE('2450715;00000','J;SSSSS'),TO_DATE('2450743;00000','J;SSSSS'),TO_DATE('2450738;00000','J;SSSSS'),3,388.98,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BLONP',8,TO_DATE('2450715;00000','J;SSSSS'),TO_DATE('2450743;00000','J;SSSSS'),TO_DATE('2450722;00000','J;SSSSS'),3,27.94,'Blondel père et fils','24, place Kléber','Strasbourg',NULL,'67000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('OLDWO',1,TO_DATE('2450716;00000','J;SSSSS'),TO_DATE('2450744;00000','J;SSSSS'),TO_DATE('2450718;00000','J;SSSSS'),1,26.61,'Old World Delicatessen','2743 Bering St.','Anchorage','AK','99508','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('GREAL',3,TO_DATE('2450717;00000','J;SSSSS'),TO_DATE('2450745;00000','J;SSSSS'),TO_DATE('2450722;00000','J;SSSSS'),3,76.13,'Great Lakes Food Market','2732 Baker Blvd.','Eugene','OR','97403','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ANTON',3,TO_DATE('2450717;00000','J;SSSSS'),TO_DATE('2450745;00000','J;SSSSS'),TO_DATE('2450723;00000','J;SSSSS'),2,36.13,'Antonio Moreno Taquería','Mataderos  2312','México D.F.',NULL,'05023','Mexico');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('DUMON',2,TO_DATE('2450718;00000','J;SSSSS'),TO_DATE('2450746;00000','J;SSSSS'),TO_DATE('2450723;00000','J;SSSSS'),1,4.4,'Du monde entier','67, rue des Cinquante Otages','Nantes',NULL,'44000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('OTTIK',3,TO_DATE('2450718;00000','J;SSSSS'),TO_DATE('2450746;00000','J;SSSSS'),TO_DATE('2450722;00000','J;SSSSS'),1,145.63,'Ottilies Käseladen','Mehrheimerstr. 369','Köln',NULL,'50739','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('GOURL',4,TO_DATE('2450721;00000','J;SSSSS'),TO_DATE('2450735;00000','J;SSSSS'),TO_DATE('2450725;00000','J;SSSSS'),2,33.75,'Gourmet Lanchonetes','Av. Brasil, 442','Campinas','SP','04876-786','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('PICCO',2,TO_DATE('2450722;00000','J;SSSSS'),TO_DATE('2450750;00000','J;SSSSS'),TO_DATE('2450730;00000','J;SSSSS'),1,96.5,'Piccolo und mehr','Geislweg 14','Salzburg',NULL,'5020','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HUNGO',9,TO_DATE('2450722;00000','J;SSSSS'),TO_DATE('2450750;00000','J;SSSSS'),TO_DATE('2450752;00000','J;SSSSS'),2,296.43,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('VAFFE',4,TO_DATE('2450723;00000','J;SSSSS'),TO_DATE('2450737;00000','J;SSSSS'),TO_DATE('2450729;00000','J;SSSSS'),2,299.09,'Vaffeljernet','Smagsloget 45','Århus',NULL,'8200','Denmark');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BERGS',1,TO_DATE('2450723;00000','J;SSSSS'),TO_DATE('2450751;00000','J;SSSSS'),TO_DATE('2450729;00000','J;SSSSS'),2,13.42,'Berglunds snabbköp','Berguvsvägen  8','Luleå',NULL,'S-958 22','Sweden');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HANAR',1,TO_DATE('2450724;00000','J;SSSSS'),TO_DATE('2450752;00000','J;SSSSS'),TO_DATE('2450725;00000','J;SSSSS'),1,15.8,'Hanari Carnes','Rua do Paço, 67','Rio de Janeiro','RJ','05454-876','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUICK',2,TO_DATE('2450725;00000','J;SSSSS'),TO_DATE('2450767;00000','J;SSSSS'),TO_DATE('2450744;00000','J;SSSSS'),2,810.05,'QUICK-Stop','Taucherstraße 10','Cunewalde',NULL,'01307','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ALFKI',4,TO_DATE('2450725;00000','J;SSSSS'),TO_DATE('2450753;00000','J;SSSSS'),TO_DATE('2450735;00000','J;SSSSS'),2,61.02,'Alfreds Futterkiste','Obere Str. 57','Berlin',NULL,'12209','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WHITC',3,TO_DATE('2450728;00000','J;SSSSS'),TO_DATE('2450742;00000','J;SSSSS'),TO_DATE('2450732;00000','J;SSSSS'),3,139.34,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUICK',8,TO_DATE('2450728;00000','J;SSSSS'),TO_DATE('2450756;00000','J;SSSSS'),TO_DATE('2450731;00000','J;SSSSS'),3,398.36,'QUICK-Stop','Taucherstraße 10','Cunewalde',NULL,'01307','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WILMK',7,TO_DATE('2450729;00000','J;SSSSS'),TO_DATE('2450771;00000','J;SSSSS'),TO_DATE('2450736;00000','J;SSSSS'),1,16.72,'Wilman Kala','Keskuskatu 45','Helsinki',NULL,'21240','Finland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WHITC',8,TO_DATE('2450730;00000','J;SSSSS'),TO_DATE('2450772;00000','J;SSSSS'),TO_DATE('2450736;00000','J;SSSSS'),3,102.55,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LINOD',3,TO_DATE('2450730;00000','J;SSSSS'),TO_DATE('2450758;00000','J;SSSSS'),TO_DATE('2450736;00000','J;SSSSS'),1,45.52,'LINO-Delicateses','Ave. 5 de Mayo Porlamar','I. de Margarita','Nueva Esparta','4980','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ERNSH',4,TO_DATE('2450731;00000','J;SSSSS'),TO_DATE('2450759;00000','J;SSSSS'),TO_DATE('2450739;00000','J;SSSSS'),1,272.47,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('MORGK',3,TO_DATE('2450731;00000','J;SSSSS'),TO_DATE('2450759;00000','J;SSSSS'),TO_DATE('2450735;00000','J;SSSSS'),3,.58,'Morgenstern Gesundkost','Heerstr. 22','Leipzig',NULL,'04179','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SAVEA',3,TO_DATE('2450732;00000','J;SSSSS'),TO_DATE('2450760;00000','J;SSSSS'),TO_DATE('2450738;00000','J;SSSSS'),1,65.1,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HUNGO',6,TO_DATE('2450735;00000','J;SSSSS'),TO_DATE('2450749;00000','J;SSSSS'),TO_DATE('2450737;00000','J;SSSSS'),3,220.31,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ALFKI',4,TO_DATE('2450735;00000','J;SSSSS'),TO_DATE('2450777;00000','J;SSSSS'),TO_DATE('2450743;00000','J;SSSSS'),1,23.94,'Alfreds Futterkiste','Obere Str. 57','Berlin',NULL,'12209','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FOLKO',6,TO_DATE('2450736;00000','J;SSSSS'),TO_DATE('2450764;00000','J;SSSSS'),TO_DATE('2450742;00000','J;SSSSS'),2,152.3,'Folk och fä HB','Åkergatan 24','Bräcke',NULL,'S-844 67','Sweden');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUEEN',6,TO_DATE('2450736;00000','J;SSSSS'),TO_DATE('2450764;00000','J;SSSSS'),TO_DATE('2450760;00000','J;SSSSS'),1,4.78,'Queen Cozinha','Alameda dos Canàrios, 891','Sao Paulo','SP','05487-020','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HILAA',9,TO_DATE('2450737;00000','J;SSSSS'),TO_DATE('2450765;00000','J;SSSSS'),TO_DATE('2450771;00000','J;SSSSS'),2,3.52,'HILARION-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Cristóbal','Táchira','5022','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('OLDWO',8,TO_DATE('2450738;00000','J;SSSSS'),TO_DATE('2450766;00000','J;SSSSS'),TO_DATE('2450743;00000','J;SSSSS'),3,135.63,'Old World Delicatessen','2743 Bering St.','Anchorage','AK','99508','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('AROUT',4,TO_DATE('2450738;00000','J;SSSSS'),TO_DATE('2450752;00000','J;SSSSS'),TO_DATE('2450745;00000','J;SSSSS'),3,21.74,'Around the Horn','Brook Farm'||CHR(13)||CHR(10)||'Stratford St. Mary','Colchester','Essex','CO7 6JX','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('THEBI',6,TO_DATE('2450739;00000','J;SSSSS'),TO_DATE('2450781;00000','J;SSSSS'),TO_DATE('2450758;00000','J;SSSSS'),2,2.96,'The Big Cheese','89 Jefferson Way'||CHR(13)||CHR(10)||'Suite 2','Portland','OR','97201','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('GOURL',1,TO_DATE('2450739;00000','J;SSSSS'),TO_DATE('2450767;00000','J;SSSSS'),TO_DATE('2450773;00000','J;SSSSS'),3,210.8,'Gourmet Lanchonetes','Av. Brasil, 442','Campinas','SP','04876-786','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FRANS',1,TO_DATE('2450742;00000','J;SSSSS'),TO_DATE('2450770;00000','J;SSSSS'),TO_DATE('2450745;00000','J;SSSSS'),1,4.98,'Franchi S.p.A.','Via Monte Bianco 34','Torino',NULL,'10100','Italy');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SAVEA',5,TO_DATE('2450743;00000','J;SSSSS'),TO_DATE('2450785;00000','J;SSSSS'),TO_DATE('2450751;00000','J;SSSSS'),2,52.41,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HUNGO',3,TO_DATE('2450743;00000','J;SSSSS'),TO_DATE('2450771;00000','J;SSSSS'),TO_DATE('2450753;00000','J;SSSSS'),1,89.93,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SAVEA',1,TO_DATE('2450744;00000','J;SSSSS'),TO_DATE('2450772;00000','J;SSSSS'),TO_DATE('2450746;00000','J;SSSSS'),1,167.05,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SAVEA',5,TO_DATE('2450744;00000','J;SSSSS'),TO_DATE('2450772;00000','J;SSSSS'),TO_DATE('2450749;00000','J;SSSSS'),3,24.49,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BONAP',3,TO_DATE('2450745;00000','J;SSSSS'),TO_DATE('2450759;00000','J;SSSSS'),TO_DATE('2450751;00000','J;SSSSS'),1,63.2,'Bon app''','12, rue des Bouchers','Marseille',NULL,'13008','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RANCH',4,TO_DATE('2450746;00000','J;SSSSS'),TO_DATE('2450774;00000','J;SSSSS'),TO_DATE('2450749;00000','J;SSSSS'),2,22.57,'Rancho grande','Av. del Libertador 900','Buenos Aires',NULL,'1010','Argentina');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FRANK',1,TO_DATE('2450746;00000','J;SSSSS'),TO_DATE('2450774;00000','J;SSSSS'),TO_DATE('2450751;00000','J;SSSSS'),2,59.25,'Frankenversand','Berliner Platz 43','München',NULL,'80805','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('KOENE',1,TO_DATE('2450749;00000','J;SSSSS'),TO_DATE('2450777;00000','J;SSSSS'),TO_DATE('2450751;00000','J;SSSSS'),3,170.88,'Königlich Essen','Maubelstr. 90','Brandenburg',NULL,'14776','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LETSS',8,TO_DATE('2450749;00000','J;SSSSS'),TO_DATE('2450777;00000','J;SSSSS'),TO_DATE('2450758;00000','J;SSSSS'),2,51.44,'Let''s Stop N Shop','87 Polk St.'||CHR(13)||CHR(10)||'Suite 5','San Francisco','CA','94117','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUEDE',8,TO_DATE('2450750;00000','J;SSSSS'),TO_DATE('2450764;00000','J;SSSSS'),TO_DATE('2450758;00000','J;SSSSS'),2,9.53,'Que Delícia','Rua da Panificadora, 12','Rio de Janeiro','RJ','02389-673','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUICK',5,TO_DATE('2450751;00000','J;SSSSS'),TO_DATE('2450779;00000','J;SSSSS'),TO_DATE('2450753;00000','J;SSSSS'),3,48.92,'QUICK-Stop','Taucherstraße 10','Cunewalde',NULL,'01307','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SAVEA',8,TO_DATE('2450751;00000','J;SSSSS'),TO_DATE('2450793;00000','J;SSSSS'),TO_DATE('2450757;00000','J;SSSSS'),1,74.58,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WHITC',3,TO_DATE('2450752;00000','J;SSSSS'),TO_DATE('2450780;00000','J;SSSSS'),TO_DATE('2450778;00000','J;SSSSS'),1,21.72,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('MEREP',8,TO_DATE('2450752;00000','J;SSSSS'),TO_DATE('2450794;00000','J;SSSSS'),TO_DATE('2450758;00000','J;SSSSS'),2,57.75,'Mère Paillarde','43 rue St. Laurent','Montréal','Québec','H1J 1C3','Canada');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FAMIA',4,TO_DATE('2450753;00000','J;SSSSS'),TO_DATE('2450781;00000','J;SSSSS'),TO_DATE('2450758;00000','J;SSSSS'),3,10.83,'Familia Arquibaldo','Rua Orós, 92','Sao Paulo','SP','05442-030','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('EASTC',4,TO_DATE('2450756;00000','J;SSSSS'),TO_DATE('2450770;00000','J;SSSSS'),TO_DATE('2450788;00000','J;SSSSS'),1,16.56,'Eastern Connection','35 King George','London',NULL,'WX3 6FW','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('REGGC',2,TO_DATE('2450756;00000','J;SSSSS'),TO_DATE('2450784;00000','J;SSSSS'),TO_DATE('2450788;00000','J;SSSSS'),1,89.9,'Reggiani Caseifici','Strada Provinciale 124','Reggio Emilia',NULL,'42100','Italy');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUEEN',4,TO_DATE('2450757;00000','J;SSSSS'),TO_DATE('2450785;00000','J;SSSSS'),TO_DATE('2450764;00000','J;SSSSS'),2,58.33,'Queen Cozinha','Alameda dos Canàrios, 891','Sao Paulo','SP','05487-020','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LINOD',8,TO_DATE('2450757;00000','J;SSSSS'),TO_DATE('2450799;00000','J;SSSSS'),TO_DATE('2450767;00000','J;SSSSS'),3,141.06,'LINO-Delicateses','Ave. 5 de Mayo Porlamar','I. de Margarita','Nueva Esparta','4980','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BONAP',5,TO_DATE('2450758;00000','J;SSSSS'),TO_DATE('2450786;00000','J;SSSSS'),TO_DATE('2450767;00000','J;SSSSS'),1,20.12,'Bon app''','12, rue des Bouchers','Marseille',NULL,'13008','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('CHOPS',7,TO_DATE('2450759;00000','J;SSSSS'),TO_DATE('2450787;00000','J;SSSSS'),TO_DATE('2450767;00000','J;SSSSS'),1,96.65,'Chop-suey Chinese','Hauptstr. 31','Bern',NULL,'3012','Switzerland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BONAP',3,TO_DATE('2450759;00000','J;SSSSS'),TO_DATE('2450787;00000','J;SSSSS'),TO_DATE('2450760;00000','J;SSSSS'),1,16.97,'Bon app''','12, rue des Bouchers','Marseille',NULL,'13008','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BERGS',1,TO_DATE('2450760;00000','J;SSSSS'),TO_DATE('2450788;00000','J;SSSSS'),TO_DATE('2450763;00000','J;SSSSS'),3,110.11,'Berglunds snabbköp','Berguvsvägen  8','Luleå',NULL,'S-958 22','Sweden');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('GOURL',2,TO_DATE('2450760;00000','J;SSSSS'),TO_DATE('2450788;00000','J;SSSSS'),TO_DATE('2450765;00000','J;SSSSS'),3,1.63,'Gourmet Lanchonetes','Av. Brasil, 442','Campinas','SP','04876-786','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LETSS',6,TO_DATE('2450763;00000','J;SSSSS'),TO_DATE('2450791;00000','J;SSSSS'),TO_DATE('2450774;00000','J;SSSSS'),2,45.97,'Let''s Stop N Shop','87 Polk St.'||CHR(13)||CHR(10)||'Suite 5','San Francisco','CA','94117','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HUNGO',9,TO_DATE('2450764;00000','J;SSSSS'),TO_DATE('2450792;00000','J;SSSSS'),TO_DATE('2450774;00000','J;SSSSS'),2,44.1,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('VINET',2,TO_DATE('2450764;00000','J;SSSSS'),TO_DATE('2450792;00000','J;SSSSS'),TO_DATE('2450771;00000','J;SSSSS'),2,7.79,'Vins et alcools Chevalier','59 rue de l''Abbaye','Reims',NULL,'51100','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SPECD',2,TO_DATE('2450765;00000','J;SSSSS'),TO_DATE('2450793;00000','J;SSSSS'),TO_DATE('2450771;00000','J;SSSSS'),1,2.91,'spécialités du monde','25, rue Lauriston','Paris',NULL,'75016','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('VINET',3,TO_DATE('2450765;00000','J;SSSSS'),TO_DATE('2450793;00000','J;SSSSS'),TO_DATE('2450770;00000','J;SSSSS'),3,11.08,'Vins et alcools Chevalier','59 rue de l''Abbaye','Reims',NULL,'51100','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WHITC',4,TO_DATE('2450766;00000','J;SSSSS'),TO_DATE('2450794;00000','J;SSSSS'),TO_DATE('2450778;00000','J;SSSSS'),2,81.88,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('AROUT',4,TO_DATE('2450767;00000','J;SSSSS'),TO_DATE('2450781;00000','J;SSSSS'),TO_DATE('2450771;00000','J;SSSSS'),3,10.96,'Around the Horn','Brook Farm'||CHR(13)||CHR(10)||'Stratford St. Mary','Colchester','Essex','CO7 6JX','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BOTTM',3,TO_DATE('2450767;00000','J;SSSSS'),TO_DATE('2450795;00000','J;SSSSS'),TO_DATE('2450771;00000','J;SSSSS'),3,243.73,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('AROUT',1,TO_DATE('2450770;00000','J;SSSSS'),TO_DATE('2450798;00000','J;SSSSS'),TO_DATE('2450774;00000','J;SSSSS'),2,23.72,'Around the Horn','Brook Farm'||CHR(13)||CHR(10)||'Stratford St. Mary','Colchester','Essex','CO7 6JX','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('VAFFE',6,TO_DATE('2450770;00000','J;SSSSS'),TO_DATE('2450798;00000','J;SSSSS'),TO_DATE('2450777;00000','J;SSSSS'),1,69.19,'Vaffeljernet','Smagsloget 45','Århus',NULL,'8200','Denmark');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUICK',9,TO_DATE('2450771;00000','J;SSSSS'),TO_DATE('2450799;00000','J;SSSSS'),TO_DATE('2450780;00000','J;SSSSS'),1,3.52,'QUICK-Stop','Taucherstraße 10','Cunewalde',NULL,'01307','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('CHOPS',1,TO_DATE('2450772;00000','J;SSSSS'),TO_DATE('2450800;00000','J;SSSSS'),TO_DATE('2450774;00000','J;SSSSS'),3,31.43,'Chop-suey Chinese','Hauptstr. 31','Bern',NULL,'3012','Switzerland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('PICCO',6,TO_DATE('2450772;00000','J;SSSSS'),TO_DATE('2450800;00000','J;SSSSS'),TO_DATE('2450779;00000','J;SSSSS'),1,117.33,'Piccolo und mehr','Geislweg 14','Salzburg',NULL,'5020','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SAVEA',3,TO_DATE('2450773;00000','J;SSSSS'),TO_DATE('2450801;00000','J;SSSSS'),TO_DATE('2450781;00000','J;SSSSS'),1,232.55,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ISLAT',4,TO_DATE('2450773;00000','J;SSSSS'),TO_DATE('2450801;00000','J;SSSSS'),TO_DATE('2450802;00000','J;SSSSS'),2,61.53,'Island Trading','Garden House'||CHR(13)||CHR(10)||'Crowther Way','Cowes','Isle of Wight','PO31 7PJ','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WARTH',9,TO_DATE('2450774;00000','J;SSSSS'),TO_DATE('2450802;00000','J;SSSSS'),TO_DATE('2450777;00000','J;SSSSS'),1,79.3,'Wartian Herkku','Torikatu 38','Oulu',NULL,'90110','Finland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RICSU',3,TO_DATE('2450777;00000','J;SSSSS'),TO_DATE('2450805;00000','J;SSSSS'),TO_DATE('2450786;00000','J;SSSSS'),3,130.79,'Richter Supermarkt','Starenweg 5','Genève',NULL,'1204','Switzerland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('NORTS',2,TO_DATE('2450777;00000','J;SSSSS'),TO_DATE('2450805;00000','J;SSSSS'),TO_DATE('2450781;00000','J;SSSSS'),3,1.39,'North/South','South House'||CHR(13)||CHR(10)||'300 Queensbridge','London',NULL,'SW7 1RZ','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FRANS',3,TO_DATE('2450778;00000','J;SSSSS'),TO_DATE('2450806;00000','J;SSSSS'),TO_DATE('2450780;00000','J;SSSSS'),1,7.7,'Franchi S.p.A.','Via Monte Bianco 34','Torino',NULL,'10100','Italy');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('MAGAA',6,TO_DATE('2450778;00000','J;SSSSS'),TO_DATE('2450806;00000','J;SSSSS'),TO_DATE('2450780;00000','J;SSSSS'),3,2.38,'Magazzini Alimentari Riuniti','Via Ludovico il Moro 22','Bergamo',NULL,'24100','Italy');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BONAP',4,TO_DATE('2450779;00000','J;SSSSS'),TO_DATE('2450807;00000','J;SSSSS'),TO_DATE('2450781;00000','J;SSSSS'),2,16.71,'Bon app''','12, rue des Bouchers','Marseille',NULL,'13008','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SPLIR',8,TO_DATE('2450780;00000','J;SSSSS'),TO_DATE('2450808;00000','J;SSSSS'),TO_DATE('2450785;00000','J;SSSSS'),2,73.21,'Split Rail Beer '||Chr(38)||' Ale','P.O. Box 555','Lander','WY','82520','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SAVEA',6,TO_DATE('2450780;00000','J;SSSSS'),TO_DATE('2450808;00000','J;SSSSS'),TO_DATE('2450798;00000','J;SSSSS'),1,8.19,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RICSU',3,TO_DATE('2450781;00000','J;SSSSS'),TO_DATE('2450809;00000','J;SSSSS'),TO_DATE('2450787;00000','J;SSSSS'),3,138.17,'Richter Supermarkt','Starenweg 5','Genève',NULL,'1204','Switzerland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ANATR',3,TO_DATE('2450781;00000','J;SSSSS'),TO_DATE('2450809;00000','J;SSSSS'),TO_DATE('2450795;00000','J;SSSSS'),3,11.99,'Ana Trujillo Emparedados y helados','Avda. de la Constitución 2222','México D.F.',NULL,'05021','Mexico');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('MAISD',4,TO_DATE('2450784;00000','J;SSSSS'),TO_DATE('2450812;00000','J;SSSSS'),TO_DATE('2450793;00000','J;SSSSS'),1,155.64,'Maison Dewey','Rue Joseph-Bens 532','Bruxelles',NULL,'B-1180','Belgium');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RATTC',5,TO_DATE('2450785;00000','J;SSSSS'),TO_DATE('2450813;00000','J;SSSSS'),TO_DATE('2450791;00000','J;SSSSS'),2,18.66,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FOLKO',3,TO_DATE('2450785;00000','J;SSSSS'),TO_DATE('2450813;00000','J;SSSSS'),TO_DATE('2450792;00000','J;SSSSS'),1,328.74,'Folk och fä HB','Åkergatan 24','Bräcke',NULL,'S-844 67','Sweden');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FOLIG',3,TO_DATE('2450786;00000','J;SSSSS'),TO_DATE('2450814;00000','J;SSSSS'),TO_DATE('2450791;00000','J;SSSSS'),3,37.35,'Folies gourmandes','184, chaussée de Tournai','Lille',NULL,'59000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ERNSH',6,TO_DATE('2450786;00000','J;SSSSS'),TO_DATE('2450814;00000','J;SSSSS'),TO_DATE('2450791;00000','J;SSSSS'),3,145.45,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUICK',3,TO_DATE('2450787;00000','J;SSSSS'),TO_DATE('2450815;00000','J;SSSSS'),TO_DATE('2450792;00000','J;SSSSS'),3,42.74,'QUICK-Stop','Taucherstraße 10','Cunewalde',NULL,'01307','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('OTTIK',4,TO_DATE('2450788;00000','J;SSSSS'),TO_DATE('2450816;00000','J;SSSSS'),TO_DATE('2450792;00000','J;SSSSS'),1,157.55,'Ottilies Käseladen','Mehrheimerstr. 369','Köln',NULL,'50739','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SUPRD',4,TO_DATE('2450788;00000','J;SSSSS'),TO_DATE('2450816;00000','J;SSSSS'),TO_DATE('2450798;00000','J;SSSSS'),3,1.59,'Suprêmes délices','Boulevard Tirou, 255','Charleroi',NULL,'B-6000','Belgium');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('AROUT',3,TO_DATE('2450791;00000','J;SSSSS'),TO_DATE('2450819;00000','J;SSSSS'),TO_DATE('2450798;00000','J;SSSSS'),2,146.32,'Around the Horn','Brook Farm'||CHR(13)||CHR(10)||'Stratford St. Mary','Colchester','Essex','CO7 6JX','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('VAFFE',3,TO_DATE('2450791;00000','J;SSSSS'),TO_DATE('2450819;00000','J;SSSSS'),TO_DATE('2450795;00000','J;SSSSS'),1,65.06,'Vaffeljernet','Smagsloget 45','Århus',NULL,'8200','Denmark');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HANAR',8,TO_DATE('2450792;00000','J;SSSSS'),TO_DATE('2450820;00000','J;SSSSS'),TO_DATE('2450800;00000','J;SSSSS'),3,5.32,'Hanari Carnes','Rua do Paço, 67','Rio de Janeiro','RJ','05454-876','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ERNSH',9,TO_DATE('2450793;00000','J;SSSSS'),TO_DATE('2450821;00000','J;SSSSS'),TO_DATE('2450816;00000','J;SSSSS'),2,11.19,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LEHMS',3,TO_DATE('2450793;00000','J;SSSSS'),TO_DATE('2450821;00000','J;SSSSS'),TO_DATE('2450802;00000','J;SSSSS'),2,91.28,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M. ',NULL,'60528','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ERNSH',1,TO_DATE('2450794;00000','J;SSSSS'),TO_DATE('2450822;00000','J;SSSSS'),TO_DATE('2450799;00000','J;SSSSS'),3,96.43,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FOLKO',4,TO_DATE('2450794;00000','J;SSSSS'),TO_DATE('2450808;00000','J;SSSSS'),TO_DATE('2450795;00000','J;SSSSS'),1,48.2,'Folk och fä HB','Åkergatan 24','Bräcke',NULL,'S-844 67','Sweden');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('THECR',7,TO_DATE('2450795;00000','J;SSSSS'),TO_DATE('2450823;00000','J;SSSSS'),TO_DATE('2450809;00000','J;SSSSS'),1,20.25,'The Cracker Box','55 Grizzly Peak Rd.','Butte','MT','59801','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ERNSH',1,TO_DATE('2450798;00000','J;SSSSS'),TO_DATE('2450826;00000','J;SSSSS'),TO_DATE('2450801;00000','J;SSSSS'),3,351.53,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('GOURL',7,TO_DATE('2450798;00000','J;SSSSS'),TO_DATE('2450812;00000','J;SSSSS'),TO_DATE('2450835;00000','J;SSSSS'),2,3.01,'Gourmet Lanchonetes','Av. Brasil, 442','Campinas','SP','04876-786','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BERGS',3,TO_DATE('2450799;00000','J;SSSSS'),TO_DATE('2450827;00000','J;SSSSS'),TO_DATE('2450807;00000','J;SSSSS'),1,6.79,'Berglunds snabbköp','Berguvsvägen  8','Luleå',NULL,'S-958 22','Sweden');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('MORGK',3,TO_DATE('2450799;00000','J;SSSSS'),TO_DATE('2450827;00000','J;SSSSS'),TO_DATE('2450828;00000','J;SSSSS'),2,58.13,'Morgenstern Gesundkost','Heerstr. 22','Leipzig',NULL,'04179','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LILAS',2,TO_DATE('2450799;00000','J;SSSSS'),TO_DATE('2450813;00000','J;SSSSS'),TO_DATE('2450808;00000','J;SSSSS'),1,42.13,'LILA-Supermercado','Carrera 52 con Ave. Bolívar #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WARTH',2,TO_DATE('2450800;00000','J;SSSSS'),TO_DATE('2450828;00000','J;SSSSS'),TO_DATE('2450802;00000','J;SSSSS'),3,73.16,'Wartian Herkku','Torikatu 38','Oulu',NULL,'90110','Finland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('CACTU',9,TO_DATE('2450800;00000','J;SSSSS'),TO_DATE('2450828;00000','J;SSSSS'),TO_DATE('2450805;00000','J;SSSSS'),3,1.1,'Cactus Comidas para llevar','Cerrito 333','Buenos Aires',NULL,'1010','Argentina');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HANAR',4,TO_DATE('2450801;00000','J;SSSSS'),TO_DATE('2450829;00000','J;SSSSS'),TO_DATE('2450802;00000','J;SSSSS'),2,124.98,'Hanari Carnes','Rua do Paço, 67','Rio de Janeiro','RJ','05454-876','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('MAGAA',4,TO_DATE('2450801;00000','J;SSSSS'),TO_DATE('2450829;00000','J;SSSSS'),TO_DATE('2450805;00000','J;SSSSS'),3,70.09,'Magazzini Alimentari Riuniti','Via Ludovico il Moro 22','Bergamo',NULL,'24100','Italy');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('GROSR',1,TO_DATE('2450801;00000','J;SSSSS'),TO_DATE('2450829;00000','J;SSSSS'),TO_DATE('2450807;00000','J;SSSSS'),3,1.51,'GROSELLA-Restaurante','5ª Ave. Los Palos Grandes','Caracas','DF','1081','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUEEN',8,TO_DATE('2450802;00000','J;SSSSS'),TO_DATE('2450830;00000','J;SSSSS'),TO_DATE('2450806;00000','J;SSSSS'),1,110.87,'Queen Cozinha','Alameda dos Canàrios, 891','Sao Paulo','SP','05487-020','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LAMAI',2,TO_DATE('2450802;00000','J;SSSSS'),TO_DATE('2450816;00000','J;SSSSS'),TO_DATE('2450809;00000','J;SSSSS'),1,249.93,'La maison d''Asie','1 rue Alsace-Lorraine','Toulouse',NULL,'31000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUICK',1,TO_DATE('2450805;00000','J;SSSSS'),TO_DATE('2450833;00000','J;SSSSS'),TO_DATE('2450833;00000','J;SSSSS'),2,42.7,'QUICK-Stop','Taucherstraße 10','Cunewalde',NULL,'01307','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FOLIG',1,TO_DATE('2450805;00000','J;SSSSS'),TO_DATE('2450833;00000','J;SSSSS'),TO_DATE('2450814;00000','J;SSSSS'),2,100.6,'Folies gourmandes','184, chaussée de Tournai','Lille',NULL,'59000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('GOURL',6,TO_DATE('2450805;00000','J;SSSSS'),TO_DATE('2450833;00000','J;SSSSS'),TO_DATE('2450809;00000','J;SSSSS'),1,28.23,'Gourmet Lanchonetes','Av. Brasil, 442','Campinas','SP','04876-786','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FRANK',6,TO_DATE('2450806;00000','J;SSSSS'),TO_DATE('2450834;00000','J;SSSSS'),TO_DATE('2450815;00000','J;SSSSS'),2,16.85,'Frankenversand','Berliner Platz 43','München',NULL,'80805','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WOLZA',1,TO_DATE('2450806;00000','J;SSSSS'),TO_DATE('2450834;00000','J;SSSSS'),TO_DATE('2450814;00000','J;SSSSS'),3,23.79,'Wolski Zajazd','ul. Filtrowa 68','Warszawa',NULL,'01-012','Poland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('AROUT',3,TO_DATE('2450807;00000','J;SSSSS'),TO_DATE('2450835;00000','J;SSSSS'),TO_DATE('2450822;00000','J;SSSSS'),3,4.52,'Around the Horn','Brook Farm'||CHR(13)||CHR(10)||'Stratford St. Mary','Colchester','Essex','CO7 6JX','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUEDE',6,TO_DATE('2450807;00000','J;SSSSS'),TO_DATE('2450835;00000','J;SSSSS'),TO_DATE('2450816;00000','J;SSSSS'),1,21.49,'Que Delícia','Rua da Panificadora, 12','Rio de Janeiro','RJ','02389-673','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ERNSH',8,TO_DATE('2450807;00000','J;SSSSS'),TO_DATE('2450835;00000','J;SSSSS'),TO_DATE('2450834;00000','J;SSSSS'),2,126.66,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HILAA',3,TO_DATE('2450808;00000','J;SSSSS'),TO_DATE('2450836;00000','J;SSSSS'),TO_DATE('2450828;00000','J;SSSSS'),1,26.52,'HILARION-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Cristóbal','Táchira','5022','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('DRACD',7,TO_DATE('2450808;00000','J;SSSSS'),TO_DATE('2450836;00000','J;SSSSS'),TO_DATE('2450819;00000','J;SSSSS'),2,33.35,'Drachenblut Delikatessen','Walserweg 21','Aachen',NULL,'52066','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ISLAT',2,TO_DATE('2450809;00000','J;SSSSS'),TO_DATE('2450837;00000','J;SSSSS'),TO_DATE('2450819;00000','J;SSSSS'),1,2.33,'Island Trading','Garden House'||CHR(13)||CHR(10)||'Crowther Way','Cowes','Isle of Wight','PO31 7PJ','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('KOENE',9,TO_DATE('2450809;00000','J;SSSSS'),TO_DATE('2450851;00000','J;SSSSS'),TO_DATE('2450819;00000','J;SSSSS'),3,30.76,'Königlich Essen','Maubelstr. 90','Brandenburg',NULL,'14776','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SEVES',1,TO_DATE('2450809;00000','J;SSSSS'),TO_DATE('2450837;00000','J;SSSSS'),TO_DATE('2450819;00000','J;SSSSS'),3,137.44,'Seven Seas Imports','90 Wadhurst Rd.','London',NULL,'OX15 4NB','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BOLID',4,TO_DATE('2450812;00000','J;SSSSS'),TO_DATE('2450840;00000','J;SSSSS'),TO_DATE('2450814;00000','J;SSSSS'),2,97.09,'Bólido Comidas preparadas','C/ Araquil, 67','Madrid',NULL,'28023','Spain');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SIMOB',4,TO_DATE('2450812;00000','J;SSSSS'),TO_DATE('2450840;00000','J;SSSSS'),TO_DATE('2450816;00000','J;SSSSS'),2,257.26,'Simons bistro','Vinbæltet 34','Kobenhavn',NULL,'1734','Denmark');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WELLI',4,TO_DATE('2450813;00000','J;SSSSS'),TO_DATE('2450841;00000','J;SSSSS'),TO_DATE('2450820;00000','J;SSSSS'),1,55.23,'Wellington Importadora','Rua do Mercado, 12','Resende','SP','08737-363','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SEVES',6,TO_DATE('2450813;00000','J;SSSSS'),TO_DATE('2450841;00000','J;SSSSS'),TO_DATE('2450821;00000','J;SSSSS'),2,27.33,'Seven Seas Imports','90 Wadhurst Rd.','London',NULL,'OX15 4NB','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('THEBI',2,TO_DATE('2450813;00000','J;SSSSS'),TO_DATE('2450841;00000','J;SSSSS'),TO_DATE('2450823;00000','J;SSSSS'),3,237.34,'The Big Cheese','89 Jefferson Way'||CHR(13)||CHR(10)||'Suite 2','Portland','OR','97201','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('VICTE',3,TO_DATE('2450814;00000','J;SSSSS'),TO_DATE('2450842;00000','J;SSSSS'),TO_DATE('2450819;00000','J;SSSSS'),2,22.11,'Victuailles en stock','2, rue du Commerce','Lyon',NULL,'69004','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FRANS',4,TO_DATE('2450814;00000','J;SSSSS'),TO_DATE('2450842;00000','J;SSSSS'),TO_DATE('2450844;00000','J;SSSSS'),1,1.36,'Franchi S.p.A.','Via Monte Bianco 34','Torino',NULL,'10100','Italy');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('PRINI',2,TO_DATE('2450815;00000','J;SSSSS'),TO_DATE('2450843;00000','J;SSSSS'),TO_DATE('2450823;00000','J;SSSSS'),3,45.53,'Old World Delicatessen','2743 Bering St.','Anchorage','AK','99508','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WELLI',7,TO_DATE('2450815;00000','J;SSSSS'),TO_DATE('2450843;00000','J;SSSSS'),TO_DATE('2450821;00000','J;SSSSS'),1,4.87,'Wellington Importadora','Rua do Mercado, 12','Resende','SP','08737-363','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LAUGB',2,TO_DATE('2450815;00000','J;SSSSS'),TO_DATE('2450843;00000','J;SSSSS'),TO_DATE('2450821;00000','J;SSSSS'),3,4.33,'Laughing Bacchus Wine Cellars','2319 Elm St.','Vancouver','BC','V3F 2K1','Canada');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LINOD',8,TO_DATE('2450816;00000','J;SSSSS'),TO_DATE('2450844;00000','J;SSSSS'),TO_DATE('2450822;00000','J;SSSSS'),1,31.22,'LINO-Delicateses','Ave. 5 de Mayo Porlamar','I. de Margarita','Nueva Esparta','4980','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('REGGC',5,TO_DATE('2450816;00000','J;SSSSS'),TO_DATE('2450844;00000','J;SSSSS'),TO_DATE('2450826;00000','J;SSSSS'),1,59.78,'Reggiani Caseifici','Strada Provinciale 124','Reggio Emilia',NULL,'42100','Italy');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RICAR',1,TO_DATE('2450819;00000','J;SSSSS'),TO_DATE('2450847;00000','J;SSSSS'),TO_DATE('2450823;00000','J;SSSSS'),1,47.38,'Ricardo Adocicados','Av. Copacabana, 267','Rio de Janeiro','RJ','02389-890','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('VICTE',3,TO_DATE('2450819;00000','J;SSSSS'),TO_DATE('2450847;00000','J;SSSSS'),TO_DATE('2450828;00000','J;SSSSS'),3,130.94,'Victuailles en stock','2, rue du Commerce','Lyon',NULL,'69004','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SAVEA',2,TO_DATE('2450819;00000','J;SSSSS'),TO_DATE('2450847;00000','J;SSSSS'),TO_DATE('2450828;00000','J;SSSSS'),3,14.62,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('GREAL',4,TO_DATE('2450820;00000','J;SSSSS'),TO_DATE('2450848;00000','J;SSSSS'),TO_DATE('2450849;00000','J;SSSSS'),2,719.78,'Great Lakes Food Market','2732 Baker Blvd.','Eugene','OR','97403','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('KOENE',3,TO_DATE('2450820;00000','J;SSSSS'),TO_DATE('2450834;00000','J;SSSSS'),TO_DATE('2450827;00000','J;SSSSS'),2,306.07,'Königlich Essen','Maubelstr. 90','Brandenburg',NULL,'14776','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('MAGAA',7,TO_DATE('2450821;00000','J;SSSSS'),TO_DATE('2450849;00000','J;SSSSS'),TO_DATE('2450826;00000','J;SSSSS'),3,65.48,'Magazzini Alimentari Riuniti','Via Ludovico il Moro 22','Bergamo',NULL,'24100','Italy');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('CACTU',2,TO_DATE('2450821;00000','J;SSSSS'),TO_DATE('2450849;00000','J;SSSSS'),TO_DATE('2450830;00000','J;SSSSS'),3,19.76,'Cactus Comidas para llevar','Cerrito 333','Buenos Aires',NULL,'1010','Argentina');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RATTC',3,TO_DATE('2450821;00000','J;SSSSS'),TO_DATE('2450849;00000','J;SSSSS'),TO_DATE('2450827;00000','J;SSSSS'),2,37.52,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SPLIR',1,TO_DATE('2450822;00000','J;SSSSS'),TO_DATE('2450850;00000','J;SSSSS'),TO_DATE('2450829;00000','J;SSSSS'),1,36.68,'Split Rail Beer '||Chr(38)||' Ale','P.O. Box 555','Lander','WY','82520','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('TRAIH',6,TO_DATE('2450822;00000','J;SSSSS'),TO_DATE('2450850;00000','J;SSSSS'),TO_DATE('2450830;00000','J;SSSSS'),3,7,'Trail''s Head Gourmet Provisioners','722 DaVinci Blvd.','Kirkland','WA','98034','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LILAS',5,TO_DATE('2450823;00000','J;SSSSS'),TO_DATE('2450851;00000','J;SSSSS'),TO_DATE('2450827;00000','J;SSSSS'),2,163.97,'LILA-Supermercado','Carrera 52 con Ave. Bolívar #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FOLKO',8,TO_DATE('2450823;00000','J;SSSSS'),TO_DATE('2450851;00000','J;SSSSS'),TO_DATE('2450844;00000','J;SSSSS'),1,1.23,'Folk och fä HB','Åkergatan 24','Bräcke',NULL,'S-844 67','Sweden');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('DRACD',1,TO_DATE('2450823;00000','J;SSSSS'),TO_DATE('2450851;00000','J;SSSSS'),TO_DATE('2450828;00000','J;SSSSS'),1,79.25,'Drachenblut Delikatessen','Walserweg 21','Aachen',NULL,'52066','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BLONP',6,TO_DATE('2450826;00000','J;SSSSS'),TO_DATE('2450854;00000','J;SSSSS'),TO_DATE('2450851;00000','J;SSSSS'),1,7.09,'Blondel père et fils','24, place Kléber','Strasbourg',NULL,'67000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BONAP',1,TO_DATE('2450826;00000','J;SSSSS'),TO_DATE('2450840;00000','J;SSSSS'),TO_DATE('2450851;00000','J;SSSSS'),2,63.54,'Bon app''','12, rue des Bouchers','Marseille',NULL,'13008','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RANCH',9,TO_DATE('2450827;00000','J;SSSSS'),TO_DATE('2450841;00000','J;SSSSS'),TO_DATE('2450849;00000','J;SSSSS'),1,90.85,'Rancho grande','Av. del Libertador 900','Buenos Aires',NULL,'1010','Argentina');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ISLAT',9,TO_DATE('2450827;00000','J;SSSSS'),TO_DATE('2450855;00000','J;SSSSS'),TO_DATE('2450837;00000','J;SSSSS'),1,154.72,'Island Trading','Garden House'||CHR(13)||CHR(10)||'Crowther Way','Cowes','Isle of Wight','PO31 7PJ','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('TRADH',4,TO_DATE('2450827;00000','J;SSSSS'),TO_DATE('2450869;00000','J;SSSSS'),TO_DATE('2450835;00000','J;SSSSS'),2,81.83,'Tradiçao Hipermercados','Av. Inês de Castro, 414','Sao Paulo','SP','05634-030','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SANTG',3,TO_DATE('2450828;00000','J;SSSSS'),TO_DATE('2450856;00000','J;SSSSS'),TO_DATE('2450837;00000','J;SSSSS'),2,72.19,'Santé Gourmet','Erling Skakkes gate 78','Stavern',NULL,'4110','Norway');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LAMAI',2,TO_DATE('2450828;00000','J;SSSSS'),TO_DATE('2450856;00000','J;SSSSS'),TO_DATE('2450833;00000','J;SSSSS'),2,43.26,'La maison d''Asie','1 rue Alsace-Lorraine','Toulouse',NULL,'31000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('OTTIK',6,TO_DATE('2450829;00000','J;SSSSS'),TO_DATE('2450857;00000','J;SSSSS'),TO_DATE('2450837;00000','J;SSSSS'),2,71.49,'Ottilies Käseladen','Mehrheimerstr. 369','Köln',NULL,'50739','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('TRADH',1,TO_DATE('2450829;00000','J;SSSSS'),TO_DATE('2450857;00000','J;SSSSS'),TO_DATE('2450833;00000','J;SSSSS'),3,29.78,'Tradiçao Hipermercados','Av. Inês de Castro, 414','Sao Paulo','SP','05634-030','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ALFKI',1,TO_DATE('2450829;00000','J;SSSSS'),TO_DATE('2450857;00000','J;SSSSS'),TO_DATE('2450835;00000','J;SSSSS'),3,69.53,'Alfreds Futterkiste','Obere Str. 57','Berlin',NULL,'12209','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ERNSH',7,TO_DATE('2450830;00000','J;SSSSS'),TO_DATE('2450858;00000','J;SSSSS'),TO_DATE('2450835;00000','J;SSSSS'),1,411.88,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BERGS',9,TO_DATE('2450830;00000','J;SSSSS'),TO_DATE('2450858;00000','J;SSSSS'),TO_DATE('2450837;00000','J;SSSSS'),3,13.32,'Berglunds snabbköp','Berguvsvägen  8','Luleå',NULL,'S-958 22','Sweden');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LINOD',3,TO_DATE('2450833;00000','J;SSSSS'),TO_DATE('2450861;00000','J;SSSSS'),TO_DATE('2450837;00000','J;SSSSS'),3,59.28,'LINO-Delicateses','Ave. 5 de Mayo Porlamar','I. de Margarita','Nueva Esparta','4980','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('TRADH',3,TO_DATE('2450833;00000','J;SSSSS'),TO_DATE('2450861;00000','J;SSSSS'),TO_DATE('2450836;00000','J;SSSSS'),3,35.43,'Tradiçao Hipermercados','Av. Inês de Castro, 414','Sao Paulo','SP','05634-030','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LINOD',4,TO_DATE('2450833;00000','J;SSSSS'),TO_DATE('2450875;00000','J;SSSSS'),TO_DATE('2450861;00000','J;SSSSS'),2,2.71,'LINO-Delicateses','Ave. 5 de Mayo Porlamar','I. de Margarita','Nueva Esparta','4980','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SUPRD',5,TO_DATE('2450834;00000','J;SSSSS'),TO_DATE('2450862;00000','J;SSSSS'),TO_DATE('2450843;00000','J;SSSSS'),2,424.3,'Suprêmes délices','Boulevard Tirou, 255','Charleroi',NULL,'B-6000','Belgium');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('TORTU',1,TO_DATE('2450834;00000','J;SSSSS'),TO_DATE('2450862;00000','J;SSSSS'),TO_DATE('2450843;00000','J;SSSSS'),3,54.42,'Tortuga Restaurante','Avda. Azteca 123','México D.F.',NULL,'05033','Mexico');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('VICTE',4,TO_DATE('2450835;00000','J;SSSSS'),TO_DATE('2450863;00000','J;SSSSS'),TO_DATE('2450840;00000','J;SSSSS'),2,9.26,'Victuailles en stock','2, rue du Commerce','Lyon',NULL,'69004','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('PICCO',8,TO_DATE('2450835;00000','J;SSSSS'),TO_DATE('2450863;00000','J;SSSSS'),TO_DATE('2450840;00000','J;SSSSS'),2,25.22,'Piccolo und mehr','Geislweg 14','Salzburg',NULL,'5020','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUICK',8,TO_DATE('2450835;00000','J;SSSSS'),TO_DATE('2450849;00000','J;SSSSS'),TO_DATE('2450844;00000','J;SSSSS'),1,212.98,'QUICK-Stop','Taucherstraße 10','Cunewalde',NULL,'01307','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SUPRD',2,TO_DATE('2450836;00000','J;SSSSS'),TO_DATE('2450878;00000','J;SSSSS'),TO_DATE('2450837;00000','J;SSSSS'),3,56.46,'Suprêmes délices','Boulevard Tirou, 255','Charleroi',NULL,'B-6000','Belgium');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SAVEA',4,TO_DATE('2450836;00000','J;SSSSS'),TO_DATE('2450850;00000','J;SSSSS'),TO_DATE('2450855;00000','J;SSSSS'),3,487.57,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('CONSH',7,TO_DATE('2450837;00000','J;SSSSS'),TO_DATE('2450865;00000','J;SSSSS'),TO_DATE('2450843;00000','J;SSSSS'),2,38.24,'Consolidated Holdings','Berkeley Gardens'||CHR(13)||CHR(10)||'12  Brewery ','London',NULL,'WX1 6LT','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('KOENE',9,TO_DATE('2450837;00000','J;SSSSS'),TO_DATE('2450865;00000','J;SSSSS'),TO_DATE('2450844;00000','J;SSSSS'),2,.56,'Königlich Essen','Maubelstr. 90','Brandenburg',NULL,'14776','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('VICTE',1,TO_DATE('2450837;00000','J;SSSSS'),TO_DATE('2450879;00000','J;SSSSS'),TO_DATE('2450844;00000','J;SSSSS'),1,49.19,'Victuailles en stock','2, rue du Commerce','Lyon',NULL,'69004','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RICAR',5,TO_DATE('2450840;00000','J;SSSSS'),TO_DATE('2450868;00000','J;SSSSS'),TO_DATE('2450847;00000','J;SSSSS'),1,160.55,'Ricardo Adocicados','Av. Copacabana, 267','Rio de Janeiro','RJ','02389-890','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RATTC',8,TO_DATE('2450840;00000','J;SSSSS'),TO_DATE('2450854;00000','J;SSSSS'),TO_DATE('2450844;00000','J;SSSSS'),1,174.05,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BLAUS',9,TO_DATE('2450841;00000','J;SSSSS'),TO_DATE('2450869;00000','J;SSSSS'),TO_DATE('2450848;00000','J;SSSSS'),2,53.83,'Blauer See Delikatessen','Forsterstr. 57','Mannheim',NULL,'68306','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ERNSH',3,TO_DATE('2450841;00000','J;SSSSS'),TO_DATE('2450869;00000','J;SSSSS'),TO_DATE('2450850;00000','J;SSSSS'),2,100.22,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('OLDWO',3,TO_DATE('2450841;00000','J;SSSSS'),TO_DATE('2450869;00000','J;SSSSS'),TO_DATE('2450849;00000','J;SSSSS'),1,170.97,'Old World Delicatessen','2743 Bering St.','Anchorage','AK','99508','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ANTON',3,TO_DATE('2450842;00000','J;SSSSS'),TO_DATE('2450870;00000','J;SSSSS'),TO_DATE('2450855;00000','J;SSSSS'),2,58.43,'Antonio Moreno Taquería','Mataderos  2312','México D.F.',NULL,'05023','Mexico');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BERGS',8,TO_DATE('2450842;00000','J;SSSSS'),TO_DATE('2450870;00000','J;SSSSS'),TO_DATE('2450851;00000','J;SSSSS'),2,188.85,'Berglunds snabbköp','Berguvsvägen  8','Luleå',NULL,'S-958 22','Sweden');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LACOR',2,TO_DATE('2450843;00000','J;SSSSS'),TO_DATE('2450871;00000','J;SSSSS'),TO_DATE('2450848;00000','J;SSSSS'),1,52.51,'La corne d''abondance','67, avenue de l''Europe','Versailles',NULL,'78000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FRANK',1,TO_DATE('2450843;00000','J;SSSSS'),TO_DATE('2450871;00000','J;SSSSS'),TO_DATE('2450847;00000','J;SSSSS'),2,76.1,'Frankenversand','Berliner Platz 43','München',NULL,'80805','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FRANR',3,TO_DATE('2450843;00000','J;SSSSS'),TO_DATE('2450871;00000','J;SSSSS'),TO_DATE('2450849;00000','J;SSSSS'),3,19.26,'France restauration','54, rue Royale','Nantes',NULL,'44000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WHITC',4,TO_DATE('2450844;00000','J;SSSSS'),TO_DATE('2450872;00000','J;SSSSS'),TO_DATE('2450862;00000','J;SSSSS'),2,14.93,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LEHMS',8,TO_DATE('2450844;00000','J;SSSSS'),TO_DATE('2450886;00000','J;SSSSS'),TO_DATE('2450847;00000','J;SSSSS'),2,53.23,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M. ',NULL,'60528','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HILAA',4,TO_DATE('2450847;00000','J;SSSSS'),TO_DATE('2450875;00000','J;SSSSS'),TO_DATE('2450862;00000','J;SSSSS'),2,30.26,'HILARION-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Cristóbal','Táchira','5022','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('AROUT',4,TO_DATE('2450847;00000','J;SSSSS'),TO_DATE('2450875;00000','J;SSSSS'),TO_DATE('2450854;00000','J;SSSSS'),2,3.04,'Around the Horn','Brook Farm'||CHR(13)||CHR(10)||'Stratford St. Mary','Colchester','Essex','CO7 6JX','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUICK',2,TO_DATE('2450847;00000','J;SSSSS'),TO_DATE('2450861;00000','J;SSSSS'),TO_DATE('2450857;00000','J;SSSSS'),1,348.14,'QUICK-Stop','Taucherstraße 10','Cunewalde',NULL,'01307','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BERGS',5,TO_DATE('2450848;00000','J;SSSSS'),TO_DATE('2450876;00000','J;SSSSS'),TO_DATE('2450857;00000','J;SSSSS'),1,109.11,'Berglunds snabbköp','Berguvsvägen  8','Luleå',NULL,'S-958 22','Sweden');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LONEP',6,TO_DATE('2450848;00000','J;SSSSS'),TO_DATE('2450890;00000','J;SSSSS'),TO_DATE('2450856;00000','J;SSSSS'),1,1.93,'Lonesome Pine Restaurant','89 Chiaroscuro Rd.','Portland','OR','97219','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUEEN',7,TO_DATE('2450849;00000','J;SSSSS'),TO_DATE('2450877;00000','J;SSSSS'),TO_DATE('2450868;00000','J;SSSSS'),2,191.27,'Queen Cozinha','Alameda dos Canàrios, 891','Sao Paulo','SP','05487-020','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SEVES',5,TO_DATE('2450849;00000','J;SSSSS'),TO_DATE('2450877;00000','J;SSSSS'),TO_DATE('2450854;00000','J;SSSSS'),1,143.28,'Seven Seas Imports','90 Wadhurst Rd.','London',NULL,'OX15 4NB','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WOLZA',5,TO_DATE('2450849;00000','J;SSSSS'),TO_DATE('2450877;00000','J;SSSSS'),TO_DATE('2450858;00000','J;SSSSS'),3,12.04,'Wolski Zajazd','ul. Filtrowa 68','Warszawa',NULL,'01-012','Poland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BONAP',9,TO_DATE('2450850;00000','J;SSSSS'),TO_DATE('2450878;00000','J;SSSSS'),TO_DATE('2450855;00000','J;SSSSS'),2,112.27,'Bon app''','12, rue des Bouchers','Marseille',NULL,'13008','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('GODOS',5,TO_DATE('2450850;00000','J;SSSSS'),TO_DATE('2450878;00000','J;SSSSS'),TO_DATE('2450854;00000','J;SSSSS'),2,175.32,'Godos Cocina Típica','C/ Romero, 33','Sevilla',NULL,'41101','Spain');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WILMK',4,TO_DATE('2450851;00000','J;SSSSS'),TO_DATE('2450879;00000','J;SSSSS'),TO_DATE('2450854;00000','J;SSSSS'),1,.82,'Wilman Kala','Keskuskatu 45','Helsinki',NULL,'21240','Finland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('GODOS',5,TO_DATE('2450851;00000','J;SSSSS'),TO_DATE('2450879;00000','J;SSSSS'),TO_DATE('2450856;00000','J;SSSSS'),2,19.58,'Godos Cocina Típica','C/ Romero, 33','Sevilla',NULL,'41101','Spain');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BERGS',4,TO_DATE('2450851;00000','J;SSSSS'),TO_DATE('2450879;00000','J;SSSSS'),TO_DATE('2450876;00000','J;SSSSS'),2,32.37,'Berglunds snabbköp','Berguvsvägen  8','Luleå',NULL,'S-958 22','Sweden');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BONAP',7,TO_DATE('2450854;00000','J;SSSSS'),TO_DATE('2450882;00000','J;SSSSS'),TO_DATE('2450857;00000','J;SSSSS'),3,60.42,'Bon app''','12, rue des Bouchers','Marseille',NULL,'13008','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RICAR',1,TO_DATE('2450854;00000','J;SSSSS'),TO_DATE('2450882;00000','J;SSSSS'),TO_DATE('2450864;00000','J;SSSSS'),1,38.06,'Ricardo Adocicados','Av. Copacabana, 267','Rio de Janeiro','RJ','02389-890','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUICK',4,TO_DATE('2450855;00000','J;SSSSS'),TO_DATE('2450883;00000','J;SSSSS'),TO_DATE('2450857;00000','J;SSSSS'),1,46.69,'QUICK-Stop','Taucherstraße 10','Cunewalde',NULL,'01307','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WILMK',3,TO_DATE('2450855;00000','J;SSSSS'),TO_DATE('2450883;00000','J;SSSSS'),TO_DATE('2450857;00000','J;SSSSS'),3,8.5,'Wilman Kala','Keskuskatu 45','Helsinki',NULL,'21240','Finland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FOLKO',7,TO_DATE('2450855;00000','J;SSSSS'),TO_DATE('2450897;00000','J;SSSSS'),TO_DATE('2450863;00000','J;SSSSS'),1,88.01,'Folk och fä HB','Åkergatan 24','Bräcke',NULL,'S-844 67','Sweden');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('CACTU',4,TO_DATE('2450856;00000','J;SSSSS'),TO_DATE('2450884;00000','J;SSSSS'),TO_DATE('2450863;00000','J;SSSSS'),1,2.84,'Cactus Comidas para llevar','Cerrito 333','Buenos Aires',NULL,'1010','Argentina');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SAVEA',4,TO_DATE('2450856;00000','J;SSSSS'),TO_DATE('2450884;00000','J;SSSSS'),TO_DATE('2450865;00000','J;SSSSS'),3,23.1,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LONEP',8,TO_DATE('2450857;00000','J;SSSSS'),TO_DATE('2450885;00000','J;SSSSS'),TO_DATE('2450865;00000','J;SSSSS'),3,.53,'Lonesome Pine Restaurant','89 Chiaroscuro Rd.','Portland','OR','97219','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LETSS',4,TO_DATE('2450857;00000','J;SSSSS'),TO_DATE('2450885;00000','J;SSSSS'),TO_DATE('2450858;00000','J;SSSSS'),2,90.97,'Let''s Stop N Shop','87 Polk St.'||CHR(13)||CHR(10)||'Suite 5','San Francisco','CA','94117','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SUPRD',6,TO_DATE('2450857;00000','J;SSSSS'),TO_DATE('2450885;00000','J;SSSSS'),TO_DATE('2450863;00000','J;SSSSS'),3,5.64,'Suprêmes délices','Boulevard Tirou, 255','Charleroi',NULL,'B-6000','Belgium');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HANAR',1,TO_DATE('2450858;00000','J;SSSSS'),TO_DATE('2450886;00000','J;SSSSS'),TO_DATE('2450875;00000','J;SSSSS'),1,4.99,'Hanari Carnes','Rua do Paço, 67','Rio de Janeiro','RJ','05454-876','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('GALED',8,TO_DATE('2450858;00000','J;SSSSS'),TO_DATE('2450886;00000','J;SSSSS'),TO_DATE('2450861;00000','J;SSSSS'),3,1.25,'Galería del gastronómo','Rambla de Cataluña, 23','Barcelona',NULL,'8022','Spain');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('GODOS',1,TO_DATE('2450861;00000','J;SSSSS'),TO_DATE('2450889;00000','J;SSSSS'),TO_DATE('2450868;00000','J;SSSSS'),2,51.87,'Godos Cocina Típica','C/ Romero, 33','Sevilla',NULL,'41101','Spain');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RATTC',9,TO_DATE('2450861;00000','J;SSSSS'),TO_DATE('2450889;00000','J;SSSSS'),TO_DATE('2450868;00000','J;SSSSS'),3,280.61,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('DUMON',7,TO_DATE('2450861;00000','J;SSSSS'),TO_DATE('2450889;00000','J;SSSSS'),TO_DATE('2450863;00000','J;SSSSS'),1,32.76,'Du monde entier','67, rue des Cinquante Otages','Nantes',NULL,'44000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LEHMS',7,TO_DATE('2450862;00000','J;SSSSS'),TO_DATE('2450890;00000','J;SSSSS'),TO_DATE('2450864;00000','J;SSSSS'),2,20.37,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M. ',NULL,'60528','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('MAISD',4,TO_DATE('2450862;00000','J;SSSSS'),TO_DATE('2450890;00000','J;SSSSS'),TO_DATE('2450864;00000','J;SSSSS'),2,120.27,'Maison Dewey','Rue Joseph-Bens 532','Bruxelles',NULL,'B-1180','Belgium');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('KOENE',9,TO_DATE('2450863;00000','J;SSSSS'),TO_DATE('2450891;00000','J;SSSSS'),TO_DATE('2450865;00000','J;SSSSS'),2,77.78,'Königlich Essen','Maubelstr. 90','Brandenburg',NULL,'14776','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SAVEA',1,TO_DATE('2450863;00000','J;SSSSS'),TO_DATE('2450891;00000','J;SSSSS'),TO_DATE('2450865;00000','J;SSSSS'),1,116.13,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ERNSH',3,TO_DATE('2450863;00000','J;SSSSS'),TO_DATE('2450891;00000','J;SSSSS'),TO_DATE('2450868;00000','J;SSSSS'),1,162.75,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('MAISD',7,TO_DATE('2450864;00000','J;SSSSS'),TO_DATE('2450892;00000','J;SSSSS'),TO_DATE('2450872;00000','J;SSSSS'),3,32.45,'Maison Dewey','Rue Joseph-Bens 532','Bruxelles',NULL,'B-1180','Belgium');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HUNGO',3,TO_DATE('2450864;00000','J;SSSSS'),TO_DATE('2450892;00000','J;SSSSS'),TO_DATE('2450870;00000','J;SSSSS'),2,603.54,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('OCEAN',4,TO_DATE('2450865;00000','J;SSSSS'),TO_DATE('2450893;00000','J;SSSSS'),TO_DATE('2450879;00000','J;SSSSS'),2,1.27,'Océano Atlántico Ltda.','Ing. Gustavo Moncada 8585'||CHR(13)||CHR(10)||'Piso 20-A','Buenos Aires',NULL,'1010','Argentina');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LILAS',5,TO_DATE('2450865;00000','J;SSSSS'),TO_DATE('2450893;00000','J;SSSSS'),TO_DATE('2450871;00000','J;SSSSS'),3,1.21,'LILA-Supermercado','Carrera 52 con Ave. Bolívar #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WELLI',1,TO_DATE('2450865;00000','J;SSSSS'),TO_DATE('2450893;00000','J;SSSSS'),TO_DATE('2450877;00000','J;SSSSS'),2,1.66,'Wellington Importadora','Rua do Mercado, 12','Resende','SP','08737-363','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HILAA',4,TO_DATE('2450868;00000','J;SSSSS'),TO_DATE('2450896;00000','J;SSSSS'),TO_DATE('2450871;00000','J;SSSSS'),1,62.09,'HILARION-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Cristóbal','Táchira','5022','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FOLKO',1,TO_DATE('2450868;00000','J;SSSSS'),TO_DATE('2450896;00000','J;SSSSS'),TO_DATE('2450876;00000','J;SSSSS'),1,44.15,'Folk och fä HB','Åkergatan 24','Bräcke',NULL,'S-844 67','Sweden');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HANAR',3,TO_DATE('2450869;00000','J;SSSSS'),TO_DATE('2450897;00000','J;SSSSS'),TO_DATE('2450877;00000','J;SSSSS'),3,36.71,'Hanari Carnes','Rua do Paço, 67','Rio de Janeiro','RJ','05454-876','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WHITC',3,TO_DATE('2450869;00000','J;SSSSS'),TO_DATE('2450897;00000','J;SSSSS'),TO_DATE('2450872;00000','J;SSSSS'),3,162.95,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WELLI',9,TO_DATE('2450869;00000','J;SSSSS'),TO_DATE('2450897;00000','J;SSSSS'),TO_DATE('2450879;00000','J;SSSSS'),2,13.72,'Wellington Importadora','Rua do Mercado, 12','Resende','SP','08737-363','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WOLZA',4,TO_DATE('2450870;00000','J;SSSSS'),TO_DATE('2450884;00000','J;SSSSS'),TO_DATE('2450876;00000','J;SSSSS'),3,26.29,'Wolski Zajazd','ul. Filtrowa 68','Warszawa',NULL,'01-012','Poland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SPECD',6,TO_DATE('2450870;00000','J;SSSSS'),TO_DATE('2450898;00000','J;SSSSS'),TO_DATE('2450872;00000','J;SSSSS'),3,9.19,'spécialités du monde','25, rue Lauriston','Paris',NULL,'75016','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('REGGC',4,TO_DATE('2450871;00000','J;SSSSS'),TO_DATE('2450899;00000','J;SSSSS'),TO_DATE('2450879;00000','J;SSSSS'),2,32.96,'Reggiani Caseifici','Strada Provinciale 124','Reggio Emilia',NULL,'42100','Italy');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SANTG',1,TO_DATE('2450871;00000','J;SSSSS'),TO_DATE('2450899;00000','J;SSSSS'),TO_DATE('2450883;00000','J;SSSSS'),2,53.05,'Santé Gourmet','Erling Skakkes gate 78','Stavern',NULL,'4110','Norway');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WILMK',1,TO_DATE('2450871;00000','J;SSSSS'),TO_DATE('2450899;00000','J;SSSSS'),TO_DATE('2450877;00000','J;SSSSS'),3,38.11,'Wilman Kala','Keskuskatu 45','Helsinki',NULL,'21240','Finland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('GODOS',3,TO_DATE('2450871;00000','J;SSSSS'),TO_DATE('2450899;00000','J;SSSSS'),TO_DATE('2450878;00000','J;SSSSS'),1,38.19,'Godos Cocina Típica','C/ Romero, 33','Sevilla',NULL,'41101','Spain');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HUNGO',2,TO_DATE('2450871;00000','J;SSSSS'),TO_DATE('2450899;00000','J;SSSSS'),TO_DATE('2450891;00000','J;SSSSS'),2,580.91,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUEEN',4,TO_DATE('2450871;00000','J;SSSSS'),TO_DATE('2450899;00000','J;SSSSS'),TO_DATE('2450877;00000','J;SSSSS'),1,33.05,'Queen Cozinha','Alameda dos Canàrios, 891','Sao Paulo','SP','05487-020','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUEEN',6,TO_DATE('2450872;00000','J;SSSSS'),TO_DATE('2450900;00000','J;SSSSS'),TO_DATE('2450875;00000','J;SSSSS'),1,21.19,'Queen Cozinha','Alameda dos Canàrios, 891','Sao Paulo','SP','05487-020','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('TORTU',2,TO_DATE('2450872;00000','J;SSSSS'),TO_DATE('2450900;00000','J;SSSSS'),TO_DATE('2450875;00000','J;SSSSS'),2,3.51,'Tortuga Restaurante','Avda. Azteca 123','México D.F.',NULL,'05033','Mexico');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RANCH',1,TO_DATE('2450872;00000','J;SSSSS'),TO_DATE('2450900;00000','J;SSSSS'),TO_DATE('2450882;00000','J;SSSSS'),2,63.77,'Rancho grande','Av. del Libertador 900','Buenos Aires',NULL,'1010','Argentina');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ROMEY',4,TO_DATE('2450875;00000','J;SSSSS'),TO_DATE('2450903;00000','J;SSSSS'),TO_DATE('2450884;00000','J;SSSSS'),2,8.29,'Romero y tomillo','Gran Vía, 1','Madrid',NULL,'28001','Spain');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BOTTM',3,TO_DATE('2450875;00000','J;SSSSS'),TO_DATE('2450903;00000','J;SSSSS'),TO_DATE('2450884;00000','J;SSSSS'),3,48.83,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LINOD',2,TO_DATE('2450875;00000','J;SSSSS'),TO_DATE('2450903;00000','J;SSSSS'),TO_DATE('2450877;00000','J;SSSSS'),2,19.8,'LINO-Delicateses','Ave. 5 de Mayo Porlamar','I. de Margarita','Nueva Esparta','4980','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('AROUT',4,TO_DATE('2450876;00000','J;SSSSS'),TO_DATE('2450904;00000','J;SSSSS'),TO_DATE('2450882;00000','J;SSSSS'),2,29.61,'Around the Horn','Brook Farm'||CHR(13)||CHR(10)||'Stratford St. Mary','Colchester','Essex','CO7 6JX','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('VAFFE',1,TO_DATE('2450876;00000','J;SSSSS'),TO_DATE('2450918;00000','J;SSSSS'),TO_DATE('2450882;00000','J;SSSSS'),1,176.48,'Vaffeljernet','Smagsloget 45','Århus',NULL,'8200','Denmark');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HANAR',5,TO_DATE('2450876;00000','J;SSSSS'),TO_DATE('2450904;00000','J;SSSSS'),TO_DATE('2450878;00000','J;SSSSS'),3,62.74,'Hanari Carnes','Rua do Paço, 67','Rio de Janeiro','RJ','05454-876','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LAMAI',7,TO_DATE('2450876;00000','J;SSSSS'),TO_DATE('2450918;00000','J;SSSSS'),TO_DATE('2450886;00000','J;SSSSS'),3,68.26,'La maison d''Asie','1 rue Alsace-Lorraine','Toulouse',NULL,'31000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BERGS',3,TO_DATE('2450877;00000','J;SSSSS'),TO_DATE('2450905;00000','J;SSSSS'),TO_DATE('2450912;00000','J;SSSSS'),2,151.52,'Berglunds snabbköp','Berguvsvägen  8','Luleå',NULL,'S-958 22','Sweden');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HANAR',3,TO_DATE('2450877;00000','J;SSSSS'),TO_DATE('2450905;00000','J;SSSSS'),TO_DATE('2450886;00000','J;SSSSS'),1,2.27,'Hanari Carnes','Rua do Paço, 67','Rio de Janeiro','RJ','05454-876','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ANATR',4,TO_DATE('2450877;00000','J;SSSSS'),TO_DATE('2450905;00000','J;SSSSS'),TO_DATE('2450884;00000','J;SSSSS'),3,39.92,'Ana Trujillo Emparedados y helados','Avda. de la Constitución 2222','México D.F.',NULL,'05021','Mexico');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LACOR',4,TO_DATE('2450878;00000','J;SSSSS'),TO_DATE('2450906;00000','J;SSSSS'),TO_DATE('2450912;00000','J;SSSSS'),1,19.79,'La corne d''abondance','67, avenue de l''Europe','Versailles',NULL,'78000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('GALED',1,TO_DATE('2450878;00000','J;SSSSS'),TO_DATE('2450906;00000','J;SSSSS'),TO_DATE('2450891;00000','J;SSSSS'),1,1.36,'Galería del gastronómo','Rambla de Cataluña, 23','Barcelona',NULL,'8022','Spain');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FRANK',6,TO_DATE('2450878;00000','J;SSSSS'),TO_DATE('2450906;00000','J;SSSSS'),TO_DATE('2450885;00000','J;SSSSS'),1,33.93,'Frankenversand','Berliner Platz 43','München',NULL,'80805','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SUPRD',4,TO_DATE('2450879;00000','J;SSSSS'),TO_DATE('2450921;00000','J;SSSSS'),TO_DATE('2450891;00000','J;SSSSS'),3,15.55,'Suprêmes délices','Boulevard Tirou, 255','Charleroi',NULL,'B-6000','Belgium');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RICSU',4,TO_DATE('2450879;00000','J;SSSSS'),TO_DATE('2450893;00000','J;SSSSS'),TO_DATE('2450892;00000','J;SSSSS'),2,13.6,'Richter Supermarkt','Starenweg 5','Genève',NULL,'1204','Switzerland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BONAP',8,TO_DATE('2450879;00000','J;SSSSS'),TO_DATE('2450907;00000','J;SSSSS'),TO_DATE('2450897;00000','J;SSSSS'),1,134.64,'Bon app''','12, rue des Bouchers','Marseille',NULL,'13008','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ISLAT',6,TO_DATE('2450879;00000','J;SSSSS'),TO_DATE('2450907;00000','J;SSSSS'),TO_DATE('2450889;00000','J;SSSSS'),3,54.15,'Island Trading','Garden House'||CHR(13)||CHR(10)||'Crowther Way','Cowes','Isle of Wight','PO31 7PJ','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LEHMS',3,TO_DATE('2450882;00000','J;SSSSS'),TO_DATE('2450910;00000','J;SSSSS'),TO_DATE('2450885;00000','J;SSSSS'),3,32.01,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M. ',NULL,'60528','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WELLI',4,TO_DATE('2450882;00000','J;SSSSS'),TO_DATE('2450910;00000','J;SSSSS'),TO_DATE('2450891;00000','J;SSSSS'),3,47.59,'Wellington Importadora','Rua do Mercado, 12','Resende','SP','08737-363','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('GREAL',3,TO_DATE('2450882;00000','J;SSSSS'),TO_DATE('2450910;00000','J;SSSSS'),TO_DATE('2450891;00000','J;SSSSS'),2,33.68,'Great Lakes Food Market','2732 Baker Blvd.','Eugene','OR','97403','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('CACTU',7,TO_DATE('2450883;00000','J;SSSSS'),TO_DATE('2450897;00000','J;SSSSS'),TO_DATE('2450886;00000','J;SSSSS'),3,31.51,'Cactus Comidas para llevar','Cerrito 333','Buenos Aires',NULL,'1010','Argentina');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUICK',3,TO_DATE('2450883;00000','J;SSSSS'),TO_DATE('2450911;00000','J;SSSSS'),TO_DATE('2450889;00000','J;SSSSS'),2,31.89,'QUICK-Stop','Taucherstraße 10','Cunewalde',NULL,'01307','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('MAGAA',2,TO_DATE('2450883;00000','J;SSSSS'),TO_DATE('2450911;00000','J;SSSSS'),TO_DATE('2450886;00000','J;SSSSS'),2,76.33,'Magazzini Alimentari Riuniti','Via Ludovico il Moro 22','Bergamo',NULL,'24100','Italy');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BONAP',8,TO_DATE('2450884;00000','J;SSSSS'),TO_DATE('2450912;00000','J;SSSSS'),TO_DATE('2450896;00000','J;SSSSS'),3,19.77,'Bon app''','12, rue des Bouchers','Marseille',NULL,'13008','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SAVEA',7,TO_DATE('2450884;00000','J;SSSSS'),TO_DATE('2450912;00000','J;SSSSS'),TO_DATE('2450893;00000','J;SSSSS'),2,400.81,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('REGGC',9,TO_DATE('2450884;00000','J;SSSSS'),TO_DATE('2450912;00000','J;SSSSS'),TO_DATE('2450891;00000','J;SSSSS'),3,17.95,'Reggiani Caseifici','Strada Provinciale 124','Reggio Emilia',NULL,'42100','Italy');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BSBEV',4,TO_DATE('2450884;00000','J;SSSSS'),TO_DATE('2450912;00000','J;SSSSS'),TO_DATE('2450892;00000','J;SSSSS'),2,2.17,'B''s Beverages','Fauntleroy Circus','London',NULL,'EC2 5NT','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BOTTM',6,TO_DATE('2450885;00000','J;SSSSS'),TO_DATE('2450899;00000','J;SSSSS'),TO_DATE('2450886;00000','J;SSSSS'),3,52.92,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('MORGK',4,TO_DATE('2450885;00000','J;SSSSS'),TO_DATE('2450913;00000','J;SSSSS'),TO_DATE('2450891;00000','J;SSSSS'),1,10.22,'Morgenstern Gesundkost','Heerstr. 22','Leipzig',NULL,'04179','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('VAFFE',1,TO_DATE('2450885;00000','J;SSSSS'),TO_DATE('2450913;00000','J;SSSSS'),TO_DATE('2450892;00000','J;SSSSS'),2,27.2,'Vaffeljernet','Smagsloget 45','Århus',NULL,'8200','Denmark');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BSBEV',3,TO_DATE('2450886;00000','J;SSSSS'),TO_DATE('2450914;00000','J;SSSSS'),TO_DATE('2450889;00000','J;SSSSS'),2,3.26,'B''s Beverages','Fauntleroy Circus','London',NULL,'EC2 5NT','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('GODOS',3,TO_DATE('2450886;00000','J;SSSSS'),TO_DATE('2450914;00000','J;SSSSS'),TO_DATE('2450892;00000','J;SSSSS'),3,23.39,'Godos Cocina Típica','C/ Romero, 33','Sevilla',NULL,'41101','Spain');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BOTTM',2,TO_DATE('2450886;00000','J;SSSSS'),TO_DATE('2450914;00000','J;SSSSS'),TO_DATE('2450890;00000','J;SSSSS'),3,74.44,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('MAGAA',1,TO_DATE('2450889;00000','J;SSSSS'),TO_DATE('2450917;00000','J;SSSSS'),TO_DATE('2450896;00000','J;SSSSS'),2,2.5,'Magazzini Alimentari Riuniti','Via Ludovico il Moro 22','Bergamo',NULL,'24100','Italy');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RICSU',9,TO_DATE('2450889;00000','J;SSSSS'),TO_DATE('2450931;00000','J;SSSSS'),TO_DATE('2450911;00000','J;SSSSS'),2,30.85,'Richter Supermarkt','Starenweg 5','Genève',NULL,'1204','Switzerland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ALFKI',1,TO_DATE('2450889;00000','J;SSSSS'),TO_DATE('2450931;00000','J;SSSSS'),TO_DATE('2450897;00000','J;SSSSS'),1,40.42,'Alfreds Futterkiste','Obere Str. 57','Berlin',NULL,'12209','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('AROUT',9,TO_DATE('2450889;00000','J;SSSSS'),TO_DATE('2450903;00000','J;SSSSS'),TO_DATE('2450898;00000','J;SSSSS'),2,23.72,'Around the Horn','Brook Farm'||CHR(13)||CHR(10)||'Stratford St. Mary','Colchester','Essex','CO7 6JX','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LINOD',5,TO_DATE('2450890;00000','J;SSSSS'),TO_DATE('2450932;00000','J;SSSSS'),TO_DATE('2450893;00000','J;SSSSS'),1,27.91,'LINO-Delicateses','Ave. 5 de Mayo Porlamar','I. de Margarita','Nueva Esparta','4980','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FOLKO',8,TO_DATE('2450890;00000','J;SSSSS'),TO_DATE('2450918;00000','J;SSSSS'),TO_DATE('2450893;00000','J;SSSSS'),2,3.26,'Folk och fä HB','Åkergatan 24','Bräcke',NULL,'S-844 67','Sweden');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BLAUS',6,TO_DATE('2450890;00000','J;SSSSS'),TO_DATE('2450932;00000','J;SSSSS'),TO_DATE('2450893;00000','J;SSSSS'),2,44.65,'Blauer See Delikatessen','Forsterstr. 57','Mannheim',NULL,'68306','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HILAA',8,TO_DATE('2450891;00000','J;SSSSS'),TO_DATE('2450919;00000','J;SSSSS'),TO_DATE('2450900;00000','J;SSSSS'),3,105.36,'HILARION-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Cristóbal','Táchira','5022','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('OCEAN',7,TO_DATE('2450891;00000','J;SSSSS'),TO_DATE('2450919;00000','J;SSSSS'),TO_DATE('2450900;00000','J;SSSSS'),2,49.56,'Océano Atlántico Ltda.','Ing. Gustavo Moncada 8585'||CHR(13)||CHR(10)||'Piso 20-A','Buenos Aires',NULL,'1010','Argentina');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('GOURL',6,TO_DATE('2450891;00000','J;SSSSS'),TO_DATE('2450933;00000','J;SSSSS'),TO_DATE('2450896;00000','J;SSSSS'),2,4.98,'Gourmet Lanchonetes','Av. Brasil, 442','Campinas','SP','04876-786','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HILAA',3,TO_DATE('2450892;00000','J;SSSSS'),TO_DATE('2450906;00000','J;SSSSS'),TO_DATE('2450912;00000','J;SSSSS'),1,2.08,'HILARION-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Cristóbal','Táchira','5022','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUEEN',8,TO_DATE('2450892;00000','J;SSSSS'),TO_DATE('2450920;00000','J;SSSSS'),TO_DATE('2450903;00000','J;SSSSS'),1,104.47,'Queen Cozinha','Alameda dos Canàrios, 891','Sao Paulo','SP','05487-020','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUICK',8,TO_DATE('2450892;00000','J;SSSSS'),TO_DATE('2450920;00000','J;SSSSS'),TO_DATE('2450896;00000','J;SSSSS'),2,275.79,'QUICK-Stop','Taucherstraße 10','Cunewalde',NULL,'01307','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FURIB',9,TO_DATE('2450892;00000','J;SSSSS'),TO_DATE('2450920;00000','J;SSSSS'),TO_DATE('2450899;00000','J;SSSSS'),3,2.7,'Furia Bacalhau e Frutos do Mar','Jardim das rosas n. 32','Lisboa',NULL,'1675','Portugal');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SPECD',3,TO_DATE('2450893;00000','J;SSSSS'),TO_DATE('2450921;00000','J;SSSSS'),TO_DATE('2450897;00000','J;SSSSS'),2,87.38,'spécialités du monde','25, rue Lauriston','Paris',NULL,'75016','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('OLDWO',6,TO_DATE('2450893;00000','J;SSSSS'),TO_DATE('2450921;00000','J;SSSSS'),TO_DATE('2450903;00000','J;SSSSS'),3,144.38,'Old World Delicatessen','2743 Bering St.','Anchorage','AK','99508','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('CHOPS',4,TO_DATE('2450893;00000','J;SSSSS'),TO_DATE('2450921;00000','J;SSSSS'),TO_DATE('2450912;00000','J;SSSSS'),1,27.19,'Chop-suey Chinese','Hauptstr. 31','Bern',NULL,'3012','Switzerland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('TOMSP',2,TO_DATE('2450896;00000','J;SSSSS'),TO_DATE('2450924;00000','J;SSSSS'),TO_DATE('2450906;00000','J;SSSSS'),2,62.22,'Toms Spezialitäten','Luisenstr. 48','Münster',NULL,'44087','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ERNSH',1,TO_DATE('2450896;00000','J;SSSSS'),TO_DATE('2450924;00000','J;SSSSS'),TO_DATE('2450905;00000','J;SSSSS'),3,74.6,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('COMMI',1,TO_DATE('2450896;00000','J;SSSSS'),TO_DATE('2450924;00000','J;SSSSS'),TO_DATE('2450903;00000','J;SSSSS'),2,.21,'Comércio Mineiro','Av. dos Lusíadas, 23','Sao Paulo','SP','05432-043','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BOLID',9,TO_DATE('2450897;00000','J;SSSSS'),TO_DATE('2450911;00000','J;SSSSS'),TO_DATE('2450928;00000','J;SSSSS'),1,16.16,'Bólido Comidas preparadas','C/ Araquil, 67','Madrid',NULL,'28023','Spain');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FRANR',2,TO_DATE('2450897;00000','J;SSSSS'),TO_DATE('2450925;00000','J;SSSSS'),TO_DATE('2450906;00000','J;SSSSS'),2,121.82,'France restauration','54, rue Royale','Nantes',NULL,'44000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LACOR',4,TO_DATE('2450897;00000','J;SSSSS'),TO_DATE('2450925;00000','J;SSSSS'),TO_DATE('2450899;00000','J;SSSSS'),2,.02,'La corne d''abondance','67, avenue de l''Europe','Versailles',NULL,'78000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LACOR',6,TO_DATE('2450897;00000','J;SSSSS'),TO_DATE('2450925;00000','J;SSSSS'),TO_DATE('2450900;00000','J;SSSSS'),2,15.17,'La corne d''abondance','67, avenue de l''Europe','Versailles',NULL,'78000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SPLIR',3,TO_DATE('2450898;00000','J;SSSSS'),TO_DATE('2450912;00000','J;SSSSS'),TO_DATE('2450907;00000','J;SSSSS'),3,12.96,'Split Rail Beer '||Chr(38)||' Ale','P.O. Box 555','Lander','WY','82520','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BOTTM',1,TO_DATE('2450898;00000','J;SSSSS'),TO_DATE('2450926;00000','J;SSSSS'),TO_DATE('2450900;00000','J;SSSSS'),3,32.27,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HILAA',1,TO_DATE('2450898;00000','J;SSSSS'),TO_DATE('2450940;00000','J;SSSSS'),TO_DATE('2450907;00000','J;SSSSS'),1,37.97,'HILARION-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Cristóbal','Táchira','5022','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FOLKO',8,TO_DATE('2450899;00000','J;SSSSS'),TO_DATE('2450927;00000','J;SSSSS'),TO_DATE('2450914;00000','J;SSSSS'),3,208.5,'Folk och fä HB','Åkergatan 24','Bräcke',NULL,'S-844 67','Sweden');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('MAISD',9,TO_DATE('2450899;00000','J;SSSSS'),TO_DATE('2450927;00000','J;SSSSS'),TO_DATE('2450927;00000','J;SSSSS'),2,32.82,'Maison Dewey','Rue Joseph-Bens 532','Bruxelles',NULL,'B-1180','Belgium');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ERNSH',8,TO_DATE('2450899;00000','J;SSSSS'),TO_DATE('2450927;00000','J;SSSSS'),TO_DATE('2450904;00000','J;SSSSS'),2,353.07,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FOLKO',4,TO_DATE('2450900;00000','J;SSSSS'),TO_DATE('2450942;00000','J;SSSSS'),TO_DATE('2450921;00000','J;SSSSS'),1,1.26,'Folk och fä HB','Åkergatan 24','Bräcke',NULL,'S-844 67','Sweden');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HANAR',1,TO_DATE('2450900;00000','J;SSSSS'),TO_DATE('2450928;00000','J;SSSSS'),TO_DATE('2450906;00000','J;SSSSS'),2,193.37,'Hanari Carnes','Rua do Paço, 67','Rio de Janeiro','RJ','05454-876','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BOTTM',2,TO_DATE('2450900;00000','J;SSSSS'),TO_DATE('2450928;00000','J;SSSSS'),TO_DATE('2450912;00000','J;SSSSS'),1,14.01,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SAVEA',2,TO_DATE('2450900;00000','J;SSSSS'),TO_DATE('2450928;00000','J;SSSSS'),TO_DATE('2450910;00000','J;SSSSS'),2,657.54,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SAVEA',1,TO_DATE('2450903;00000','J;SSSSS'),TO_DATE('2450931;00000','J;SSSSS'),TO_DATE('2450907;00000','J;SSSSS'),3,211.22,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HUNGO',2,TO_DATE('2450903;00000','J;SSSSS'),TO_DATE('2450931;00000','J;SSSSS'),TO_DATE('2450906;00000','J;SSSSS'),1,91.51,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('OCEAN',8,TO_DATE('2450903;00000','J;SSSSS'),TO_DATE('2450931;00000','J;SSSSS'),TO_DATE('2450925;00000','J;SSSSS'),2,217.86,'Océano Atlántico Ltda.','Ing. Gustavo Moncada 8585'||CHR(13)||CHR(10)||'Piso 20-A','Buenos Aires',NULL,'1010','Argentina');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('EASTC',8,TO_DATE('2450904;00000','J;SSSSS'),TO_DATE('2450932;00000','J;SSSSS'),TO_DATE('2450910;00000','J;SSSSS'),1,185.48,'Eastern Connection','35 King George','London',NULL,'WX3 6FW','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RATTC',3,TO_DATE('2450904;00000','J;SSSSS'),TO_DATE('2450932;00000','J;SSSSS'),TO_DATE('2450914;00000','J;SSSSS'),2,61.14,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUEDE',2,TO_DATE('2450904;00000','J;SSSSS'),TO_DATE('2450932;00000','J;SSSSS'),TO_DATE('2450906;00000','J;SSSSS'),1,34.76,'Que Delícia','Rua da Panificadora, 12','Rio de Janeiro','RJ','02389-673','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ERNSH',2,TO_DATE('2450905;00000','J;SSSSS'),TO_DATE('2450947;00000','J;SSSSS'),TO_DATE('2450911;00000','J;SSSSS'),3,117.61,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUICK',1,TO_DATE('2450905;00000','J;SSSSS'),TO_DATE('2450933;00000','J;SSSSS'),TO_DATE('2450911;00000','J;SSSSS'),1,38.51,'QUICK-Stop','Taucherstraße 10','Cunewalde',NULL,'01307','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('THEBI',1,TO_DATE('2450905;00000','J;SSSSS'),TO_DATE('2450933;00000','J;SSSSS'),TO_DATE('2450907;00000','J;SSSSS'),3,4.27,'The Big Cheese','89 Jefferson Way'||CHR(13)||CHR(10)||'Suite 2','Portland','OR','97201','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FOLKO',7,TO_DATE('2450905;00000','J;SSSSS'),TO_DATE('2450933;00000','J;SSSSS'),TO_DATE('2450914;00000','J;SSSSS'),3,8.81,'Folk och fä HB','Åkergatan 24','Bräcke',NULL,'S-844 67','Sweden');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('VAFFE',2,TO_DATE('2450906;00000','J;SSSSS'),TO_DATE('2450920;00000','J;SSSSS'),TO_DATE('2450913;00000','J;SSSSS'),3,65.53,'Vaffeljernet','Smagsloget 45','Århus',NULL,'8200','Denmark');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('PERIC',1,TO_DATE('2450906;00000','J;SSSSS'),TO_DATE('2450934;00000','J;SSSSS'),TO_DATE('2450910;00000','J;SSSSS'),3,46,'Pericles Comidas clásicas','Calle Dr. Jorge Cash 321','México D.F.',NULL,'05033','Mexico');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUICK',4,TO_DATE('2450906;00000','J;SSSSS'),TO_DATE('2450934;00000','J;SSSSS'),TO_DATE('2450914;00000','J;SSSSS'),2,1.12,'QUICK-Stop','Taucherstraße 10','Cunewalde',NULL,'01307','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LILAS',8,TO_DATE('2450907;00000','J;SSSSS'),TO_DATE('2450949;00000','J;SSSSS'),TO_DATE('2450917;00000','J;SSSSS'),2,73.91,'LILA-Supermercado','Carrera 52 con Ave. Bolívar #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WOLZA',8,TO_DATE('2450907;00000','J;SSSSS'),TO_DATE('2450921;00000','J;SSSSS'),TO_DATE('2450921;00000','J;SSSSS'),2,20.31,'Wolski Zajazd','ul. Filtrowa 68','Warszawa',NULL,'01-012','Poland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('OTTIK',6,TO_DATE('2450907;00000','J;SSSSS'),TO_DATE('2450935;00000','J;SSSSS'),TO_DATE('2450914;00000','J;SSSSS'),2,96.35,'Ottilies Käseladen','Mehrheimerstr. 369','Köln',NULL,'50739','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RATTC',2,TO_DATE('2450910;00000','J;SSSSS'),TO_DATE('2450938;00000','J;SSSSS'),TO_DATE('2450918;00000','J;SSSSS'),3,55.12,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FOLKO',2,TO_DATE('2450910;00000','J;SSSSS'),TO_DATE('2450938;00000','J;SSSSS'),TO_DATE('2450918;00000','J;SSSSS'),2,197.3,'Folk och fä HB','Åkergatan 24','Bräcke',NULL,'S-844 67','Sweden');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SAVEA',4,TO_DATE('2450910;00000','J;SSSSS'),TO_DATE('2450938;00000','J;SSSSS'),TO_DATE('2450920;00000','J;SSSSS'),1,141.16,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('THECR',3,TO_DATE('2450910;00000','J;SSSSS'),TO_DATE('2450938;00000','J;SSSSS'),TO_DATE('2450912;00000','J;SSSSS'),3,14.91,'The Cracker Box','55 Grizzly Peak Rd.','Butte','MT','59801','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('MAISD',3,TO_DATE('2450911;00000','J;SSSSS'),TO_DATE('2450939;00000','J;SSSSS'),TO_DATE('2450924;00000','J;SSSSS'),1,44.84,'Maison Dewey','Rue Joseph-Bens 532','Bruxelles',NULL,'B-1180','Belgium');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WILMK',2,TO_DATE('2450911;00000','J;SSSSS'),TO_DATE('2450939;00000','J;SSSSS'),TO_DATE('2450914;00000','J;SSSSS'),1,.75,'Wilman Kala','Keskuskatu 45','Helsinki',NULL,'21240','Finland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('GREAL',3,TO_DATE('2450911;00000','J;SSSSS'),TO_DATE('2450939;00000','J;SSSSS'),TO_DATE('2450919;00000','J;SSSSS'),2,25.19,'Great Lakes Food Market','2732 Baker Blvd.','Eugene','OR','97403','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('PRINI',8,TO_DATE('2450912;00000','J;SSSSS'),TO_DATE('2450940;00000','J;SSSSS'),TO_DATE('2450917;00000','J;SSSSS'),2,202.24,'Princesa Isabel Vinhos','Estrada da saúde n. 58','Lisboa',NULL,'1756','Portugal');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ERNSH',7,TO_DATE('2450912;00000','J;SSSSS'),TO_DATE('2450940;00000','J;SSSSS'),NULL,3,79.46,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('GODOS',2,TO_DATE('2450912;00000','J;SSSSS'),TO_DATE('2450940;00000','J;SSSSS'),TO_DATE('2450914;00000','J;SSSSS'),1,59.11,'Godos Cocina Típica','C/ Romero, 33','Sevilla',NULL,'41101','Spain');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('REGGC',2,TO_DATE('2450913;00000','J;SSSSS'),TO_DATE('2450941;00000','J;SSSSS'),TO_DATE('2450925;00000','J;SSSSS'),2,28.71,'Reggiani Caseifici','Strada Provinciale 124','Reggio Emilia',NULL,'42100','Italy');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ALFKI',3,TO_DATE('2450913;00000','J;SSSSS'),TO_DATE('2450941;00000','J;SSSSS'),TO_DATE('2450917;00000','J;SSSSS'),1,1.21,'Alfreds Futterkiste','Obere Str. 57','Berlin',NULL,'12209','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FRANK',1,TO_DATE('2450913;00000','J;SSSSS'),TO_DATE('2450927;00000','J;SSSSS'),TO_DATE('2450921;00000','J;SSSSS'),3,242.95,'Frankenversand','Berliner Platz 43','München',NULL,'80805','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ROMEY',2,TO_DATE('2450913;00000','J;SSSSS'),TO_DATE('2450941;00000','J;SSSSS'),TO_DATE('2450914;00000','J;SSSSS'),1,32.99,'Romero y tomillo','Gran Vía, 1','Madrid',NULL,'28001','Spain');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LINOD',2,TO_DATE('2450914;00000','J;SSSSS'),TO_DATE('2450942;00000','J;SSSSS'),TO_DATE('2450919;00000','J;SSSSS'),3,23.6,'LINO-Delicateses','Ave. 5 de Mayo Porlamar','I. de Margarita','Nueva Esparta','4980','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SANTG',2,TO_DATE('2450914;00000','J;SSSSS'),TO_DATE('2450928;00000','J;SSSSS'),TO_DATE('2450924;00000','J;SSSSS'),2,4.62,'Santé Gourmet','Erling Skakkes gate 78','Stavern',NULL,'4110','Norway');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('AROUT',9,TO_DATE('2450914;00000','J;SSSSS'),TO_DATE('2450942;00000','J;SSSSS'),TO_DATE('2450917;00000','J;SSSSS'),2,33.8,'Around the Horn','Brook Farm'||CHR(13)||CHR(10)||'Stratford St. Mary','Colchester','Essex','CO7 6JX','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ERNSH',9,TO_DATE('2450917;00000','J;SSSSS'),TO_DATE('2450945;00000','J;SSSSS'),TO_DATE('2450924;00000','J;SSSSS'),2,754.26,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LONEP',4,TO_DATE('2450917;00000','J;SSSSS'),TO_DATE('2450945;00000','J;SSSSS'),TO_DATE('2450920;00000','J;SSSSS'),2,11.65,'Lonesome Pine Restaurant','89 Chiaroscuro Rd.','Portland','OR','97219','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RANCH',6,TO_DATE('2450917;00000','J;SSSSS'),TO_DATE('2450945;00000','J;SSSSS'),NULL,3,3.17,'Rancho grande','Av. del Libertador 900','Buenos Aires',NULL,'1010','Argentina');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('OTTIK',2,TO_DATE('2450918;00000','J;SSSSS'),TO_DATE('2450946;00000','J;SSSSS'),TO_DATE('2450920;00000','J;SSSSS'),2,43.3,'Ottilies Käseladen','Mehrheimerstr. 369','Köln',NULL,'50739','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUICK',3,TO_DATE('2450918;00000','J;SSSSS'),TO_DATE('2450946;00000','J;SSSSS'),TO_DATE('2450925;00000','J;SSSSS'),1,297.18,'QUICK-Stop','Taucherstraße 10','Cunewalde',NULL,'01307','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HANAR',9,TO_DATE('2450918;00000','J;SSSSS'),TO_DATE('2450946;00000','J;SSSSS'),TO_DATE('2450938;00000','J;SSSSS'),2,6.27,'Hanari Carnes','Rua do Paço, 67','Rio de Janeiro','RJ','05454-876','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BSBEV',1,TO_DATE('2450918;00000','J;SSSSS'),TO_DATE('2450932;00000','J;SSSSS'),TO_DATE('2450928;00000','J;SSSSS'),2,123.83,'B''s Beverages','Fauntleroy Circus','London',NULL,'EC2 5NT','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('EASTC',4,TO_DATE('2450919;00000','J;SSSSS'),TO_DATE('2450947;00000','J;SSSSS'),TO_DATE('2450924;00000','J;SSSSS'),1,74.36,'Eastern Connection','35 King George','London',NULL,'WX3 6FW','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WARTH',6,TO_DATE('2450919;00000','J;SSSSS'),TO_DATE('2450947;00000','J;SSSSS'),TO_DATE('2450928;00000','J;SSSSS'),3,29.17,'Wartian Herkku','Torikatu 38','Oulu',NULL,'90110','Finland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FRANS',4,TO_DATE('2450919;00000','J;SSSSS'),TO_DATE('2450947;00000','J;SSSSS'),TO_DATE('2450932;00000','J;SSSSS'),1,47.09,'Franchi S.p.A.','Via Monte Bianco 34','Torino',NULL,'10100','Italy');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BOTTM',1,TO_DATE('2450920;00000','J;SSSSS'),TO_DATE('2450948;00000','J;SSSSS'),TO_DATE('2450924;00000','J;SSSSS'),1,52.52,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('KOENE',2,TO_DATE('2450920;00000','J;SSSSS'),TO_DATE('2450948;00000','J;SSSSS'),TO_DATE('2450926;00000','J;SSSSS'),1,29.59,'Königlich Essen','Maubelstr. 90','Brandenburg',NULL,'14776','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('CHOPS',4,TO_DATE('2450920;00000','J;SSSSS'),TO_DATE('2450948;00000','J;SSSSS'),TO_DATE('2450931;00000','J;SSSSS'),1,47.84,'Chop-suey Chinese','Hauptstr. 31','Bern',NULL,'3012','Switzerland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SAVEA',7,TO_DATE('2450921;00000','J;SSSSS'),TO_DATE('2450949;00000','J;SSSSS'),TO_DATE('2450931;00000','J;SSSSS'),2,830.75,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SAVEA',6,TO_DATE('2450921;00000','J;SSSSS'),TO_DATE('2450949;00000','J;SSSSS'),TO_DATE('2450928;00000','J;SSSSS'),2,227.22,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WHITC',2,TO_DATE('2450921;00000','J;SSSSS'),TO_DATE('2450949;00000','J;SSSSS'),TO_DATE('2450927;00000','J;SSSSS'),3,606.19,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RICSU',7,TO_DATE('2450921;00000','J;SSSSS'),TO_DATE('2450949;00000','J;SSSSS'),TO_DATE('2450927;00000','J;SSSSS'),3,84.74,'Richter Supermarkt','Starenweg 5','Genève',NULL,'1204','Switzerland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('OLDWO',8,TO_DATE('2450924;00000','J;SSSSS'),TO_DATE('2450966;00000','J;SSSSS'),TO_DATE('2450931;00000','J;SSSSS'),1,40.32,'Old World Delicatessen','2743 Bering St.','Anchorage','AK','99508','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SUPRD',2,TO_DATE('2450924;00000','J;SSSSS'),TO_DATE('2450952;00000','J;SSSSS'),TO_DATE('2450928;00000','J;SSSSS'),2,.17,'Suprêmes délices','Boulevard Tirou, 255','Charleroi',NULL,'B-6000','Belgium');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('DRACD',8,TO_DATE('2450924;00000','J;SSSSS'),TO_DATE('2450952;00000','J;SSSSS'),TO_DATE('2450926;00000','J;SSSSS'),3,149.47,'Drachenblut Delikatessen','Walserweg 21','Aachen',NULL,'52066','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('GODOS',7,TO_DATE('2450925;00000','J;SSSSS'),TO_DATE('2450953;00000','J;SSSSS'),TO_DATE('2450931;00000','J;SSSSS'),1,3.2,'Godos Cocina Típica','C/ Romero, 33','Sevilla',NULL,'41101','Spain');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SUPRD',1,TO_DATE('2450925;00000','J;SSSSS'),TO_DATE('2450953;00000','J;SSSSS'),TO_DATE('2450934;00000','J;SSSSS'),2,29.59,'Suprêmes délices','Boulevard Tirou, 255','Charleroi',NULL,'B-6000','Belgium');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LINOD',1,TO_DATE('2450925;00000','J;SSSSS'),TO_DATE('2450953;00000','J;SSSSS'),NULL,2,65,'LINO-Delicateses','Ave. 5 de Mayo Porlamar','I. de Margarita','Nueva Esparta','4980','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('GREAL',4,TO_DATE('2450926;00000','J;SSSSS'),TO_DATE('2450954;00000','J;SSSSS'),NULL,3,18.84,'Great Lakes Food Market','2732 Baker Blvd.','Eugene','OR','97403','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('CHOPS',3,TO_DATE('2450926;00000','J;SSSSS'),TO_DATE('2450954;00000','J;SSSSS'),TO_DATE('2450932;00000','J;SSSSS'),2,48.22,'Chop-suey Chinese','Hauptstr. 31','Bern',NULL,'3012','Switzerland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('COMMI',2,TO_DATE('2450926;00000','J;SSSSS'),TO_DATE('2450940;00000','J;SSSSS'),TO_DATE('2450935;00000','J;SSSSS'),1,29.99,'Comércio Mineiro','Av. dos Lusíadas, 23','Sao Paulo','SP','05432-043','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SPECD',5,TO_DATE('2450926;00000','J;SSSSS'),TO_DATE('2450954;00000','J;SSSSS'),TO_DATE('2450933;00000','J;SSSSS'),2,8.8,'spécialités du monde','25, rue Lauriston','Paris',NULL,'75016','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WOLZA',4,TO_DATE('2450927;00000','J;SSSSS'),TO_DATE('2450955;00000','J;SSSSS'),TO_DATE('2450935;00000','J;SSSSS'),1,8.72,'Wolski Zajazd','ul. Filtrowa 68','Warszawa',NULL,'01-012','Poland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BOTTM',6,TO_DATE('2450927;00000','J;SSSSS'),TO_DATE('2450955;00000','J;SSSSS'),NULL,2,70.58,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WANDK',8,TO_DATE('2450927;00000','J;SSSSS'),TO_DATE('2450955;00000','J;SSSSS'),TO_DATE('2450928;00000','J;SSSSS'),2,71.64,'Die Wandernde Kuh','Adenauerallee 900','Stuttgart',NULL,'70563','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('EASTC',7,TO_DATE('2450928;00000','J;SSSSS'),TO_DATE('2450956;00000','J;SSSSS'),TO_DATE('2450935;00000','J;SSSSS'),3,46.62,'Eastern Connection','35 King George','London',NULL,'WX3 6FW','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BOTTM',7,TO_DATE('2450928;00000','J;SSSSS'),TO_DATE('2450956;00000','J;SSSSS'),TO_DATE('2450934;00000','J;SSSSS'),3,24.12,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('GOURL',3,TO_DATE('2450928;00000','J;SSSSS'),TO_DATE('2450956;00000','J;SSSSS'),TO_DATE('2450938;00000','J;SSSSS'),1,8.34,'Gourmet Lanchonetes','Av. Brasil, 442','Campinas','SP','04876-786','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FOLKO',8,TO_DATE('2450931;00000','J;SSSSS'),TO_DATE('2450959;00000','J;SSSSS'),TO_DATE('2450939;00000','J;SSSSS'),2,59.41,'Folk och fä HB','Åkergatan 24','Bräcke',NULL,'S-844 67','Sweden');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LAMAI',7,TO_DATE('2450931;00000','J;SSSSS'),TO_DATE('2450959;00000','J;SSSSS'),NULL,3,2.79,'La maison d''Asie','1 rue Alsace-Lorraine','Toulouse',NULL,'31000','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HANAR',3,TO_DATE('2450931;00000','J;SSSSS'),TO_DATE('2450959;00000','J;SSSSS'),TO_DATE('2450935;00000','J;SSSSS'),1,67.26,'Hanari Carnes','Rua do Paço, 67','Rio de Janeiro','RJ','05454-876','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('PICCO',2,TO_DATE('2450931;00000','J;SSSSS'),TO_DATE('2450959;00000','J;SSSSS'),TO_DATE('2450933;00000','J;SSSSS'),2,53.05,'Piccolo und mehr','Geislweg 14','Salzburg',NULL,'5020','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('CACTU',8,TO_DATE('2450932;00000','J;SSSSS'),TO_DATE('2450960;00000','J;SSSSS'),NULL,1,.33,'Cactus Comidas para llevar','Cerrito 333','Buenos Aires',NULL,'1010','Argentina');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HILAA',7,TO_DATE('2450932;00000','J;SSSSS'),TO_DATE('2450960;00000','J;SSSSS'),TO_DATE('2450939;00000','J;SSSSS'),2,120.92,'HILARION-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Cristóbal','Táchira','5022','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('EASTC',8,TO_DATE('2450932;00000','J;SSSSS'),TO_DATE('2450946;00000','J;SSSSS'),TO_DATE('2450935;00000','J;SSSSS'),2,278.96,'Eastern Connection','35 King George','London',NULL,'WX3 6FW','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('NORTS',3,TO_DATE('2450933;00000','J;SSSSS'),TO_DATE('2450961;00000','J;SSSSS'),TO_DATE('2450935;00000','J;SSSSS'),3,4.13,'North/South','South House'||CHR(13)||CHR(10)||'300 Queensbridge','London',NULL,'SW7 1RZ','UK');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BLAUS',9,TO_DATE('2450933;00000','J;SSSSS'),TO_DATE('2450961;00000','J;SSSSS'),NULL,3,31.14,'Blauer See Delikatessen','Forsterstr. 57','Mannheim',NULL,'68306','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RICAR',2,TO_DATE('2450933;00000','J;SSSSS'),TO_DATE('2450975;00000','J;SSSSS'),NULL,2,85.8,'Ricardo Adocicados','Av. Copacabana, 267','Rio de Janeiro','RJ','02389-890','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('FRANS',2,TO_DATE('2450934;00000','J;SSSSS'),TO_DATE('2450962;00000','J;SSSSS'),TO_DATE('2450938;00000','J;SSSSS'),2,10.98,'Franchi S.p.A.','Via Monte Bianco 34','Torino',NULL,'10100','Italy');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('GREAL',4,TO_DATE('2450934;00000','J;SSSSS'),TO_DATE('2450976;00000','J;SSSSS'),NULL,3,14.01,'Great Lakes Food Market','2732 Baker Blvd.','Eugene','OR','97403','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('REGGC',4,TO_DATE('2450934;00000','J;SSSSS'),TO_DATE('2450962;00000','J;SSSSS'),NULL,2,29.93,'Reggiani Caseifici','Strada Provinciale 124','Reggio Emilia',NULL,'42100','Italy');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('HUNGO',3,TO_DATE('2450934;00000','J;SSSSS'),TO_DATE('2450962;00000','J;SSSSS'),TO_DATE('2450940;00000','J;SSSSS'),2,81.73,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SAVEA',1,TO_DATE('2450935;00000','J;SSSSS'),TO_DATE('2450963;00000','J;SSSSS'),TO_DATE('2450938;00000','J;SSSSS'),1,30.09,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LILAS',8,TO_DATE('2450935;00000','J;SSSSS'),TO_DATE('2450963;00000','J;SSSSS'),NULL,1,12.91,'LILA-Supermercado','Carrera 52 con Ave. Bolívar #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('WHITC',7,TO_DATE('2450935;00000','J;SSSSS'),TO_DATE('2450963;00000','J;SSSSS'),TO_DATE('2450938;00000','J;SSSSS'),2,44.72,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','USA');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('DRACD',1,TO_DATE('2450938;00000','J;SSSSS'),TO_DATE('2450952;00000','J;SSSSS'),TO_DATE('2450940;00000','J;SSSSS'),2,7.98,'Drachenblut Delikatessen','Walserweg 21','Aachen',NULL,'52066','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('QUEEN',8,TO_DATE('2450938;00000','J;SSSSS'),TO_DATE('2450966;00000','J;SSSSS'),NULL,2,81.75,'Queen Cozinha','Alameda dos Canàrios, 891','Sao Paulo','SP','05487-020','Brazil');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('TORTU',1,TO_DATE('2450938;00000','J;SSSSS'),TO_DATE('2450966;00000','J;SSSSS'),TO_DATE('2450940;00000','J;SSSSS'),2,15.67,'Tortuga Restaurante','Avda. Azteca 123','México D.F.',NULL,'05033','Mexico');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LEHMS',2,TO_DATE('2450939;00000','J;SSSSS'),TO_DATE('2450967;00000','J;SSSSS'),NULL,1,136,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M. ',NULL,'60528','Germany');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('LILAS',1,TO_DATE('2450939;00000','J;SSSSS'),TO_DATE('2450967;00000','J;SSSSS'),NULL,1,.93,'LILA-Supermercado','Carrera 52 con Ave. Bolívar #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('ERNSH',4,TO_DATE('2450939;00000','J;SSSSS'),TO_DATE('2450967;00000','J;SSSSS'),NULL,2,258.64,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('PERIC',2,TO_DATE('2450939;00000','J;SSSSS'),TO_DATE('2450967;00000','J;SSSSS'),NULL,2,24.95,'Pericles Comidas clásicas','Calle Dr. Jorge Cash 321','México D.F.',NULL,'05033','Mexico');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('SIMOB',7,TO_DATE('2450940;00000','J;SSSSS'),TO_DATE('2450968;00000','J;SSSSS'),NULL,2,18.44,'Simons bistro','Vinbæltet 34','Kobenhavn',NULL,'1734','Denmark');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RICSU',8,TO_DATE('2450940;00000','J;SSSSS'),TO_DATE('2450968;00000','J;SSSSS'),NULL,2,6.19,'Richter Supermarkt','Starenweg 5','Genève',NULL,'1204','Switzerland');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('BONAP',4,TO_DATE('2450940;00000','J;SSSSS'),TO_DATE('2450968;00000','J;SSSSS'),NULL,2,38.28,'Bon app''','12, rue des Bouchers','Marseille',NULL,'13008','France');
INSERT INTO Orders (CUSTOMERID,EMPLOYEEID,ORDERDATE,REQUIREDDATE,SHIPPEDDATE,SHIPVIA,FREIGHT,SHIPNAME,SHIPADDRESS,SHIPCITY,SHIPRegion,SHIPPOSTALCODE,SHIPCOUNTRY) VALUES ('RATTC',1,TO_DATE('2450940;00000','J;SSSSS'),TO_DATE('2450968;00000','J;SSSSS'),NULL,2,8.53,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','USA');

/* Commit changes */
COMMIT;


/* Insert into table */

INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (1,11,14,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (1,42,9.8,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (1,72,34.8,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (2,14,18.6,9,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (2,51,42.4,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (3,41,7.7,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (3,51,42.4,35,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (3,65,16.8,15,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (4,22,16.8,6,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (4,57,15.6,15,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (4,65,16.8,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (5,20,64.8,40,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (5,33,2,25,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (5,60,27.2,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (6,31,10,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (6,39,14.4,42,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (6,49,16,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (7,24,3.6,15,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (7,55,19.2,21,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (7,74,8,21,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (8,2,15.2,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (8,16,13.9,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (8,36,15.2,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (8,59,44,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (9,53,26.2,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (9,77,10.4,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (10,27,35.1,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (10,39,14.4,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (10,77,10.4,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (11,2,15.2,50,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (11,5,17,65,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (11,32,25.6,6,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (12,21,8,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (12,37,20.8,1,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (13,41,7.7,16,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (13,57,15.6,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (13,62,39.4,15,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (13,70,12,21,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (14,21,8,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (14,35,14.4,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (15,5,17,12,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (15,7,24,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (15,56,30.4,2,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (16,16,13.9,60,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (16,24,3.6,28,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (16,30,20.7,60,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (16,74,8,36,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (17,2,15.2,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (17,41,7.7,25,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (18,17,31.2,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (18,70,12,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (19,12,30.4,12,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (20,40,14.7,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (20,59,44,70,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (20,76,14.4,15,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (21,29,99,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (21,72,27.8,4,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (22,33,2,60,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (22,72,27.8,20,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (23,36,15.2,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (23,43,36.8,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (24,33,2,24,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (25,20,64.8,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (25,31,10,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (25,72,27.8,24,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (26,10,24.8,24,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (26,31,10,15,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (26,33,2,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (26,40,14.7,60,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (26,76,14.4,33,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (27,71,17.2,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (27,72,27.8,7,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (28,24,3.6,12,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (28,59,44,6,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (29,10,24.8,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (29,13,4.8,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (30,28,36.4,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (30,62,39.4,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (31,44,15.5,16,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (31,59,44,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (31,63,35.1,8,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (31,73,12,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (32,17,31.2,15,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (33,24,3.6,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (33,55,19.2,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (33,75,6.2,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (34,19,7.3,1,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (34,24,3.6,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (34,35,14.4,4,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (35,30,20.7,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (35,57,15.6,2,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (36,15,12.4,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (36,19,7.3,18,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (36,60,27.2,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (36,72,27.8,3,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (37,27,35.1,15,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (37,44,15.5,21,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (37,60,27.2,20,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (37,67,11.2,5,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (38,1,14.4,45,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (38,40,14.7,40,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (38,53,26.2,36,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (39,35,14.4,100,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (39,62,39.4,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (40,16,13.9,40,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (40,34,11.2,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (40,46,9.6,15,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (41,54,5.9,10,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (41,68,10,3,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (42,3,8,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (42,64,26.6,9,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (43,5,17,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (43,29,99,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (43,49,16,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (43,77,10.4,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (44,13,4.8,20,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (44,44,15.5,24,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (44,51,42.4,2,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (45,20,64.8,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (46,18,50,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (46,24,3.6,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (46,63,35.1,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (46,75,6.2,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (47,1,14.4,18,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (47,17,31.2,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (47,43,36.8,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (47,60,27.2,21,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (47,75,6.2,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (48,56,30.4,4,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (49,11,16.8,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (49,16,13.9,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (49,69,28.8,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (50,39,14.4,60,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (50,72,27.8,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (51,2,15.2,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (51,36,15.2,40,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (51,59,44,30,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (51,62,39.4,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (52,19,7.3,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (52,70,12,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (53,66,13.6,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (53,68,10,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (54,40,14.7,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (54,56,30.4,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (55,17,31.2,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (55,28,36.4,28,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (55,43,36.8,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (56,40,14.7,40,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (56,65,16.8,30,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (56,68,10,15,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (57,49,16,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (57,59,44,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (57,71,17.2,2,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (58,18,50,25,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (58,29,99,25,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (58,39,14.4,30,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (59,30,20.7,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (59,53,26.2,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (59,54,5.9,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (60,62,39.4,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (60,68,10,3,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (61,69,28.8,1,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (61,70,12,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (62,4,17.6,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (62,6,20,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (62,42,11.2,2,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (62,43,36.8,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (62,71,17.2,3,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (63,16,13.9,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (63,62,39.4,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (64,42,11.2,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (64,69,28.8,7,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (65,28,36.4,4,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (65,43,36.8,24,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (65,53,26.2,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (65,75,6.2,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (66,36,15.2,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (67,32,25.6,40,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (67,58,10.6,30,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (67,62,39.4,25,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (68,34,11.2,14,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (68,70,12,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (69,41,7.7,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (69,62,39.4,70,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (70,1,14.4,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (71,41,7.7,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (71,76,14.4,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (72,17,31.2,8,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (72,28,36.4,14,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (72,76,14.4,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (73,71,17.2,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (74,35,14.4,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (75,52,5.6,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (76,15,12.4,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (76,25,11.2,4,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (76,39,14.4,4,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (77,16,13.9,21,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (77,35,14.4,70,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (77,46,9.6,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (77,59,44,40,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (77,63,35.1,80,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (78,6,20,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (78,13,4.8,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (78,14,18.6,9,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (78,31,10,4,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (78,72,27.8,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (79,4,17.6,24,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (79,57,15.6,16,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (79,75,6.2,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (80,2,15.2,25,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (80,11,16.8,50,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (80,30,20.7,35,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (80,58,10.6,30,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (81,59,44,9,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (81,65,16.8,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (81,68,10,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (82,19,7.3,10,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (82,30,20.7,8,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (82,38,210.8,20,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (82,56,30.4,12,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (83,26,24.9,50,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (83,72,27.8,25,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (84,54,5.9,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (85,18,50,40,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (85,42,11.2,10,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (85,47,7.6,16,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (86,14,18.6,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (86,21,8,10,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (86,71,17.2,40,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (87,52,5.6,8,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (87,68,10,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (88,2,15.2,7,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (88,31,10,25,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (88,32,25.6,6,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (88,51,42.4,48,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (89,4,17.6,18,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (90,23,7.2,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (90,26,24.9,24,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (90,36,15.2,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (90,37,20.8,28,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (90,72,27.8,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (91,17,31.2,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (91,30,20.7,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (92,4,17.6,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (92,17,31.2,70,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (92,62,39.4,28,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (93,18,50,20,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (93,41,7.7,12,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (93,43,36.8,40,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (94,33,2,8,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (94,59,44,9,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (95,2,15.2,24,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (95,31,10,56,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (95,36,15.2,40,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (95,55,19.2,40,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (96,64,26.6,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (96,68,10,4,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (96,76,14.4,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (97,4,17.6,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (97,8,32,70,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (98,8,32,70,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (98,19,7.3,80,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (98,42,11.2,9,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (99,17,31.2,36,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (99,56,30.4,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (100,25,11.2,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (100,39,14.4,50,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (100,40,14.7,4,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (100,75,6.2,6,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (101,1,14.4,15,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (101,23,7.2,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (102,54,5.9,24,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (103,50,13,15,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (103,69,28.8,18,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (104,38,210.8,20,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (104,41,7.7,13,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (104,44,15.5,77,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (104,65,16.8,10,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (105,24,3.6,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (105,54,5.9,20,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (106,11,16.8,12,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (106,38,210.8,50,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (107,1,14.4,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (107,29,99,4,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (108,24,3.6,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (108,57,15.6,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (109,31,10,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (109,55,19.2,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (109,69,28.8,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (110,10,24.8,30,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (110,26,24.9,16,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (110,60,27.2,8,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (111,24,3.6,10,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (111,34,11.2,10,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (111,36,15.2,20,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (112,16,13.9,56,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (112,31,10,70,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (112,60,27.2,80,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (113,28,36.4,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (113,29,99,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (113,38,210.8,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (113,49,16,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (113,54,5.9,28,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (114,39,14.4,54,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (114,60,27.2,55,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (115,25,11.2,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (115,51,42.4,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (115,54,5.9,24,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (116,31,10,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (116,75,6.2,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (116,76,14.4,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (117,69,28.8,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (117,71,17.2,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (118,11,16.8,24,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (119,65,16.8,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (119,77,10.4,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (120,34,11.2,36,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (120,54,5.9,18,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (120,65,16.8,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (120,77,10.4,7,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (121,21,8,5,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (121,28,36.4,13,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (121,57,15.6,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (121,64,26.6,35,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (122,29,99,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (122,56,30.4,18,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (123,1,14.4,15,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (123,64,26.6,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (123,74,8,20,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (124,36,15.2,6,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (125,20,64.8,12,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (125,38,210.8,40,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (125,60,27.2,70,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (125,72,27.8,42,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (126,58,10.6,80,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (126,71,17.2,50,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (127,31,10,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (127,58,10.6,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (128,14,18.6,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (128,54,5.9,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (129,31,10,42,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (130,28,36.4,20,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (130,39,14.4,20,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (131,71,17.2,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (132,41,7.7,8,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (132,63,35.1,16,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (132,65,16.8,20,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (133,30,20.7,18,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (133,53,26.2,20,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (133,60,27.2,6,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (133,70,12,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (134,74,8,14,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (135,5,17,32,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (135,18,50,9,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (135,29,99,14,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (135,33,2,60,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (135,74,8,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (136,13,4.8,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (136,50,13,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (136,56,30.4,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (137,20,64.8,28,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (137,60,27.2,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (138,7,24,10,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (138,60,27.2,20,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (138,68,10,8,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (139,24,3.6,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (139,34,11.2,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (140,24,3.6,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (140,28,36.4,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (140,59,44,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (140,71,17.2,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (141,45,7.6,15,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (141,52,5.6,20,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (141,53,26.2,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (142,10,24.8,16,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (142,55,19.2,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (142,62,39.4,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (142,70,12,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (143,31,10,60,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (143,35,14.4,40,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (143,46,9.6,45,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (143,72,27.8,24,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (144,13,4.8,18,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (145,69,28.8,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (146,2,15.2,25,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (146,14,18.6,42,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (146,25,11.2,7,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (146,26,24.9,70,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (146,31,10,32,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (147,13,4.8,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (147,62,39.4,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (148,46,9.6,28,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (148,53,26.2,70,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (148,69,28.8,8,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (149,23,7.2,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (149,71,17.2,60,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (149,72,27.8,21,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (150,21,8,10,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (150,51,42.4,18,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (151,35,14.4,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (151,55,19.2,120,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (152,68,10,60,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (152,71,17.2,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (152,76,14.4,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (152,77,10.4,14,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (153,29,99,21,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (153,35,14.4,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (153,49,16,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (154,30,20.7,18,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (154,56,30.4,70,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (154,65,16.8,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (154,71,17.2,60,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (155,23,7.2,60,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (155,63,35.1,65,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (156,16,13.9,21,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (156,48,10.2,70,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (157,26,24.9,30,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (157,42,11.2,40,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (157,49,16,30,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (158,3,8,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (159,1,14.4,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (159,21,8,30,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (159,28,36.4,42,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (159,36,15.2,5,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (159,40,14.7,2,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (160,11,16.8,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (160,69,28.8,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (160,71,17.2,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (161,37,20.8,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (161,54,5.9,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (161,62,39.4,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (162,14,18.6,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (162,21,8,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (163,33,2,49,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (163,59,44,16,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (164,41,7.7,25,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (164,44,15.5,40,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (164,59,44,9,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (165,14,18.6,20,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (166,1,14.4,24,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (166,62,39.4,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (166,76,14.4,14,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (167,19,7.3,18,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (167,33,2,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (168,17,31.2,2,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (168,33,2,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (169,19,7.3,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (169,53,26.2,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (169,57,15.6,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (170,38,210.8,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (170,46,9.6,2,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (170,68,10,36,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (170,77,10.4,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (171,2,15.2,60,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (171,47,7.6,55,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (171,61,22.8,16,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (171,74,8,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (172,60,27.2,60,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (172,69,28.8,20,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (173,9,77.6,20,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (173,13,4.8,2,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (173,70,12,8,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (173,73,12,20,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (174,19,7.3,4,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (174,26,24.9,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (174,53,26.2,15,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (174,77,10.4,10,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (175,26,24.9,2,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (176,31,10,14,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (176,59,44,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (177,35,14.4,60,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (177,38,210.8,49,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (177,68,10,30,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (178,55,19.2,10,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (178,76,14.4,20,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (179,56,30.4,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (179,64,26.6,7,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (180,14,18.6,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (181,46,9.6,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (182,50,13,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (182,63,35.1,35,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (183,17,31.2,45,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (183,21,8,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (183,56,30.4,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (183,59,44,70,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (184,17,31.2,50,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (184,40,14.7,50,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (184,47,7.6,30,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (185,26,24.9,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (185,54,5.9,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (186,56,30.4,28,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (187,11,16.8,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (187,76,14.4,18,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (188,2,15.2,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (188,22,16.8,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (188,72,27.8,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (189,46,9.6,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (189,56,30.4,40,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (189,64,26.6,30,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (189,75,6.2,24,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (190,53,26.2,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (191,19,7.3,15,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (191,34,11.2,20,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (191,57,15.6,15,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (192,12,30.4,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (192,16,13.9,16,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (192,64,26.6,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (192,74,8,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (193,2,15.2,45,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (193,16,13.9,49,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (193,29,99,24,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (193,61,22.8,90,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (194,27,35.1,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (195,11,16.8,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (195,54,5.9,80,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (195,66,13.6,60,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (196,11,16.8,6,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (196,28,36.4,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (197,17,31.2,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (197,26,24.9,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (197,35,14.4,8,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (197,41,7.7,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (198,39,14.4,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (198,54,5.9,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (199,19,7.3,12,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (199,24,3.6,20,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (199,31,10,3,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (199,52,5.6,15,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (200,19,7.3,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (200,65,16.8,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (200,71,17.2,2,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (201,26,24.9,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (201,40,14.7,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (202,10,24.8,14,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (202,52,5.6,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (202,62,39.4,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (203,10,24.8,20,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (203,54,5.9,6,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (204,55,19.2,120,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (204,64,26.6,35,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (204,65,16.8,28,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (204,77,10.4,55,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (205,28,36.4,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (205,44,15.5,100,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (206,48,10.2,15,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (206,70,12,25,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (207,16,13.9,20,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (207,33,2,20,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (207,46,9.6,10,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (208,39,14.4,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (208,53,26.2,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (208,61,22.8,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (208,71,17.2,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (209,21,8,40,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (209,49,16,21,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (210,59,44,36,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (211,26,24.9,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (211,28,36.4,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (211,43,36.8,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (211,56,30.4,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (211,71,17.2,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (212,7,24,16,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (212,46,9.6,20,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (212,72,27.8,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (213,68,10,21,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (213,75,6.2,4,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (214,21,8,40,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (214,30,20.7,28,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (214,55,19.2,60,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (215,13,4.8,1,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (215,23,7.2,21,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (216,19,7.3,21,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (216,42,11.2,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (217,4,17.6,16,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (217,43,36.8,3,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (217,56,30.4,30,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (217,60,27.2,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (218,24,3.6,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (218,29,99,18,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (218,40,14.7,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (218,45,7.6,30,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (218,50,13,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (219,11,16.8,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (219,46,9.6,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (220,24,3.6,28,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (220,25,11.2,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (221,30,20.7,8,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (221,43,36.8,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (222,2,15.2,40,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (222,16,13.9,35,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (222,44,15.5,2,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (223,18,50,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (223,23,7.2,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (223,64,26.6,8,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (224,7,24,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (224,56,30.4,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (225,24,3.6,80,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (225,51,42.4,18,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (226,33,2,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (226,71,17.2,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (227,14,18.6,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (227,28,36.4,18,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (227,40,14.7,21,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (227,75,6.2,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (228,31,10,35,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (228,66,13.6,60,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (228,76,14.4,42,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (229,55,19.2,2,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (229,70,12,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (230,1,14.4,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (230,21,8,21,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (230,39,14.4,20,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (231,10,24.8,20,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (232,38,210.8,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (232,53,26.2,28,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (232,59,44,60,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (232,64,26.6,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (233,47,7.6,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (233,59,44,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (234,49,16,24,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (234,60,27.2,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (235,40,14.7,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (236,34,11.2,35,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (236,77,10.4,30,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (237,21,8,14,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (237,40,14.7,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (237,51,42.4,3,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (238,2,15.2,20,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (238,3,8,20,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (238,55,19.2,30,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (238,70,12,60,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (239,11,16.8,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (239,51,42.4,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (239,74,8,16,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (240,19,7.3,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (240,26,24.9,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (240,54,5.9,24,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (241,59,44,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (241,73,12,20,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (242,11,16.8,15,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (242,16,13.9,18,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (243,59,44,60,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (243,68,10,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (243,75,6.2,36,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (244,44,15.5,15,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (244,77,10.4,7,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (245,25,11.2,60,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (245,42,11.2,20,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (246,65,16.8,15,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (246,66,13.6,10,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (246,69,28.8,10,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (247,56,30.4,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (248,23,7.2,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (248,41,7.7,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (248,77,10.4,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (249,31,10,20,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (250,56,30.4,14,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (250,72,27.8,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (250,77,10.4,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (251,24,4.5,14,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (251,40,18.4,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (251,42,14,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (252,28,45.6,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (252,49,20,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (253,15,15.5,12,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (253,28,45.6,8,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (254,54,7.45,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (255,45,9.5,21,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (255,53,32.8,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (255,67,14,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (256,14,23.25,70,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (256,65,21.05,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (257,2,19,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (257,21,10,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (257,53,32.8,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (257,61,28.5,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (258,62,49.3,3,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (259,25,14,18,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (259,70,15,14,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (260,43,46,15,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (260,48,12.75,15,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (261,13,6,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (261,39,18,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (262,28,45.6,3,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (263,29,123.79,36,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (263,75,7.75,36,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (264,4,22,50,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (264,7,30,50,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (264,8,40,10,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (265,24,4.5,10,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (265,46,12,9,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (265,47,9.5,6,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (265,60,34,12,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (266,21,10,40,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (266,32,32,50,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (266,61,28.5,15,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (267,20,81,39,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (267,28,45.6,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (267,56,38,70,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (267,65,21.05,39,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (267,75,7.75,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (268,9,97,16,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (268,16,17.45,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (268,27,43.9,120,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (268,33,2.5,16,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (268,60,34,84,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (269,18,62.5,25,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (269,41,9.65,80,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (269,42,14,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (270,52,7,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (270,59,55,4,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (270,70,15,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (271,24,4.5,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (271,38,263.5,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (271,44,19.45,9,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (272,10,31,16,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (272,56,38,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (272,60,34,10,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (273,24,4.5,8,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (273,53,32.8,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (274,35,18,3,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (274,41,9.65,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (274,68,12.5,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (275,1,18,40,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (275,8,40,24,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (275,30,25.89,20,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (275,40,18.4,25,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (276,17,39,25,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (276,20,81,15,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (276,37,26,18,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (276,41,9.65,6,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (277,10,31,2,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (277,30,25.89,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (277,43,46,60,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (277,54,7.45,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (278,36,19,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (278,40,18.4,15,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (279,1,18,8,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (279,13,6,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (279,56,38,30,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (280,4,22,50,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (280,36,19,30,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (281,11,21,3,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (281,33,2.5,8,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (281,72,34.8,9,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (282,55,24,14,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (282,68,12.5,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (282,69,36,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (283,17,39,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (283,43,46,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (283,61,28.5,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (283,76,18,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (284,59,55,2,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (285,30,25.89,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (285,66,17,24,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (286,4,22,50,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (286,72,34.8,24,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (286,73,15,24,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (287,30,25.89,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (287,40,18.4,10,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (287,54,7.45,10,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (288,11,21,50,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (288,40,18.4,10,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (288,57,19.5,5,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (288,59,55,15,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (289,12,38,15,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (289,31,12.5,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (289,33,2.5,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (289,60,34,35,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (290,31,12.5,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (290,51,53,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (290,58,13.25,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (290,72,34.8,21,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (290,73,15,9,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (291,70,15,7,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (291,72,34.8,1,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (292,13,6,8,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (292,21,10,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (292,33,2.5,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (292,49,20,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (293,3,10,60,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (293,26,31.23,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (293,38,263.5,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (293,68,12.5,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (294,24,4.5,35,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (294,38,263.5,4,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (294,65,21.05,36,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (294,71,21.5,9,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (295,11,21,15,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (295,54,7.45,24,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (296,12,38,30,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (296,23,9,70,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (297,28,45.6,7,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (297,67,14,7,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (298,11,21,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (299,7,30,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (299,35,18,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (299,62,49.3,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (300,32,32,24,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (300,36,19,60,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (301,34,14,10,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (301,41,9.65,14,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (302,31,12.5,55,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (302,45,9.5,100,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (302,51,53,48,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (303,17,39,8,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (303,19,9.2,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (303,21,10,6,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (303,61,28.5,10,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (304,16,17.45,40,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (304,35,18,20,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (304,44,19.45,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (305,69,36,18,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (305,75,7.75,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (306,11,21,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (306,16,17.45,14,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (306,22,21,24,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (306,31,12.5,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (306,35,18,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (307,16,17.45,30,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (307,23,9,20,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (307,62,49.3,20,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (307,77,13,10,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (308,14,23.25,30,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (308,19,9.2,35,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (308,24,4.5,18,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (308,51,53,20,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (308,56,38,40,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (309,72,34.8,24,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (310,64,33.25,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (310,75,7.75,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (311,47,9.5,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (311,51,53,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (311,52,7,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (311,53,32.8,18,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (311,73,15,3,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (312,41,9.65,12,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (312,55,24,18,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (313,30,25.89,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (313,62,49.3,15,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (314,44,19.45,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (314,51,53,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (315,33,2.5,20,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (315,62,49.3,10,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (316,36,19,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (316,52,7,70,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (317,17,39,16,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (317,31,12.5,6,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (317,55,24,25,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (318,24,4.5,25,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (318,64,33.25,18,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (319,11,21,35,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (319,18,62.5,18,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (319,76,18,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (320,31,12.5,60,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (320,51,53,3,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (320,59,55,40,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (321,10,31,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (322,31,12.5,35,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (322,76,18,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (323,11,21,15,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (323,56,38,60,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (324,14,23.25,11,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (324,42,14,28,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (325,16,17.45,12,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (325,32,32,10,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (325,40,18.4,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (325,75,7.75,15,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (326,17,39,18,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (326,34,14,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (326,53,32.8,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (327,33,2.5,14,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (327,40,18.4,2,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (327,62,49.3,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (327,64,33.25,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (328,59,55,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (328,63,43.9,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (328,72,34.8,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (328,76,18,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (329,1,18,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (329,31,12.5,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (329,44,19.45,21,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (330,39,18,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (330,75,7.75,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (330,77,13,18,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (331,35,18,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (331,57,19.5,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (332,15,15.5,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (332,75,7.75,21,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (333,14,23.25,15,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (333,41,9.65,9,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (333,65,21.05,30,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (334,75,7.75,50,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (335,57,19.5,4,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (335,76,18,14,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (336,29,123.79,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (336,60,34,24,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (336,69,36,10,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (337,31,12.5,50,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (338,47,9.5,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (339,52,7,4,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (340,26,31.23,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (340,35,18,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (340,77,13,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (341,18,62.5,40,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (341,42,14,100,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (342,35,18,4,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (343,1,18,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (343,77,13,60,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (344,3,10,14,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (344,7,30,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (344,54,7.45,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (345,15,15.5,25,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (345,26,31.23,5,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (346,20,81,21,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (346,69,36,20,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (346,76,18,4,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (347,52,7,24,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (347,58,13.25,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (348,35,18,30,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (348,61,28.5,120,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (348,69,36,65,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (349,56,38,5,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (349,63,43.9,24,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (349,75,7.75,30,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (350,24,4.5,35,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (350,57,19.5,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (350,65,21.05,12,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (351,27,43.9,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (351,71,21.5,9,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (352,62,49.3,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (353,54,7.45,4,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (353,73,15,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (354,13,6,60,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (354,59,55,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (355,77,13,5,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (356,22,21,48,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (356,49,20,25,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (357,48,12.75,6,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (357,76,18,10,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (358,16,17.45,30,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (358,59,55,20,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (358,60,34,70,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (358,71,21.5,15,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (359,4,22,20,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (359,55,24,20,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (359,62,49.3,10,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (360,7,30,45,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (360,17,39,100,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (360,33,2.5,14,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (360,40,18.4,42,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (360,72,34.8,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (361,56,38,28,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (362,1,18,3,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (362,10,31,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (362,21,10,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (363,36,19,21,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (364,1,18,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (364,2,19,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (364,60,34,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (365,10,31,70,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (365,36,19,55,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (365,49,20,18,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (365,60,34,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (365,76,18,80,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (366,13,6,8,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (366,75,7.75,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (367,11,21,14,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (367,21,10,8,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (367,39,18,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (368,55,24,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (369,38,263.5,15,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (369,56,38,14,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (369,70,15,15,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (369,71,21.5,15,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (370,59,55,30,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (371,6,25,70,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (371,56,38,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (371,68,12.5,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (372,21,10,42,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (372,22,21,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (373,24,4.5,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (373,52,7,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (374,19,9.2,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (374,23,9,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (374,70,15,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (374,71,21.5,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (375,2,19,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (375,68,12.5,18,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (376,14,23.25,21,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (376,19,9.2,15,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (376,21,10,25,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (376,24,4.5,3,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (376,35,18,30,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (377,28,45.6,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (377,29,123.79,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (377,44,19.45,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (378,14,23.25,3,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (378,42,14,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (378,60,34,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (379,53,32.8,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (379,60,34,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (379,71,21.5,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (380,62,49.3,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (380,73,15,35,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (381,1,18,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (382,29,123.79,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (382,64,33.25,9,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (383,55,24,12,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (383,76,18,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (384,75,7.75,8,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (385,2,19,30,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (385,33,2.5,20,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (386,12,38,36,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (386,13,6,13,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (386,26,31.23,35,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (386,62,49.3,80,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (387,7,30,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (387,18,62.5,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (387,51,53,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (387,75,7.75,2,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (388,4,22,10,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (388,5,21.35,15,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (388,22,21,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (389,4,22,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (389,58,13.25,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (390,11,21,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (390,50,16.25,25,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (390,56,38,60,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (391,45,9.5,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (391,65,21.05,21,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (391,72,34.8,60,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (392,18,62.5,8,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (393,69,36,20,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (393,70,15,15,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (394,2,19,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (394,40,18.4,60,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (395,21,10,30,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (395,61,28.5,20,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (396,28,45.6,15,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (396,39,18,21,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (396,46,12,2,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (397,18,62.5,4,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (397,43,46,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (397,46,12,21,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (398,18,62.5,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (398,36,19,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (399,1,18,15,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (399,10,31,18,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (399,71,21.5,30,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (399,77,13,35,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (400,19,9.2,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (400,39,18,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (401,22,21,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (401,24,4.5,15,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (402,28,45.6,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (402,72,34.8,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (403,30,25.89,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (403,53,32.8,25,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (403,54,7.45,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (404,19,9.2,12,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (404,22,21,20,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (405,30,25.89,2,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (405,42,14,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (406,16,17.45,30,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (406,60,34,20,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (407,4,22,12,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (407,39,18,20,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (407,54,7.45,6,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (408,41,9.65,20,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (409,14,23.25,3,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (409,44,19.45,28,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (409,47,9.5,6,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (410,15,15.5,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (410,41,9.65,24,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (410,46,12,45,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (410,47,9.5,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (410,56,38,45,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (410,60,34,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (411,21,10,60,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (411,40,18.4,70,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (411,60,34,55,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (411,77,13,70,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (412,31,12.5,20,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (412,40,18.4,24,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (412,70,15,40,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (413,20,81,21,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (414,39,18,3,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (414,58,13.25,49,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (415,68,12.5,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (416,40,18.4,30,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (416,42,14,30,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (416,51,53,20,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (417,10,31,24,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (417,56,38,12,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (417,65,21.05,15,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (418,51,53,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (418,59,55,1,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (418,76,18,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (419,29,123.79,36,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (419,65,21.05,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (420,69,36,45,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (420,71,21.5,14,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (421,31,12.5,8,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (421,55,24,4,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (421,64,33.25,15,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (422,36,19,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (423,23,9,32,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (423,46,12,60,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (423,67,14,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (423,73,15,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (423,75,7.75,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (424,16,17.45,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (424,62,49.3,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (424,65,21.05,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (425,38,263.5,15,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (425,71,21.5,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (426,16,17.45,3,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (426,42,14,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (426,43,46,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (427,23,9,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (428,14,23.25,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (428,53,32.8,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (428,58,13.25,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (429,10,31,2,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (429,19,9.2,7,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (429,44,19.45,21,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (430,26,31.23,30,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (430,33,2.5,8,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (431,12,38,100,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (431,33,2.5,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (431,41,9.65,120,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (431,54,7.45,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (432,59,55,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (433,16,17.45,50,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (433,31,12.5,20,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (433,42,14,40,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (434,19,9.2,30,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (434,21,10,12,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (434,64,33.25,28,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (435,33,2.5,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (435,66,17,4,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (435,75,7.75,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (436,52,7,9,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (437,40,18.4,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (437,47,9.5,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (437,60,34,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (438,10,31,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (438,41,9.65,4,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (438,47,9.5,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (439,17,39,30,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (439,26,31.23,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (440,9,97,50,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (440,29,123.79,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (440,36,19,6,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (441,10,31,18,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (441,28,45.6,60,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (441,34,14,14,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (442,1,18,35,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (443,56,38,20,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (443,77,13,30,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (444,1,18,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (444,29,123.79,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (444,43,46,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (444,44,19.45,24,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (444,62,49.3,48,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (445,63,43.9,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (446,9,97,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (446,54,7.45,60,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (446,69,36,30,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (446,73,15,15,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (447,7,30,90,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (447,59,55,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (447,70,15,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (448,8,40,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (448,12,38,4,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (448,24,4.5,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (449,17,39,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (449,46,12,18,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (450,19,9.2,7,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (450,35,18,9,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (450,58,13.25,30,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (450,70,15,30,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (451,11,21,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (451,17,39,8,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (451,29,123.79,12,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (451,65,21.05,65,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (451,70,15,8,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (452,47,9.5,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (453,1,18,5,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (453,34,14,12,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (453,68,12.5,40,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (453,71,21.5,60,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (454,59,55,42,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (454,71,21.5,20,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (454,76,18,35,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (455,3,10,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (455,76,18,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (456,2,19,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (456,59,55,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (456,73,15,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (457,4,22,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (457,24,4.5,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (457,48,12.75,24,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (458,31,12.5,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (458,32,32,4,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (459,16,17.45,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (459,43,46,24,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (459,59,55,8,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (460,55,24,21,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (460,57,19.5,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (460,70,15,28,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (461,5,21.35,4,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (461,36,19,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (462,8,40,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (462,51,53,28,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (462,60,34,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (463,19,9.2,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (463,47,9.5,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (464,19,9.2,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (464,41,9.65,42,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (464,53,32.8,120,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (465,53,32.8,3,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (465,56,38,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (466,10,31,18,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (466,26,31.23,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (466,45,9.5,110,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (466,46,12,24,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (467,2,19,30,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (467,17,39,27,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (467,47,9.5,50,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (467,56,38,18,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (467,58,13.25,12,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (468,10,31,21,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (468,71,21.5,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (469,21,10,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (469,51,53,7,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (469,61,28.5,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (470,21,10,32,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (470,54,7.45,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (470,69,36,25,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (471,12,38,36,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (471,16,17.45,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (471,36,19,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (471,62,49.3,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (472,18,62.5,12,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (472,30,25.89,3,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (472,54,7.45,40,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (473,35,18,21,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (473,71,21.5,8,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (474,44,19.45,50,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (475,2,19,3,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (475,31,12.5,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (475,68,12.5,45,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (475,75,7.75,42,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (476,26,31.23,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (477,10,31,16,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (477,61,28.5,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (478,41,9.65,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (478,52,7,4,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (478,55,24,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (479,4,22,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (479,11,21,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (480,17,39,20,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (480,56,38,10,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (480,59,55,10,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (481,30,25.89,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (481,40,18.4,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (481,55,24,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (481,60,34,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (482,1,18,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (482,21,10,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (482,50,16.25,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (483,16,17.45,15,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (483,31,12.5,3,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (483,65,21.05,10,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (484,21,10,40,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (484,51,53,30,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (485,76,18,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (486,14,23.25,16,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (486,28,45.6,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (486,52,7,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (487,6,25,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (487,30,25.89,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (487,76,18,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (488,61,28.5,20,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (488,77,13,2,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (489,65,21.05,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (489,75,7.75,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (490,13,6,4,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (490,41,9.65,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (491,16,17.45,3,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (492,36,19,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (492,52,7,18,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (493,28,45.6,5,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (493,35,18,35,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (493,45,9.5,40,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (493,56,38,14,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (494,2,19,15,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (495,3,10,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (495,60,34,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (495,72,34.8,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (496,46,12,28,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (497,40,18.4,50,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (498,18,62.5,24,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (498,44,19.45,16,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (498,59,55,45,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (498,72,34.8,7,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (499,13,6,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (499,42,14,28,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (499,62,49.3,9,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (499,69,36,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (500,31,12.5,8,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (500,41,9.65,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (500,63,43.9,9,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (500,69,36,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (501,23,9,44,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (501,40,18.4,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (501,56,38,28,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (502,56,38,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (502,59,55,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (502,76,18,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (503,14,23.25,5,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (503,45,9.5,40,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (503,59,55,25,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (504,26,31.23,12,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (504,30,25.89,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (504,50,16.25,20,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (504,73,15,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (505,1,18,8,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (505,69,36,3,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (506,45,9.5,4,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (506,74,10,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (507,40,18.4,3,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (508,47,9.5,30,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (508,56,38,30,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (508,57,19.5,14,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (508,69,36,25,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (509,18,62.5,21,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (509,36,19,20,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (509,68,12.5,6,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (509,69,36,20,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (510,34,14,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (510,59,55,7,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (510,62,49.3,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (510,64,33.25,24,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (511,26,31.23,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (511,52,7,60,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (511,70,15,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (512,32,32,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (513,25,14,12,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (513,27,43.9,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (513,43,46,30,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (514,25,14,35,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (514,75,7.75,18,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (515,39,18,16,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (515,47,9.5,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (515,51,53,28,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (515,56,38,60,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (516,21,10,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (516,22,21,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (516,24,4.5,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (517,3,10,20,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (517,39,18,130,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (518,65,21.05,80,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (519,2,19,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (519,7,30,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (519,68,12.5,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (520,42,14,2,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (521,22,21,4,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (521,31,12.5,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (521,60,34,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (521,71,21.5,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (522,41,9.65,30,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (522,52,7,15,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (522,61,28.5,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (522,62,49.3,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (523,11,21,15,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (524,71,21.5,16,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (525,29,123.79,18,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (525,59,55,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (526,17,39,33,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (526,31,12.5,70,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (526,75,7.75,7,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (527,31,12.5,2,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (527,66,17,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (528,10,31,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (528,67,14,3,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (529,31,12.5,16,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (529,42,14,12,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (529,45,9.5,27,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (529,51,53,120,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (530,42,14,20,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (531,41,9.65,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (532,16,17.45,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (532,62,49.3,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (533,70,15,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (533,77,13,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (534,54,7.45,3,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (534,56,38,20,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (534,74,10,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (535,31,12.5,1,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (536,31,12.5,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (536,38,263.5,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (537,36,19,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (537,39,18,2,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (537,72,34.8,30,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (538,10,31,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (538,75,7.75,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (539,8,40,30,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (539,30,25.89,15,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (539,75,7.75,42,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (540,2,19,15,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (540,29,123.79,20,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (541,19,9.2,50,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (541,75,7.75,40,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (542,18,62.5,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (542,35,18,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (542,63,43.9,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (542,68,12.5,18,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (543,7,30,3,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (543,56,38,20,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (544,29,123.79,14,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (544,41,9.65,20,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (545,2,19,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (545,54,7.45,3,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (545,68,12.5,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (546,41,9.65,14,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (546,52,7,8,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (547,14,23.25,15,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (547,54,7.45,6,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (548,16,17.45,65,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (548,17,39,35,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (549,26,31.23,21,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (549,44,19.45,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (549,64,33.25,35,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (549,69,36,24,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (550,11,21,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (551,62,49.3,2,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (551,72,34.8,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (552,13,6,20,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (552,24,4.5,20,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (552,59,55,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (553,11,21,50,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (553,51,53,10,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (553,54,7.45,7,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (554,17,39,40,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (554,29,123.79,20,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (555,30,25.89,25,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (555,51,53,30,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (555,55,24,60,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (555,62,49.3,5,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (556,19,9.2,24,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (556,25,14,15,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (556,59,55,15,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (557,10,31,36,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (557,28,45.6,24,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (557,49,20,4,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (558,34,14,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (558,38,263.5,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (559,2,19,20,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (559,65,21.05,2,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (559,74,10,15,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (560,40,18.4,1,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (561,56,38,20,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (561,76,18,50,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (562,52,7,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (563,13,6,7,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (563,25,14,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (563,70,15,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (564,19,9.2,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (564,23,9,18,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (564,40,18.4,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (565,31,12.5,16,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (565,72,34.8,40,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (565,77,13,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (566,2,19,12,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (566,46,12,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (567,41,9.65,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (567,43,46,20,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (567,48,12.75,8,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (567,61,28.5,30,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (568,33,2.5,16,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (569,38,263.5,30,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (569,62,49.3,20,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (570,26,31.23,40,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (570,38,263.5,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (570,40,18.4,60,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (570,62,49.3,25,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (571,32,32,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (571,41,9.65,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (572,43,46,7,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (572,75,7.75,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (573,56,38,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (574,35,18,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (574,51,53,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (575,62,49.3,3,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (575,70,15,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (576,11,21,20,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (576,57,19.5,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (576,59,55,40,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (576,77,13,15,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (577,41,9.65,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (577,70,15,9,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (578,26,31.23,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (578,53,32.8,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (579,31,12.5,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (579,57,19.5,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (580,10,31,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (580,39,18,21,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (581,20,81,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (581,38,263.5,2,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (582,2,19,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (582,8,40,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (582,13,6,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (582,60,34,21,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (583,6,25,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (583,39,18,28,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (583,60,34,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (583,68,12.5,24,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (584,19,9.2,2,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (584,35,18,8,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (584,38,263.5,8,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (584,43,46,9,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (585,13,6,3,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (585,25,14,10,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (585,44,19.45,16,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (585,64,33.25,3,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (586,7,30,20,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (586,31,12.5,9,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (586,53,32.8,9,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (587,29,123.79,8,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (587,30,25.89,20,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (588,59,55,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (588,77,13,2,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (589,22,21,52,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (589,35,18,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (589,57,19.5,24,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (589,60,34,60,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (589,64,33.25,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (590,13,6,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (590,40,18.4,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (590,47,9.5,40,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (590,76,18,21,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (591,1,18,4,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (591,18,62.5,25,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (591,36,19,50,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (592,58,13.25,30,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (592,72,34.8,15,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (593,25,14,6,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (593,39,18,10,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (594,10,31,16,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (594,56,38,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (594,59,55,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (594,77,13,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (595,11,21,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (595,43,46,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (595,68,12.5,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (595,70,15,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (596,51,53,4,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (597,22,21,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (598,23,9,70,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (598,35,18,25,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (598,42,14,42,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (598,58,13.25,60,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (598,64,33.25,48,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (599,4,22,21,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (599,70,15,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (599,74,10,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (600,1,18,80,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (600,19,9.2,12,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (600,37,26,60,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (600,45,9.5,36,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (600,60,34,45,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (600,71,21.5,55,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (601,5,21.35,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (601,9,97,3,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (602,3,10,49,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (602,26,31.23,18,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (603,25,14,20,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (603,33,2.5,4,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (603,70,15,30,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (604,2,19,5,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (604,25,14,10,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (604,57,19.5,10,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (604,59,55,42,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (605,2,19,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (605,17,39,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (605,62,49.3,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (606,18,62.5,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (607,10,31,100,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (607,13,6,65,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (608,16,17.45,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (608,31,12.5,14,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (608,56,38,24,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (608,65,21.05,15,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (609,2,19,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (609,42,14,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (610,3,10,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (610,26,31.23,35,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (610,29,123.79,10,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (611,7,30,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (611,27,43.9,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (611,70,15,4,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (612,24,4.5,40,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (612,54,7.45,35,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (612,64,33.25,30,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (613,51,53,3,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (613,76,18,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (614,17,39,42,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (614,18,62.5,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (614,21,10,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (614,33,2.5,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (614,62,49.3,3,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (615,11,21,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (615,52,7,8,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (616,1,18,20,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (616,58,13.25,12,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (617,35,18,4,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (617,67,14,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (618,38,263.5,60,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (618,39,18,80,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (619,2,19,21,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (619,24,4.5,6,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (619,30,25.89,40,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (620,53,32.8,3,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (621,26,31.23,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (621,35,18,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (621,49,20,42,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (622,1,18,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (622,11,21,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (622,23,9,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (622,68,12.5,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (623,35,18,3,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (623,51,53,2,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (624,6,25,50,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (624,16,17.45,12,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (624,17,39,16,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (625,55,24,10,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (625,62,49.3,20,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (625,64,33.25,15,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (625,65,21.05,21,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (626,21,10,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (626,28,45.6,3,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (627,10,31,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (628,19,9.2,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (628,47,9.5,21,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (628,49,20,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (629,46,12,21,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (629,64,33.25,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (630,16,17.45,30,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (630,18,62.5,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (631,20,81,20,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (632,40,18.4,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (632,65,21.05,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (632,76,18,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (633,23,9,30,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (633,61,28.5,30,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (633,70,15,50,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (634,73,15,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (635,42,14,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (635,49,20,20,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (635,54,7.45,32,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (636,24,4.5,8,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (637,21,10,40,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (637,56,38,21,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (637,65,21.05,12,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (638,2,19,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (638,24,4.5,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (638,70,15,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (638,77,13,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (639,10,31,70,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (639,31,12.5,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (639,77,13,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (640,25,14,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (641,2,19,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (641,68,12.5,18,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (642,11,21,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (642,38,263.5,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (643,17,39,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (643,34,14,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (643,41,9.65,14,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (644,30,25.89,15,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (645,59,55,40,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (646,8,40,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (646,24,4.5,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (646,29,123.79,24,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (646,30,25.89,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (646,36,19,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (647,13,6,28,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (647,69,36,50,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (647,75,7.75,120,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (648,24,4.5,110,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (648,39,18,45,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (648,40,18.4,91,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (648,60,34,100,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (649,45,9.5,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (649,56,38,16,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (650,29,123.79,80,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (650,30,25.89,36,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (651,13,6,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (652,39,18,8,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (653,70,15,3,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (654,41,9.65,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (654,71,21.5,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (655,55,24,30,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (655,62,49.3,6,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (656,13,6,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (656,65,21.05,21,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (656,68,12.5,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (657,58,13.25,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (657,62,49.3,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (658,1,18,20,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (659,61,28.5,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (660,75,7.75,14,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (661,7,30,20,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (661,52,7,14,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (662,7,30,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (662,16,17.45,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (662,41,9.65,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (663,19,9.2,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (663,49,20,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (663,61,28.5,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (664,1,18,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (664,17,39,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (664,67,14,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (665,11,21,40,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (665,29,123.79,60,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (666,4,22,30,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (666,33,2.5,40,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (666,58,13.25,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (667,71,21.5,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (668,17,39,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (668,33,2.5,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (668,54,7.45,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (669,16,17.45,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (669,32,32,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (669,57,19.5,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (670,30,25.89,1,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (670,60,34,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (671,1,18,60,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (671,60,34,25,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (672,16,17.45,24,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (672,25,14,24,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (672,40,18.4,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (673,50,16.25,24,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (674,35,18,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (674,63,43.9,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (675,17,39,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (675,24,4.5,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (676,42,14,10,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (676,43,46,10,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (676,67,14,24,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (677,10,31,20,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (677,28,45.6,30,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (677,75,7.75,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (678,36,19,25,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (678,52,7,12,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (679,11,21,2,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (679,13,6,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (679,19,9.2,7,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (679,72,34.8,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (680,20,81,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (680,52,7,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (680,76,18,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (681,47,9.5,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (681,76,18,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (682,21,10,60,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (682,75,7.75,49,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (682,77,13,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (683,21,10,36,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (683,27,43.9,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (683,55,24,25,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (683,58,13.25,30,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (684,13,6,42,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (684,57,19.5,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (685,16,17.45,30,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (685,62,49.3,14,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (685,72,34.8,16,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (685,75,7.75,20,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (686,53,32.8,2,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (686,61,28.5,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (687,6,25,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (688,1,18,21,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (688,18,62.5,4,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (688,23,9,8,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (689,36,19,30,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (690,28,45.6,8,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (690,34,14,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (691,13,6,20,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (691,43,46,24,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (691,60,34,49,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (691,71,21.5,35,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (692,2,19,10,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (692,67,14,40,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (693,7,30,8,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (693,13,6,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (694,31,12.5,44,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (694,62,49.3,30,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (694,68,12.5,80,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (694,72,34.8,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (695,49,20,28,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (696,13,6,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (696,22,21,21,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (696,46,12,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (697,11,21,5,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (697,44,19.45,18,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (697,56,38,18,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (698,13,6,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (698,31,12.5,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (699,10,31,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (699,24,4.5,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (699,77,13,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (700,59,55,4,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (701,50,16.25,9,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (701,51,53,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (701,55,24,4,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (702,6,25,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (702,10,31,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (702,17,39,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (702,62,49.3,60,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (703,4,22,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (704,33,2.5,15,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (704,41,9.65,6,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (704,75,7.75,50,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (705,6,25,16,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (705,28,45.6,2,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (706,20,81,50,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (706,31,12.5,50,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (707,16,17.45,28,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (707,31,12.5,25,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (707,45,9.5,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (707,60,34,24,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (708,75,7.75,12,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (709,21,10,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (709,47,9.5,14,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (709,51,53,8,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (710,30,25.89,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (710,35,18,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (710,64,33.25,8,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (711,5,21.35,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (711,7,30,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (711,72,34.8,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (712,75,7.75,20,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (713,24,4.5,10,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (713,41,9.65,24,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (714,52,7,6,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (714,76,18,60,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (715,7,30,45,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (715,13,6,77,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (715,53,32.8,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (715,69,36,9,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (715,76,18,44,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (716,60,34,2,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (717,18,62.5,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (717,38,263.5,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (717,69,36,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (718,51,53,16,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (719,37,26,8,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (719,56,38,12,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (719,62,49.3,12,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (720,19,9.2,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (720,49,20,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (721,12,38,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (721,24,4.5,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (721,64,33.25,4,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (722,46,12,9,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (723,52,7,40,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (724,29,123.79,14,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (725,17,39,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (725,33,2.5,7,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (726,26,31.23,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (726,41,9.65,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (726,75,7.75,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (727,63,43.9,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (728,8,40,16,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (728,75,7.75,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (729,28,45.6,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (730,39,18,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (730,47,9.5,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (730,51,53,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (730,63,43.9,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (731,8,40,20,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (731,21,10,40,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (731,40,18.4,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (731,44,19.45,6,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (732,7,30,18,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (732,12,38,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (732,24,4.5,80,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (732,27,43.9,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (732,31,12.5,24,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (732,63,43.9,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (733,75,7.75,40,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (734,38,263.5,60,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (735,7,30,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (735,43,46,9,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (736,13,6,84,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (736,57,19.5,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (737,16,17.45,55,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (737,24,4.5,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (737,36,19,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (738,16,17.45,36,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (738,18,62.5,8,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (738,32,32,35,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (739,11,21,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (739,20,81,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (739,76,18,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (739,77,13,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (740,7,30,60,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (740,43,46,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (740,72,34.8,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (741,7,30,60,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (741,62,49.3,40,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (742,6,25,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (742,11,21,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (742,41,9.65,4,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (743,21,10,65,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (743,34,14,60,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (743,55,24,65,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (743,61,28.5,66,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (744,2,19,50,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (744,70,15,20,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (744,76,18,90,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (745,72,34.8,2,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (746,29,123.79,50,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (746,41,9.65,35,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (747,59,55,18,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (748,51,53,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (748,60,34,4,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (749,42,14,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (750,32,32,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (750,46,12,20,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (750,52,7,20,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (751,24,4.5,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (751,61,28.5,7,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (751,74,10,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (751,75,7.75,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (752,41,9.65,20,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (752,51,53,15,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (752,77,13,21,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (753,4,22,25,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (753,24,4.5,30,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (753,77,13,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (754,7,30,60,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (754,22,21,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (754,46,12,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (754,55,24,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (755,13,6,56,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (755,35,18,15,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (755,42,14,24,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (755,55,24,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (756,1,18,4,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (756,40,18.4,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (756,52,7,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (757,26,31.23,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (757,76,18,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (758,1,18,2,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (758,59,55,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (759,1,18,8,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (759,29,123.79,2,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (760,8,40,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (760,29,123.79,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (760,42,14,14,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (761,28,45.6,70,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (761,34,14,90,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (761,71,21.5,21,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (762,24,4.5,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (762,36,19,18,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (762,60,34,9,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (763,7,30,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (763,24,4.5,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (764,58,13.25,40,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (764,71,21.5,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (765,19,9.2,50,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (765,60,34,36,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (765,71,21.5,60,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (766,23,9,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (766,42,14,4,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (766,45,9.5,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (766,68,12.5,2,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (767,41,9.65,28,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (768,30,25.89,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (768,77,13,18,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (769,31,12.5,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (769,36,19,16,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (770,3,10,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (770,59,55,110,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (770,70,15,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (771,12,38,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (771,18,62.5,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (771,56,38,5,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (772,46,12,3,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (772,49,20,2,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (773,10,31,24,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (774,2,19,11,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (774,20,81,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (774,26,31.23,63,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (774,51,53,44,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (774,72,34.8,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (775,19,9.2,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (775,69,36,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (776,7,30,4,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (776,43,46,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (777,26,31.23,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (777,33,2.5,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (777,65,21.05,21,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (777,71,21.5,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (778,1,18,10,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (778,13,6,20,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (779,18,62.5,8,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (779,51,53,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (780,24,4.5,30,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (780,62,49.3,21,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (781,55,24,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (781,59,55,24,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (782,56,38,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (782,63,43.9,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (783,2,19,100,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (783,5,21.35,70,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (783,29,123.79,60,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (783,59,55,100,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (784,1,18,45,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (784,13,6,80,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (784,24,4.5,21,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (784,64,33.25,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (784,71,21.5,16,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (785,36,19,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (785,38,263.5,25,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (785,59,55,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (786,53,32.8,70,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (786,69,36,36,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (787,21,10,15,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (787,44,19.45,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (787,61,28.5,6,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (788,1,18,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (788,35,18,60,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (788,42,14,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (788,54,7.45,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (789,13,6,7,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (789,59,55,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (790,70,15,4,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (791,40,18.4,5,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (791,52,7,2,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (791,71,21.5,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (792,28,45.6,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (792,35,18,24,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (792,49,20,60,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (792,57,19.5,28,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (793,21,10,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (794,2,19,30,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (794,63,43.9,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (795,44,19.45,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (795,61,28.5,4,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (796,11,21,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (797,62,49.3,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (798,33,2.5,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (798,51,53,24,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (799,12,38,20,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (799,32,32,15,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (799,35,18,18,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (800,1,18,25,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (800,5,21.35,30,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (801,68,12.5,42,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (802,2,19,10,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (802,12,38,4,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (803,76,18,50,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (804,24,4.5,10,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (805,43,46,30,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (805,61,28.5,10,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (806,18,62.5,35,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (806,32,32,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (806,64,33.25,25,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (807,33,2.5,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (807,67,14,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (808,24,4.5,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (808,25,14,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (808,51,53,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (808,57,19.5,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (809,7,30,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (809,55,24,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (809,60,34,50,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (810,70,15,3,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (811,21,10,3,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (811,60,34,21,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (811,61,28.5,4,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (812,13,6,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (812,17,39,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (812,60,34,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (813,60,34,4,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (813,77,13,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (814,60,34,15,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (815,53,32.8,10,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (815,70,15,12,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (816,34,14,30,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (816,40,18.4,40,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (816,41,9.65,30,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (817,17,39,77,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (817,41,9.65,12,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (817,53,32.8,25,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (817,55,24,4,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (817,68,12.5,55,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (818,30,25.89,4,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (818,54,7.45,20,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (819,16,17.45,3,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (819,19,9.2,42,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (819,34,14,35,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (820,41,9.65,9,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (821,28,45.6,8,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (821,43,46,36,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (821,77,13,28,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (822,39,18,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (823,1,18,40,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (823,2,19,20,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (823,16,17.45,30,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (823,31,12.5,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (824,7,30,15,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (824,13,6,10,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (825,2,19,8,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (825,41,9.65,40,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (825,50,16.25,22,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (825,64,33.25,130,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (826,11,21,10,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (826,24,4.5,20,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (827,16,17.45,14,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (828,2,19,10,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (828,46,12,30,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (828,76,18,2,.15000000596046448);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (829,6,25,20,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (829,14,23.25,20,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (829,19,9.2,10,.25);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (830,2,19,24,.20000000298023224);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (830,3,10,4,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (830,4,22,1,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (830,6,25,1,.019999999552965164);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (830,7,30,1,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (830,8,40,2,.10000000149011612);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (830,10,31,1,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (830,12,38,2,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (830,13,6,4,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (830,14,23.25,1,.029999999329447746);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (830,16,17.45,2,.029999999329447746);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (830,20,81,1,.03999999910593033);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (830,23,9,2,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (830,32,32,1,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (830,39,18,2,.05000000074505806);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (830,41,9.65,3,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (830,46,12,3,.019999999552965164);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (830,52,7,2,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (830,55,24,2,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (830,60,34,2,.05999999865889549);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (830,64,33.25,2,.029999999329447746);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (830,66,17,1,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (830,73,15,2,.009999999776482582);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (830,75,7.75,4,0);
INSERT INTO OrderDetails (ORDERID,PRODUCTID,UNITPRICE,QUANTITY,DISCOUNT) VALUES (830,77,13,2,0);

/* Commit changes */
COMMIT;


INSERT INTO Region (RegionDescription) VALUES ('Eastern');
INSERT INTO Region (RegionDescription) VALUES ('Western');
INSERT INTO Region (RegionDescription) VALUES ('Northern');
INSERT INTO Region (RegionDescription) VALUES ('Southern');

/* Commit changes */
COMMIT;