SELECT e.FirstName, e.LastName, o.OrderID
FROM Employees e JOIN Orders o ON
    (e.EmployeeID = o.EmployeeID)
WHERE o.RequiredDate < o.ShippedDate
ORDER BY e.LastName, e.FirstName;

SELECT p.ProductName, SUM(od.Quantity) AS TotalUnits
FROM OrderDetails od JOIN Products p ON
    (p.ProductID = od.ProductID)
GROUP BY p.ProductName
HAVING SUM(Quantity) < 200;

/******************************
For the third problem, both of the solutions below will work in SQL Server

Oracle Solution
******************************/
SELECT c.CompanyName, COUNT(o.OrderID) AS NumOrders
FROM Customers c JOIN Orders o ON
    (c.CustomerID = o.CustomerID)
WHERE OrderDate > '31-Dec-1996'
GROUP BY c.CompanyName
HAVING COUNT(o.OrderID) > 15
ORDER BY NumOrders DESC;

/******************************
MySQL
******************************/
SELECT c.CompanyName, COUNT(o.OrderID) AS NumOrders
FROM Customers c JOIN Orders o ON
    (c.CustomerID = o.CustomerID)
WHERE OrderDate > '1996-12-31'
GROUP BY c.CompanyName
HAVING COUNT(o.OrderID) > 15
ORDER BY NumOrders DESC;

SELECT c.CompanyName, o.OrderID,
    od.UnitPrice * od.Quantity * (1-od.Discount) AS TotalPrice
FROM OrderDetails od
    JOIN Orders o ON (o.OrderID = od.OrderID)
    JOIN Customers c ON (c.CustomerID = o.CustomerID)
WHERE od.UnitPrice * od.Quantity * (1-od.Discount) > 10000
ORDER BY TotalPrice DESC;

/*
    SQL Server users will replace OrderDetails with OrderDetails
*/