/*
    Create a report that shows the number of
    employees and customers from each city.
    
    Note that MySQL does NOT support full outer joins.
*/

SELECT COUNT(DISTINCT e.EmployeeID) AS numEmployees,
    COUNT(DISTINCT c.CustomerID) AS numCompanies,
    e.City, c.City
FROM Employees e FULL JOIN Customers c ON
    (e.City = c.City)
GROUP BY e.City, c.City
ORDER BY numEmployees DESC;