-- Find the EmployeeID and OrderID for all orders

SELECT EmployeeID, OrderID
FROM Orders;

--------------------------

-- Create a report showing employee orders.

SELECT Employees.EmployeeID, Employees.FirstName,
    Employees.LastName, Orders.OrderID, Orders.OrderDate
FROM Employees JOIN Orders ON
    (Employees.EmployeeID = Orders.EmployeeID)
ORDER BY Orders.OrderDate;

--------------------------

-- Create a report showing employee orders using Aliases.

SELECT e.EmployeeID, e.FirstName, e.LastName,
    o.OrderID, o.OrderDate
FROM Employees e JOIN Orders o ON
    (e.EmployeeID = o.EmployeeID)
ORDER BY o.OrderDate;

--------------------------

/*
Create a report showing the Order ID, the name of the company that placed the order,
and the first and last name of the associated employee.
Only show orders placed after January 1, 1998 that shipped after they were required.
Sort by Company Name.
*/

SELECT o.OrderID, c.CompanyName, e.FirstName, e.LastName
FROM Orders o
    JOIN Employees e ON (e.EmployeeID = o.EmployeeID)
    JOIN Customers c ON (c.CustomerID = o.CustomerID)
WHERE o.ShippedDate > o.RequiredDate AND o.OrderDate > '1-1-1998'
ORDER BY c.CompanyName;