/*
Create a report showing the title and the first and last name
of all sales representatives.
*/

SELECT Title, FirstName, LastName
FROM Employees
WHERE Title = 'Sales Representative';

--------------------------
/*
Create a report showing the first and last name of all employees
excluding sales representatives.
*/

SELECT FirstName, LastName
FROM Employees
WHERE Title <> 'Sales Representative';

--------------------------
/*
Create a report showing the first and last name of all employees whose
last names start with a letter in the last half of the alphabet.
*/

SELECT FirstName, LastName
FROM Employees
WHERE LastName >= 'N';

--------------------------
/*
Create a report showing the first and last name of
all employees who are not in a specified region.
*/

SELECT FirstName, LastName
FROM Employees
WHERE Region IS NULL;

--------------------------
/*
Create a report showing the first and last name of all
employees who are in a specified region.
*/

SELECT FirstName, LastName
FROM Employees
WHERE Region IS NOT NULL;

--------------------------
/*
Create a report showing the first and last name of all employees whose last names
start with a letter in the last half of the alphabet.
Sort by LastName in descending order.
*/

SELECT FirstName, LastName
FROM Employees
WHERE LastName >= 'N'
ORDER BY LastName DESC;