CREATE TABLE Suppliers2
(
    SupplierID int PRIMARY KEY,
    CompanyName nvarchar(40) NOT NULL,
    ContactName nvarchar(30) NULL,
    ContactTitle nvarchar(30) NULL,
    Address nvarchar(60) NULL,
    City nvarchar(15) NULL,
    Region nvarchar(15) NULL,
    PostalCode nvarchar(10) NULL,
    Country nvarchar(15) NULL,
    Phone nvarchar(24) NULL,
    Fax nvarchar(24) NULL
)

CREATE TABLE Categories2
(
    CategoryID int PRIMARY KEY,
    CategoryName nvarchar(15) NOT NULL
)

CREATE TABLE Products2
(
    ProductID int PRIMARY KEY,
    ProductName nvarchar(40) NOT NULL,
    SupplierID int FOREIGN KEY REFERENCES Suppliers2(SupplierID),
    CategoryID int FOREIGN KEY REFERENCES Categories2(CategoryID),
    QuantityPerUnit nvarchar(20) NULL,
    UnitPrice decimal(8,2),
    UnitsInStock smallint,
    UnitsOnOrder smallint,
    ReorderLevel smallint NULL
);

-- This solution is for Oracle
--
CREATE TABLE Suppliers2
(
    SupplierID int PRIMARY KEY,
    CompanyName nvarchar2(40) NOT NULL,
    ContactName nvarchar2(30) NULL,
    ContactTitle nvarchar2(30) NULL,
    Address nvarchar2(60) NULL,
    City nvarchar2(15) NULL,
    Region nvarchar2(15) NULL,
    PostalCode nvarchar2(10) NULL,
    Country nvarchar2(15) NULL,
    Phone nvarchar2(24) NULL,
    Fax nvarchar2(24) NULL
);

CREATE TABLE Categories2
(
    CategoryID int PRIMARY KEY,
    CategoryName nvarchar2(15) NOT NULL
);

CREATE TABLE Products2
(
    ProductID int PRIMARY KEY,
    ProductName nvarchar2(40) NOT NULL,
    SupplierID int,
    CategoryID int,
    QuantityPerUnit nvarchar2(20) NULL,
    UnitPrice decimal(8,2),
    UnitsInStock smallint,
    UnitsOnOrder smallint,
    ReorderLevel smallint NULL, 
  CONSTRAINT FK1_products2 FOREIGN KEY (SupplierID)
                          REFERENCES Suppliers2(SupplierID),
  CONSTRAINT FK2_products2 FOREIGN KEY (CategoryID)
                          REFERENCES Categories2(CategoryID)                        
);

-- This solution is for MySQL
--
CREATE TABLE IF NOT EXISTS Suppliers2
(
    SupplierID int PRIMARY KEY,
    CompanyName nvarchar(40) NOT NULL,
    ContactName nvarchar(30) NULL,
    ContactTitle nvarchar(30) NULL,
    Address nvarchar(60) NULL,
    City nvarchar(15) NULL,
    Region nvarchar(15) NULL,
    PostalCode nvarchar(10) NULL,
    Country nvarchar(15) NULL,
    Phone nvarchar(24) NULL,
    Fax nvarchar(24) NULL
);

CREATE TABLE IF NOT EXISTS Categories2
(
    CategoryID int PRIMARY KEY,
    CategoryName nvarchar(15) NOT NULL
);

CREATE TABLE IF NOT EXISTS Products2
(
    ProductID int PRIMARY KEY,
    ProductName nvarchar(40) NOT NULL,
    SupplierID int,
    CategoryID int,
    QuantityPerUnit nvarchar(20) NULL,
    UnitPrice decimal(8,2),
    UnitsInStock smallint,
    UnitsOnOrder smallint,
    ReorderLevel smallint NULL,
  CONSTRAINT FK1_products2 FOREIGN KEY (SupplierID)
                          REFERENCES Suppliers2(SupplierID),
  CONSTRAINT FK2_products2 FOREIGN KEY (CategoryID)
                          REFERENCES Categories2(CategoryID)
);