--
-- This solution is for MySQL
--
CREATE TABLE IF NOT EXISTS Suppliers2
(
    SupplierID int PRIMARY KEY,
    CompanyName nvarchar(40) NOT NULL,
    ContactName nvarchar(30) NULL,
    ContactTitle nvarchar(30) NULL,
    Address nvarchar(60) NULL,
    City nvarchar(15) NULL,
    Region nvarchar(15) NULL,
    PostalCode nvarchar(10) NULL,
    Country nvarchar(15) NULL,
    Phone nvarchar(24) NULL,
    Fax nvarchar(24) NULL
);

CREATE TABLE IF NOT EXISTS Categories2
(
    CategoryID int PRIMARY KEY,
    CategoryName nvarchar(15) NOT NULL
);

CREATE TABLE IF NOT EXISTS Products2
(
    ProductID int PRIMARY KEY,
    ProductName nvarchar(40) NOT NULL,
    SupplierID int,
    CategoryID int,
    QuantityPerUnit nvarchar(20) NULL,
    UnitPrice decimal(8,2),
    UnitsInStock smallint,
    UnitsOnOrder smallint,
    ReorderLevel smallint NULL,
  CONSTRAINT FK1_products2 FOREIGN KEY (SupplierID)
                          REFERENCES Suppliers2(SupplierID),
  CONSTRAINT FK2_products2 FOREIGN KEY (CategoryID)
                          REFERENCES Categories2(CategoryID)
);