CREATE TABLE Employees2
(
    EmployeeID int NOT NULL PRIMARY KEY,
    LastName nvarchar(20) NOT NULL,
    FirstName nvarchar(10) NOT NULL,
    Title nvarchar(30) NULL,
    TitleOfCourtesy nvarchar(25) NULL,
    BirthDate datetime NULL,
    HireDate datetime NULL,
    Address nvarchar(60) NULL,
    City nvarchar(15) NULL,
    Region nvarchar(15) NULL,
    PostalCode nvarchar(10) NULL,
    Country nvarchar(15) NULL,
    HomePhone nvarchar(24) NULL,
    Extension nvarchar(4) NULL,
    ReportsTo int FOREIGN KEY REFERENCES Employees(EmployeeID)
)

CREATE TABLE Customers2
(
    CustomerID nchar(5) PRIMARY KEY,
    CompanyName nvarchar(40) NOT NULL,
    ContactName nvarchar(30) NULL,
    ContactTitle nvarchar(30) NULL,
    Address nvarchar(60) NULL,
    City nvarchar(15) NULL,
    Region nvarchar(15) NULL,
    PostalCode nvarchar(10) NULL,
    Country nvarchar(15) NULL,
    Phone nvarchar(24) NULL,
    Fax nvarchar(24) NULL
)

CREATE TABLE Orders2
(
    OrderID int PRIMARY KEY,
    CustomerID nchar(5) FOREIGN KEY REFERENCES Customers2(CustomerID),
    EmployeeID int FOREIGN KEY REFERENCES Employees2(EmployeeID),
    OrderDate datetime NULL,
    RequiredDate datetime NULL,
    ShippedDate datetime NULL,
    ShipVia int NULL,
    Freight decimal(8, 2) NULL
)