CREATE TABLE Employees2
(
EmployeeID int NOT NULL PRIMARY KEY,
LastName nvarchar2(20) NOT NULL,
FirstName nvarchar2(10) NOT NULL,
Title nvarchar2(30) NULL,
TitleOfCourtesy nvarchar2(25) NULL,
BirthDate date NULL,
HireDate date NULL,
Address nvarchar2(60) NULL,
City nvarchar2(15) NULL,
Region nvarchar2(15) NULL,
PostalCode nvarchar2(10) NULL,
Country nvarchar2(15) NULL,
HomePhone nvarchar2(24) NULL,
Extension nvarchar2(4) NULL,
ReportsTo int REFERENCES Employees(EmployeeID)
);

CREATE TABLE Customers2
(
CustomerID nchar(5) PRIMARY KEY,
CompanyName nvarchar2(40) NOT NULL,
ContactName nvarchar2(30) NULL,
ContactTitle nvarchar2(30) NULL,
Address nvarchar2(60) NULL,
City nvarchar2(15) NULL,
Region nvarchar2(15) NULL,
PostalCode nvarchar2(10) NULL,
Country nvarchar2(15) NULL,
Phone nvarchar2(24) NULL,
Fax nvarchar2(24) NULL
);

CREATE TABLE Orders2
(
OrderID int PRIMARY KEY,
CustomerID nchar(5) REFERENCES Customers2(CustomerID),
EmployeeID int REFERENCES Employees2(EmployeeID),
OrderDate date NULL,
RequiredDate date NULL,
ShippedDate date NULL,
ShipVia int NULL,
Freight decimal(8, 2) NULL
);