CREATE TABLE IF NOT EXISTS Employees2
(
EmployeeID int NOT NULL PRIMARY KEY,
LastName varchar(20) NOT NULL,
FirstName varchar(10) NOT NULL,
Title varchar(30) NULL,
TitleOfCourtesy varchar(25) NULL,
BirthDate date NULL,
HireDate date NULL,
Address varchar(60) NULL,
City varchar(15) NULL,
Region varchar(15) NULL,
PostalCode varchar(10) NULL,
Country varchar(15) NULL,
HomePhone varchar(24) NULL,
Extension varchar(4) NULL,
ReportsTo int REFERENCES Employees(EmployeeID)
);

CREATE TABLE IF NOT EXISTS Customers2
(
CustomerID nchar(5) PRIMARY KEY,
CompanyName varchar(40) NOT NULL,
ContactName varchar(30) NULL,
ContactTitle varchar(30) NULL,
Address varchar(60) NULL,
City varchar(15) NULL,
Region varchar(15) NULL,
PostalCode varchar(10) NULL,
Country varchar(15) NULL,
Phone varchar(24) NULL,
Fax varchar(24) NULL
);

CREATE TABLE IF NOT EXISTS Orders2
(
OrderID int PRIMARY KEY,
CustomerID nchar(5) REFERENCES Customers2(CustomerID),
EmployeeID int REFERENCES Employees2(EmployeeID),
OrderDate date NULL,
RequiredDate date NULL,
ShippedDate date NULL,
ShipVia int NULL,
Freight decimal(8, 2) NULL
);