/******************************
SQL Server
******************************/
SELECT UnitsInStock, UnitPrice,
    UnitsInStock * UnitPrice AS TotalPrice,
    FLOOR(UnitsInStock * UnitPrice) AS TotalPriceDown,
    CEILING(UnitsInStock * UnitPrice) AS TotalPriceUp
FROM Products
ORDER BY TotalPrice DESC;

SELECT LastName,
    DATEDIFF(year, BirthDate, HireDate) AS HireAgeInaccurate,
    FLOOR(DATEDIFF(day, BirthDate, HireDate)/365.25) AS HireAgeAccurate
FROM Employees;

SELECT FirstName, LastName, DATENAME(month, BirthDate) AS BirthMonth
FROM Employees
WHERE DATEPART(month, BirthDate) = DATEPART(month, GETDATE());

SELECT LOWER(ContactTitle) AS Title
FROM Customers;

/******************************
Oracle
******************************/
SELECT UnitsInStock, UnitPrice,
    UnitsInStock * UnitPrice AS TotalPrice,
FLOOR(UnitsInStock * UnitPrice) AS TotalPriceDown,
CEIL(UnitsInStock * UnitPrice) AS TotalPriceUp
FROM Products
ORDER BY TotalPrice DESC;

SELECT FirstName, LastName, TO_CHAR(BirthDate, 'MONTH') AS BirthMonth
FROM Employees
WHERE TO_CHAR(BirthDate, 'MM') = TO_CHAR(SYSDATE, 'MM');

SELECT LOWER(ContactTitle) AS Title
FROM Customers;

/******************************
MySQL
******************************/
SELECT UnitsInStock, UnitPrice,
    UnitsInStock * UnitPrice AS TotalPrice,
    FLOOR(UnitsInStock * UnitPrice) AS TotalPriceDown,
    CEILING(UnitsInStock * UnitPrice) AS TotalPriceUp
FROM Products
ORDER BY TotalPrice DESC;

SELECT FirstName, LastName, DATE_FORMAT(BirthDate, '%M') AS BirthMonth
FROM Employees
WHERE EXTRACT(MONTH FROM BirthDate) = EXTRACT(MONTH FROM NOW());

SELECT LOWER(ContactTitle) AS Title
FROM Customers;