# LAB: Generate Quarto Report(s) Programmatically

# check that your working directory is the labs folder
setwd('../labs')
getwd()

library(tidyverse)

#### PART 2

# building a single report
quarto::quarto_render(
  input          = "07EXs1_Parameterized_Report_SOLUTION_PART1.qmd",
  output_format  = 'html',
  output_file    = "Christopher Canada.html"
)
# move the HTML file to the my_stuff folder
file.rename('Christopher Canada.html', 'my_stuff/Christopher Canada.html')

#### PART 4

# first, find the staff ID for Jordan Smith
staff <- read.csv('../data/healthcare2/Staff.csv')
first_name <- 'Jordan'
last_name  <- 'Smith'
full_name  <- paste(first_name, last_name)
file_name  <- paste0(full_name, '.html')
jordan_id <- staff %>%
  filter(FirstName == first_name & LastName == last_name) %>%
  pull(StaffID)

# now generate a report for Jordan
quarto::quarto_render(
  input          = "07EXs3_Parameterized_Report_SOLUTION_PART3.qmd",
  output_format  = 'html',
  output_file    = file_name,
  execute_params = list(StaffID = jordan_id)
)
# move the HTML file to the my_stuff folder
file.rename(file_name, paste0('my_stuff/', file_name))

#### PART 5

# now generate a report for the first 10 physicians

# first, we have to find the first 10 physicians!
physicians <- staff %>%
  filter(StaffType == 'Physician') %>%
  slice(1:10)
  
# now go through most the same steps as in STEP 4
first_names <- physicians$FirstName
last_names  <- physicians$LastName
full_names  <- paste(first_names, last_names)
file_names  <- paste0(full_names, '.html')
IDs         <- physicians %>% pull(StaffID)

# now generate a report for each physician
for (i in 1:length(IDs)) {
  quarto::quarto_render(
    input          = "07EXs3_Parameterized_Report_SOLUTION_PART3.qmd",
    output_format  = 'html',
    output_file    = file_names[i],
    execute_params = list(StaffID = IDs[i])
  )
  # move the HTML file to the my_stuff folder
  file.rename(file_names[i], paste0('my_stuff/', file_names[i]))  
}

#### PART 6

# do it all again, but for nurses this time

# first, we have to find the first 10 nurses!
nurses <- staff %>%
  filter(StaffType == 'Nurse') %>%
  slice(1:10)

# now go through most the same steps as in STEP 4
first_names <- nurses$FirstName
last_names  <- nurses$LastName
full_names  <- paste(first_names, last_names)
file_names  <- paste0(full_names, '.html')
IDs         <- nurses %>% pull(StaffID)

# now generate a report for each physician
for (i in 1:length(IDs)) {
  quarto::quarto_render(
    input          = "07EXs6b_Parameterized_Report_SOLUTION_PART6b.qmd",
    output_format  = 'html',
    output_file    = file_names[i],
    execute_params = list(StaffID = IDs[i])
  )
  # move the HTML file to the my_stuff folder
  file.rename(file_names[i], paste0('my_stuff/', file_names[i]))  
}






