# Generate a Quarto Report Programmatically

# check that your working directory is the reports folder
course_dir <- '../reports'
setwd(course_dir)
getwd()

library(tidyverse)

# building a single report
quarto::quarto_render(
  input          = "test_report.qmd",
  output_format  = 'html',
  output_file    = "Starlight Medical Center.html",
  execute_params = list(clinic_name = "Starlight Medical Center")
)

# if we wanted to build many reports, we could use a for-loop
clinic_names <- read.csv('../data/healthcare2/clinic.csv') %>%
  pull(ClinicName) %>%
  unique() %>%
  head(3)

for (i in 1:length(clinic_names)) {
  print(paste("Working on Hospital:", clinic_names[i]))
  quarto::quarto_render(
    input          = "test_report.qmd",
    output_file    = paste0(clinic_names[i], ".html"),
    execute_params = list(clinic_name = clinic_names[i])
  )
}

# and now for the test report with conditional content
# we will add different information for Primary Care vs. ER clinics
for (i in 1:length(clinic_names)) {
  print(paste("Working on Hospital:", clinic_names[i]))
  quarto::quarto_render(
    input          = "test_report_conditional_content.qmd",
    output_file    = paste0(clinic_names[i], ".html"),
    execute_params = list(clinic_name = clinic_names[i])
  )
}
