# LAB: Generate Quarto Report(s) Programmatically

# check that your working directory is the labs folder
setwd('../labs')
getwd()

library(tidyverse)

#### PART 2

# building a single report
quarto::quarto_render(
  input          = "07EXs1_Parameterized_Report_SOLUTION_PART1.qmd",
  output_format  = 'html',
  output_file    = "Christopher Canada.html"
)
# move the HTML file to the my_stuff folder
file.rename('Christopher Canada.html', 'my_stuff/Christopher Canada.html')

#### PART 4

# first, find the staff ID for Jordan Smith
staff <- read.csv('../data/healthcare2/Staff.csv')
first_name <- 'Jordan'
last_name  <- 'Smith'
full_name  <- paste(first_name, last_name)
file_name  <- paste0(full_name, '.html')
jordan_id <- staff %>%
  filter(FirstName == first_name & LastName == last_name) %>%
  pull(StaffID)

# now generate a report for Jordan
quarto::quarto_render(
  input          = "07EXs3_Parameterized_Report_SOLUTION_PART3.qmd",
  output_format  = 'html',
  output_file    = file_name,
  execute_params = list(StaffID = jordan_id)
)
# move the HTML file to the my_stuff folder
file.rename(file_name, paste0('my_stuff/', file_name))
            