import React, {useState, useEffect} from 'react';

function LightBulb4() {

  const [on, setOn] = useState(true);

  document.body.style.backgroundColor = on ? 'orange' : 'white';

  const handleClick = () => setOn(!on)

  useEffect(() => {
    window.addEventListener('click', handleClick)
    return () => window.removeEventListener('click', handleClick)
  }, []);

  return (
    <div className="container">
      {on ? 'Light is on!' : 'Light is off!'}
    </div>
  )
}
export default LightBulb4;