from datetime import datetime

class Person:
    """
    Person class.
    full_name is the property defined for the class.
    _full_name is the variable that stores the value of the property.
    """

    def __init__(self, full_name):
        self._full_name = full_name

    def __str__(self):
        return f"Hey! My name is {self._full_name}"

    @property
    def full_name(self):
        """
        Getter for full_name.
        """
        return self._full_name

    @full_name.setter
    def full_name(self, new_full_name):
        """
        Setter for full_name.
        """
        self._full_name = new_full_name

    @classmethod
    def display(cls):
        """
        Outputs the current date in a friendly format.
        Used to demonstrate that class methods can be called from classes and instances.
        """
        print(f"Today is {datetime.now().strftime('%A, %B %d, %Y')}.")

# Instantiate an object of type Person:
a_person = Person("Stephen Withrow")

# Get full name using object's __str__ method:
print(a_person)

# Now use getter to get full name:
print(f"Full name is {a_person.full_name}")

# Change full name using setter:
a_person.full_name = "Joe Smith"

# Get updated full name using object's __str__ method:
print(a_person)

# Now use getter to get updated full name:
print(f"Full name is {a_person.full_name}")

# Class display using the class:
Person.display()

# Class display using the object
a_person.display()