# Step 1: Get a valid module path from $env:PSModulePath
$validPaths = $env:PSModulePath -split ";"
$modulePath = $validPaths | Select-Object -First 1

if (-not $modulePath) {
    Write-Error "No valid module path found."
    exit
}

# Define the full path for the custom module
$modulePath = Join-Path -Path $modulePath -ChildPath "TemperatureModule"

# Step 2: Create the module directory if it doesn't exist
if (-not (Test-Path -Path $modulePath)) {
    New-Item -ItemType Directory -Path $modulePath -Force
}

# Step 3: Define the module script file path
$moduleFilePath = Join-Path -Path $modulePath -ChildPath "TemperatureModule.psm1"

# Step 4: Write the module functions to the .psm1 file
$moduleContent = @"
function ConvertToFahrenheit {
    param (
        [double]`$Celsius
    )
    return (`$Celsius * 9/5) + 32
}

function ConvertToCelsius {
    param (
        [double]`$Fahrenheit
    )
    return (`$Fahrenheit - 32) * 5/9
}
"@

$moduleContent | Set-Content -Path $moduleFilePath -Encoding UTF8

# Step 5: Import the newly created module
Import-Module TemperatureModule -Force

# Step 6: Verify that the module and functions are available
Get-Command -Module TemperatureModule

# Step 7: Test the functions with example values
$testCelsius = 25
$testFahrenheit = 77

Write-Output "Converting $testCelsius°C to Fahrenheit: $(ConvertToFahrenheit -Celsius $testCelsius)°F"
Write-Output "Converting $testFahrenheit°F to Celsius: $(ConvertToCelsius -Fahrenheit $testFahrenheit)°C"