# Create an array containing numbers 1 to 10
$numbers = @(1, 2, 3, 4, 5, 6, 7, 8, 9, 10)

function PrintEvenNumbers {
    # Use a for loop to print only even numbers
    Write-Host "Even Numbers:"
    for ($i = 0; $i -lt $numbers.Count; $i++) {
        if ($numbers[$i] % 2 -eq 0) {
            Write-Host $numbers[$i]
        }
    }
}
function SumNumbersArray {
    # Use a foreach loop to calculate the sum of all numbers
    $totalSum = 0
    foreach ($num in $numbers) {
        $totalSum += $num
    }
    Write-Host "Total Sum: $totalSum"
}

# Create a list to be dynamically populated with numbers
$numbersList = new-object System.Collections.Generic.List[int]

function AddNumbersToList {
    # Use a while loop to add numbers to the list
    $i = 1
    while ($i -le 50) {
        $numbersList.Add($i)
        $i++
    }
    $listTotal = $numbersList.Count
    Write-Host "$listTotal Numbers added to list successfully"
}

function RemoveNumberFromList {
    param (
        [int]$numToRemove
    )
    if ($numbersList.Contains($numToRemove)) {
        Write-Host "Removing $numToRemove from the list"
        $numbersList.Remove($numToRemove)
    } else {
        Write-Host "$numToRemove is not in the list"
    }
    
    Write-Host "Current list of numbers: $numbersList"
}

# Create a hashtable with student names and scores
$studentScores = @{
  "Alice"   = 78
  "Bob"     = 85
  "Charlie" = 92
  "David"   = 70
  "Eve"     = 88
}

function PrintStudentScores {
    # Iterate through the hashtable and print all student scores
    foreach ($student in $studentScores.Keys) {
        $score = $studentScores[$student]
        Write-Host "$student $score"

        # Check if the student scored above 80
        if ($score -gt 80) {
            Write-Host "$student has scored above 80"
        }
    }
}