Rem
Rem $Header: hr_cre.sql 29-aug-2002.11:44:03 hyeh Exp $
Rem
Rem hr_cre.sql
Rem
Rem Copyright (c) 2001, 2015, Oracle Corporation.  All rights reserved.  
Rem 
Rem Permission is hereby granted, free of charge, to any person obtaining
Rem a copy of this software and associated documentation files (the
Rem "Software"), to deal in the Software without restriction, including
Rem without limitation the rights to use, copy, modify, merge, publish,
Rem distribute, sublicense, and/or sell copies of the Software, and to
Rem permit persons to whom the Software is furnished to do so, subject to
Rem the following conditions:
Rem 
Rem The above copyright notice and this permission notice shall be
Rem included in all copies or substantial portions of the Software.
Rem 
Rem THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
Rem EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
Rem MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
Rem NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
Rem LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
Rem OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
Rem WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
Rem
Rem    NAME
Rem      hr_cre.sql - Create data objects for HR schema
Rem
Rem    DESCRIPTION
Rem      This script creates six tables, associated constraints
Rem      and indexes in the human resources (HR) schema.
Rem
Rem    NOTES
Rem
Rem    CREATED by Nancy Greenberg, Nagavalli Pataballa - 06/01/00
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    hyeh        08/29/02 - hyeh_mv_comschema_to_rdbms
Rem    ahunold     09/14/00 - Added emp_details_view
Rem    ahunold     02/20/01 - New header
Rem    vpatabal	 03/02/01 - Added regions table, modified regions
Rem			            column in countries table to NUMBER.
Rem			            Added foreign key from countries table
Rem			            to regions table on region_id.
Rem		                    Removed currency name, currency symbol 
Rem			            columns from the countries table.
Rem		      	            Removed dn columns from employees and
Rem			            departments tables.
Rem			            Added sequences.	
Rem			            Removed not null constraint from 
Rem 			            salary column of the employees table.

SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100
SET ECHO OFF 

-- ********************************************************************
-- Create the REGIONS table to hold region information for locations
-- HR.LOCATIONS table has a foreign key to this table.

Prompt Creating REGIONS table ....

CREATE TABLE regions (
    region_id     NUMBER GENERATED BY DEFAULT AS IDENTITY
                  CONSTRAINT region_id_nn NOT NULL,
    region_name   VARCHAR2(25)
);

CREATE UNIQUE INDEX reg_id_pk ON regions (region_id);

ALTER TABLE regions
ADD CONSTRAINT reg_id_pk PRIMARY KEY (region_id);

-- ********************************************************************
-- Create the COUNTRIES table to hold country information for customers
-- and company locations. OE.CUSTOMERS table and HR.LOCATIONS have a foreign key to this table.

Prompt Creating COUNTRIES table ....

CREATE TABLE countries (
    country_id    CHAR(2) 
                  CONSTRAINT country_id_nn NOT NULL,
    country_name  VARCHAR2(40),
    region_id     NUMBER,
    CONSTRAINT    country_c_id_pk PRIMARY KEY (country_id)
) ORGANIZATION INDEX;

ALTER TABLE countries
ADD CONSTRAINT countr_reg_fk FOREIGN KEY (region_id)
REFERENCES regions(region_id);

-- ********************************************************************
-- Create the LOCATIONS table to hold address information for company departments.
-- HR.DEPARTMENTS has a foreign key to this table.

Prompt Creating LOCATIONS table ....

CREATE TABLE locations (
    location_id     NUMBER(4),
    street_address  VARCHAR2(40),
    postal_code     VARCHAR2(12),
    city            VARCHAR2(30) CONSTRAINT loc_city_nn NOT NULL,
    state_province  VARCHAR2(25),
    country_id      CHAR(2)
);

CREATE UNIQUE INDEX loc_id_pk ON locations (location_id);

ALTER TABLE locations
ADD (CONSTRAINT loc_id_pk PRIMARY KEY (location_id),
    CONSTRAINT loc_c_id_fk FOREIGN KEY (country_id)
    REFERENCES countries(country_id));

CREATE SEQUENCE locations_seq
START WITH     3300
INCREMENT BY   100
MAXVALUE       9900
NOCACHE
NOCYCLE;

-- ********************************************************************
-- Create the DEPARTMENTS table to hold company department information.

Prompt Creating DEPARTMENTS table ....

CREATE TABLE departments (
    department_id    NUMBER(4),
    department_name  VARCHAR2(30) CONSTRAINT dept_name_nn NOT NULL,
    manager_id       NUMBER(6),
    location_id      NUMBER(4)
);

CREATE UNIQUE INDEX dept_id_pk ON departments (department_id);

ALTER TABLE departments
ADD (CONSTRAINT dept_id_pk PRIMARY KEY (department_id),
    CONSTRAINT dept_loc_fk FOREIGN KEY (location_id)
    REFERENCES locations(location_id));

CREATE SEQUENCE departments_seq
START WITH     280
INCREMENT BY   10
MAXVALUE       9990
NOCACHE
NOCYCLE;

-- ********************************************************************
-- Create the JOBS table to hold job roles within the company.

Prompt Creating JOBS table ....

CREATE TABLE jobs (
    job_id      VARCHAR2(10),
    job_title   VARCHAR2(35) CONSTRAINT job_title_nn NOT NULL,
    min_salary  NUMBER(6),
    max_salary  NUMBER(6)
);

CREATE UNIQUE INDEX job_id_pk ON jobs (job_id);

ALTER TABLE jobs
ADD CONSTRAINT job_id_pk PRIMARY KEY(job_id);

-- ********************************************************************
-- Create the EMPLOYEES table to hold employee information.

Prompt Creating EMPLOYEES table ....

CREATE TABLE employees (
    employee_id    NUMBER GENERATED BY DEFAULT AS IDENTITY (START WITH 100),
    first_name     VARCHAR2(20),
    last_name      VARCHAR2(25) CONSTRAINT emp_last_name_nn NOT NULL,
    email          VARCHAR2(25) CONSTRAINT emp_email_nn NOT NULL,
    phone_number   VARCHAR2(20),
    hire_date      DATE CONSTRAINT emp_hire_date_nn NOT NULL,
    job_id         VARCHAR2(10) CONSTRAINT emp_job_nn NOT NULL,
    salary         NUMBER(8,2),
    commission_pct NUMBER(2,2),
    manager_id     NUMBER(6),
    department_id  NUMBER(4),
    CONSTRAINT     emp_salary_min CHECK (salary > 0),
    CONSTRAINT     emp_email_uk UNIQUE (email)
);

CREATE UNIQUE INDEX emp_emp_id_pk ON employees (employee_id);

ALTER TABLE employees
ADD (CONSTRAINT emp_emp_id_pk PRIMARY KEY (employee_id),
    CONSTRAINT emp_dept_fk FOREIGN KEY (department_id)
    REFERENCES departments,
    CONSTRAINT emp_job_fk FOREIGN KEY (job_id)
    REFERENCES jobs(job_id),
    CONSTRAINT emp_manager_fk FOREIGN KEY (manager_id)
    REFERENCES employees);

ALTER TABLE departments
ADD (CONSTRAINT dept_mgr_fk FOREIGN KEY (manager_id)
REFERENCES employees(employee_id));

CREATE SEQUENCE employees_seq
START WITH     207
INCREMENT BY   1
NOCACHE
NOCYCLE;

-- ********************************************************************
-- Create the JOB_HISTORY table to hold job history information.

Prompt Creating JOB_HISTORY table ....

CREATE TABLE job_history (
    employee_id    NUMBER(6) CONSTRAINT jhist_employee_nn NOT NULL,
    start_date     DATE CONSTRAINT jhist_start_date_nn NOT NULL,
    end_date       DATE CONSTRAINT jhist_end_date_nn NOT NULL,
    job_id         VARCHAR2(10) CONSTRAINT jhist_job_nn NOT NULL,
    department_id  NUMBER(4),
    CONSTRAINT     jhist_date_interval CHECK (end_date > start_date)
);

CREATE UNIQUE INDEX jhist_emp_id_st_date_pk 
ON job_history (employee_id, start_date);

ALTER TABLE job_history
ADD (CONSTRAINT jhist_emp_id_st_date_pk PRIMARY KEY (employee_id, start_date),
    CONSTRAINT jhist_job_fk FOREIGN KEY (job_id)
    REFERENCES jobs,
    CONSTRAINT jhist_emp_fk FOREIGN KEY (employee_id)
    REFERENCES employees,
    CONSTRAINT jhist_dept_fk FOREIGN KEY (department_id)
    REFERENCES departments);

-- ********************************************************************
-- Create the EMP_DETAILS_VIEW to provide employee details.

Prompt Creating EMP_DETAILS_VIEW view ...

CREATE OR REPLACE VIEW emp_details_view AS
SELECT e.employee_id, e.job_id, e.manager_id, e.department_id, d.location_id,
       l.country_id, e.first_name, e.last_name, e.salary, e.commission_pct,
       d.department_name, j.job_title, l.city, l.state_province,
       c.country_name, r.region_name
FROM employees e
JOIN departments d ON e.department_id = d.department_id
JOIN jobs j ON j.job_id = e.job_id
JOIN locations l ON d.location_id = l.location_id
JOIN countries c ON l.country_id = c.country_id
JOIN regions r ON c.region_id = r.region_id
WITH READ ONLY;

COMMIT;
