CREATE OR REPLACE TRIGGER jobs_bu_trigger
  BEFORE
    UPDATE OF min_salary, max_salary
  ON jobs
  FOR EACH ROW
WHEN (NEW.min_salary > OLD.min_salary
      OR NEW.max_salary < OLD.max_salary)
DECLARE
  CURSOR employee_cursor (job_id_in jobs.job_id%TYPE) IS
    SELECT employee_id, first_name, last_name, salary
    FROM employees
    WHERE job_id = job_id_in;
  invalid_min_salary  EXCEPTION;
  invalid_max_salary  EXCEPTION;
  l_first_name        employees.first_name%TYPE;
  l_last_name         employees.last_name%TYPE;
  l_employee_id       employees.employee_id%TYPE;
  l_salary            employees.salary%TYPE;
BEGIN
  DBMS_OUTPUT.PUT_LINE('Trigger code executed.');
  FOR l_employee IN employee_cursor(:NEW.job_id) LOOP
    l_first_name  := l_employee.first_name;
    l_last_name   := l_employee.last_name;
    l_employee_id := l_employee.employee_id;
    l_salary      := l_employee.salary;
    
    IF l_employee.salary < :NEW.min_salary THEN
      RAISE invalid_min_salary;
    ELSIF l_employee.salary > :NEW.max_salary THEN
      RAISE invalid_max_salary;
    END IF;
    
  END LOOP;
  
EXCEPTION
  WHEN invalid_min_salary THEN
    -- re-raise the error to be caught by calling code
    RAISE_APPLICATION_ERROR(-20101,
                  'Error: Min salary of ' || :NEW.min_salary ||
                  ' for ' || :NEW.job_id || 
                  ' is higher than salary of ' ||
                  l_first_name || ' ' || l_last_name ||
                  ' (' || l_employee_id || '), which is ' ||
                  l_salary || '.');
  WHEN invalid_max_salary THEN
    -- re-raise the error to be caught by calling code
    RAISE_APPLICATION_ERROR(-20102,
                  'Error: Max salary of ' || :NEW.max_salary ||
                  ' for ' || :NEW.job_id || 
                  ' is lower than salary of ' ||
                  l_first_name || ' ' || l_last_name ||
                  ' (' || l_employee_id || '), which is ' ||
                  l_salary || '.');
END jobs_bu_trigger;