CREATE OR REPLACE TRIGGER employees_salary_biu_trigger
  BEFORE
    INSERT
    OR UPDATE OF salary, job_id
  ON employees
  FOR EACH ROW
DECLARE
  l_min_salary jobs.min_salary%TYPE;
  l_max_salary jobs.max_salary%TYPE;
  invalid_salary EXCEPTION;
BEGIN

  SELECT min_salary, max_salary
  INTO l_min_salary, l_max_salary
  FROM jobs
  WHERE job_id = :NEW.job_id;
  
  IF :NEW.salary NOT BETWEEN l_min_salary AND l_max_salary THEN
    RAISE invalid_salary;
  END IF;
  
EXCEPTION
  WHEN invalid_salary THEN
    -- re-raise the error to be caught by calling code
    RAISE_APPLICATION_ERROR(-20101,
              'Salary for ' || :NEW.job_id || ' must be between ' ||
              l_min_salary || ' and ' || l_max_salary || '.');
END employees_salary_biu_trigger;