CREATE OR REPLACE TRIGGER employees_aud_trigger
  AFTER
    UPDATE OF manager_id
    OR DELETE
  ON employees
DECLARE
  num_head_honchos        NUMBER(6,0);
  cannot_remove_boss      EXCEPTION;
BEGIN
  SELECT COUNT(*)
  INTO num_head_honchos
  FROM employees
  WHERE manager_id IS NULL;
  
  IF num_head_honchos = 0 THEN
    RAISE cannot_remove_boss;
  END IF;
  
EXCEPTION
  WHEN cannot_remove_boss THEN
    RAISE_APPLICATION_ERROR(-20101,
                            'Must have at least one head honcho.');
END employees_aud_trigger;