CREATE OR REPLACE TRIGGER employees_aiud_trigger
  AFTER
    INSERT OR UPDATE OR DELETE
  ON employees
  FOR EACH ROW
DECLARE
  l_operation CHAR := CASE 
      WHEN UPDATING THEN 'U'
      WHEN DELETING THEN 'D'
      ELSE 'I' END;
BEGIN
  IF INSERTING OR UPDATING THEN
    INSERT INTO employees_audit (
      employee_id,
      first_name,
      last_name,
      email,
      phone_number,
      hire_date,
      job_id,
      salary,
      commission_pct,
      manager_id,
      department_id,
      operation,
      change_date,
      change_made_by
    )
    VALUES (
      :NEW.employee_id,
      :NEW.first_name,
      :NEW.last_name,
      :NEW.email,
      :NEW.phone_number,
      :NEW.hire_date,
      :NEW.job_id,
      :NEW.salary,
      :NEW.commission_pct,
      :NEW.manager_id,
      :NEW.department_id,
      l_operation,
      SYSDATE,
      USER
    );
  ELSE -- DELETING
    INSERT INTO employees_audit (
      employee_id,
      first_name,
      last_name,
      email,
      phone_number,
      hire_date,
      job_id,
      salary,
      commission_pct,
      manager_id,
      department_id,
      operation,
      change_date,
      change_made_by
    )
    VALUES (
      :OLD.employee_id,
      :OLD.first_name,
      :OLD.last_name,
      :OLD.email,
      :OLD.phone_number,
      :OLD.hire_date,
      :OLD.job_id,
      :OLD.salary,
      :OLD.commission_pct,
      :OLD.manager_id,
      :OLD.department_id,
      l_operation,
      SYSDATE,
      USER
    );
  END IF;
END employees_aiud_trigger;