DROP TABLE employees_audit; -- in case it exists already

CREATE TABLE employees_audit
(
  employee_id     NUMBER(6) REFERENCES employees(employee_id),
  first_name      VARCHAR2(20),
  last_name       VARCHAR2(25),
  email           VARCHAR2(25),
  phone_number    VARCHAR2(20),
  hire_date       DATE,
  job_id          VARCHAR2(10),
  salary          NUMBER(8,2),
  commission_pct  NUMBER(2,2),
  manager_id      NUMBER(6) REFERENCES employees(employee_id),
  department_id   NUMBER(4) REFERENCES departments(department_id),
  operation       CHAR,
  change_date     DATE DEFAULT SYSDATE,
  change_made_by  VARCHAR2(20)
);