-- Create the procedure here
CREATE OR REPLACE PROCEDURE update_employee_email (
  employee_id_in  IN      employees.employee_id%TYPE,
  new_email_io    IN OUT  employees.email%TYPE,
  old_email_out   OUT     employees.email%TYPE,
  full_name_out   OUT     VARCHAR2
) IS
  -- No variable declarations
BEGIN
  SELECT email
  INTO old_email_out
  FROM employees
  WHERE employee_id = employee_id_in;

  UPDATE employees
  SET email = new_email_io || '@hr'
  WHERE employee_id = employee_id_in;

  SELECT first_name || ' ' || last_name, email
  INTO
    full_name_out,
    new_email_io
  FROM employees
  WHERE employee_id = employee_id_in;
END update_employee_email;

-- Call procedure
DECLARE
  l_employee_id NUMBER(6,0)  :=  150;
  l_new_email   VARCHAR2(25) :=  'peter.tucker';
  l_old_email   VARCHAR2(25);
  l_full_name   VARCHAR2(50);
BEGIN
  update_employee_email(
    employee_id_in  => l_employee_id,
    new_email_io    => l_new_email,
    old_email_out   => l_old_email,
    full_name_out   => l_full_name
  );
  DBMS_OUTPUT.PUT_LINE('Email of ' || l_full_name || 
    ' changed from "' || l_old_email || '" to "' || l_new_email || '".');
END;