-- Create the function here
CREATE OR REPLACE FUNCTION get_manager(
  first_name_in  IN  employees.first_name%TYPE,
  last_name_in   IN  employees.last_name%TYPE
)
 RETURN VARCHAR2
IS
  l_manager_name VARCHAR2(50);
BEGIN
  SELECT first_name || ' ' || last_name
  INTO l_manager_name
  FROM employees
  WHERE employee_id = (
    SELECT manager_id
    FROM employees
    WHERE first_name = first_name_in
      AND last_name = last_name_in
  );
  
  RETURN l_manager_name;
END get_manager;

-- Call function
DECLARE
  l_first_name    VARCHAR2(20);
  l_last_name     VARCHAR2(25);
  l_manager_name  VARCHAR2(50);
BEGIN
  l_first_name    := 'Nancy';
  l_last_name     := 'Greenberg';
  l_manager_name  := get_manager(l_first_name, l_last_name);

  DBMS_OUTPUT.PUT_LINE(l_manager_name || ' is the manager of ' ||
    l_first_name || ' ' || l_last_name || '.');
END;