CREATE OR REPLACE PROCEDURE hello(
  greeting IN VARCHAR2,
  person   IN VARCHAR2,
  subject  IN VARCHAR2 := 'SQL'
)
IS
BEGIN
  DBMS_OUTPUT.PUT_LINE(greeting || ', ' || person ||
    '! You are learning ' || subject ||
    ' really fast. Great job!');
END hello;

-- positional notation
BEGIN
  hello('Howdy', 'Dolly', 'PL/SQL');
  hello('Howdy', 'Dolly');
  hello('Dolly', 'Howdy'); -- Dolly, Howdy!
END;

-- named notation
BEGIN
  hello(greeting => 'Howdy',
        person   => 'Dolly',
        subject  => 'PL/SQL');

  -- Order of parameters changed
  hello(subject  => 'PL/SQL',
        greeting => 'Howdy',
        person   => 'Dolly');

  -- No value passed for subject
  hello(greeting => 'Howdy',
        person   => 'Dolly');
END;

-- mixed notation
BEGIN
  hello('Howdy',
        'Dolly',
        subject  => 'PL/SQL');
              
  hello('Howdy',
        person   => 'Dolly');
END;