CREATE OR REPLACE FUNCTION get_circumference(
  radius_in IN NUMBER
)
  RETURN FLOAT
IS
  c_pi CONSTANT FLOAT := 3.14159;
BEGIN
  RETURN c_pi * (radius_in * 2);
END get_circumference;
/
CREATE OR REPLACE FUNCTION get_country_name(
  country_id_in IN CHAR
)
  RETURN VARCHAR2
IS
  l_country_name VARCHAR2(40);
BEGIN
  SELECT country_name
  INTO l_country_name
  FROM countries
  WHERE country_id = country_id_in;
  
  RETURN l_country_name;
END get_country_name;
/
DECLARE
  l_radius        NUMBER  := 5;
  l_circumference FLOAT;
  l_country_id    CHAR(2) := 'US';
  l_country_name  VARCHAR2(40);
BEGIN
  l_circumference := get_circumference(l_radius);
  l_country_name  := get_country_name(l_country_id);

  DBMS_OUTPUT.PUT_LINE('Circumference: ' || l_circumference);
  DBMS_OUTPUT.PUT_LINE('Hello, ' || l_country_name || '!');
END;
/