CREATE OR REPLACE PROCEDURE assign_country_name(
  country_id     IN      CHAR,
  country_name   OUT     VARCHAR2
) IS
  -- No variable declarations
BEGIN
  SELECT country_name
  INTO country_name
  FROM countries
  WHERE country_id = country_id;
  -- Problem above: country_id will come from countries table
END assign_country_name;

/*
  The code below will error because the SELECT statement
  in the procedure above will return multiple records, which
  is not allowed for a SELECT...INTO statement.
*/
DECLARE
  country_id    CHAR(2)       := 'US';
  country_name  VARCHAR2(40);
BEGIN
  assign_country_name(
    country_id    => country_id,
    country_name  => country_name
  );

  DBMS_OUTPUT.PUT_LINE('Hello, ' || country_name || '!');
END;

/*
  Below, we fix the problem by qualifying country_id
  in the WHERE clause with the name of the procedure.
*/
CREATE OR REPLACE PROCEDURE assign_country_name(
  country_id     IN      CHAR,
  country_name   OUT     VARCHAR2
) IS
  -- No variable declarations
BEGIN
  SELECT country_name
  INTO assign_country_name.country_name
  FROM countries
  WHERE country_id = assign_country_name.country_id;
END assign_country_name;

DECLARE
  country_id    CHAR(2)       := 'US';
  country_name  VARCHAR2(40);
BEGIN
  assign_country_name(
    country_id    => country_id,
    country_name  => country_name
  );

  DBMS_OUTPUT.PUT_LINE('Hello, ' || country_name || '!');
END;

/*
  Below, we take a different approach to fixing the problem of the
  ambiguous country_id: Instead of qualifying country_id, we rename
  the formal parameters, so they are different from the column names.
*/
CREATE OR REPLACE PROCEDURE assign_country_name(
  country_id_in     IN      CHAR,
  country_name_out  OUT     VARCHAR2
) IS
  -- No variable declarations
BEGIN
  SELECT country_name
  INTO country_name_out
  FROM countries
  WHERE country_id = country_id_in;
END assign_country_name;

DECLARE
  country_id    CHAR(2)       := 'US';
  country_name  VARCHAR2(40);
BEGIN
  assign_country_name(
    country_id_in      => country_id,
    country_name_out   => country_name
  );

  DBMS_OUTPUT.PUT_LINE('Hello, ' || country_name || '!');
END;