DECLARE
  l_employee_id     employees.employee_id%TYPE  := 176;
  l_employee        employees%ROWTYPE;
BEGIN
  -- Get employee by id
  l_employee := employee_package.get_employee(l_employee_id);

  -- Change job
  employee_package.change_job(l_employee_id, 'SA_REP', 80);
  
  FOR l_job IN employee_package.employee_jh_cursor(l_employee_id)
    LOOP

    DBMS_OUTPUT.PUT_LINE('Job: '         || l_job.job_title ||
                        ', Department: ' || l_job.department_name ||
                        ', Start Date: ' || l_job.start_date ||
                        ', End Date: '   || l_job.end_date || '.');
  END LOOP;
  
END;