DECLARE
  l_employee_id     employees.employee_id%TYPE  :=  102;
  l_new_manager_id  employees.manager_id%TYPE   :=  102;
  l_manager         employees%ROWTYPE;
BEGIN
  l_manager := employee_package.get_manager(l_employee_id);
  IF l_manager.employee_id IS NULL THEN
    DBMS_OUTPUT.PUT_LINE('Employee had no manager.');
  ELSE
    DBMS_OUTPUT.PUT_LINE('Old manager is ' || l_manager.first_name ||
                       ' ' || l_manager.last_name || '.');
  END IF;
                        
  employee_package.change_manager(
    employee_id_in      => l_employee_id,
    manager_id_in       => l_new_manager_id
  );
  
  l_manager := employee_package.get_manager(l_employee_id);
  IF l_manager.employee_id IS NULL THEN
    DBMS_OUTPUT.PUT_LINE('Employee has no manager.');
  ELSE
    DBMS_OUTPUT.PUT_LINE('New manager is ' || l_manager.first_name ||
                       ' ' || l_manager.last_name || '.');
  END IF;

EXCEPTION
  WHEN OTHERS THEN
    RAISE_APPLICATION_ERROR(-20001, 'An error was encountered - ' ||
                                    SQLCODE ||
                                    ' -ERROR- ' ||
                                    SQLERRM, TRUE);
END;