DECLARE
  l_employee_id employees.employee_id%TYPE;
  l_manager     employees%ROWTYPE;
  l_hire_date   employees.hire_date%TYPE;
BEGIN
  l_employee_id := 103;

  -- Get employee's manager
  l_manager := employee_package.get_manager(l_employee_id);
  IF l_manager.employee_id IS NULL THEN
    DBMS_OUTPUT.PUT_LINE('Employee has no manager.');
  ELSE
    DBMS_OUTPUT.PUT_LINE('Manager is ' || l_manager.first_name ||
                       ' ' || l_manager.last_name || '.');
  END IF;
                        
  -- Get employee's hire date
  l_hire_date := employee_package.get_hire_date(l_employee_id);
  DBMS_OUTPUT.PUT_LINE('Employee hired on ' ||
                      TO_CHAR(l_hire_date, 'MM/DD/YYYY') || '.');
  
END;