CREATE OR REPLACE PACKAGE employee_package
IS
  -- INSERT
  FUNCTION new_employee(
        first_name_in       IN employees.first_name%TYPE,
        last_name_in        IN employees.last_name%TYPE,
        email_in            IN employees.email%TYPE,
        phone_number_in     IN employees.phone_number%TYPE,
        job_id_in           IN employees.job_id%TYPE,
        salary_in           IN employees.salary%TYPE,
        manager_id_in       IN employees.manager_id%TYPE,
        department_id_in    IN employees.department_id%TYPE,
        commission_pct_in   IN employees.commission_pct%TYPE := NULL,
        hire_date_in        IN employees.hire_date%TYPE := SYSDATE
  )
    RETURN employees%ROWTYPE;

  -- GETTERS (RECORDS)
  FUNCTION get_employee(employee_id_in IN employees.employee_id%TYPE)
    RETURN employees%ROWTYPE;
  
  FUNCTION get_employee(email_in IN employees.email%TYPE)
    RETURN employees%ROWTYPE;
  
  FUNCTION get_employee(first_name_in   IN employees.first_name%TYPE,
                        last_name_in    IN employees.last_name%TYPE)
    RETURN employees%ROWTYPE;

  FUNCTION get_manager(employee_id_in IN employees.employee_id%TYPE)
    RETURN employees%ROWTYPE;
    
  -- GETTERS (FIELDS)
  FUNCTION get_hire_date(
                  employee_id_in IN employees.employee_id%TYPE
  )
    RETURN employees.hire_date%TYPE;
  
  -- SETTERS (UPDATES)
  PROCEDURE change_job(
    employee_id_in    employees.employee_id%TYPE,
    job_id_in         employees.job_id%TYPE,
    department_id_in  employees.department_id%TYPE
  );

  PROCEDURE change_manager(
    employee_id_in    employees.employee_id%TYPE,
    manager_id_in     employees.manager_id%TYPE
  );
    
  -- VALIDATION
  PROCEDURE check_manager(
    employee_id_in  IN      employees.employee_id%TYPE,
    manager_id_in   IN      employees.manager_id%TYPE
  );
   
  -- DELETE
  FUNCTION delete_employee(
                  employee_id_in IN employees.employee_id%TYPE
  )
    RETURN BOOLEAN;

END employee_package;