CREATE OR REPLACE PACKAGE BODY circle_package
IS

  -- Public functions (declared in package specification)
  FUNCTION get_diameter(radius_in NUMBER) 
    RETURN NUMBER
  IS
    -- nothing to declare
  BEGIN
    RETURN radius_in * 2;
  END get_diameter;
  
  FUNCTION get_area(radius_in NUMBER) 
    RETURN NUMBER
  IS
    -- nothing to declare
  BEGIN
    RETURN POWER(radius_in, 2) * pi;
  END get_area;
  
  FUNCTION get_circumference(radius_in NUMBER) 
    RETURN NUMBER
  IS
    -- nothing to declare
  BEGIN
    RETURN get_diameter(radius_in) * pi;
  END get_circumference;
  
  FUNCTION get_radius_from_diameter(diameter_in NUMBER) 
    RETURN NUMBER
  IS
    -- nothing to declare
  BEGIN
    RETURN diameter_in / 2;
  END get_radius_from_diameter;
  
  FUNCTION get_radius_from_area(area_in NUMBER) 
    RETURN NUMBER
  IS
    -- nothing to declare
  BEGIN
    RETURN SQRT(area_in / pi);
  END get_radius_from_area;
  
  FUNCTION get_radius_from_circumference(circumference_in NUMBER)
    RETURN NUMBER
  IS
    -- nothing to declare
  BEGIN
    RETURN (circumference_in / pi) / 2;
  END get_radius_from_circumference;
  
END circle_package;