CREATE OR REPLACE PACKAGE BODY employee_package
IS
  -- INSERT
  FUNCTION new_employee(
        first_name_in       IN employees.first_name%TYPE,
        last_name_in        IN employees.last_name%TYPE,
        email_in            IN employees.email%TYPE,
        phone_number_in     IN employees.phone_number%TYPE,
        job_id_in           IN employees.job_id%TYPE,
        salary_in           IN employees.salary%TYPE,
        manager_id_in       IN employees.manager_id%TYPE,
        department_id_in    IN employees.department_id%TYPE,
        commission_pct_in   IN employees.commission_pct%TYPE := NULL,
        hire_date_in        IN employees.hire_date%TYPE := SYSDATE
    )
    RETURN employees%ROWTYPE
  IS
    l_employee_id employees.employee_id%TYPE;
    l_employee    employees%ROWTYPE;
  BEGIN
    -- Get new employee_id
    SELECT MAX(employee_id) + 1
    INTO l_employee_id
    FROM employees;
  
    INSERT INTO employees (employee_id, first_name, last_name,
                          email, phone_number, hire_date,
                          job_id, salary, commission_pct,
                          manager_id, department_id)
    VALUES               (l_employee_id, first_name_in, last_name_in,
                          email_in, phone_number_in, hire_date_in,
                          job_id_in, salary_in, commission_pct_in,
                          manager_id_in, department_id_in)
    RETURNING employee_id, first_name, last_name,
              email, phone_number, hire_date,
              job_id, salary, commission_pct,
              manager_id, department_id INTO l_employee;
    
    RETURN l_employee;
  
  END new_employee;
  
  -- GETTERS (RECORDS)
  FUNCTION get_employee(employee_id_in IN employees.employee_id%TYPE)
    RETURN employees%ROWTYPE
  IS
    l_employee employees%ROWTYPE;
  BEGIN
    SELECT *
    INTO l_employee
    FROM employees
    WHERE employee_id = employee_id_in;
  
    RETURN l_employee;
  
  EXCEPTION
    WHEN no_data_found THEN
      RETURN NULL;
  
  END get_employee;

  -- DELETE
  FUNCTION delete_employee(
    employee_id_in IN employees.employee_id%TYPE
  )
    RETURN BOOLEAN
  IS
  BEGIN
    DELETE
    FROM employees
    WHERE employee_id = employee_id_in;
    
    RETURN SQL%FOUND;
  
  END delete_employee;
  
END employee_package;