DECLARE
  l_employee_id employees.employee_id%TYPE;
  l_employee_1  employees%ROWTYPE;
  l_employee_2  employees%ROWTYPE;
BEGIN
  -- Insert employee
  l_employee_1 := employee_package.new_employee(
        first_name_in       => 'Nat',
        last_name_in        => 'Dunn',
        email_in            => 'NDUNN',
        phone_number_in     => '555-054-2211',
        job_id_in           => 'IT_PROG',
        salary_in           => 4001,
        manager_id_in       => 103,
        department_id_in    => 60
  );
  
  DBMS_OUTPUT.PUT_LINE(l_employee_1.first_name || ' ' ||
                    l_employee_1.last_name || ' inserted with id ' ||
                    l_employee_1.employee_id || '.');
                        
  -- Get a different employee
  l_employee_2 := employee_package.get_employee(100);
  DBMS_OUTPUT.PUT_LINE('Employee is ' || l_employee_2.first_name ||
                       ' ' || l_employee_2.last_name || '.');
END;

-- Delete the record (You may need to change the id)
DECLARE
  l_employee_id employees.employee_id%TYPE := 207;
  l_employee    employees%ROWTYPE;
  l_result      BOOLEAN;
BEGIN
  l_employee  := employee_package.get_employee(l_employee_id);
  l_result    := employee_package.delete_employee(l_employee_id);
  IF l_result THEN
    DBMS_OUTPUT.PUT_LINE(l_employee.first_name || ' ' ||
                          l_employee.last_name ||' deleted.');
  ELSE
    DBMS_OUTPUT.PUT_LINE('No employee with id ' ||
                          l_employee_id ||
                          ' to delete.');
  END IF;
END;