CREATE OR REPLACE PROCEDURE update_employee_manager(
  employee_id_in      IN    employees.employee_id%TYPE,
  manager_id_in       IN    employees.manager_id%TYPE
) IS
  -- Give l_managers_manager_id default so it isn't NULL
  l_managers_manager_id   employees.manager_id%TYPE := -1;

  -- Default l_temp_employee_id to manager_id_in. Used to check that
  -- employee_id_in doesn't report to l_temp_employee_id's boss
  l_temp_employee_id    employees.employee_id%TYPE := manager_id_in;
    
  manager_is_self       EXCEPTION;
  reciprocal_managers   EXCEPTION;
BEGIN
  IF employee_id_in = manager_id_in THEN
    RAISE manager_is_self;
  END IF;
    -- Make sure employee is not reporting to an underling
    
  WHILE l_managers_manager_id IS NOT NULL LOOP
    SELECT manager_id
    INTO l_managers_manager_id
    FROM employees
    WHERE employee_id = l_temp_employee_id;
    
    IF l_managers_manager_id = employee_id_in THEN
      RAISE reciprocal_managers;
    END IF;
    -- Assign manager's manager id to l_temp_employee_id
    l_temp_employee_id := l_managers_manager_id;
    
  END LOOP;
  
  -- Set new manager
  UPDATE employees
  SET manager_id = manager_id_in
  WHERE employee_id = employee_id_in;
  
EXCEPTION
  WHEN manager_is_self THEN
    -- re-raise the error to be caught by calling code
    RAISE_APPLICATION_ERROR(-20101,
                    'Employee cannot be own manager.');
  WHEN reciprocal_managers THEN
    -- re-raise the error to be caught by calling code
    RAISE_APPLICATION_ERROR(-20102,
                    'Employees cannot be managed by an underling.');
                    
END update_employee_manager;