DECLARE
  -- Declare and initialize variable
  greeting VARCHAR2(20) := 'Hello, world!';
BEGIN
  DBMS_OUTPUT.PUT_LINE(greeting);
END;

DECLARE
  -- Declare and initialize variable
  greeting VARCHAR2(20) DEFAULT 'Hello, world!';
BEGIN
  DBMS_OUTPUT.PUT_LINE(greeting);
  
  -- Assign a new value
  greeting := 'Hello again!';
  
  DBMS_OUTPUT.PUT_LINE(greeting);
END;

DECLARE
  -- Declare, but don't initialize variable
  greeting VARCHAR2(20);
BEGIN
  -- Assign value
  greeting := 'Hello, world';
  DBMS_OUTPUT.PUT_LINE(greeting);
END;

-- Concatenation Example
DECLARE
  greeting  VARCHAR2(20);
  person    VARCHAR2(20);
  subject   VARCHAR2(20) := 'PL/SQL';
BEGIN
  greeting  := 'Hello';
  person    := 'Dolly';
  DBMS_OUTPUT.PUT_LINE(greeting || ', ' || person || '!');
  
  -- You can break long lines up:
  DBMS_OUTPUT.PUT_LINE(greeting || ', ' || person ||
    '! You are learning ' || subject ||
    ' really fast. Great job!');
END;