DECLARE
  l_greeting VARCHAR2(50);
BEGIN
  SELECT 'Hello, ' || region_name || '!'
  INTO l_greeting
  FROM regions
  WHERE region_id = 100;

  DBMS_OUTPUT.PUT_LINE(l_greeting);
EXCEPTION
  WHEN TOO_MANY_ROWS THEN
    DBMS_OUTPUT.PUT_LINE('ERROR: Query returns more than one row.');
  WHEN NO_DATA_FOUND THEN
    DBMS_OUTPUT.PUT_LINE('ERROR: Query must return a row.');
  WHEN OTHERS THEN
    RAISE_APPLICATION_ERROR(-20001,'An error was encountered - ' ||
                                    SQLCODE ||
                                    ' -ERROR- ' ||
                                    SQLERRM);
END;