DECLARE
  l_employee_id       employees.employee_id%TYPE := 101;
  l_manager_id        employees.manager_id%TYPE  := 101;
  manager_is_self     EXCEPTION;
BEGIN
  IF l_employee_id = l_manager_id THEN
    RAISE manager_is_self;
  END IF;

  UPDATE employees
  SET manager_id = l_manager_id
  WHERE employee_id = l_employee_id;

EXCEPTION
  WHEN manager_is_self THEN
    DBMS_OUTPUT.PUT_LINE('Employee cannot be own manager.');
  WHEN OTHERS THEN
    RAISE_APPLICATION_ERROR(-20001,'An error was encountered - ' ||
                                    SQLCODE ||
                                    ' -ERROR- ' ||
                                    SQLERRM);
END;