-- Create the procedure
CREATE OR REPLACE PROCEDURE update_employee_manager(
  employee_id_in    IN  employees.employee_id%TYPE,
  new_manager_id_in IN  employees.manager_id%TYPE
) IS
  manager_is_self      EXCEPTION;
BEGIN
  IF employee_id_in = new_manager_id_in THEN
    RAISE manager_is_self;
  END IF;
  
  -- Set new manager
  UPDATE employees
  SET manager_id = new_manager_id_in
  WHERE employee_id = employee_id_in;
  DBMS_OUTPUT.PUT_LINE('Success: Employee manager updated.');
  
EXCEPTION
  WHEN manager_is_self THEN
    DBMS_OUTPUT.PUT_LINE('Error: Employee cannot be own manager.');
END update_employee_manager;

-- Call the procedure
DECLARE
  l_employee_id  employees.employee_id%TYPE  :=  101;
  l_manager_id   employees.manager_id%TYPE   :=  101;
  
BEGIN
  update_employee_manager(
    employee_id_in     => l_employee_id,
    new_manager_id_in  => l_manager_id
  );
END;