DECLARE

   CURSOR employee_cursor IS
      SELECT first_name, last_name, email, phone_number, hire_date
      FROM employees;

   CURSOR client_cursor IS
      SELECT first_name, last_name, email, phone_number, company_name
      FROM clients;

   CURSOR vendor_cursor IS
      SELECT first_name, last_name, email, phone_number, company_name
      FROM vendors;

BEGIN

  FOR l_employee IN employee_cursor LOOP
    insert_person(
      first_name_in   => l_employee.first_name,
      last_name_in    => l_employee.last_name,
      email_in        => l_employee.email,
      phone_number_in => l_employee.phone_number,
      company_name_in => 'Webucator',
      company_type_in => 'staff',
      hire_date_in    => l_employee.hire_date
    );
  END LOOP;

  FOR l_client IN client_cursor LOOP
    insert_person(
      first_name_in   => l_client.first_name,
      last_name_in    => l_client.last_name,
      email_in        => l_client.email,
      phone_number_in => l_client.phone_number,
      company_name_in => l_client.company_name,
      company_type_in => 'client'
    );
  END LOOP;

  FOR l_vendor IN vendor_cursor LOOP
    insert_person(
      first_name_in   => l_vendor.first_name,
      last_name_in    => l_vendor.last_name,
      email_in        => l_vendor.email,
      phone_number_in => l_vendor.phone_number,
      company_name_in => l_vendor.company_name,
      company_type_in => 'vendor'
    );
  END LOOP;

END;