-- Create procedure
CREATE OR REPLACE PROCEDURE update_employee_email(
  employee_id_in  IN  employees.employee_id%TYPE,
  new_email_in    IN  employees.email%TYPE
) IS
  no_such_employee EXCEPTION;
BEGIN

  UPDATE employees
  SET email = new_email_in
  WHERE employee_id = employee_id_in;
  
  IF SQL%NOTFOUND THEN
    RAISE no_such_employee;
  END IF;

EXCEPTION
  WHEN no_such_employee THEN
    RAISE_APPLICATION_ERROR(-20101,
                         'No employee with id ' || employee_id_in);
  
END update_employee_email;

-- Call procedure
DECLARE
  l_employee_id NUMBER(6,0)  :=  51;
  l_new_email   VARCHAR2(25) :=  'peter.tucker';
BEGIN
  update_employee_email(
    employee_id_in  => l_employee_id,
    new_email_in    => l_new_email
  );
EXCEPTION
  WHEN OTHERS THEN
    RAISE_APPLICATION_ERROR(-20001, 'An error was encountered - ' ||
                                    SQLCODE ||
                                    ' -ERROR- ' ||
                                    SQLERRM, TRUE);
END;