DECLARE
   l_amt_to_reduce  NUMBER(10,2) := 30000;
   l_change_amt     NUMBER(2,2)  := -0.05;
   l_i              NUMBER(3,0)  :=1;

   CURSOR employee_cursor IS
      SELECT employee_id, first_name, last_name
      FROM employees
      ORDER BY hire_date DESC;

   l_salary_old employees.salary%TYPE;
   l_salary_new employees.salary%TYPE;
BEGIN

   FOR l_employee IN employee_cursor LOOP
      change_salary(l_employee.employee_id, l_change_amt,
                              l_salary_old, l_salary_new);
      l_amt_to_reduce := l_amt_to_reduce -
                              (l_salary_old - l_salary_new);
  
      DBMS_OUTPUT.PUT_LINE(
        l_i || '. Salary of ' || l_employee.first_name || ' ' ||
        l_employee.last_name || ' reduced from ' || 
        to_char(l_salary_old, '$99,999') || ' to ' ||
        to_char(l_salary_new, '$99,999') || '. Left to reduce: ' ||
        to_char(l_amt_to_reduce, '$99,999') || '.'
      );
      l_i := l_i + 1;
      EXIT WHEN l_amt_to_reduce <= 0;
   END LOOP;

END;