-- Create procedure
CREATE OR REPLACE PROCEDURE change_salary(
  employee_id_in  IN    employees.employee_id%TYPE,
  change_amount   IN    NUMBER, -- decimal representing % change
  salary_old_out  OUT   employees.salary%TYPE,
  salary_new_out  OUT   employees.salary%TYPE
) IS
  no_such_employee EXCEPTION;
BEGIN
  SELECT salary
  INTO salary_old_out
  FROM employees
  WHERE employee_id = employee_id_in;
  
  UPDATE employees
  SET salary = salary * (1 + change_amount)
  WHERE employee_id = employee_id_in
  RETURNING salary INTO salary_new_out;
  
  IF SQL%NOTFOUND THEN
    RAISE no_such_employee;
  END IF;

EXCEPTION
  WHEN no_such_employee THEN
    RAISE_APPLICATION_ERROR(-20101,
                         'No employee with id ' || employee_id_in);
  
END change_salary;