DECLARE
  CURSOR employee_cursor IS
    SELECT first_name || ' ' || last_name AS full_name, salary
    FROM employees;
    
  l_full_name  VARCHAR2(50);
  l_salary     employees.salary%TYPE;

BEGIN
  OPEN employee_cursor;
  
  LOOP
    FETCH employee_cursor INTO l_full_name, l_salary;
    EXIT WHEN employee_cursor%NOTFOUND;
    DBMS_OUTPUT.PUT_LINE(
      RPAD(l_full_name, 50) || ': ' || to_char(l_salary, '$99,999')
    );
  END LOOP;
  
  CLOSE employee_cursor;
END;